/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workorder.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.workorder.entity.OmWorkOrderTypeEntity;
import com.bringspring.workorder.model.omworkordertype.OmWorkOrderTypeCrForm;
import com.bringspring.workorder.model.omworkordertype.OmWorkOrderTypeInfoVO;
import com.bringspring.workorder.model.omworkordertype.OmWorkOrderTypePagination;
import com.bringspring.workorder.model.omworkordertype.OmWorkOrderTypeUpForm;
import com.bringspring.workorder.service.OmWorkOrderTypeService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8fd0\u7ef4\u670d\u52a1\u76ee\u5f55"}, value="workorder")
@RequestMapping(value={"/api/workorder/OmWorkOrderType"})
public class OmWorkOrderTypeController {
    private static final Logger log = LoggerFactory.getLogger(OmWorkOrderTypeController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OmWorkOrderTypeService omWorkOrderTypeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OmWorkOrderTypePagination omWorkOrderTypePagination) throws IOException {
        List<OmWorkOrderTypeEntity> list = this.omWorkOrderTypeService.getList(omWorkOrderTypePagination);
        List listVO = JsonUtil.getJsonToList(list, OmWorkOrderTypeCrForm.class);
        this.omWorkOrderTypeService.selectValues(listVO);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)omWorkOrderTypePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/getListTree"})
    public ActionResult getListTree(@RequestParam String parentId) {
        List<OmWorkOrderTypeCrForm> listVO = this.omWorkOrderTypeService.getListTree(parentId);
        return ActionResult.success(listVO);
    }

    @GetMapping(value={"/getFirstListTree"})
    public ActionResult getFirstListTree(@RequestParam String parentId) {
        List<OmWorkOrderTypeCrForm> listVO = this.omWorkOrderTypeService.getListTree(parentId);
        return ActionResult.success(listVO);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid OmWorkOrderTypeUpForm omWorkOrderTypeCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        OmWorkOrderTypeEntity entity = (OmWorkOrderTypeEntity)JsonUtil.getJsonToBean((Object)omWorkOrderTypeCrForm, OmWorkOrderTypeEntity.class);
        entity.setId(mainId);
        entity.setEnabledMark(1);
        entity.setDeleteMark(1);
        this.omWorkOrderTypeService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OmWorkOrderTypeInfoVO> info(@PathVariable(value="id") String id) {
        OmWorkOrderTypeEntity entity = this.omWorkOrderTypeService.getInfo(id);
        OmWorkOrderTypeInfoVO vo = (OmWorkOrderTypeInfoVO)JsonUtil.getJsonToBean((Object)entity, OmWorkOrderTypeInfoVO.class);
        if (!ObjectUtil.isEmpty((Object)vo.getFinishTime())) {
            vo.setFinishDay(String.valueOf(Math.floor(Integer.valueOf(vo.getFinishTime()) / 24)));
            vo.setFinishHour(String.valueOf(Integer.valueOf(vo.getFinishTime()) % 24));
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OmWorkOrderTypeInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OmWorkOrderTypeEntity entity = this.omWorkOrderTypeService.getInfo(id);
        OmWorkOrderTypeInfoVO vo = (OmWorkOrderTypeInfoVO)JsonUtil.getJsonToBean((Object)entity, OmWorkOrderTypeInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OmWorkOrderTypeUpForm omWorkOrderTypeUpForm) throws DataException {
        OmWorkOrderTypeEntity entity = this.omWorkOrderTypeService.getInfo(id);
        if (entity != null) {
            OmWorkOrderTypeEntity subentity = (OmWorkOrderTypeEntity)JsonUtil.getJsonToBean((Object)omWorkOrderTypeUpForm, OmWorkOrderTypeEntity.class);
            this.omWorkOrderTypeService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OmWorkOrderTypeEntity entity = this.omWorkOrderTypeService.getInfo(id);
        if (entity != null) {
            UserInfo userInfo = this.userProvider.get();
            entity.setDeleteMark(0);
            entity.setDeleteUserId(userInfo.getUserId());
            entity.setDeleteTime(new Date());
            this.omWorkOrderTypeService.update(id, entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

