/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workorder.service.impl;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.workorder.entity.OmWorkGroupEntity;
import com.bringspring.workorder.mapper.OmWorkGroupMapper;
import com.bringspring.workorder.model.omWorkGroup.OmWorkGroupPagination;
import com.bringspring.workorder.service.OmWorkGroupService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OmWorkGroupServiceImpl
extends ServiceImpl<OmWorkGroupMapper, OmWorkGroupEntity>
implements OmWorkGroupService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public List<OmWorkGroupEntity> getList(OmWorkGroupPagination omWorkGroupPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int omWorkGroupNum = 0;
        QueryWrapper omWorkGroupQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)omWorkGroupPagination.getWorkOrderTypeId())) {
            ++omWorkGroupNum;
            omWorkGroupQueryWrapper.lambda().like(OmWorkGroupEntity::getWorkOrderTypeId, (Object)omWorkGroupPagination.getWorkOrderTypeId());
        }
        if (StringUtils.isNotEmpty((String)omWorkGroupPagination.getBaseGroupId())) {
            ++omWorkGroupNum;
            omWorkGroupQueryWrapper.lambda().like(OmWorkGroupEntity::getBaseGroupId, (Object)omWorkGroupPagination.getBaseGroupId());
        }
        if (AllIdList.size() > 0) {
            omWorkGroupQueryWrapper.lambda().in(OmWorkGroupEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)omWorkGroupPagination.getSidx())) {
            omWorkGroupQueryWrapper.lambda().orderByDesc(OmWorkGroupEntity::getId);
        } else {
            try {
                String sidx = omWorkGroupPagination.getSidx();
                OmWorkGroupEntity omWorkGroupEntity = new OmWorkGroupEntity();
                Field declaredField = omWorkGroupEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                omWorkGroupQueryWrapper = "asc".equals(omWorkGroupPagination.getSort().toLowerCase()) ? (QueryWrapper)omWorkGroupQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)omWorkGroupQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(omWorkGroupPagination.getCurrentPage(), omWorkGroupPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)omWorkGroupQueryWrapper);
            return omWorkGroupPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return omWorkGroupPagination.setData(list, list.size());
    }

    @Override
    public OmWorkGroupEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OmWorkGroupEntity::getId, (Object)id);
        return (OmWorkGroupEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public boolean deleteByType(List<String> ids) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(OmWorkGroupEntity::getWorkOrderTypeId, ids);
        List listByGroupType = this.list((Wrapper)queryWrapper);
        return this.removeBatchByIds(listByGroupType.stream().map(item -> item.getId()).collect(Collectors.toList()));
    }

    @Override
    public boolean deleteByGroup(List<String> ids) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(OmWorkGroupEntity::getBaseGroupId, ids);
        List listByGroupType = this.list((Wrapper)queryWrapper);
        return this.removeBatchByIds(listByGroupType.stream().map(item -> item.getId()).collect(Collectors.toList()));
    }

    @Override
    public List<OmWorkGroupEntity> getByGroup(String groupId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OmWorkGroupEntity::getBaseGroupId, (Object)groupId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OmWorkGroupEntity> getByGroups(List<String> groupIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(OmWorkGroupEntity::getBaseGroupId, groupIds);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OmWorkGroupEntity> getByTypes(List<String> typeIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(OmWorkGroupEntity::getWorkOrderTypeId, typeIds);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OmWorkGroupEntity> selectAllList() {
        return ((OmWorkGroupMapper)this.baseMapper).selectList(null);
    }

    @Override
    public void create(OmWorkGroupEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, OmWorkGroupEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(OmWorkGroupEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

