/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workorder.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.logistics.entity.OmWorkOrderHistoryEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.workorder.mapper.OmWorkOrderHistoryMapper;
import com.bringspring.workorder.model.omworkorderhistory.OmWorkOrderHistoryPagination;
import com.bringspring.workorder.service.OmWorkOrderHistoryService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OmWorkOrderHistoryServiceImpl
extends ServiceImpl<OmWorkOrderHistoryMapper, OmWorkOrderHistoryEntity>
implements OmWorkOrderHistoryService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public List<OmWorkOrderHistoryEntity> getList(OmWorkOrderHistoryPagination omWorkOrderHistoryPagination) {
        Object omWorkOrderHistoryObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int omWorkOrderHistoryNum = 0;
        QueryWrapper omWorkOrderHistoryQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            omWorkOrderHistoryObj = this.authorizeService.getCondition(new AuthorizeConditionModel(omWorkOrderHistoryQueryWrapper, omWorkOrderHistoryPagination.getMenuId(), "omWorkOrderHistory"));
            if (ObjectUtil.isEmpty((Object)omWorkOrderHistoryObj)) {
                return new ArrayList<OmWorkOrderHistoryEntity>();
            }
            omWorkOrderHistoryQueryWrapper = (QueryWrapper)omWorkOrderHistoryObj;
            ++omWorkOrderHistoryNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            omWorkOrderHistoryObj = this.authorizeService.getCondition(new AuthorizeConditionModel(omWorkOrderHistoryQueryWrapper, omWorkOrderHistoryPagination.getMenuId(), "omWorkOrderHistory"));
            if (ObjectUtil.isEmpty((Object)omWorkOrderHistoryObj)) {
                return new ArrayList<OmWorkOrderHistoryEntity>();
            }
            omWorkOrderHistoryQueryWrapper = (QueryWrapper)omWorkOrderHistoryObj;
            ++omWorkOrderHistoryNum;
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderHistoryPagination.getWorkOrderId())) {
            ++omWorkOrderHistoryNum;
            omWorkOrderHistoryQueryWrapper.lambda().like(OmWorkOrderHistoryEntity::getWorkOrderId, (Object)omWorkOrderHistoryPagination.getWorkOrderId());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderHistoryPagination.getPhase())) {
            ++omWorkOrderHistoryNum;
            omWorkOrderHistoryQueryWrapper.lambda().like(OmWorkOrderHistoryEntity::getPhase, (Object)omWorkOrderHistoryPagination.getPhase());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderHistoryPagination.getDescription())) {
            ++omWorkOrderHistoryNum;
            omWorkOrderHistoryQueryWrapper.lambda().like(OmWorkOrderHistoryEntity::getDescription, (Object)omWorkOrderHistoryPagination.getDescription());
        }
        if (AllIdList.size() > 0) {
            omWorkOrderHistoryQueryWrapper.lambda().in(OmWorkOrderHistoryEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)omWorkOrderHistoryPagination.getSidx())) {
            omWorkOrderHistoryQueryWrapper.lambda().orderByDesc(OmWorkOrderHistoryEntity::getId);
        } else {
            try {
                String sidx = omWorkOrderHistoryPagination.getSidx();
                OmWorkOrderHistoryEntity omWorkOrderHistoryEntity = new OmWorkOrderHistoryEntity();
                Field declaredField = omWorkOrderHistoryEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                omWorkOrderHistoryQueryWrapper = "asc".equals(omWorkOrderHistoryPagination.getSort().toLowerCase()) ? (QueryWrapper)omWorkOrderHistoryQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)omWorkOrderHistoryQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(omWorkOrderHistoryPagination.getCurrentPage(), omWorkOrderHistoryPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)omWorkOrderHistoryQueryWrapper);
            return omWorkOrderHistoryPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return omWorkOrderHistoryPagination.setData(list, list.size());
    }

    @Override
    public List<OmWorkOrderHistoryEntity> getTypeList(OmWorkOrderHistoryPagination omWorkOrderHistoryPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int omWorkOrderHistoryNum = 0;
        QueryWrapper omWorkOrderHistoryQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        if (StringUtils.isNotEmpty((Collection)omWorkOrderHistoryPagination.getCreatorTimeList())) {
            ((LambdaQueryWrapper)omWorkOrderHistoryQueryWrapper.lambda().ge(OmWorkOrderHistoryEntity::getCreatorTime, omWorkOrderHistoryPagination.getCreatorTimeList().get(0))).le(OmWorkOrderHistoryEntity::getCreatorTime, omWorkOrderHistoryPagination.getCreatorTimeList().get(1));
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderHistoryPagination.getWorkOrderId())) {
            ++omWorkOrderHistoryNum;
            omWorkOrderHistoryQueryWrapper.lambda().like(OmWorkOrderHistoryEntity::getWorkOrderId, (Object)omWorkOrderHistoryPagination.getWorkOrderId());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderHistoryPagination.getPhase())) {
            ++omWorkOrderHistoryNum;
            omWorkOrderHistoryQueryWrapper.lambda().like(OmWorkOrderHistoryEntity::getPhase, (Object)omWorkOrderHistoryPagination.getPhase());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderHistoryPagination.getDescription())) {
            ++omWorkOrderHistoryNum;
            omWorkOrderHistoryQueryWrapper.lambda().like(OmWorkOrderHistoryEntity::getDescription, (Object)omWorkOrderHistoryPagination.getDescription());
        }
        if (AllIdList.size() > 0) {
            omWorkOrderHistoryQueryWrapper.lambda().in(OmWorkOrderHistoryEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)omWorkOrderHistoryPagination.getSidx())) {
            omWorkOrderHistoryQueryWrapper.lambda().orderByDesc(OmWorkOrderHistoryEntity::getId);
        } else {
            try {
                String sidx = omWorkOrderHistoryPagination.getSidx();
                OmWorkOrderHistoryEntity omWorkOrderHistoryEntity = new OmWorkOrderHistoryEntity();
                Field declaredField = omWorkOrderHistoryEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                omWorkOrderHistoryQueryWrapper = "asc".equals(omWorkOrderHistoryPagination.getSort().toLowerCase()) ? (QueryWrapper)omWorkOrderHistoryQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)omWorkOrderHistoryQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(omWorkOrderHistoryPagination.getCurrentPage(), omWorkOrderHistoryPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)omWorkOrderHistoryQueryWrapper);
                return omWorkOrderHistoryPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return omWorkOrderHistoryPagination.setData(list, list.size());
        }
        return this.list((Wrapper)omWorkOrderHistoryQueryWrapper);
    }

    @Override
    public List<OmWorkOrderHistoryEntity> getListByWorkId(String id, String phase) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OmWorkOrderHistoryEntity::getWorkOrderId, (Object)id);
        if (!ObjectUtil.isEmpty((Object)phase)) {
            queryWrapper.lambda().eq(OmWorkOrderHistoryEntity::getPhase, (Object)phase);
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByDesc(OmWorkOrderHistoryEntity::getCreatorTime)).orderByAsc(OmWorkOrderHistoryEntity::getPhase);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public OmWorkOrderHistoryEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OmWorkOrderHistoryEntity::getId, (Object)id);
        return (OmWorkOrderHistoryEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<OmWorkOrderHistoryEntity> getListByPhrase(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OmWorkOrderHistoryEntity::getPhase, (Object)id);
        return this.list((Wrapper)queryWrapper).stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OmWorkOrderHistoryEntity>(Comparator.comparing(OmWorkOrderHistoryEntity::getWorkOrderId))), ArrayList::new));
    }

    @Override
    public void create(OmWorkOrderHistoryEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, OmWorkOrderHistoryEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(OmWorkOrderHistoryEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

