/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workorder.service.impl;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.duty.service.OmDutyService;
import com.bringspring.logistics.entity.OmWorkOrderHistoryEntity;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.model.module.ModuleModel;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.msgCenter.model.BusinessKeys;
import com.bringspring.system.msgCenter.model.CustomKeysLink;
import com.bringspring.system.msgCenter.model.LinkMsgKeys;
import com.bringspring.system.msgCenter.model.TaskMsg;
import com.bringspring.system.msgCenter.util.SendTaskMsgUtils;
import com.bringspring.system.permission.entity.GroupEntity;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.mapper.GroupMapper;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.model.authorize.AuthorizeVO;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.GroupService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import com.bringspring.workorder.entity.OmWorkGroupEntity;
import com.bringspring.workorder.entity.OmWorkOrderAttachEntity;
import com.bringspring.workorder.entity.OmWorkOrderEntity;
import com.bringspring.workorder.entity.OmWorkOrderTypeEntity;
import com.bringspring.workorder.mapper.OmWorkOrderMapper;
import com.bringspring.workorder.model.omworkorder.OmWorkOrderCrForm;
import com.bringspring.workorder.model.omworkorder.OmWorkOrderPagination;
import com.bringspring.workorder.model.omworkorder.OmWorkOrderUpForm;
import com.bringspring.workorder.model.omworkordergateway.OmWorkOrderCountStatistics;
import com.bringspring.workorder.model.omworkordergateway.OmWorkOrderGateway;
import com.bringspring.workorder.model.omworkordergateway.OmWorkOrderStatistics;
import com.bringspring.workorder.model.omworkorderhistory.OmWorkOrderHistoryPagination;
import com.bringspring.workorder.model.omworkordertype.OmWorkOrderTypeCrForm;
import com.bringspring.workorder.service.OmWorkGroupService;
import com.bringspring.workorder.service.OmWorkOrderAttachService;
import com.bringspring.workorder.service.OmWorkOrderHistoryService;
import com.bringspring.workorder.service.OmWorkOrderMaterialService;
import com.bringspring.workorder.service.OmWorkOrderService;
import com.bringspring.workorder.service.OmWorkOrderTypeService;
import com.bringspring.workorder.util.BusinessTypeEnum;
import com.bringspring.workorder.util.UploaderVO;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OmWorkOrderServiceImpl
extends ServiceImpl<OmWorkOrderMapper, OmWorkOrderEntity>
implements OmWorkOrderService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private OmWorkOrderTypeService omWorkOrderTypeService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private OmWorkOrderHistoryService omWorkOrderHistoryService;
    @Autowired
    private OmWorkOrderAttachService omWorkOrderAttachService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private UserService userService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private OmWorkOrderMaterialService omWorkOrderMaterialService;
    @Autowired
    private OmWorkOrderMapper omWorkOrderMapper;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private GroupService userGroupService;
    @Autowired
    private GroupMapper groupMapper;
    @Autowired
    private OmWorkGroupService omWorkGroupService;
    @Autowired
    private OmDutyService omDutyService;
    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;

    @Override
    public List<OmWorkOrderEntity> getList(OmWorkOrderPagination omWorkOrderPagination) throws Exception {
        Object omWorkOrderObj;
        if (!this.dataAuth(omWorkOrderPagination.getMenu())) {
            return null;
        }
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int omWorkOrderNum = 0;
        QueryWrapper omWorkOrderQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            omWorkOrderObj = this.authorizeService.getCondition(new AuthorizeConditionModel(omWorkOrderQueryWrapper, omWorkOrderPagination.getMenuId(), "omWorkOrder"));
            if (ObjectUtil.isEmpty((Object)omWorkOrderObj)) {
                return new ArrayList<OmWorkOrderEntity>();
            }
            omWorkOrderQueryWrapper = (QueryWrapper)omWorkOrderObj;
            ++omWorkOrderNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            omWorkOrderObj = this.authorizeService.getCondition(new AuthorizeConditionModel(omWorkOrderQueryWrapper, omWorkOrderPagination.getMenuId(), "omWorkOrder"));
            if (ObjectUtil.isEmpty((Object)omWorkOrderObj)) {
                return new ArrayList<OmWorkOrderEntity>();
            }
            omWorkOrderQueryWrapper = (QueryWrapper)omWorkOrderObj;
            ++omWorkOrderNum;
        }
        if (ObjectUtil.isNotEmpty((Object)omWorkOrderPagination.getBusinessId())) {
            ++omWorkOrderNum;
            omWorkOrderQueryWrapper.lambda().eq(OmWorkOrderEntity::getBusinessId, (Object)omWorkOrderPagination.getBusinessId());
        }
        if (ObjectUtil.isNotEmpty((Object)omWorkOrderPagination.getBusinessName())) {
            ++omWorkOrderNum;
            omWorkOrderQueryWrapper.lambda().like(OmWorkOrderEntity::getBusinessName, (Object)omWorkOrderPagination.getBusinessName());
        }
        if (ObjectUtil.isNotEmpty((Object)omWorkOrderPagination.getBusinessType())) {
            ++omWorkOrderNum;
            omWorkOrderQueryWrapper.lambda().eq(OmWorkOrderEntity::getBusinessType, (Object)omWorkOrderPagination.getBusinessType());
        }
        if (ObjectUtil.isNotEmpty((Object)omWorkOrderPagination.getPhrase())) {
            List<OmWorkOrderHistoryEntity> listByPhrase = this.omWorkOrderHistoryService.getListByPhrase(omWorkOrderPagination.getPhrase());
            if (!ObjectUtil.isEmpty(listByPhrase)) {
                omWorkOrderQueryWrapper.lambda().in(OmWorkOrderEntity::getId, (Collection)listByPhrase.stream().map(a -> a.getWorkOrderId()).collect(Collectors.toList()));
            } else {
                return new ArrayList<OmWorkOrderEntity>();
            }
        }
        if (!ObjectUtil.isEmpty((Object)omWorkOrderPagination.getCreateOrganizeId())) {
            ++omWorkOrderNum;
            omWorkOrderQueryWrapper.lambda().eq(OmWorkOrderEntity::getCreateOrganizeId, (Object)omWorkOrderPagination.getCreateOrganizeId());
        }
        if (StringUtils.isNotEmpty((Collection)omWorkOrderPagination.getExecuteTimeListDefault())) {
            ++omWorkOrderNum;
            omWorkOrderQueryWrapper.lambda().in(OmWorkOrderEntity::getEnabledMark, (Collection)omWorkOrderPagination.getExecuteTimeListDefault());
        }
        if (StringUtils.isNotEmpty((Collection)omWorkOrderPagination.getCreatorTimeList())) {
            ++omWorkOrderNum;
            ((LambdaQueryWrapper)omWorkOrderQueryWrapper.lambda().ge(OmWorkOrderEntity::getCreatorTime, omWorkOrderPagination.getCreatorTimeList().get(0))).le(OmWorkOrderEntity::getCreatorTime, (Object)(omWorkOrderPagination.getCreatorTimeList().get(1) + " 23:59:59"));
        }
        if (StringUtils.isNotEmpty((Collection)omWorkOrderPagination.getExecuteTimeList())) {
            ++omWorkOrderNum;
            ((LambdaQueryWrapper)omWorkOrderQueryWrapper.lambda().ge(OmWorkOrderEntity::getExecuteTime, omWorkOrderPagination.getExecuteTimeList().get(0))).le(OmWorkOrderEntity::getExecuteTime, (Object)(omWorkOrderPagination.getExecuteTimeList().get(1) + " 23:59:59"));
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getExecuteUser())) {
            ++omWorkOrderNum;
            omWorkOrderQueryWrapper.lambda().like(OmWorkOrderEntity::getExecuteUser, (Object)omWorkOrderPagination.getExecuteUser());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getCreatorUserId())) {
            ++omWorkOrderNum;
            omWorkOrderQueryWrapper.lambda().like(OmWorkOrderEntity::getCreatorUserId, (Object)omWorkOrderPagination.getCreatorUserId());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getWorkOrderTypeId())) {
            ++omWorkOrderNum;
            ArrayList<String> collecttypeIdList = new ArrayList<String>();
            collecttypeIdList.add(omWorkOrderPagination.getWorkOrderTypeId());
            List<OmWorkOrderTypeCrForm> listTreeStep = this.omWorkOrderTypeService.getListTreeStep(omWorkOrderPagination.getWorkOrderTypeId());
            if (!ObjectUtil.isEmpty(listTreeStep)) {
                collecttypeIdList.addAll(listTreeStep.stream().map(item -> item.getId()).collect(Collectors.toList()));
            }
            omWorkOrderQueryWrapper.lambda().in(OmWorkOrderEntity::getWorkOrderTypeId, collecttypeIdList);
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getCode())) {
            ++omWorkOrderNum;
            omWorkOrderQueryWrapper.lambda().like(OmWorkOrderEntity::getCode, (Object)omWorkOrderPagination.getCode());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getTitle())) {
            ++omWorkOrderNum;
            omWorkOrderQueryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(OmWorkOrderEntity::getTitle, (Object)omWorkOrderPagination.getTitle())).or()).like(OmWorkOrderEntity::getCode, (Object)omWorkOrderPagination.getTitle());
            });
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getPutway())) {
            ++omWorkOrderNum;
            omWorkOrderQueryWrapper.lambda().like(OmWorkOrderEntity::getPutway, (Object)omWorkOrderPagination.getPutway());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getNote())) {
            ++omWorkOrderNum;
            omWorkOrderQueryWrapper.lambda().like(OmWorkOrderEntity::getNote, (Object)omWorkOrderPagination.getNote());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getLocation())) {
            ++omWorkOrderNum;
            omWorkOrderQueryWrapper.lambda().like(OmWorkOrderEntity::getLocation, (Object)omWorkOrderPagination.getLocation());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getAcceptUser())) {
            ++omWorkOrderNum;
            omWorkOrderQueryWrapper.lambda().like(OmWorkOrderEntity::getAcceptUser, (Object)omWorkOrderPagination.getAcceptUser());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getAcceptTime())) {
            ++omWorkOrderNum;
            omWorkOrderQueryWrapper.lambda().like(OmWorkOrderEntity::getAcceptTime, (Object)omWorkOrderPagination.getAcceptTime());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getResult())) {
            ++omWorkOrderNum;
            omWorkOrderQueryWrapper.lambda().like(OmWorkOrderEntity::getResult, (Object)omWorkOrderPagination.getResult());
        }
        if (StringUtils.isNotEmpty(omWorkOrderPagination.getEnabledMarkList())) {
            ++omWorkOrderNum;
            omWorkOrderQueryWrapper.lambda().in(OmWorkOrderEntity::getEnabledMark, omWorkOrderPagination.getEnabledMarkList());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getEnabledMark())) {
            ++omWorkOrderNum;
            omWorkOrderQueryWrapper.lambda().eq(OmWorkOrderEntity::getEnabledMark, (Object)omWorkOrderPagination.getEnabledMark());
        }
        omWorkOrderQueryWrapper.lambda().eq(OmWorkOrderEntity::getDeleteMark, (Object)1);
        if (AllIdList.size() > 0) {
            omWorkOrderQueryWrapper.lambda().in(OmWorkOrderEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)omWorkOrderPagination.getSidx())) {
            omWorkOrderQueryWrapper.lambda().orderByDesc(OmWorkOrderEntity::getCreatorTime);
        } else {
            try {
                String sidx = omWorkOrderPagination.getSidx();
                OmWorkOrderEntity omWorkOrderEntity = new OmWorkOrderEntity();
                Field declaredField = omWorkOrderEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                omWorkOrderQueryWrapper = "asc".equals(omWorkOrderPagination.getSort().toLowerCase()) ? (QueryWrapper)omWorkOrderQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)omWorkOrderQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(omWorkOrderPagination.getCurrentPage(), omWorkOrderPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)omWorkOrderQueryWrapper);
            return omWorkOrderPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return omWorkOrderPagination.setData(list, list.size());
    }

    @Override
    public List<OmWorkOrderEntity> getListNoPag(OmWorkOrderPagination omWorkOrderPagination) throws Exception {
        ArrayList AllIdList = new ArrayList();
        QueryWrapper omWorkOrderQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        if (StringUtils.isNotEmpty((Collection)omWorkOrderPagination.getExecuteTimeListDefault())) {
            omWorkOrderQueryWrapper.lambda().in(OmWorkOrderEntity::getEnabledMark, (Collection)omWorkOrderPagination.getExecuteTimeListDefault());
        }
        if (StringUtils.isNotEmpty((Collection)omWorkOrderPagination.getCreatorTimeList())) {
            ((LambdaQueryWrapper)omWorkOrderQueryWrapper.lambda().ge(OmWorkOrderEntity::getCreatorTime, omWorkOrderPagination.getCreatorTimeList().get(0))).le(OmWorkOrderEntity::getCreatorTime, (Object)(omWorkOrderPagination.getCreatorTimeList().get(1) + " 23:59:59"));
        }
        if (StringUtils.isNotEmpty((Collection)omWorkOrderPagination.getExecuteTimeList())) {
            ((LambdaQueryWrapper)omWorkOrderQueryWrapper.lambda().ge(OmWorkOrderEntity::getExecuteTime, omWorkOrderPagination.getExecuteTimeList().get(0))).le(OmWorkOrderEntity::getExecuteTime, (Object)(omWorkOrderPagination.getExecuteTimeList().get(1) + " 23:59:59"));
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getExecuteUser())) {
            omWorkOrderQueryWrapper.lambda().like(OmWorkOrderEntity::getExecuteUser, (Object)omWorkOrderPagination.getExecuteUser());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getCreatorUserId())) {
            omWorkOrderQueryWrapper.lambda().like(OmWorkOrderEntity::getCreatorUserId, (Object)omWorkOrderPagination.getCreatorUserId());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getWorkOrderTypeId())) {
            ArrayList<String> collecttypeIdList = new ArrayList<String>();
            collecttypeIdList.add(omWorkOrderPagination.getWorkOrderTypeId());
            List<OmWorkOrderTypeCrForm> listTreeStep = this.omWorkOrderTypeService.getListTreeStep(omWorkOrderPagination.getWorkOrderTypeId());
            if (!ObjectUtil.isEmpty(listTreeStep)) {
                collecttypeIdList.addAll(listTreeStep.stream().map(item -> item.getId()).collect(Collectors.toList()));
            }
            omWorkOrderQueryWrapper.lambda().in(OmWorkOrderEntity::getWorkOrderTypeId, collecttypeIdList);
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getCode())) {
            omWorkOrderQueryWrapper.lambda().like(OmWorkOrderEntity::getCode, (Object)omWorkOrderPagination.getCode());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getTitle())) {
            omWorkOrderQueryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(OmWorkOrderEntity::getTitle, (Object)omWorkOrderPagination.getTitle())).or()).like(OmWorkOrderEntity::getCode, (Object)omWorkOrderPagination.getTitle());
            });
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getPutway())) {
            omWorkOrderQueryWrapper.lambda().like(OmWorkOrderEntity::getPutway, (Object)omWorkOrderPagination.getPutway());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getNote())) {
            omWorkOrderQueryWrapper.lambda().like(OmWorkOrderEntity::getNote, (Object)omWorkOrderPagination.getNote());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getLocation())) {
            omWorkOrderQueryWrapper.lambda().like(OmWorkOrderEntity::getLocation, (Object)omWorkOrderPagination.getLocation());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getAcceptUser())) {
            omWorkOrderQueryWrapper.lambda().like(OmWorkOrderEntity::getAcceptUser, (Object)omWorkOrderPagination.getAcceptUser());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getAcceptTime())) {
            omWorkOrderQueryWrapper.lambda().like(OmWorkOrderEntity::getAcceptTime, (Object)omWorkOrderPagination.getAcceptTime());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getResult())) {
            omWorkOrderQueryWrapper.lambda().like(OmWorkOrderEntity::getResult, (Object)omWorkOrderPagination.getResult());
        }
        if (StringUtils.isNotEmpty(omWorkOrderPagination.getEnabledMarkList())) {
            omWorkOrderQueryWrapper.lambda().in(OmWorkOrderEntity::getEnabledMark, omWorkOrderPagination.getEnabledMarkList());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getEnabledMark())) {
            omWorkOrderQueryWrapper.lambda().eq(OmWorkOrderEntity::getEnabledMark, (Object)omWorkOrderPagination.getEnabledMark());
        }
        omWorkOrderQueryWrapper.lambda().eq(OmWorkOrderEntity::getDeleteMark, (Object)1);
        if (AllIdList.size() > 0) {
            omWorkOrderQueryWrapper.lambda().in(OmWorkOrderEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)omWorkOrderPagination.getSidx())) {
            omWorkOrderQueryWrapper.lambda().orderByDesc(OmWorkOrderEntity::getAcceptTime);
        } else {
            try {
                String sidx = omWorkOrderPagination.getSidx();
                OmWorkOrderEntity omWorkOrderEntity = new OmWorkOrderEntity();
                Field declaredField = omWorkOrderEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                omWorkOrderQueryWrapper = "asc".equals(omWorkOrderPagination.getSort().toLowerCase()) ? (QueryWrapper)omWorkOrderQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)omWorkOrderQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return this.list((Wrapper)omWorkOrderQueryWrapper);
    }

    public boolean dataAuth(String menu) throws Exception {
        List<OmWorkGroupEntity> omWorkGroupEntities;
        List listByObjectIdAll;
        List<String> workOrderAccept;
        List groupId;
        List collectUserId;
        String userId = this.userProvider.get().getUserId();
        return !("accept".equals(menu) ? !(collectUserId = this.userRelationService.getListByObjectIdAll(groupId = this.userGroupService.listByIds(workOrderAccept = Arrays.asList(this.sysConfigService.getConfigByKeyName("workOrderAccept").getKeyValue().split(","))).stream().map(item -> item.getId()).collect(Collectors.toList())).stream().map(item -> item.getUserId()).distinct().collect(Collectors.toList())).contains(userId) : "execute".equals(menu) && !(collectUserId = (listByObjectIdAll = this.userRelationService.getListByObjectIdAll((omWorkGroupEntities = this.omWorkGroupService.selectAllList()).stream().map(item -> item.getBaseGroupId()).distinct().collect(Collectors.toList()))).stream().map(item -> item.getUserId()).collect(Collectors.toList())).contains(userId));
    }

    @Override
    public long getEnableMarkCount(OmWorkOrderCrForm workOrderCrForm) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OmWorkOrderEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId());
        queryWrapper.lambda().eq(OmWorkOrderEntity::getEnabledMark, (Object)workOrderCrForm.getEnabledMark());
        if (!ObjectUtil.isEmpty((Object)workOrderCrForm.getBusinessType())) {
            queryWrapper.lambda().eq(OmWorkOrderEntity::getBusinessType, (Object)workOrderCrForm.getBusinessType());
        }
        queryWrapper.lambda().eq(OmWorkOrderEntity::getDeleteMark, (Object)1);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public long urgingWorkOrder(OmWorkOrderCrForm workOrderCrForm) throws Exception {
        String pcUrl;
        String appUrl;
        OmWorkOrderCrForm info = this.getInfoSelect(workOrderCrForm.getId());
        info.setEnabledMarkName("\u50ac\u529e");
        if ("submit".equals(info.getEnabledMark())) {
            List<String> workOrderAccept = Arrays.asList(this.sysConfigService.getConfigByKeyName("workOrderAccept").getKeyValue().split(","));
            List groupId = this.userGroupService.listByIds(workOrderAccept).stream().map(item -> item.getId()).collect(Collectors.toList());
            List<String> collectUserId = this.userRelationService.getListByObjectIdAll(groupId).stream().map(item -> item.getUserId()).distinct().collect(Collectors.toList());
            String appUrl2 = "/#/pages/work-order/my-work-order/detailNew?id=" + workOrderCrForm.getId();
            String pcUrl2 = "/#/logistics/workorderaccept";
            this.sendMessage2(collectUserId, info, appUrl2, pcUrl2, "workorder_notification");
        }
        if ("accepted".equals(info.getEnabledMark())) {
            ArrayList<String> collectUserId = new ArrayList<String>();
            if (!ObjectUtil.isEmpty((Object)info)) {
                collectUserId.add(info.getCreatorUserId());
                appUrl = "/#/pages/work-order/my-work-order/detailNew?id=" + workOrderCrForm.getId();
                pcUrl = "/#/logistics/workorderaccept";
                this.sendMessage2(collectUserId, info, appUrl, pcUrl, "workorder_notification");
            }
        }
        if ("assign".equals(info.getEnabledMark()) && !ObjectUtil.isEmpty((Object)info)) {
            ArrayList<String> executeUser = new ArrayList<String>();
            executeUser.add(info.getExecuteUser());
            appUrl = "/#/pages/work-order/my-work-order/detailNew?id=" + workOrderCrForm.getId();
            pcUrl = "/#/logistics/workorderexecute";
            this.sendMessage2(executeUser, info, appUrl, pcUrl, "workorder_notification");
        }
        return 1L;
    }

    @Override
    public Integer updateWorkWithHistory(OmWorkOrderCrForm workOrderCrForm) throws Exception {
        OmWorkOrderCrForm info;
        OmWorkOrderCrForm info2;
        String workOrderAuto;
        List<UploaderVO> urlList;
        UserInfo userInfo = this.userProvider.get();
        OmWorkOrderEntity entity = (OmWorkOrderEntity)JsonUtil.getJsonToBean((Object)workOrderCrForm, OmWorkOrderEntity.class);
        entity.setCreatorTime(DateUtil.dateAddSeconds((Date)new Date(), (int)2));
        this.update(entity.getId(), entity);
        OmWorkOrderHistoryEntity omWorkOrderHistoryEntity = new OmWorkOrderHistoryEntity();
        String historyId = RandomUtil.uuId();
        omWorkOrderHistoryEntity.setId(historyId);
        omWorkOrderHistoryEntity.setWorkOrderId(entity.getId());
        if (!ObjectUtil.isEmpty((Object)workOrderCrForm.getEnabledMark())) {
            DictionaryDataEntity dictionaryDataentity = this.dictionaryDataService.getSwapInfo(workOrderCrForm.getEnabledMark(), "408965779678037317");
            workOrderCrForm.setDescription(ObjectUtil.isEmpty((Object)workOrderCrForm.getDescription()) ? userInfo.getUserName() + dictionaryDataentity.getDescription() : workOrderCrForm.getDescription());
        }
        omWorkOrderHistoryEntity.setDescription(workOrderCrForm.getDescription());
        omWorkOrderHistoryEntity.setPhase(ObjectUtil.isEmpty((Object)workOrderCrForm.getPhase()) ? workOrderCrForm.getEnabledMark() : workOrderCrForm.getPhase());
        this.omWorkOrderHistoryService.create(omWorkOrderHistoryEntity);
        if (!ObjectUtil.isEmpty(workOrderCrForm.getUrl()) && !ObjectUtil.isEmpty(urlList = workOrderCrForm.getUrl())) {
            for (UploaderVO url : urlList) {
                OmWorkOrderAttachEntity omWorkOrderAttachEntity = new OmWorkOrderAttachEntity();
                omWorkOrderAttachEntity.setId(RandomUtil.uuId());
                omWorkOrderAttachEntity.setWorkOrderHistoryId(historyId);
                omWorkOrderAttachEntity.setAttachUrl(url.getUrl());
                omWorkOrderAttachEntity.setAttachNote(JSON.toJSONString((Object)url));
                this.createAttach(omWorkOrderAttachEntity);
            }
        }
        if (!ObjectUtil.isEmpty(workOrderCrForm.getMaterial())) {
            workOrderCrForm.getMaterial().stream().forEach(item -> {
                item.setId(RandomUtil.uuId());
                item.setWorkOrderId(workOrderCrForm.getId());
                item.setWorkOrderHistoryId(historyId);
            });
            this.omWorkOrderMaterialService.saveBatch(workOrderCrForm.getMaterial());
        }
        if ("submit".equals(workOrderCrForm.getEnabledMark()) && "false".equals(workOrderAuto = this.sysConfigService.getConfigByKeyName("workOrderAuto").getKeyValue())) {
            info2 = this.getInfoSelect(entity.getId());
            List<String> workOrderAccept = Arrays.asList(this.sysConfigService.getConfigByKeyName("workOrderAccept").getKeyValue().split(","));
            List groupId = this.userGroupService.listByIds(workOrderAccept).stream().map(item -> item.getId()).collect(Collectors.toList());
            List<String> collectUserId = this.userRelationService.getListByObjectIdAll(groupId).stream().map(item -> item.getUserId()).distinct().collect(Collectors.toList());
            String appUrl = "/#/pages/work-order/my-work-order/detailNew?id=" + workOrderCrForm.getId();
            String pcUrl = "/#/logistics/workorderaccept";
            if (!ObjectUtil.isEmpty((Object)info2)) {
                ArrayList createUserId = new ArrayList();
                this.sendMessage2(collectUserId, info2, appUrl, pcUrl, "workorder_notification");
            }
        }
        if ("assign".equals(workOrderCrForm.getEnabledMark()) && !ObjectUtil.isEmpty((Object)(info = this.getInfoSelect(entity.getId())))) {
            ArrayList<String> executeUser = new ArrayList<String>();
            executeUser.add(info.getExecuteUser());
            String appUrlExe = "/#/pages/work-order/work-order-execute/index";
            String pcUrlExe = "/#/logistics/workorderexecute";
            this.sendMessage2(executeUser, info, appUrlExe, pcUrlExe, "workorder_notification");
        }
        if ("execute".equals(workOrderCrForm.getEnabledMark())) {
            ArrayList<String> collectUserId = new ArrayList<String>();
            info2 = this.getInfoSelect(entity.getId());
            if (!ObjectUtil.isEmpty((Object)info2)) {
                collectUserId.add(info2.getCreatorUserId());
                String appUrl = "/#/pages/work-order/my-work-order/index?id=" + workOrderCrForm.getId() + "&enabledMark=execute";
                String pcUrl = "/#/logistics/workorderlist";
                this.sendMessage2(collectUserId, info2, appUrl, pcUrl, "workorder_notification");
            }
        }
        return 1;
    }

    public void createAttach(OmWorkOrderAttachEntity omWorkOrderAttachEntity) {
        this.omWorkOrderAttachService.create(omWorkOrderAttachEntity);
    }

    @Override
    public void selectValues(List<OmWorkOrderCrForm> outputVo) {
        if (ObjectUtil.isNull(outputVo)) {
            return;
        }
        outputVo.stream().forEach(item -> {
            UserEntity infoCreater;
            UserEntity executeUser;
            String acceptUserName;
            item.setBusinessTypeName(BusinessTypeEnum.getEnumFullName(item.getBusinessType()));
            item.setPutwayName(this.baseDataUtil.getDictName(item.getPutway(), "DeclareRole"));
            item.setEnabledMarkName(this.baseDataUtil.getDictName(item.getEnabledMark(), "wostate"));
            item.setPriorityName(this.baseDataUtil.getDictName(item.getPriority(), "priority"));
            OmWorkOrderTypeEntity infoType = this.omWorkOrderTypeService.getInfo(item.getWorkOrderTypeId());
            if (!ObjectUtil.isEmpty((Object)infoType)) {
                item.setWorkOrderTypeName(infoType.getName());
            }
            if (!ObjectUtil.isEmpty((Object)(acceptUserName = this.baseDataUtil.userSelectValueNoAccount(item.getAcceptUser())))) {
                item.setAcceptUserName(acceptUserName);
            }
            if (!ObjectUtil.isEmpty((Object)(executeUser = this.userService.getInfo(item.getExecuteUser())))) {
                item.setExecuteUserName(executeUser.getRealName());
                item.setExecuteUserPhone(executeUser.getMobilePhone());
            }
            if (!ObjectUtil.isEmpty((Object)(infoCreater = this.userService.getInfo(item.getCreatorUserId())))) {
                item.setCreatorUserName(infoCreater.getRealName());
                List allOrgByUserId = this.organizeService.getAllOrgByUserId(item.getCreatorUserId());
                if (!ObjectUtil.isEmpty((Object)allOrgByUserId)) {
                    item.setCreatorOrgName(allOrgByUserId.stream().map(itemOrg -> itemOrg.getFullName()).collect(Collectors.joining("/")));
                }
            }
            item.setAcceptTimeFormat(ObjectUtil.isNull((Object)item.getAcceptTime()) ? null : DateUtil.dateFormat((Date)item.getAcceptTime()));
            item.setExecuteTimeFormat(ObjectUtil.isNull((Object)item.getExecuteTime()) ? null : DateUtil.dateFormat((Date)item.getExecuteTime()));
            item.setCreatorTimeFormat(ObjectUtil.isNull((Object)item.getCreatorTime()) ? null : DateUtil.daFormat((Long)item.getCreatorTime()));
            item.setLastModifyTimeFormat(ObjectUtil.isNull((Object)item.getLastModifyTime()) ? null : DateUtil.daFormat((Long)item.getLastModifyTime()));
            item.setStartTimeFormat(ObjectUtil.isNull((Object)item.getStartTime()) ? null : DateUtil.daFormat((Date)item.getStartTime()));
        });
    }

    @Override
    public OmWorkOrderCrForm getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OmWorkOrderEntity::getId, (Object)id);
        queryWrapper.lambda().eq(OmWorkOrderEntity::getDeleteMark, (Object)1);
        OmWorkOrderEntity entity = (OmWorkOrderEntity)this.getOne((Wrapper)queryWrapper);
        OmWorkOrderCrForm vo = (OmWorkOrderCrForm)JsonUtil.getJsonToBean((Object)entity, OmWorkOrderCrForm.class);
        vo.setMaterial(this.omWorkOrderMaterialService.getByWorkHistoryId(null, id));
        List<OmWorkOrderHistoryEntity> listByWorkId = this.omWorkOrderHistoryService.getListByWorkId(id, "draft");
        List collectHistoryId = listByWorkId.stream().map(item -> item.getId()).collect(Collectors.toList());
        if (!ObjectUtil.isEmpty(collectHistoryId)) {
            List<OmWorkOrderAttachEntity> listByHistoryId = this.omWorkOrderAttachService.getListByHistoryId((String)collectHistoryId.get(0));
            ArrayList<UploaderVO> urlList = new ArrayList<UploaderVO>();
            for (OmWorkOrderAttachEntity o : listByHistoryId) {
                UploaderVO uploaderVO = new UploaderVO();
                if (!ObjectUtil.isEmpty((Object)o.getAttachNote())) {
                    uploaderVO = (UploaderVO)JSON.parseObject((String)o.getAttachNote(), (TypeReference)new TypeReference<UploaderVO>(){}, (Feature[])new Feature[0]);
                }
                urlList.add(uploaderVO);
            }
            vo.setUrl(urlList);
            ArrayList<OmWorkOrderCrForm> ListVo = new ArrayList<OmWorkOrderCrForm>();
            ListVo.add(vo);
            this.selectValues(ListVo);
        }
        return vo;
    }

    @Override
    public List<GroupEntity> getGroupByLeader(String leadId) {
        List workGroupEntityList = this.omWorkGroupService.list(null);
        if (!ObjectUtil.isEmpty((Object)workGroupEntityList)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(GroupEntity::getGroupLeader, (Object)leadId);
            return this.groupMapper.selectList((Wrapper)queryWrapper);
        }
        return null;
    }

    @Override
    public OmWorkOrderCrForm getInfoSelect(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OmWorkOrderEntity::getId, (Object)id);
        queryWrapper.lambda().eq(OmWorkOrderEntity::getDeleteMark, (Object)1);
        OmWorkOrderEntity entity = (OmWorkOrderEntity)this.getOne((Wrapper)queryWrapper);
        OmWorkOrderCrForm vo = (OmWorkOrderCrForm)JsonUtil.getJsonToBean((Object)entity, OmWorkOrderCrForm.class);
        ArrayList<OmWorkOrderCrForm> list = new ArrayList<OmWorkOrderCrForm>();
        list.add(vo);
        this.selectValues(list);
        return vo;
    }

    @Override
    public OmWorkOrderEntity create(OmWorkOrderUpForm omWorkOrderCrForm) throws Exception {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        OmWorkOrderEntity entity = (OmWorkOrderEntity)JsonUtil.getJsonToBean((Object)omWorkOrderCrForm, OmWorkOrderEntity.class);
        entity.setId(mainId);
        entity.setCode(this.baseDataUtil.getBillNumber("workorderno", Boolean.valueOf(false)));
        if (ObjectUtil.isEmpty((Object)entity.getCreatorUserId())) {
            entity.setCreatorUserId(userInfo.getUserId());
        }
        entity.setCreateOrganizeId(userInfo.getDepartmentId());
        entity.setDeleteMark(1);
        entity.setCreateName(userInfo.getUserName());
        OrganizeEntity infoOrg = this.organizeService.getInfo(userInfo.getDepartmentId());
        if (!ObjectUtil.isEmpty((Object)infoOrg)) {
            entity.setCreateOrganize(infoOrg.getFullName());
        }
        this.save(entity);
        if ("submit".equals(omWorkOrderCrForm.getEnabledMark())) {
            // empty if block
        }
        OmWorkOrderHistoryEntity createHistory = new OmWorkOrderHistoryEntity();
        String createHistoryId = RandomUtil.uuId();
        createHistory.setWorkOrderId(mainId);
        createHistory.setId(createHistoryId);
        createHistory.setPhase("draft");
        DictionaryDataEntity dictionaryDataentity = this.dictionaryDataService.getSwapInfo("draft", "408965779678037317");
        if (!ObjectUtil.isEmpty((Object)dictionaryDataentity)) {
            createHistory.setDescription(userInfo.getUserName() + dictionaryDataentity.getDescription());
        }
        Date setTime = new Date();
        createHistory.setCreatorTime(setTime);
        this.omWorkOrderHistoryService.create(createHistory);
        if ("submit".equals(entity.getEnabledMark())) {
            DictionaryDataEntity dictionaryDataentitySub = this.dictionaryDataService.getSwapInfo(entity.getEnabledMark(), "408965779678037317");
            createHistory.setDescription(userInfo.getUserName() + dictionaryDataentitySub.getDescription());
            createHistory.setId(String.valueOf(Long.valueOf(createHistoryId) - 1L));
            createHistory.setPhase(entity.getEnabledMark());
            createHistory.setCreatorTime(DateUtil.dateAddSeconds((Date)setTime, (int)1));
            this.omWorkOrderHistoryService.create(createHistory);
            this.autoAssign();
        }
        List<UploaderVO> urlList = omWorkOrderCrForm.getUrl();
        if (!ObjectUtil.isEmpty(omWorkOrderCrForm.getUrl())) {
            for (UploaderVO url : urlList) {
                OmWorkOrderAttachEntity omWorkOrderAttachEntity = new OmWorkOrderAttachEntity();
                omWorkOrderAttachEntity.setId(RandomUtil.uuId());
                omWorkOrderAttachEntity.setWorkOrderHistoryId(createHistoryId);
                omWorkOrderAttachEntity.setAttachUrl(url.getUrl());
                omWorkOrderAttachEntity.setAttachNote(JSON.toJSONString((Object)url));
                this.createAttach(omWorkOrderAttachEntity);
            }
        }
        return entity;
    }

    @Override
    public boolean update(String id, OmWorkOrderEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public Integer updateEvaluate() {
        Integer returnEvaluate = this.omWorkOrderMapper.updateEvaluate("5", "\u7cfb\u7edf\u81ea\u52a8\u8bc4\u4ef7");
        return returnEvaluate;
    }

    @Override
    public OmWorkOrderGateway getTotal(OmWorkOrderGateway omWorkOrderGateway) {
        if (!ObjectUtil.isEmpty(omWorkOrderGateway.getDatetime())) {
            omWorkOrderGateway.setStartDate(omWorkOrderGateway.getDatetime().get(0));
            omWorkOrderGateway.setEndDate(omWorkOrderGateway.getDatetime().get(1));
        }
        ArrayList<String> enabledMarkList = new ArrayList<String>();
        OmWorkOrderGateway returnGateway = new OmWorkOrderGateway();
        enabledMarkList.add("submit");
        enabledMarkList.add("pending");
        enabledMarkList.add("accepted");
        enabledMarkList.add("assign");
        enabledMarkList.add("execute");
        enabledMarkList.add("evaluate");
        omWorkOrderGateway.setEnabledMarkList(enabledMarkList);
        double totalWorkOrder = this.omWorkOrderMapper.getTotal(omWorkOrderGateway);
        returnGateway.setTotalWorkOrder(totalWorkOrder);
        enabledMarkList.clear();
        omWorkOrderGateway.setEnabledMarkList(null);
        enabledMarkList.add("execute");
        enabledMarkList.add("evaluate");
        omWorkOrderGateway.setEnabledMarkList(enabledMarkList);
        double totalComplete = this.omWorkOrderMapper.getTotal(omWorkOrderGateway);
        returnGateway.setTotalComplete(totalComplete);
        double totalNotComplete = totalWorkOrder - totalComplete;
        returnGateway.setTotalNotComplete(totalNotComplete);
        double epsilon = 1.0E-5;
        if (Math.abs(totalComplete) < epsilon) {
            returnGateway.setTotalRateComplete("0");
        } else {
            Double totalRateComplete = totalComplete / totalWorkOrder * 100.0;
            DecimalFormat df = new DecimalFormat("#.00");
            returnGateway.setTotalRateComplete(df.format(totalRateComplete));
        }
        return returnGateway;
    }

    @Override
    public List<OmWorkOrderStatistics> getStatistics(OmWorkOrderGateway omWorkOrderGateway) {
        ArrayList<OmWorkOrderStatistics> createStatisticsReturn = new ArrayList();
        List<OmWorkOrderStatistics> createStatistics = this.omWorkOrderMapper.getCreateStatistics(omWorkOrderGateway);
        if (!"1".equals(omWorkOrderGateway.getOrganizeLevel())) {
            List allCompanyList = this.organizeService.getAllCompanyList(null);
            for (int a = 0; a < allCompanyList.size(); ++a) {
                OrganizeEntity j = (OrganizeEntity)allCompanyList.get(a);
                OmWorkOrderStatistics omWorkOrderStatistics = new OmWorkOrderStatistics();
                omWorkOrderStatistics.setOrganizeName(j.getFullName());
                double sum = 0.0;
                for (int o = 0; o < createStatistics.size(); ++o) {
                    String companyId;
                    String[] splitOrganize;
                    OmWorkOrderStatistics i = createStatistics.get(o);
                    if (ObjectUtil.isEmpty((Object)i.getOrganizeIdTree()) || ObjectUtil.isEmpty((Object)(splitOrganize = i.getOrganizeIdTree().split(","))) || !(companyId = splitOrganize[0]).equals(j.getId())) continue;
                    sum = i.getWorkCount() + sum;
                }
                omWorkOrderStatistics.setWorkCount(sum);
                createStatisticsReturn.add(omWorkOrderStatistics);
            }
        } else {
            createStatisticsReturn = createStatistics;
        }
        return createStatisticsReturn;
    }

    @Override
    public List<OmWorkOrderStatistics> getCreateUserStatistics(OmWorkOrderGateway omWorkOrderGateway) {
        ArrayList<OmWorkOrderStatistics> createStatisticsReturn = new ArrayList();
        List<OmWorkOrderStatistics> createStatistics = this.omWorkOrderMapper.getCreateUserStatistics(omWorkOrderGateway);
        if (!"1".equals(omWorkOrderGateway.getOrganizeLevel())) {
            List allCompanyList = this.organizeService.getAllCompanyList(null);
            for (int a = 0; a < allCompanyList.size(); ++a) {
                OrganizeEntity j = (OrganizeEntity)allCompanyList.get(a);
                OmWorkOrderStatistics omWorkOrderStatistics = new OmWorkOrderStatistics();
                omWorkOrderStatistics.setOrganizeName(j.getFullName());
                double sum = 0.0;
                for (int o = 0; o < createStatistics.size(); ++o) {
                    String companyId;
                    String[] splitOrganize;
                    OmWorkOrderStatistics i = createStatistics.get(o);
                    if (ObjectUtil.isEmpty((Object)i.getOrganizeIdTree()) || ObjectUtil.isEmpty((Object)(splitOrganize = i.getOrganizeIdTree().split(","))) || !(companyId = splitOrganize[0]).equals(j.getId())) continue;
                    sum = i.getWorkCount() + sum;
                }
                omWorkOrderStatistics.setWorkCount(sum);
                createStatisticsReturn.add(omWorkOrderStatistics);
            }
        } else {
            createStatisticsReturn = createStatistics;
        }
        return createStatisticsReturn;
    }

    @Override
    public List<OmWorkOrderStatistics> getDepartStatistics(OmWorkOrderGateway omWorkOrderGateway) {
        List<OmWorkOrderStatistics> createStatistics = this.omWorkOrderMapper.getExecuteStatistics(omWorkOrderGateway);
        return createStatistics;
    }

    @Override
    public List<OmWorkOrderStatistics> getTypeStatistics(OmWorkOrderGateway omWorkOrderGateway) {
        List<OmWorkOrderStatistics> createStatistics = this.omWorkOrderMapper.getTypeStatistics(omWorkOrderGateway);
        return createStatistics;
    }

    @Override
    public List<OmWorkOrderGateway> getTotalStatistics(OmWorkOrderGateway omWorkOrderGateway) {
        ArrayList<String> enabledMarkList = new ArrayList<String>();
        List<OmWorkOrderGateway> createStatistics = this.omWorkOrderMapper.getTotalStatistics(omWorkOrderGateway);
        enabledMarkList.add("execute");
        enabledMarkList.add("evaluate");
        omWorkOrderGateway.setEnabledMarkList(enabledMarkList);
        List<OmWorkOrderGateway> createStatisticsComplete = this.omWorkOrderMapper.getTotalStatistics(omWorkOrderGateway);
        createStatistics.stream().forEach(i -> createStatisticsComplete.stream().forEach(j -> {
            if (!ObjectUtil.isEmpty((Object)i.getLocation()) && i.getLocation().equals(j.getLocation())) {
                i.setTotalComplete(j.getTotalWorkOrder());
                i.setTotalNotComplete(i.getTotalWorkOrder() - i.getTotalComplete());
            }
        }));
        return createStatistics;
    }

    @Override
    public OmWorkOrderCountStatistics getDateStatistics(OmWorkOrderGateway omWorkOrderGateway) {
        OmWorkOrderCountStatistics workOrderCountStatistics = new OmWorkOrderCountStatistics();
        if ("year".equals(omWorkOrderGateway.getTimeGranularity())) {
            OmWorkOrderGateway omWorkOrderGatewayNow = new OmWorkOrderGateway();
            int yearNow = DateUtil.getNowYear();
            Date startOfNowYear = this.localDateToDate(LocalDate.of(yearNow, 1, 1));
            Date endOfNowYear = this.localDateToDate(LocalDate.of(yearNow, 12, 31));
            omWorkOrderGatewayNow.setStartDate(startOfNowYear);
            omWorkOrderGatewayNow.setEndDate(endOfNowYear);
            double totalWorkOrderNow = this.omWorkOrderMapper.getTotal(omWorkOrderGatewayNow);
            ArrayList<String> enableMark = new ArrayList<String>();
            enableMark.add("execute");
            enableMark.add("evaluate");
            omWorkOrderGatewayNow.setEnabledMarkList(enableMark);
            double totalWorkOrderNowComplete = this.omWorkOrderMapper.getTotal(omWorkOrderGatewayNow);
            double totalWorkOrderNowNot = totalWorkOrderNow - totalWorkOrderNowComplete;
            int yearLast = new Date().getYear() - 1;
            Date startOfLastYear = this.localDateToDate(LocalDate.of(yearLast, 1, 1));
            Date endOfLastYear = this.localDateToDate(LocalDate.of(yearLast, 12, 31));
            omWorkOrderGatewayNow.setStartDate(startOfLastYear);
            omWorkOrderGatewayNow.setEndDate(endOfLastYear);
            omWorkOrderGatewayNow.setEnabledMarkList(null);
            double totalWorkOrderLast = this.omWorkOrderMapper.getTotal(omWorkOrderGatewayNow);
            omWorkOrderGatewayNow.setEnabledMarkList(enableMark);
            double totalWorkOrderLastComplete = this.omWorkOrderMapper.getTotal(omWorkOrderGatewayNow);
            double totalWorkOrderLastNot = totalWorkOrderLast - totalWorkOrderLastComplete;
            int yearPrevious = new Date().getYear() - 2;
            Date startOfPreviousYear = this.localDateToDate(LocalDate.of(yearPrevious, 1, 1));
            Date endOfPreviousYear = this.localDateToDate(LocalDate.of(yearPrevious, 12, 31));
            omWorkOrderGatewayNow.setStartDate(startOfPreviousYear);
            omWorkOrderGatewayNow.setEndDate(endOfPreviousYear);
            omWorkOrderGatewayNow.setEnabledMarkList(null);
            double totalWorkOrderPrevious = this.omWorkOrderMapper.getTotal(omWorkOrderGatewayNow);
            omWorkOrderGatewayNow.setEnabledMarkList(enableMark);
            double totalWorkOrderPreviousComplete = this.omWorkOrderMapper.getTotal(omWorkOrderGatewayNow);
            double totalWorkOrderPreviousNot = totalWorkOrderPrevious - totalWorkOrderPreviousComplete;
            omWorkOrderGatewayNow.setEnabledMarkList(enableMark);
            ArrayList<Double> totalWorkOrder = new ArrayList<Double>();
            ArrayList<Double> totalComplete = new ArrayList<Double>();
            ArrayList<Double> totalNotComplete = new ArrayList<Double>();
            totalWorkOrder.add(totalWorkOrderPrevious);
            totalWorkOrder.add(totalWorkOrderLast);
            totalWorkOrder.add(totalWorkOrderNow);
            totalComplete.add(totalWorkOrderPreviousComplete);
            totalComplete.add(totalWorkOrderLastComplete);
            totalComplete.add(totalWorkOrderNowComplete);
            totalNotComplete.add(totalWorkOrderPreviousNot);
            totalNotComplete.add(totalWorkOrderLastNot);
            totalNotComplete.add(totalWorkOrderNowNot);
            workOrderCountStatistics.setTotalWorkOrder(totalWorkOrder);
            workOrderCountStatistics.setTotalComplete(totalComplete);
            workOrderCountStatistics.setTotalNotComplete(totalNotComplete);
        } else if ("month".equals(omWorkOrderGateway.getTimeGranularity())) {
            LocalDate currentDate = LocalDate.now();
            LocalDate startOfMonth = currentDate.with(TemporalAdjusters.firstDayOfMonth());
            Date startDateNow = this.localDateToDate(startOfMonth);
            LocalDate endOfMonth = currentDate.with(TemporalAdjusters.lastDayOfMonth());
            OmWorkOrderGateway omWorkOrderGatewayNow = new OmWorkOrderGateway();
            Date endDateNow = this.localDateToDate(endOfMonth);
            omWorkOrderGatewayNow.setStartDate(startDateNow);
            omWorkOrderGatewayNow.setEndDate(endDateNow);
            double totalWorkOrderNow = this.omWorkOrderMapper.getTotal(omWorkOrderGatewayNow);
            ArrayList<String> enableMark = new ArrayList<String>();
            enableMark.add("execute");
            enableMark.add("evaluate");
            omWorkOrderGatewayNow.setEnabledMarkList(enableMark);
            double totalWorkOrderNowComplete = this.omWorkOrderMapper.getTotal(omWorkOrderGatewayNow);
            double totalWorkOrderNowNot = totalWorkOrderNow - totalWorkOrderNowComplete;
            OmWorkOrderGateway workOrderGatewayNow = new OmWorkOrderGateway();
            workOrderGatewayNow.setTotalWorkOrder(totalWorkOrderNow);
            workOrderGatewayNow.setTotalComplete(totalWorkOrderNowComplete);
            workOrderGatewayNow.setTotalNotComplete(totalWorkOrderNowNot);
            LocalDate startOfLastMonth = currentDate.minusMonths(1L).with(TemporalAdjusters.firstDayOfMonth());
            Date startDateLast = this.localDateToDate(startOfLastMonth);
            LocalDate endOfLastMonth = currentDate.minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth());
            Date endDateLast = this.localDateToDate(endOfLastMonth);
            omWorkOrderGatewayNow.setStartDate(startDateLast);
            omWorkOrderGatewayNow.setEndDate(endDateLast);
            omWorkOrderGatewayNow.setEnabledMarkList(null);
            double totalWorkOrderLast = this.omWorkOrderMapper.getTotal(omWorkOrderGatewayNow);
            omWorkOrderGatewayNow.setEnabledMarkList(enableMark);
            double totalWorkOrderLastComplete = this.omWorkOrderMapper.getTotal(omWorkOrderGatewayNow);
            double totalWorkOrderLastNot = totalWorkOrderLast - totalWorkOrderLastComplete;
            OmWorkOrderGateway workOrderGatewayLast = new OmWorkOrderGateway();
            workOrderGatewayLast.setTotalWorkOrder(totalWorkOrderLast);
            workOrderGatewayLast.setTotalComplete(totalWorkOrderLastComplete);
            workOrderGatewayLast.setTotalNotComplete(totalWorkOrderLastNot);
            LocalDate startOfPreviousMonth = currentDate.minusMonths(2L).with(TemporalAdjusters.firstDayOfMonth());
            Date startDatePrevious = this.localDateToDate(startOfPreviousMonth);
            LocalDate endOfPreviousMonth = currentDate.minusMonths(2L).with(TemporalAdjusters.lastDayOfMonth());
            Date endDatePrevious = this.localDateToDate(endOfPreviousMonth);
            omWorkOrderGatewayNow.setStartDate(startDatePrevious);
            omWorkOrderGatewayNow.setEndDate(endDatePrevious);
            omWorkOrderGatewayNow.setEnabledMarkList(null);
            double totalWorkOrderPrevious = this.omWorkOrderMapper.getTotal(omWorkOrderGatewayNow);
            omWorkOrderGatewayNow.setEnabledMarkList(enableMark);
            double totalWorkOrderPreviousComplete = this.omWorkOrderMapper.getTotal(omWorkOrderGatewayNow);
            double totalWorkOrderPreviousNot = totalWorkOrderPrevious - totalWorkOrderPreviousComplete;
            OmWorkOrderGateway workOrderGatewayPrevious = new OmWorkOrderGateway();
            workOrderGatewayPrevious.setTotalWorkOrder(totalWorkOrderPrevious);
            workOrderGatewayPrevious.setTotalComplete(totalWorkOrderPreviousComplete);
            workOrderGatewayPrevious.setTotalNotComplete(totalWorkOrderPreviousNot);
            ArrayList<Double> totalWorkOrder = new ArrayList<Double>();
            ArrayList<Double> totalComplete = new ArrayList<Double>();
            ArrayList<Double> totalNotComplete = new ArrayList<Double>();
            totalWorkOrder.add(totalWorkOrderPrevious);
            totalWorkOrder.add(totalWorkOrderLast);
            totalWorkOrder.add(totalWorkOrderNow);
            totalComplete.add(totalWorkOrderPreviousComplete);
            totalComplete.add(totalWorkOrderLastComplete);
            totalComplete.add(totalWorkOrderNowComplete);
            totalNotComplete.add(totalWorkOrderPreviousNot);
            totalNotComplete.add(totalWorkOrderLastNot);
            totalNotComplete.add(totalWorkOrderNowNot);
            workOrderCountStatistics.setTotalWorkOrder(totalWorkOrder);
            workOrderCountStatistics.setTotalComplete(totalComplete);
            workOrderCountStatistics.setTotalNotComplete(totalNotComplete);
        } else if ("week".equals(omWorkOrderGateway.getTimeGranularity())) {
            OmWorkOrderGateway omWorkOrderGatewayNow = new OmWorkOrderGateway();
            LocalDate today = LocalDate.now();
            ArrayList<String> enableMark = new ArrayList<String>();
            enableMark.add("execute");
            enableMark.add("evaluate");
            Date startOfWeek = this.localDateToDate(today.with(DayOfWeek.MONDAY));
            Date endOfWeek = this.localDateToDate(today.with(DayOfWeek.MONDAY).plusDays(6L));
            omWorkOrderGatewayNow.setStartDate(startOfWeek);
            omWorkOrderGatewayNow.setEndDate(endOfWeek);
            double totalWorkOrderNow = this.omWorkOrderMapper.getTotal(omWorkOrderGatewayNow);
            omWorkOrderGatewayNow.setEnabledMarkList(enableMark);
            double totalWorkOrderNowComplete = this.omWorkOrderMapper.getTotal(omWorkOrderGatewayNow);
            double totalWorkOrderNowNot = totalWorkOrderNow - totalWorkOrderNowComplete;
            omWorkOrderGatewayNow.setEnabledMarkList(null);
            Date startOfWeek1 = this.localDateToDate(today.minusWeeks(1L).with(DayOfWeek.MONDAY));
            Date endOfWeek1 = this.localDateToDate(today.minusWeeks(1L).with(DayOfWeek.MONDAY).plusDays(6L));
            omWorkOrderGatewayNow.setStartDate(startOfWeek1);
            omWorkOrderGatewayNow.setEndDate(endOfWeek1);
            double totalWorkOrder1 = this.omWorkOrderMapper.getTotal(omWorkOrderGatewayNow);
            omWorkOrderGatewayNow.setEnabledMarkList(enableMark);
            double totalWorkOrderComplete1 = this.omWorkOrderMapper.getTotal(omWorkOrderGatewayNow);
            double totalWorkOrderLastNot = totalWorkOrder1 - totalWorkOrderComplete1;
            omWorkOrderGatewayNow.setEnabledMarkList(null);
            Date startOfWeek2 = this.localDateToDate(today.minusWeeks(2L).with(DayOfWeek.MONDAY));
            Date endOfWeek2 = this.localDateToDate(today.minusWeeks(2L).with(DayOfWeek.MONDAY).plusDays(6L));
            omWorkOrderGatewayNow.setStartDate(startOfWeek2);
            omWorkOrderGatewayNow.setEndDate(endOfWeek2);
            double totalWorkOrder2 = this.omWorkOrderMapper.getTotal(omWorkOrderGatewayNow);
            omWorkOrderGatewayNow.setEnabledMarkList(enableMark);
            double totalWorkOrderPreviousComplete = this.omWorkOrderMapper.getTotal(omWorkOrderGatewayNow);
            double totalWorkOrderPreviousNot = totalWorkOrder2 - totalWorkOrderPreviousComplete;
            System.out.println("Start of week: " + startOfWeek);
            System.out.println("End of week: " + endOfWeek);
            LocalDate date = LocalDate.now();
            DayOfWeek dayOfWeek = date.getDayOfWeek();
            OmWorkOrderGateway workOrderGatewayPrevious = new OmWorkOrderGateway();
            workOrderGatewayPrevious.setTotalWorkOrder(totalWorkOrderNow);
            workOrderGatewayPrevious.setTotalComplete(totalWorkOrderPreviousComplete);
            workOrderGatewayPrevious.setTotalNotComplete(totalWorkOrderPreviousNot);
            ArrayList<Double> totalWorkOrder = new ArrayList<Double>();
            ArrayList<Double> totalComplete = new ArrayList<Double>();
            ArrayList<Double> totalNotComplete = new ArrayList<Double>();
            totalWorkOrder.add(totalWorkOrder2);
            totalWorkOrder.add(totalWorkOrderComplete1);
            totalWorkOrder.add(totalWorkOrderNow);
            totalComplete.add(totalWorkOrderPreviousComplete);
            totalComplete.add(totalWorkOrderComplete1);
            totalComplete.add(totalWorkOrderNowComplete);
            totalNotComplete.add(totalWorkOrderPreviousNot);
            totalNotComplete.add(totalWorkOrderLastNot);
            totalNotComplete.add(totalWorkOrderNowNot);
            workOrderCountStatistics.setTotalWorkOrder(totalWorkOrder);
            workOrderCountStatistics.setTotalComplete(totalComplete);
            workOrderCountStatistics.setTotalNotComplete(totalNotComplete);
        }
        return workOrderCountStatistics;
    }

    public static void main(String[] args) {
        LocalDate today = LocalDate.now();
        LocalDate startOfWeek = today.with(DayOfWeek.MONDAY);
        LocalDate endOfWeek = today.with(DayOfWeek.MONDAY).plusDays(6L);
        LocalDate startOfWeek1 = today.minusWeeks(1L).with(DayOfWeek.MONDAY).plusDays(6L);
        System.out.println("Start of week: " + startOfWeek);
        System.out.println("End of week: " + endOfWeek);
    }

    @Override
    public List<Double> getGradeStatistics(OmWorkOrderGateway omWorkOrderGateway) {
        omWorkOrderGateway.setEvaluateGrade(1);
        double totalWorkOrderOne = this.omWorkOrderMapper.getGradeStatistics(omWorkOrderGateway);
        omWorkOrderGateway.setEvaluateGrade(2);
        double totalWorkOrderTwo = this.omWorkOrderMapper.getGradeStatistics(omWorkOrderGateway);
        omWorkOrderGateway.setEvaluateGrade(3);
        double totalWorkOrderThree = this.omWorkOrderMapper.getGradeStatistics(omWorkOrderGateway);
        omWorkOrderGateway.setEvaluateGrade(4);
        double totalWorkOrderFour = this.omWorkOrderMapper.getGradeStatistics(omWorkOrderGateway);
        omWorkOrderGateway.setEvaluateGrade(5);
        double totalWorkOrderFive = this.omWorkOrderMapper.getGradeStatistics(omWorkOrderGateway);
        ArrayList<Double> returnDouble = new ArrayList<Double>();
        returnDouble.add(totalWorkOrderOne);
        returnDouble.add(totalWorkOrderTwo);
        returnDouble.add(totalWorkOrderThree);
        returnDouble.add(totalWorkOrderFour);
        returnDouble.add(totalWorkOrderFive);
        return returnDouble;
    }

    private Date localDateToDate(LocalDate localDate) {
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDate.atStartOfDay(zone).toInstant();
        return Date.from(instant);
    }

    @Override
    public boolean permitState(String id, String enabledMark) {
        if (!ObjectUtil.isEmpty((Object)enabledMark)) {
            OmWorkOrderCrForm info = this.getInfo(id);
            HashMap<String, String> actions = new HashMap<String, String>();
            ArrayList<String> draftList = new ArrayList<String>();
            draftList.add("draft");
            draftList.add("submit");
            actions.put("draft", "draft,submit");
            actions.put("submit", "draft,pending,accepted");
            actions.put("pending", "accepted");
            actions.put("accepted", "assign");
            actions.put("assign", "execute,assign,draft");
            actions.put("execute", "confirm,draft");
            actions.put("confirm", "evaluate");
            String s = (String)actions.get(info.getEnabledMark());
            return s.contains(enabledMark);
        }
        return true;
    }

    @Override
    public void autoAssign() throws Exception {
        String workOrderAccept = this.sysConfigService.getConfigByKeyName("workOrderAuto").getKeyValue();
        if ("false".equals(workOrderAccept)) {
            return;
        }
        OmWorkOrderPagination omWorkOrderPagination = new OmWorkOrderPagination();
        omWorkOrderPagination.setEnabledMark("submit");
        List<OmWorkOrderEntity> listNoPag = this.getListNoPag(omWorkOrderPagination);
        listNoPag.stream().forEach(i -> {
            List<OmWorkGroupEntity> groupByTypes;
            List<String> groupIdList;
            List listByObjectIdAll;
            Date startTime = ObjectUtil.isEmpty((Object)i.getStartTime()) ? new Date() : i.getStartTime();
            i.getWorkOrderTypeId();
            OmWorkOrderTypeEntity info = new OmWorkOrderTypeEntity();
            ArrayList<UserEntity> userList = new ArrayList();
            info = this.omWorkOrderTypeService.getInfo(i.getWorkOrderTypeId());
            if (ObjectUtil.isEmpty((Object)info)) {
                return;
            }
            if (ObjectUtil.isEmpty((Object)info.getId()) || ObjectUtil.isEmpty((Object)info.getFinishTime())) {
                info.setFinishTime("0");
            }
            Date finishDate = DateUtils.addHours((Date)startTime, (int)Integer.valueOf(info.getFinishTime()));
            ArrayList<Object> listTreeStep = new ArrayList<Object>();
            listTreeStep.add(JsonUtil.getJsonToBean((Object)this.omWorkOrderTypeService.getInfo(i.getWorkOrderTypeId()), OmWorkOrderTypeCrForm.class));
            List<OmWorkOrderTypeCrForm> listTreeStepType = this.omWorkOrderTypeService.getListTreeStep(i.getWorkOrderTypeId());
            if (!ObjectUtil.isEmpty(listTreeStepType)) {
                listTreeStep.addAll(listTreeStepType);
            }
            if (!ObjectUtil.isEmpty((Object)(listByObjectIdAll = this.userRelationService.getListByObjectIdAll(groupIdList = (groupByTypes = this.omWorkGroupService.getByTypes(listTreeStep.stream().map(item -> item.getId()).collect(Collectors.toList()))).stream().map(item -> item.getBaseGroupId()).distinct().collect(Collectors.toList()))))) {
                userList = this.userService.listByIds((Collection)listByObjectIdAll.stream().map(item -> item.getUserId()).collect(Collectors.toList()));
            }
            OmWorkOrderHistoryPagination omWorkOrderHistoryPagination = new OmWorkOrderHistoryPagination();
            omWorkOrderHistoryPagination.setPhase("assign");
            ArrayList<Date> dateList = new ArrayList<Date>();
            dateList.add(startTime);
            dateList.add(finishDate);
            omWorkOrderHistoryPagination.setCreatorTimeList(dateList);
            OmWorkOrderCrForm workOrderCrForm = new OmWorkOrderCrForm();
            if ("autoAssign".equals(workOrderAccept)) {
                this.autoAssignMode(workOrderCrForm, (OmWorkOrderEntity)i, (List<UserEntity>)userList, groupIdList);
            }
            if ("leader".equals(workOrderAccept)) {
                this.leaderMode(workOrderCrForm, groupIdList);
            }
            if ("combin".equals(workOrderAccept)) {
                if ("false".equals(info.getAssignType()) || ObjectUtil.isEmpty((Object)info.getAssignType())) {
                    return;
                }
                if ("autoAssign".equals(info.getAssignType())) {
                    this.autoAssignMode(workOrderCrForm, (OmWorkOrderEntity)i, (List<UserEntity>)userList, groupIdList);
                } else if ("leader".equals(info.getAssignType())) {
                    this.leaderMode(workOrderCrForm, groupIdList);
                }
            }
            workOrderCrForm.setEnabledMark("assign");
            workOrderCrForm.setAcceptUser("\u7cfb\u7edf\u81ea\u52a8\u53d7\u7406");
            workOrderCrForm.setAcceptTime(new Date());
            workOrderCrForm.setId(i.getId());
            try {
                Thread.sleep(1000L);
                this.updateWorkWithHistory(workOrderCrForm);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void autoAssignMode(OmWorkOrderCrForm workOrderCrForm, OmWorkOrderEntity i, List<UserEntity> userList, List<String> groupIdList) {
        List infoBetweenDutyDate = this.omDutyService.getInfoBetweenDutyDate(i.getStartTime()).stream().map(a -> a.getDutyUserId()).collect(Collectors.toList());
        List executeUserList = userList.stream().filter(a -> infoBetweenDutyDate.contains(a.getId())).collect(Collectors.toList());
        if (!ObjectUtil.isEmpty(executeUserList)) {
            workOrderCrForm.setExecuteUser(((UserEntity)executeUserList.get(0)).getId());
            workOrderCrForm.setDescription("\u7cfb\u7edf\u81ea\u52a8\u5206\u6d3e\u7ed9" + ((UserEntity)executeUserList.get(0)).getRealName());
        } else {
            String leadId = groupIdList.get(0);
            GroupEntity groupLeader = this.userGroupService.getInfo(leadId);
            workOrderCrForm.setExecuteUser(groupLeader.getGroupLeader());
            workOrderCrForm.setDescription("\u7cfb\u7edf\u81ea\u52a8\u5206\u6d3e\u7ed9" + this.userService.getInfo(groupLeader.getGroupLeader()).getRealName());
        }
    }

    public void leaderMode(OmWorkOrderCrForm workOrderCrForm, List<String> groupIdList) {
        if (ObjectUtil.isEmpty(groupIdList)) {
            return;
        }
        String leadId = groupIdList.get(0);
        GroupEntity groupLeader = this.userGroupService.getInfo(leadId);
        workOrderCrForm.setExecuteUser(groupLeader.getGroupLeader());
        workOrderCrForm.setDescription("\u7cfb\u7edf\u81ea\u52a8\u5206\u6d3e\u7ed9" + this.userService.getInfo(groupLeader.getGroupLeader()).getRealName());
    }

    @Override
    public List<OmWorkOrderEntity> getByIds(List<String> ids) {
        QueryWrapper queryWrapper = new QueryWrapper();
        return this.list((Wrapper)queryWrapper.lambda().in(OmWorkOrderEntity::getId, ids));
    }

    @Override
    public void delete(OmWorkOrderEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    public void sendMessage(List<String> userId, String title, OmWorkOrderCrForm info, String url) throws Exception {
        Field[] fields;
        List collect = userId.stream().distinct().collect(Collectors.toList());
        SentMessageForm sentMessageForm = new SentMessageForm();
        sentMessageForm.setType(Integer.valueOf(3));
        sentMessageForm.setToUserIds(collect);
        sentMessageForm.setTemplateId(this.sysConfigService.getConfigByKeyName("workOrderMessage").getKeyValue());
        sentMessageForm.setTitle("\u7ad9\u5185\u4fe1\u6807\u9898");
        sentMessageForm.setContent("\u7ad9\u5185\u4fe1\u5185\u5bb9");
        sentMessageForm.setBodyText(new HashMap());
        HashMap<String, String> map = new HashMap<String, String>();
        for (Field field : fields = OmWorkOrderCrForm.class.getDeclaredFields()) {
            field.setAccessible(true);
            try {
                map.put(field.getName(), String.valueOf(field.get(info)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        HashMap<String, String> colorMap = new HashMap<String, String>();
        colorMap.put("emergent", "highlight");
        colorMap.put("normal", "gray");
        colorMap.put("urgent", "normal");
        map.put("priority", (String)colorMap.get(info.getPriority()));
        String appUrl = "/#/pages/work-order/my-work-order/detailNew?id=" + info.getId();
        map.put("AppUrl", this.sysConfigService.getSystemAddress("app") + appUrl);
        sentMessageForm.setParameterMap(map);
        sentMessageForm.setBodyText(map);
        ArrayList<SentMessageForm> messageListAll = new ArrayList<SentMessageForm>();
        messageListAll.add(sentMessageForm);
    }

    private void sendMessage2(List<String> userId, OmWorkOrderCrForm info, String appUrl, String pcUrl, String messageTemplate) {
        Field[] fields;
        List collect = userId.stream().distinct().collect(Collectors.toList());
        if (ObjectUtil.isEmpty(collect)) {
            return;
        }
        TaskMsg taskMsg = new TaskMsg();
        taskMsg.setTaskCode("\u5de5\u5355\u7ba1\u7406");
        taskMsg.setSendCode(messageTemplate);
        HashMap<String, String> map = new HashMap<String, String>();
        for (Field field : fields = OmWorkOrderCrForm.class.getDeclaredFields()) {
            field.setAccessible(true);
            try {
                map.put(field.getName(), String.valueOf(field.get(info)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ("workorder_notification".equals(messageTemplate)) {
            map.put("thing1", info.getTitle());
            map.put("phrase5", info.getEnabledMarkName().length() > 5 ? info.getEnabledMarkName().substring(0, 5) : info.getEnabledMarkName());
            map.put("thing4", info.getLocation().length() > 20 ? info.getLocation().substring(0, 20) : info.getLocation());
        }
        LinkMsgKeys linkMsgKeys = new LinkMsgKeys();
        linkMsgKeys.setLinkUrl("pages/launch/index");
        linkMsgKeys.setKeys(map);
        taskMsg.setBusinessKey((BusinessKeys)linkMsgKeys);
        CustomKeysLink customKeysLink = new CustomKeysLink();
        customKeysLink.setAppUrl(appUrl);
        customKeysLink.setPcUrl(pcUrl);
        taskMsg.setCustomKey(customKeysLink);
        HashMap<String, String> customerMap = new HashMap<String, String>();
        customerMap.put("appUrl", appUrl);
        AuthorizeVO authorizeModel = this.authorizeService.getAuthorize(false);
        List moduleList = authorizeModel.getModuleList().stream().filter(v -> "WorkOrderSystem".equals(v.getEnCode())).collect(Collectors.toList());
        customerMap.put("pcUrl", pcUrl + "?applicationId=" + ((ModuleModel)moduleList.get(0)).getId());
        taskMsg.setToUserIds(String.join((CharSequence)",", collect));
        ThreadUtil.execute(() -> {
            try {
                this.sendTaskMsgUtils.sendTaskMsg(taskMsg);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public List<OmWorkOrderEntity> getTypeList(OmWorkOrderPagination omWorkOrderPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int omWorkOrderNum = 0;
        QueryWrapper omWorkOrderQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getWorkOrderTypeId())) {
            ++omWorkOrderNum;
            omWorkOrderQueryWrapper.lambda().like(OmWorkOrderEntity::getWorkOrderTypeId, (Object)omWorkOrderPagination.getWorkOrderTypeId());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getCode())) {
            ++omWorkOrderNum;
            omWorkOrderQueryWrapper.lambda().like(OmWorkOrderEntity::getCode, (Object)omWorkOrderPagination.getCode());
        }
        if (StringUtils.isNotEmpty((String)omWorkOrderPagination.getTitle())) {
            ++omWorkOrderNum;
            omWorkOrderQueryWrapper.lambda().like(OmWorkOrderEntity::getTitle, (Object)omWorkOrderPagination.getTitle());
        }
        if (AllIdList.size() > 0) {
            omWorkOrderQueryWrapper.lambda().in(OmWorkOrderEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)omWorkOrderPagination.getSidx())) {
            omWorkOrderQueryWrapper.lambda().orderByDesc(OmWorkOrderEntity::getId);
        } else {
            try {
                String sidx = omWorkOrderPagination.getSidx();
                OmWorkOrderEntity omWorkOrderEntity = new OmWorkOrderEntity();
                Field declaredField = omWorkOrderEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                omWorkOrderQueryWrapper = "asc".equals(omWorkOrderPagination.getSort().toLowerCase()) ? (QueryWrapper)omWorkOrderQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)omWorkOrderQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(omWorkOrderPagination.getCurrentPage(), omWorkOrderPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)omWorkOrderQueryWrapper);
                return omWorkOrderPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return omWorkOrderPagination.setData(list, list.size());
        }
        return this.list((Wrapper)omWorkOrderQueryWrapper);
    }

    @Override
    public List<OmWorkOrderEntity> selectList() {
        return this.omWorkOrderMapper.selectList(null);
    }
}

