/*
 * Decompiled with CFR 0.152.
 */
package com.bsmis.core.auth.handler;

import cn.dev33.satoken.exception.DisableLoginException;
import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.exception.NotPermissionException;
import cn.dev33.satoken.exception.NotRoleException;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.exception.StopMatchException;
import com.bsmis.core.auth.exception.AuthBaseException;
import com.bsmis.core.common.api.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@ResponseBody
@RestControllerAdvice
public class AuthBaseExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(AuthBaseExceptionHandler.class);

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Result<?> handleException(AuthBaseException ex) {
        log.error("\u7a0b\u5e8f\u5f02\u5e38\uff1a" + ex.toString());
        return Result.fail((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)ex.getMessage());
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public Result<?> handleException(NotLoginException ex) {
        log.error("\u7a0b\u5e8f\u5f02\u5e38\uff1a" + ex.toString());
        return Result.fail((int)HttpStatus.UNAUTHORIZED.value(), (String)ex.getMessage());
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Result<?> handleException(DisableLoginException ex) {
        log.error("\u7a0b\u5e8f\u5f02\u5e38\uff1a" + ex.toString());
        return Result.fail((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)ex.getMessage());
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.PAYMENT_REQUIRED)
    public Result<?> handleException(NotPermissionException ex) {
        log.error("\u7a0b\u5e8f\u5f02\u5e38\uff1a" + ex.toString());
        return Result.fail((int)HttpStatus.PAYMENT_REQUIRED.value(), (String)ex.getMessage());
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.PAYMENT_REQUIRED)
    public Result<?> handleException(NotRoleException ex) {
        log.error("\u7a0b\u5e8f\u5f02\u5e38\uff1a" + ex.toString());
        return Result.fail((int)HttpStatus.PAYMENT_REQUIRED.value(), (String)ex.getMessage());
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Result<?> handleException(SaTokenException ex) {
        log.error("\u7a0b\u5e8f\u5f02\u5e38\uff1a" + ex.toString());
        return Result.fail((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)ex.getMessage());
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Result<?> handleException(StopMatchException ex) {
        log.error("\u7a0b\u5e8f\u5f02\u5e38\uff1a" + ex.toString());
        return Result.fail((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)ex.getMessage());
    }
}

