/*
 * Decompiled with CFR 0.152.
 */
package com.bsmis.core.database.config;

import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import com.bsmis.core.common.factory.YamlPropertySourceFactory;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(factory=YamlPropertySourceFactory.class, value={"classpath:druid-db.yml"})
@ComponentScan(value={"com.bsmis"})
@ConfigurationProperties(prefix="spring.datasource.druid.stat-view-servlet")
public class DruidConfiguration {
    private String allow = "true";
    private String deny = "admin";
    private String loginUsername = "admin";
    private String loginPassword = "admin";
    private String resetEnable = "true";

    @Bean
    public ServletRegistrationBean DruidStatViewServle() {
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean((Servlet)new StatViewServlet(), new String[]{"/druid/*"});
        servletRegistrationBean.addInitParameter("allow", this.allow);
        servletRegistrationBean.addInitParameter("deny", this.deny);
        servletRegistrationBean.addInitParameter("loginUsername", this.loginUsername);
        servletRegistrationBean.addInitParameter("loginPassword", this.loginPassword);
        servletRegistrationBean.addInitParameter("resetEnable", this.resetEnable);
        return servletRegistrationBean;
    }

    @Bean
    public FilterRegistrationBean druidStatFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new WebStatFilter(), new ServletRegistrationBean[0]);
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        filterRegistrationBean.addInitParameter("exclusions", "*.js,*.gif,*.jpg,*.png,*.css,*.ico,/druid/*");
        return filterRegistrationBean;
    }

    public String getAllow() {
        return this.allow;
    }

    public String getDeny() {
        return this.deny;
    }

    public String getLoginUsername() {
        return this.loginUsername;
    }

    public String getLoginPassword() {
        return this.loginPassword;
    }

    public String getResetEnable() {
        return this.resetEnable;
    }

    public void setAllow(String allow) {
        this.allow = allow;
    }

    public void setDeny(String deny) {
        this.deny = deny;
    }

    public void setLoginUsername(String loginUsername) {
        this.loginUsername = loginUsername;
    }

    public void setLoginPassword(String loginPassword) {
        this.loginPassword = loginPassword;
    }

    public void setResetEnable(String resetEnable) {
        this.resetEnable = resetEnable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DruidConfiguration)) {
            return false;
        }
        DruidConfiguration other = (DruidConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$allow = this.getAllow();
        String other$allow = other.getAllow();
        if (this$allow == null ? other$allow != null : !this$allow.equals(other$allow)) {
            return false;
        }
        String this$deny = this.getDeny();
        String other$deny = other.getDeny();
        if (this$deny == null ? other$deny != null : !this$deny.equals(other$deny)) {
            return false;
        }
        String this$loginUsername = this.getLoginUsername();
        String other$loginUsername = other.getLoginUsername();
        if (this$loginUsername == null ? other$loginUsername != null : !this$loginUsername.equals(other$loginUsername)) {
            return false;
        }
        String this$loginPassword = this.getLoginPassword();
        String other$loginPassword = other.getLoginPassword();
        if (this$loginPassword == null ? other$loginPassword != null : !this$loginPassword.equals(other$loginPassword)) {
            return false;
        }
        String this$resetEnable = this.getResetEnable();
        String other$resetEnable = other.getResetEnable();
        return !(this$resetEnable == null ? other$resetEnable != null : !this$resetEnable.equals(other$resetEnable));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DruidConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $allow = this.getAllow();
        result = result * 59 + ($allow == null ? 43 : $allow.hashCode());
        String $deny = this.getDeny();
        result = result * 59 + ($deny == null ? 43 : $deny.hashCode());
        String $loginUsername = this.getLoginUsername();
        result = result * 59 + ($loginUsername == null ? 43 : $loginUsername.hashCode());
        String $loginPassword = this.getLoginPassword();
        result = result * 59 + ($loginPassword == null ? 43 : $loginPassword.hashCode());
        String $resetEnable = this.getResetEnable();
        result = result * 59 + ($resetEnable == null ? 43 : $resetEnable.hashCode());
        return result;
    }

    public String toString() {
        return "DruidConfiguration(allow=" + this.getAllow() + ", deny=" + this.getDeny() + ", loginUsername=" + this.getLoginUsername() + ", loginPassword=" + this.getLoginPassword() + ", resetEnable=" + this.getResetEnable() + ")";
    }
}

