/*
 * Decompiled with CFR 0.152.
 */
package com.bsmis.core.database.config;

import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.bsmis.core.common.factory.YamlPropertySourceFactory;
import com.bsmis.core.database.handle.BsmisMetaObjectHandler;
import com.bsmis.core.database.log.interceptor.SqlLogInterceptor;
import com.bsmis.core.database.log.props.BsmisMybatisProperties;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableConfigurationProperties(value={BsmisMybatisProperties.class})
@PropertySource(factory=YamlPropertySourceFactory.class, value={"classpath:mybatis-plus.yml"})
@MapperScan(value={"com.bsmis.**.mapper.**"})
public class MybatisPlusConfiguration {
    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor());
        return interceptor;
    }

    @Bean
    @ConditionalOnProperty(value={"mybatis-plus.sql-log.enable"}, matchIfMissing=true)
    public SqlLogInterceptor sqlLogInterceptor() {
        return new SqlLogInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean(value={BsmisMetaObjectHandler.class})
    public BsmisMetaObjectHandler bsmisMetaObjectHandler() {
        return new BsmisMetaObjectHandler();
    }
}

