/*
 * Decompiled with CFR 0.152.
 */
package com.bsmis.core.database.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.bsmis.core.common.util.StringUtil;
import com.bsmis.core.database.exception.DataBaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@RefreshScope
@ConfigurationProperties(prefix="spring.datasource.druid")
public class NewDruidDataSource {
    private static final Logger log = LoggerFactory.getLogger(NewDruidDataSource.class);
    private String url;
    private String username;
    private String password;
    private String driverClassName;

    @Bean(name={"datasource"})
    @RefreshScope
    public DruidDataSource dataSource() {
        if (StringUtil.isBlank((String)this.url)) {
            throw new DataBaseException("\u672a\u914d\u7f6e\u6570\u636e\u5e93\u8fde\u63a5\u5730\u5740");
        }
        if (StringUtil.isBlank((String)this.username)) {
            throw new DataBaseException("\u672a\u914d\u7f6e\u6570\u636e\u5e93\u7528\u6237\u540d");
        }
        if (StringUtil.isBlank((String)this.password)) {
            throw new DataBaseException("\u672a\u914d\u7f6e\u6570\u636e\u5e93\u5bc6\u7801");
        }
        if (StringUtil.isBlank((String)this.driverClassName)) {
            throw new DataBaseException("\u672a\u914d\u7f6e\u6570\u636e\u5e93\u9a71\u52a8");
        }
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(this.url);
        datasource.setUsername(this.username);
        datasource.setPassword(this.password);
        datasource.setDriverClassName(this.driverClassName);
        log.info("\u6570\u636e\u5e93\u94fe\u63a5\u5730\u5740\uff1a" + this.url);
        log.info("\u6570\u636e\u5e93\u9a71\u52a8\uff1a" + this.driverClassName);
        log.info("\u6570\u636e\u5e93\u7528\u6237\u540d\uff1a" + this.username);
        log.info("\u6570\u636e\u5e93\u5bc6\u7801\uff1a" + this.password);
        return datasource;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NewDruidDataSource)) {
            return false;
        }
        NewDruidDataSource other = (NewDruidDataSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$driverClassName = this.getDriverClassName();
        String other$driverClassName = other.getDriverClassName();
        return !(this$driverClassName == null ? other$driverClassName != null : !this$driverClassName.equals(other$driverClassName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NewDruidDataSource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $driverClassName = this.getDriverClassName();
        result = result * 59 + ($driverClassName == null ? 43 : $driverClassName.hashCode());
        return result;
    }

    public String toString() {
        return "NewDruidDataSource(url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", driverClassName=" + this.getDriverClassName() + ")";
    }
}

