/*
 * Decompiled with CFR 0.152.
 */
package com.bsmis.core.database.log.injector.methods;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlScriptUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.springframework.util.StringUtils;

public class AbstractInsertBatch
extends AbstractMethod {
    private final String sqlTemp;
    private final String sqlMethod;

    public MappedStatement injectMappedStatement(Class<?> mapperClass, Class<?> modelClass, TableInfo tableInfo) {
        NoKeyGenerator keyGenerator = new NoKeyGenerator();
        String keyProperty = null;
        String keyColumn = null;
        if (StringUtils.hasText((String)tableInfo.getKeyProperty())) {
            if (tableInfo.getIdType() == IdType.AUTO) {
                keyGenerator = new Jdbc3KeyGenerator();
                keyProperty = tableInfo.getKeyProperty();
                keyColumn = tableInfo.getKeyColumn();
            } else if (null != tableInfo.getKeySequence()) {
                keyGenerator = TableInfoHelper.genKeyGenerator((String)this.sqlMethod, (TableInfo)tableInfo, (MapperBuilderAssistant)this.builderAssistant);
                keyProperty = tableInfo.getKeyProperty();
                keyColumn = tableInfo.getKeyColumn();
            }
        }
        String columnScript = SqlScriptUtils.convertTrim((String)AbstractInsertBatch.getAllInsertSqlColumnMaybeIf(tableInfo), (String)"(", (String)")", null, (String)",");
        String valuesScript = SqlScriptUtils.convertTrim((String)AbstractInsertBatch.getAllInsertSqlPropertyMaybeIf(tableInfo), (String)"(", (String)")", null, (String)",");
        String valuesScripts = SqlScriptUtils.convertForeach((String)valuesScript, (String)"coll", null, (String)"et", (String)",");
        String sql = String.format(this.sqlTemp, tableInfo.getTableName(), columnScript, valuesScripts);
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        return this.addInsertMappedStatement(mapperClass, modelClass, this.sqlMethod, sqlSource, (KeyGenerator)keyGenerator, keyProperty, keyColumn);
    }

    private static String getAllInsertSqlColumnMaybeIf(TableInfo tableInfo) {
        List fieldList = tableInfo.getFieldList();
        return tableInfo.getKeyInsertSqlColumn(true) + fieldList.stream().map(AbstractInsertBatch::getInsertSqlColumnMaybeIf).collect(Collectors.joining("\n"));
    }

    private static String getInsertSqlColumnMaybeIf(TableFieldInfo tableFieldInfo) {
        return tableFieldInfo.getInsertSqlColumn();
    }

    private static String getAllInsertSqlPropertyMaybeIf(TableInfo tableInfo) {
        List fieldList = tableInfo.getFieldList();
        return tableInfo.getKeyInsertSqlProperty("et.", true) + fieldList.stream().map(AbstractInsertBatch::getInsertSqlPropertyMaybeIf).collect(Collectors.joining("\n"));
    }

    private static String getInsertSqlPropertyMaybeIf(TableFieldInfo tableFieldInfo) {
        return tableFieldInfo.getInsertSqlProperty("et.");
    }

    public AbstractInsertBatch(String sqlTemp, String sqlMethod) {
        this.sqlTemp = sqlTemp;
        this.sqlMethod = sqlMethod;
    }
}

