/*
 * Decompiled with CFR 0.152.
 */
package com.bsmis.core.feign.fallback;

import com.bsmis.core.common.api.IResultCode;
import com.bsmis.core.common.api.Result;
import com.bsmis.core.common.api.ResultCode;
import feign.FeignException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public class MateFeignFallback<T>
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(MateFeignFallback.class);
    private final Class<T> targetType;
    private final String targetName;
    private final Throwable cause;
    private final String code = "code";

    @Nullable
    public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        String errorMessage = this.cause.getMessage();
        log.error("MateFeignFallback:[{}.{}] serviceId:[{}] message:[{}]", new Object[]{this.targetType.getName(), method.getName(), this.targetName, errorMessage});
        Class<?> returnType = method.getReturnType();
        if (Result.class != returnType) {
            return null;
        }
        if (!(this.cause instanceof FeignException)) {
            return Result.fail((IResultCode)ResultCode.FAILURE, (String)errorMessage);
        }
        FeignException exception = (FeignException)this.cause;
        byte[] content = exception.content();
        if (ObjectUtils.isEmpty((Object)content)) {
            return Result.fail((IResultCode)ResultCode.FAILURE, (String)errorMessage);
        }
        return Result.fail((String)content.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MateFeignFallback that = (MateFeignFallback)o;
        return this.targetType.equals(that.targetType);
    }

    public int hashCode() {
        return Objects.hash(this.targetType);
    }

    public MateFeignFallback(Class<T> targetType, String targetName, Throwable cause) {
        this.targetType = targetType;
        this.targetName = targetName;
        this.cause = cause;
    }
}

