/*
 * Decompiled with CFR 0.152.
 */
package com.bsmis.core.feign.config;

import com.bsmis.core.common.util.StringUtil;
import com.bsmis.core.common.util.TraceUtil;
import feign.RequestInterceptor;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Bean;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class FeignInterceptorConfiguration {
    private static final Logger log = LoggerFactory.getLogger(FeignInterceptorConfiguration.class);

    @Bean
    public RequestInterceptor requestInterceptor() {
        return requestTemplate -> {
            String traceId = MDC.get((String)"traceId");
            if (StringUtil.isBlank((String)traceId)) {
                HttpServletRequest request;
                Enumeration headerNames;
                ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                if (attributes != null && (headerNames = (request = attributes.getRequest()).getHeaderNames()) != null) {
                    String headerName = null;
                    while (headerNames.hasMoreElements()) {
                        headerName = (String)headerNames.nextElement();
                        if (headerName.equalsIgnoreCase("bsmis-trace-id")) {
                            traceId = request.getHeader(headerName);
                            requestTemplate.header("bsmis-trace-id", new String[]{traceId});
                            TraceUtil.mdcTraceId((String)traceId);
                        }
                        String values = request.getHeader(headerName);
                        requestTemplate.header(headerName, new String[]{values});
                    }
                }
            } else if (StringUtil.isNotBlank((String)traceId)) {
                requestTemplate.header("bsmis-trace-id", new String[]{traceId});
            }
        };
    }
}

