/*
 * Decompiled with CFR 0.152.
 */
package com.bsmis.core.log.aspect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bsmis.core.common.dto.CommonLog;
import com.bsmis.core.common.util.RequestUtil;
import com.bsmis.core.common.util.TraceUtil;
import com.bsmis.core.log.annotation.Log;
import com.bsmis.core.log.event.LogEvent;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Aspect
@Component
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    @Autowired
    private final ApplicationContext applicationContext;
    private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();

    public LogAspect(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Pointcut(value="@annotation(com.bsmis.core.log.annotation.Log)")
    public void pointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointcut()")
    public Object recordLog(ProceedingJoinPoint point) throws Throwable {
        Object result = new Object();
        HttpServletRequest request = RequestUtil.getHttpServletRequest();
        if (ObjectUtils.isEmpty((Object)request)) {
            return point.proceed();
        }
        Method targetMethod = this.resolveMethod(point);
        Log logAnn = targetMethod.getAnnotation(Log.class);
        long startTime = System.nanoTime();
        String method = request.getMethod();
        String url = request.getRequestURI();
        String ip = RequestUtil.getHttpServletRequestIpAddress();
        String region = "";
        Object[] args = point.getArgs();
        String requestParam = this.getArgs(args, request);
        long tookTime = 0L;
        try {
            result = point.proceed();
        }
        finally {
            tookTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        }
        String userName = null;
        if (url.contains("oauth") || !url.contains("code")) {
            // empty if block
        }
        CommonLog commonLog = new CommonLog();
        commonLog.setIp(ip).setCreateBy(userName).setMethod(method).setUrl(url).setOperation(String.valueOf(result)).setLocation(StringUtils.isEmpty((Object)region) ? "\u672c\u5730" : region).setTraceId(request.getHeader("bsmis-trace-id")).setExecuteTime(Long.valueOf(tookTime)).setTitle(logAnn.value()).setParams(JSON.toJSONString((Object)requestParam));
        log.info("Http Request: {}", (Object)JSONObject.toJSONString((Object)commonLog));
        this.applicationContext.publishEvent((ApplicationEvent)new LogEvent(commonLog));
        return result;
    }

    @AfterThrowing(pointcut="pointcut()", throwing="e")
    public void logAfterThrowing(JoinPoint point, Throwable e) {
        long startTime = System.nanoTime();
        CommonLog commonLog = new CommonLog();
        String ip = RequestUtil.getHttpServletRequestIpAddress();
        String region = "\u897f\u5b89";
        HttpServletRequest request = RequestUtil.getHttpServletRequest();
        String method = request.getMethod();
        String url = request.getRequestURI();
        Method targetMethod = this.resolveMethod((ProceedingJoinPoint)point);
        Log logAnn = targetMethod.getAnnotation(Log.class);
        commonLog.setExecuteTime(Long.valueOf(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime))).setIp(ip).setLocation(region).setMethod(method).setUrl(url).setTraceId(TraceUtil.getTraceId((HttpServletRequest)request)).setType("2").setTitle(logAnn.value());
        TraceUtil.mdcTraceId((String)TraceUtil.getTraceId((HttpServletRequest)request));
        this.applicationContext.publishEvent((ApplicationEvent)new LogEvent(commonLog));
        log.info("Error Result: {}", (Object)commonLog);
    }

    private Method resolveMethod(ProceedingJoinPoint point) {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Class<?> targetClass = point.getTarget().getClass();
        Method method = this.getDeclaredMethod(targetClass, signature.getName(), signature.getMethod().getParameterTypes());
        if (method == null) {
            throw new IllegalStateException("\u65e0\u6cd5\u89e3\u6790\u76ee\u6807\u65b9\u6cd5: " + signature.getMethod().getName());
        }
        return method;
    }

    private Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null) {
                return this.getDeclaredMethod(superClass, name, parameterTypes);
            }
            return null;
        }
    }

    private String getArgs(Object[] args, HttpServletRequest request) {
        String strArgs = "";
        try {
            if (!request.getContentType().contains("multipart/form-data")) {
                strArgs = JSONObject.toJSONString((Object)args);
            }
        }
        catch (Exception e) {
            try {
                strArgs = Arrays.toString(args);
            }
            catch (Exception ex) {
                log.warn("\u89e3\u6790\u53c2\u6570\u5f02\u5e38", (Throwable)ex);
            }
        }
        return strArgs;
    }

    public static MethodParameter getMethodParameter(Method method, int parameterIndex) {
        SynthesizingMethodParameter methodParameter = new SynthesizingMethodParameter(method, parameterIndex);
        methodParameter.initParameterNameDiscovery(PARAMETER_NAME_DISCOVERER);
        return methodParameter;
    }
}

