/*
 * Decompiled with CFR 0.152.
 */
package com.bsmis.core.log.config;

import com.bsmis.core.feign.annotation.EnableBsmisFeign;
import com.bsmis.core.log.aspect.LogAspect;
import com.bsmis.core.log.event.LogListener;
import com.bsmis.core.log.feign.ICommonLogProvider;
import com.bsmis.core.log.feign.ISysLogProvider;
import com.bsmis.core.log.props.LogProperties;
import com.bsmis.core.log.props.LogType;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

@EnableAsync
@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={LogProperties.class})
@EnableBsmisFeign
public class LogConfiguration {
    private final ISysLogProvider sysLogProvider;
    private final ICommonLogProvider commonLogProvider;
    private final LogProperties logProperties;

    @Bean
    public LogListener sysLogListener() {
        if (this.logProperties.getLogType().equals((Object)LogType.KAFKA)) {
            return new LogListener(this.commonLogProvider, this.logProperties);
        }
        return new LogListener(this.sysLogProvider, this.logProperties);
    }

    @Bean
    public LogAspect logAspect(ApplicationContext applicationContext) {
        return new LogAspect(applicationContext);
    }

    public LogConfiguration(ISysLogProvider sysLogProvider, ICommonLogProvider commonLogProvider, LogProperties logProperties) {
        this.sysLogProvider = sysLogProvider;
        this.commonLogProvider = commonLogProvider;
        this.logProperties = logProperties;
    }
}

