/*
 * Decompiled with CFR 0.152.
 */
package com.bsmis.core.log.event;

import com.bsmis.core.common.dto.CommonLog;
import com.bsmis.core.log.event.LogEvent;
import com.bsmis.core.log.feign.ICommonLogProvider;
import com.bsmis.core.log.feign.ISysLogProvider;
import com.bsmis.core.log.props.LogProperties;
import com.bsmis.core.log.props.LogType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;

public class LogListener {
    private static final Logger log = LoggerFactory.getLogger(LogListener.class);
    private ISysLogProvider sysLogProvider;
    private ICommonLogProvider commonLogProvider;
    private LogProperties logProperties;

    public LogListener() {
    }

    public LogListener(ISysLogProvider sysLogProvider, LogProperties logProperties) {
        this.sysLogProvider = sysLogProvider;
        this.logProperties = logProperties;
    }

    public LogListener(ICommonLogProvider commonLogProvider, LogProperties logProperties) {
        this.commonLogProvider = commonLogProvider;
        this.logProperties = logProperties;
    }

    @Async
    @Order
    @EventListener(value={LogEvent.class})
    public void saveSysLog(LogEvent event) {
        CommonLog commonLog = (CommonLog)event.getSource();
        log.info("\u53d1\u9001\u65e5\u5fd7:{}", (Object)commonLog);
        if (this.logProperties.getLogType().equals((Object)LogType.KAFKA)) {
            this.commonLogProvider.sendCommonLog(commonLog);
        } else {
            this.sysLogProvider.set(commonLog);
        }
    }
}

