/*
 * Decompiled with CFR 0.152.
 */
package com.bsmis.core.redis.core;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.util.Assert;

public class RedisService {
    private static final Logger log = LoggerFactory.getLogger(RedisService.class);
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public Boolean expire(String key, Long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time.longValue(), TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return false;
        }
    }

    public void setExpire(String key, Object value, long time, TimeUnit timeUnit) {
        this.redisTemplate.opsForValue().set((Object)key, value, time, timeUnit);
    }

    public void setExpire(String key, Object value, final long time, final TimeUnit timeUnit, RedisSerializer<Object> valueSerializer) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawValue = this.rawValue(value, valueSerializer);
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                this.potentiallyUsePsetEx(connection);
                return null;
            }

            public void potentiallyUsePsetEx(RedisConnection connection) {
                if (!TimeUnit.MILLISECONDS.equals((Object)timeUnit) || !this.failsafeInvokePsetEx(connection)) {
                    connection.setEx(rawKey, TimeoutUtils.toSeconds((long)time, (TimeUnit)timeUnit), rawValue);
                }
            }

            private boolean failsafeInvokePsetEx(RedisConnection connection) {
                boolean failed = false;
                try {
                    connection.pSetEx(rawKey, time, rawValue);
                }
                catch (UnsupportedOperationException e) {
                    failed = true;
                }
                return !failed;
            }
        }, true);
    }

    public Long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public Boolean hasKey(String key) {
        try {
            return this.redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return false;
        }
    }

    public void del(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                this.redisTemplate.delete((Object)key[0]);
            } else {
                this.redisTemplate.delete(Arrays.asList(key));
            }
        }
    }

    public Object get(String key) {
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public Object get(String key, RedisSerializer<Object> valueSerializer) {
        byte[] rawKey = this.rawKey(key);
        return this.redisTemplate.execute(connection -> this.deserializeValue(connection.get(rawKey), valueSerializer), true);
    }

    public Boolean set(String key, Object value) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return false;
        }
    }

    public Boolean set(String key, Object value, Long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time.longValue(), TimeUnit.SECONDS);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return false;
        }
    }

    public Boolean set(String key, Object value, Duration timeout) {
        try {
            Assert.notNull((Object)timeout, (String)"Timeout must not be null!");
            if (TimeoutUtils.hasMillis((Duration)timeout)) {
                this.redisTemplate.opsForValue().set((Object)key, value, timeout.toMillis(), TimeUnit.MILLISECONDS);
            } else {
                this.redisTemplate.opsForValue().set((Object)key, value, timeout.getSeconds(), TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return false;
        }
    }

    public Long incr(String key, Long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, delta.longValue());
    }

    public Long decr(String key, Long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, -delta.longValue());
    }

    public Object hget(String key, String item) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public Map<Object, Object> hmget(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public Boolean hmset(String key, Map<String, Object> map) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return false;
        }
    }

    public Boolean hmset(String key, Map<String, Object> map, Long time) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return false;
        }
    }

    public Boolean hset(String key, String item, Object value) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            return true;
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return false;
        }
    }

    public Boolean hset(String key, String item, Object value, Long time) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return false;
        }
    }

    public void hdel(String key, Object ... item) {
        this.redisTemplate.opsForHash().delete((Object)key, item);
    }

    public Boolean hHasKey(String key, String item) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public Double hincr(String key, String item, Double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, by.doubleValue());
    }

    public Double hdecr(String key, String item, Double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, -by.doubleValue());
    }

    public Set<Object> sGet(String key) {
        try {
            return this.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return null;
        }
    }

    public Boolean sHasKey(String key, Object value) {
        try {
            return this.redisTemplate.opsForSet().isMember((Object)key, value);
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return false;
        }
    }

    public Long sSet(String key, Object ... values) {
        try {
            return this.redisTemplate.opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return 0L;
        }
    }

    public Long sSetAndTime(String key, Long time, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().add((Object)key, values);
            if (time > 0L) {
                this.expire(key, time);
            }
            return count;
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return 0L;
        }
    }

    public Long sGetSetSize(String key) {
        try {
            return this.redisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return 0L;
        }
    }

    public Long setRemove(String key, Object ... values) {
        try {
            return this.redisTemplate.opsForSet().remove((Object)key, values);
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return 0L;
        }
    }

    public List<Object> lGet(String key, Long start, Long end) {
        try {
            return this.redisTemplate.opsForList().range((Object)key, start.longValue(), end.longValue());
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return null;
        }
    }

    public Long lGetListSize(String key) {
        try {
            return this.redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return 0L;
        }
    }

    public Object lGetIndex(String key, Long index) {
        try {
            return this.redisTemplate.opsForList().index((Object)key, index.longValue());
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return null;
        }
    }

    public Boolean lSet(String key, Object value) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return false;
        }
    }

    public Boolean lSet(String key, Object value, Long time) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return false;
        }
    }

    public Boolean lSet(String key, List<Object> value) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return false;
        }
    }

    public Boolean lSet(String key, List<Object> value, Long time) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return false;
        }
    }

    public Boolean lUpdateIndex(String key, Long index, Object value) {
        try {
            this.redisTemplate.opsForList().set((Object)key, index.longValue(), value);
            return true;
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return false;
        }
    }

    public Long lRemove(String key, Long count, Object value) {
        try {
            return this.redisTemplate.opsForList().remove((Object)key, count.longValue(), value);
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            return 0L;
        }
    }

    public List<Object> getList(String key, int start, int end, RedisSerializer<Object> valueSerializer) {
        byte[] rawKey = this.rawKey(key);
        return (List)this.redisTemplate.execute(connection -> this.deserializeValues(connection.lRange(rawKey, (long)start, (long)end), valueSerializer), true);
    }

    private byte[] rawKey(Object key) {
        Assert.notNull((Object)key, (String)"non null key required");
        if (key instanceof byte[]) {
            return (byte[])key;
        }
        RedisSerializer redisSerializer = this.redisTemplate.getKeySerializer();
        return redisSerializer.serialize(key);
    }

    private byte[] rawValue(Object value, RedisSerializer valueSerializer) {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        return valueSerializer.serialize(value);
    }

    private List deserializeValues(List<byte[]> rawValues, RedisSerializer<Object> valueSerializer) {
        if (valueSerializer == null) {
            return rawValues;
        }
        return SerializationUtils.deserialize(rawValues, valueSerializer);
    }

    private Object deserializeValue(byte[] value, RedisSerializer<Object> valueSerializer) {
        if (valueSerializer == null) {
            return value;
        }
        return valueSerializer.deserialize(value);
    }
}

