/*
 * Decompiled with CFR 0.152.
 */
package com.bsmis.core.sentinel.config;

import com.alibaba.csp.sentinel.adapter.spring.webflux.callback.BlockRequestHandler;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.BlockExceptionHandler;
import com.alibaba.fastjson.JSONObject;
import com.bsmis.core.common.api.Result;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.ServerResponse;

@Configuration
public class SentinelConfiguration {

    @Configuration
    @ConditionalOnClass(value={ServerResponse.class})
    public static class WebfluxHandler {
        @Bean
        public BlockRequestHandler webfluxBlockExceptionHandler() {
            return (exchange, t) -> ServerResponse.status((HttpStatus)HttpStatus.TOO_MANY_REQUESTS).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue((Object)Result.fail((String)t.getMessage())));
        }
    }

    @Configuration
    @ConditionalOnClass(value={HttpServletRequest.class})
    public static class WebmvcHandler {
        @Bean
        public BlockExceptionHandler webmvcBlockExceptionHandler() {
            return (request, response, e) -> {
                response.setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
                Result result = Result.fail((String)"Too many request, please retry later.");
                response.getWriter().print(JSONObject.toJSONString((Object)result));
            };
        }
    }
}

