/*
 * Decompiled with CFR 0.152.
 */
package com.bsmis.core.web.config;

import com.bsmis.core.common.factory.YamlPropertySourceFactory;
import com.bsmis.core.web.props.BsmisSwaggerProperties;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.PathProvider;
import springfox.documentation.annotations.ApiIgnore;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.paths.DefaultPathProvider;
import springfox.documentation.spring.web.plugins.ApiSelectorBuilder;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;

@Configuration
@EnableSwagger2WebMvc
@Import(value={BeanValidatorPluginsConfiguration.class})
@EnableConfigurationProperties(value={BsmisSwaggerProperties.class})
@PropertySource(factory=YamlPropertySourceFactory.class, value={"classpath:swagger.yml"})
public class SwaggerConfiguration
implements WebMvcConfigurer {
    private final BsmisSwaggerProperties swaggerProperties;
    private final Class[] ignoredParameterTypes = new Class[]{ServletRequest.class, ServletResponse.class, HttpServletRequest.class, HttpServletResponse.class, HttpSession.class, ApiIgnore.class};

    @Bean
    public PathProvider pathProvider() {
        return new DefaultPathProvider(){

            public String getOperationPath(String operationPath) {
                return super.getOperationPath(operationPath);
            }
        };
    }

    @Bean(value={"userApi"})
    public Docket createRestApi() {
        ApiSelectorBuilder apiSelectorBuilder = new Docket(DocumentationType.SWAGGER_2).apiInfo(this.groupApiInfo()).select();
        if (this.swaggerProperties.getBasePackage() == null) {
            apiSelectorBuilder.apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class));
        } else {
            apiSelectorBuilder.apis(RequestHandlerSelectors.basePackage((String)this.swaggerProperties.getBasePackage()));
        }
        return apiSelectorBuilder.paths(PathSelectors.any()).build().enable(this.swaggerProperties.isEnable()).securitySchemes(this.securitySchemes()).securityContexts(this.securityContexts()).pathProvider(this.pathProvider()).ignoredParameterTypes(this.ignoredParameterTypes).pathMapping("/");
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/js/**"}).addResourceLocations(new String[]{"classpath:/js/"});
        registry.addResourceHandler(new String[]{"doc.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
        registry.addResourceHandler(new String[]{"/favicon.ico"}).addResourceLocations(new String[]{"classpath:/static/"});
    }

    private ApiInfo groupApiInfo() {
        return new ApiInfoBuilder().title(this.swaggerProperties.getTitle()).description(this.swaggerProperties.getDescription()).license(this.swaggerProperties.getLicense()).termsOfServiceUrl(this.swaggerProperties.getServiceUrl()).contact(new Contact(this.swaggerProperties.getContactName(), this.swaggerProperties.getContactUrl(), this.swaggerProperties.getContactEmail())).version("1.0").build();
    }

    private List<ApiKey> securitySchemes() {
        ArrayList<ApiKey> apiKeyList = new ArrayList<ApiKey>();
        apiKeyList.add(new ApiKey("token", "token", "header"));
        return apiKeyList;
    }

    private List<SecurityContext> securityContexts() {
        ArrayList<SecurityContext> securityContexts = new ArrayList<SecurityContext>();
        securityContexts.add(SecurityContext.builder().securityReferences(this.defaultAuth()).forPaths(PathSelectors.regex((String)"^(?!auth).*$")).build());
        return securityContexts;
    }

    List<SecurityReference> defaultAuth() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        ArrayList<SecurityReference> securityReferences = new ArrayList<SecurityReference>();
        securityReferences.add(new SecurityReference("token", authorizationScopes));
        return securityReferences;
    }

    public SwaggerConfiguration(BsmisSwaggerProperties swaggerProperties) {
        this.swaggerProperties = swaggerProperties;
    }
}

