/*
 * Decompiled with CFR 0.152.
 */
package com.bsmis.core.web.config;

import cn.hutool.core.util.StrUtil;
import com.bsmis.core.common.util.IPUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@Order(value=0x7FFFFFFF)
public class SystemInfoConfig
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(SystemInfoConfig.class);
    @Autowired
    private Environment environment;

    public void run(ApplicationArguments args) throws Exception {
        String ip = IPUtils.getHostIp();
        String port = this.environment.getProperty("server.port");
        String path = this.environment.getProperty("server.servlet.context-path");
        String applicationName = this.environment.getProperty("spring.application.name");
        String springbootVersion = this.environment.getProperty("spring-boot.version");
        String springProfilesActive = this.environment.getProperty("spring.profiles.active");
        if (StrUtil.isEmpty((CharSequence)path)) {
            path = "";
        }
        log.info("\n----------------------------------------------------------\n\t" + applicationName + " is running! Access URLs:\n\t\u5fae\u670d\u52a1\u7cfb\u7edf\u540d: " + applicationName + " \u73af\u5883: " + springProfilesActive + "\n\tLocal\u8bbf\u95ee\u7f51\u5740: \t\thttp://localhost:" + port + path + "\n\tExternal\u8bbf\u95ee\u7f51\u5740: \thttp://" + ip + ":" + port + path + "\n\t\u63a5\u53e3\u6587\u6863\u8bbf\u95ee\u7f51\u5740: \t\thttp://" + ip + ":" + port + path + "/doc.html \n----------------------------------------------------------");
    }
}

