/*
 * Decompiled with CFR 0.152.
 */
package com.bsmis.core.web.datatype;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.PackageVersion;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class JavaLocalDateTimeModule
extends SimpleModule {
    public static final String PATTERN_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_DATETIME_MINI = "yyyyMMddHHmmss";
    public static final String PATTERN_DATE = "yyyy-MM-dd";
    public static final String PATTERN_TIME = "HH:mm:ss";
    public static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter DATETIME_MINI_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");

    public JavaLocalDateTimeModule() {
        super(PackageVersion.VERSION);
        this.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DATETIME_FORMATTER));
        this.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DATE_FORMATTER));
        this.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(TIME_FORMATTER));
        this.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DATETIME_FORMATTER));
        this.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DATE_FORMATTER));
        this.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(TIME_FORMATTER));
    }
}

