/*
 * Decompiled with CFR 0.152.
 */
package com.bsmis.core.web.handler;

import com.bsmis.core.common.api.Result;
import com.bsmis.core.common.exception.BaseException;
import com.bsmis.core.common.exception.PreviewException;
import feign.FeignException;
import java.io.FileNotFoundException;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@ResponseBody
@RestControllerAdvice
public class WebBaseExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(WebBaseExceptionHandler.class);

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Result<?> handleException(BaseException ex) {
        log.error("\u7a0b\u5e8f\u5f02\u5e38\uff1a" + ex.toString());
        return Result.fail((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)ex.getMessage());
    }

    @ExceptionHandler(value={FileNotFoundException.class, NoHandlerFoundException.class})
    public Result<?> noFoundException(Exception exception) {
        log.error("\u7a0b\u5e8f\u5f02\u5e38==>errorCode:{}, exception:{}", (Object)HttpStatus.NOT_FOUND.value(), (Object)exception.getMessage());
        exception.printStackTrace();
        return Result.fail((int)HttpStatus.NOT_FOUND.value(), (String)exception.getMessage());
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Result<?> handleException(PreviewException ex) {
        log.error("\u7a0b\u5e8f\u5f02\u5e38\uff1a" + ex.toString());
        return Result.fail((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)ex.getMessage());
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Result<?> handleException(NullPointerException ex) {
        log.error("\u7a0b\u5e8f\u5f02\u5e38\uff1a{}" + ex.toString());
        ex.printStackTrace();
        return Result.fail((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)ex.getMessage());
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Result<?> handleException(UnknownHostException ex) {
        log.error("\u7a0b\u5e8f\u5f02\u5e38\uff1a{}" + ex.toString());
        return Result.fail((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)(ex.getMessage() + "\u7cfb\u7edf\u672a\u4e0a\u7ebf"));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Result<?> handleException(FeignException ex) {
        log.error("\u7a0b\u5e8f\u5f02\u5e38\uff1a{}" + ex.toString());
        return Result.fail((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)ex.getMessage());
    }
}

