/*
 * Decompiled with CFR 0.152.
 */
package com.bsmis.core.web.listener;

import cn.dev33.satoken.annotation.SaCheckPermission;
import com.bsmis.core.common.util.StringUtil;
import com.bsmis.core.redis.core.RedisService;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.MediaType;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.DigestUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import springfox.documentation.annotations.ApiIgnore;

public class RequestMappingScanListener
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(RequestMappingScanListener.class);
    private static final AntPathMatcher pathMatch = new AntPathMatcher();
    private final Set<String> ignoreApi = new HashSet<String>();
    private final RedisService redisService;

    public RequestMappingScanListener(RedisService redisService) {
        this.redisService = redisService;
        this.ignoreApi.add("/error");
        this.ignoreApi.add("/swagger-resources/**");
        this.ignoreApi.add("/v2/api-docs-ext/**");
    }

    public void onApplicationEvent(@NotNull ApplicationReadyEvent event) {
        try {
            ConfigurableApplicationContext applicationContext = event.getApplicationContext();
            ConfigurableEnvironment env = applicationContext.getEnvironment();
            String microService = env.getProperty("spring.application.name", "application");
            if (this.redisService == null || applicationContext.containsBean("resourceServerConfiguration")) {
                log.warn("[{}]\u5ffd\u7565\u63a5\u53e3\u8d44\u6e90\u626b\u63cf", (Object)microService);
                return;
            }
            RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)applicationContext.getBean(RequestMappingHandlerMapping.class);
            Map map = mapping.getHandlerMethods();
            ArrayList<HashMap> list = new ArrayList<HashMap>();
            for (Map.Entry m : map.entrySet()) {
                SaCheckPermission preAuth;
                PatternsRequestCondition p;
                String urls;
                RequestMappingInfo info = (RequestMappingInfo)m.getKey();
                HandlerMethod method = (HandlerMethod)m.getValue();
                if (method.getMethodAnnotation(ApiIgnore.class) != null || this.isIgnore(urls = this.getUrls((p = info.getPatternsCondition()).getPatterns()))) continue;
                Set mediaTypeSet = info.getProducesCondition().getProducibleMediaTypes();
                for (MethodParameter params : method.getMethodParameters()) {
                    if (!params.hasParameterAnnotation(RequestBody.class)) continue;
                    mediaTypeSet.add(MediaType.APPLICATION_JSON_UTF8);
                    break;
                }
                String mediaTypes = this.getMediaTypes(mediaTypeSet);
                RequestMethodsRequestCondition methodsCondition = info.getMethodsCondition();
                String methods = this.getMethods(methodsCondition.getMethods());
                HashMap api = Maps.newHashMap();
                String className = method.getMethod().getDeclaringClass().getName();
                String methodName = method.getMethod().getName();
                String fullName = className + "." + methodName;
                String md5 = DigestUtils.md5DigestAsHex((byte[])(microService + urls).getBytes());
                String name = "";
                String notes = "";
                String auth = "0";
                String permission = "";
                ApiOperation apiOperation = (ApiOperation)method.getMethodAnnotation(ApiOperation.class);
                if (apiOperation != null) {
                    name = apiOperation.value();
                    notes = apiOperation.notes();
                }
                if ((preAuth = (SaCheckPermission)method.getMethodAnnotation(SaCheckPermission.class)) != null) {
                    auth = "1";
                    permission = StringUtil.join((Object[])preAuth.value());
                }
                name = StringUtil.isBlank((String)name) ? methodName : name;
                api.put("name", name);
                api.put("notes", notes);
                api.put("path", urls);
                api.put("code", md5);
                api.put("className", className);
                api.put("methodName", methodName);
                api.put("method", methods);
                api.put("serviceId", microService);
                api.put("contentType", mediaTypes);
                api.put("auth", auth);
                api.put("permission", permission);
                list.add(api);
            }
            HashMap res = Maps.newHashMap();
            res.put("serviceId", microService);
            res.put("size", list.size());
            res.put("list", list);
            this.redisService.hset("bsmis-api-resource", microService, (Object)res, Long.valueOf(18000L));
            this.redisService.sSetAndTime("bsmis-service-resource", Long.valueOf(18000L), new Object[]{microService});
            log.info("\u8d44\u6e90\u626b\u63cf\u7ed3\u679c:serviceId=[{}] size=[{}] redis\u7f13\u5b58key=[{}]", new Object[]{microService, list.size(), "bsmis-api-resource"});
        }
        catch (Exception e) {
            log.error("error: {}", (Object)e.getMessage());
        }
    }

    private String getUrls(Set<String> urls) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String url : urls) {
            stringBuilder.append(url).append(",");
        }
        if (urls.size() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    private boolean isIgnore(String requestPath) {
        for (String path : this.ignoreApi) {
            if (!pathMatch.match(path, requestPath)) continue;
            return true;
        }
        return false;
    }

    private String getMediaTypes(Set<MediaType> mediaTypes) {
        StringBuilder stringBuilder = new StringBuilder();
        for (MediaType mediaType : mediaTypes) {
            stringBuilder.append(mediaType.toString()).append(",");
        }
        if (mediaTypes.size() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    private String getMethods(Set<RequestMethod> requestMethods) {
        StringBuilder stringBuilder = new StringBuilder();
        for (RequestMethod requestMethod : requestMethods) {
            stringBuilder.append(requestMethod.toString()).append(",");
        }
        if (requestMethods.size() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }
}

