/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.internal.desc.Column;
import dm.jdbc.internal.desc.TypeDesc;
import dm.jdbc.util.StringUtil;
import java.math.BigDecimal;
import java.sql.SQLException;

public class DmdbType {
    public static final int CHAR = 0;
    public static final int VARCHAR2 = 1;
    public static final int VARCHAR = 2;
    public static final int BIT = 3;
    public static final int TINYINT = 5;
    public static final int SMALLINT = 6;
    public static final int INT = 7;
    public static final int BIGINT = 8;
    public static final int DECIMAL = 9;
    public static final int REAL = 10;
    public static final int DOUBLE = 11;
    public static final int BLOB = 12;
    public static final int BOOLEAN = 13;
    public static final int DATE = 14;
    public static final int TIME = 15;
    public static final int DATETIME = 16;
    public static final int BINARY = 17;
    public static final int VARBINARY = 18;
    public static final int CLOB = 19;
    public static final int INTERVAL_YM = 20;
    public static final int INTERVAL_DT = 21;
    public static final int TIME_TZ = 22;
    public static final int DATETIME_TZ = 23;
    public static final int DATETIME2 = 26;
    public static final int DATETIME2_TZ = 27;
    public static final int ROWID = 28;
    public static final int NULL = 29;
    public static final int ANY = 31;
    public static final int STAR_ALL = 32;
    public static final int STAR = 33;
    public static final int RECORD = 40;
    public static final int TYPE = 41;
    public static final int TYPE_REF = 42;
    public static final int UNKNOWN = 54;
    public static final int ARRAY = 117;
    public static final int CLASS = 119;
    public static final int CURSOR = 120;
    public static final int PLTYPE_RECORD = 121;
    public static final int SARRAY = 122;
    public static final int CURSOR_ORACLE = -10;
    public static final int BIT_PREC = 1;
    public static final int TINYINT_PREC = 1;
    public static final int SMALLINT_PREC = 2;
    public static final int INT_PREC = 4;
    public static final int BIGINT_PREC = 8;
    public static final int REAL_PREC = 4;
    public static final int DOUBLE_PREC = 8;
    public static final int DATE_PREC = 3;
    public static final int TIME_PREC = 5;
    public static final int DATETIME_PREC = 8;
    public static final int DATETIME2_PREC = 9;
    public static final int TIME_TZ_PREC = 7;
    public static final int DATETIME_TZ_PREC = 10;
    public static final int DATETIME2_TZ_PREC = 11;
    public static final int INTERVAL_YM_PREC = 12;
    public static final int INTERVAL_DT_PREC = 24;
    public static final int VARCHAR_PREC = Short.MAX_VALUE;
    public static final int VARBINARY_PREC = Short.MAX_VALUE;
    public static final int BLOB_PREC = Integer.MAX_VALUE;
    public static final int CLOB_PREC = Integer.MAX_VALUE;
    public static final int CLASS_PREC = 32768;
    public static final int CURSOR_PREC = 32768;
    public static final int NULL_PREC = 0;
    public static final int BFILE_PREC = 512;
    public static final int CURRENCY_PREC = 19;
    public static final int ROWID_PREC = 12;
    public static final int BFILE_SCALE = 6;
    public static final int COMPLEX_SCALE = 5;
    public static final int CURRENCY_SCALE = 4;
    public static final int LOCAL_DATETIME_SCALE_MASK = 4096;
    public static final int ORACLE_FLOAT_SCALE_MASK = 129;
    public static final int ORACLE_DATE_SCALE_MASK = 8192;

    public static boolean isInteger(int type) {
        return type == 5 || type == 6 || type == 7 || type == 8;
    }

    public static boolean isNumber(int type) {
        return type == 5 || type == 6 || type == 7 || type == 8 || type == 10 || type == 11 || type == 9;
    }

    public static boolean isCharacter(int type) {
        return type == 0 || type == 2 || type == 1 || type == 19;
    }

    public static boolean isBinary(int type) {
        return type == 17 || type == 18 || type == 12;
    }

    public static boolean isComplexType(int type, int scale) {
        return type == 12 && scale == 5 || type == 117 || type == 122 || type == 119 || type == 121;
    }

    public static int j2dType(int jtype) {
        int dtype = 54;
        switch (jtype) {
            case -10: 
            case 120: 
            case 2012: {
                dtype = 120;
                break;
            }
            case 16: {
                dtype = 5;
                break;
            }
            case -7: {
                dtype = 3;
                break;
            }
            case -6: {
                dtype = 5;
                break;
            }
            case 5: {
                dtype = 6;
                break;
            }
            case 4: {
                dtype = 7;
                break;
            }
            case -5: {
                dtype = 8;
                break;
            }
            case 6: 
            case 7: {
                dtype = 10;
                break;
            }
            case 8: {
                dtype = 11;
                break;
            }
            case 2: 
            case 3: {
                dtype = 9;
                break;
            }
            case -2: {
                dtype = 17;
                break;
            }
            case -3: {
                dtype = 18;
                break;
            }
            case -4: 
            case 2004: {
                dtype = 12;
                break;
            }
            case -15: 
            case 1: {
                dtype = 0;
                break;
            }
            case -9: 
            case 12: {
                dtype = 2;
                break;
            }
            case -1: 
            case 2005: 
            case 2011: {
                dtype = 19;
                break;
            }
            case 91: {
                dtype = 14;
                break;
            }
            case 92: {
                dtype = 15;
                break;
            }
            case 93: {
                dtype = 16;
                break;
            }
            case 2003: {
                dtype = 117;
                break;
            }
            case 2000: 
            case 2002: {
                dtype = 119;
                break;
            }
            case 0: {
                dtype = 29;
                break;
            }
            case 2009: {
                dtype = 19;
                break;
            }
            case -8: {
                dtype = 28;
                break;
            }
            default: {
                dtype = 2;
            }
        }
        return dtype;
    }

    public static boolean canCastToDecimal(Object x2) {
        return x2 != null && (x2 instanceof Boolean || x2 instanceof Byte || x2 instanceof Short || x2 instanceof Integer || x2 instanceof Long || x2 instanceof Float || x2 instanceof Double || x2 instanceof BigDecimal || x2 instanceof String);
    }

    public static boolean emptyStringToNull(int dtype) {
        switch (dtype) {
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    public static TypeDesc getTypeDesc(Column column, DmdbConnection connection) throws SQLException {
        if (connection.compatibleOracle() && DmdbType.isNumber(column.type)) {
            return TypeDesc.oracleNumberDesc(column, connection);
        }
        if (column.mask == 3) {
            return TypeDesc.bfileDesc(column, connection);
        }
        if (column.mask == 1) {
            return TypeDesc.dateDesc(column, connection);
        }
        if (column.mask == 4) {
            return TypeDesc.timestampLocalTZDesc(column, connection);
        }
        if (StringUtil.equalsIgnoreCase(column.typeName, "BOOLEAN")) {
            return TypeDesc.booleanDesc(column, connection);
        }
        if (StringUtil.equalsIgnoreCase(column.typeName, "FLOAT")) {
            return TypeDesc.floatDesc(column, connection);
        }
        if (StringUtil.equalsIgnoreCase(column.typeName, "NUMERIC")) {
            return TypeDesc.numericDesc(column, connection);
        }
        if (StringUtil.equalsIgnoreCase(column.typeName, "NUMBER")) {
            return TypeDesc.oracleNumberDesc(column, connection);
        }
        if (StringUtil.equalsIgnoreCase(column.typeName, "LONGVARCHAR")) {
            return TypeDesc.longvarcharDesc(column, connection);
        }
        if (StringUtil.equalsIgnoreCase(column.typeName, "LONGVARBINARY")) {
            return TypeDesc.longvarbinaryDesc(column, connection);
        }
        if (StringUtil.equalsIgnoreCase(column.typeName, "NCHAR")) {
            return TypeDesc.ncharDesc(column, connection);
        }
        int dtype = column.type;
        if (DmdbType.isComplexType(column.type, column.scale) && column.typeDescriptor != null) {
            dtype = column.typeDescriptor.column.type;
        }
        switch (dtype) {
            case 3: {
                return TypeDesc.bitDesc(column, connection);
            }
            case 13: {
                return TypeDesc.booleanDesc(column, connection);
            }
            case 5: {
                return TypeDesc.tinyintDesc(column, connection);
            }
            case 6: {
                return TypeDesc.smallintDesc(column, connection);
            }
            case 7: {
                return TypeDesc.integerDesc(column, connection);
            }
            case 8: {
                return TypeDesc.bigintDesc(column, connection);
            }
            case 10: {
                return TypeDesc.realDesc(column, connection);
            }
            case 11: {
                return TypeDesc.doubleDesc(column, connection);
            }
            case 9: {
                return TypeDesc.decimalDesc(column, connection);
            }
            case 0: {
                return TypeDesc.charDesc(column, connection);
            }
            case 2: {
                return TypeDesc.varcharDesc(column, connection);
            }
            case 1: {
                return TypeDesc.varchar2Desc(column, connection);
            }
            case 19: {
                if (connection != null && connection.getClobAsString()) {
                    return TypeDesc.varcharDesc(column, connection);
                }
                return TypeDesc.clobDesc(column, connection);
            }
            case 17: {
                return TypeDesc.binaryDesc(column, connection);
            }
            case 18: {
                return TypeDesc.varbinaryDesc(column, connection);
            }
            case 12: {
                return TypeDesc.blobDesc(column, connection);
            }
            case 14: {
                return TypeDesc.dateDesc(column, connection);
            }
            case 15: {
                return TypeDesc.timeDesc(column, connection);
            }
            case 22: {
                return TypeDesc.timeTZDesc(column, connection);
            }
            case 16: {
                return TypeDesc.timestampDesc(column, connection);
            }
            case 23: {
                return TypeDesc.timestampTZDesc(column, connection);
            }
            case 26: {
                return TypeDesc.timestampDesc(column, connection);
            }
            case 27: {
                return TypeDesc.timestampTZDesc(column, connection);
            }
            case 21: {
                return TypeDesc.intervalDTDesc(column, connection);
            }
            case 20: {
                return TypeDesc.intervalYMDesc(column, connection);
            }
            case 28: {
                return TypeDesc.rowidDesc(column, connection);
            }
            case 117: 
            case 122: {
                return TypeDesc.arrayDesc(column, connection);
            }
            case 40: 
            case 41: 
            case 42: 
            case 119: 
            case 121: {
                return TypeDesc.structDesc(column, connection);
            }
            case 120: {
                return TypeDesc.cursorDesc(column, connection);
            }
        }
        return TypeDesc.varcharDesc(column, connection);
    }
}

