/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.fullEncrypt;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbDatabaseMetaData;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbRef;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbSQLXML;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.driver.DmdbXAResource;
import dm.jdbc.filter.BaseFilter;
import dm.jdbc.internal.conf.DmProperties;
import dm.jdbc.internal.convert.DB2J;
import dm.jdbc.internal.convert.J2DB;
import dm.jdbc.internal.convert.OffRowData;
import dm.jdbc.internal.desc.Column;
import dm.jdbc.internal.desc.Parameter;
import dm.jdbc.internal.parser.FeSQLParameter;
import dm.jdbc.internal.parser.SQLProcessor;
import dm.jdbc.plugin.fldr.FldrConfig;
import dm.jdbc.plugin.fldr.FldrStatement;
import dm.jdbc.util.Base64Decoder;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.StringUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.RowIdLifetime;
import java.sql.SQLClientInfoException;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class FullEncryptFilter
extends BaseFilter {
    private static final String FILE_FORMAT_WINDOWS = "%s\\%s_rsa_private.pem";
    private static final String FILE_FORMAT_LINUX = "%s/%s_rsa_private.pem";
    private static String FILE_FORMAT = null;
    private String prefixFile;
    private static Map<Integer, Cipher> feckDecryptMap = new HashMap<Integer, Cipher>();
    private static Map<Integer, Cipher> feckEncryptMap = new HashMap<Integer, Cipher>();
    private static Map<String, Cipher> femkPriCipherMap = new HashMap<String, Cipher>();
    private List<FeSQLParameter> feParamsList;
    private HashMap<Integer, Parameter> paramsMap;
    private static final String feSQL = "/*DMJDBC*/SELECT CIPHER, FEMK, FECK_ID, CIPHER_ID from SYS.SYSFECKS WHERE FECK_ID IN (%s);";
    private static final IvParameterSpec ivSpec = new IvParameterSpec(new byte[]{32, 33, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48});

    private FullEncryptFilter() {
    }

    public static FullEncryptFilter getInstance(String prefixFile) {
        FullEncryptFilter encryptFilter = new FullEncryptFilter();
        encryptFilter.prefixFile = prefixFile;
        return encryptFilter;
    }

    @Override
    public long Blob_length(DmdbBlob blob) throws SQLException {
        if (this.next != null) {
            return this.next.Blob_length(blob);
        }
        return blob.do_length();
    }

    @Override
    public byte[] Blob_getBytes(DmdbBlob blob, long pos, int length) throws SQLException {
        if (this.next != null) {
            return this.next.Blob_getBytes(blob, pos, length);
        }
        return blob.do_getBytes(pos, length);
    }

    @Override
    public InputStream Blob_getBinaryStream(DmdbBlob blob) throws SQLException {
        if (this.next != null) {
            return this.next.Blob_getBinaryStream(blob);
        }
        return blob.do_getBinaryStream();
    }

    @Override
    public long Blob_position(DmdbBlob blob, byte[] pattern, long start) throws SQLException {
        if (this.next != null) {
            return this.next.Blob_position(blob, pattern, start);
        }
        return blob.do_position(pattern, start);
    }

    @Override
    public long Blob_position(DmdbBlob blob, Blob pattern, long start) throws SQLException {
        if (this.next != null) {
            return this.next.Blob_position(blob, pattern, start);
        }
        return blob.do_position(pattern, start);
    }

    @Override
    public int Blob_setBytes(DmdbBlob blob, long pos, byte[] bytes) throws SQLException {
        if (this.next != null) {
            return this.next.Blob_setBytes(blob, pos, bytes);
        }
        return blob.do_setBytes(pos, bytes);
    }

    @Override
    public int Blob_setBytes(DmdbBlob blob, long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (this.next != null) {
            return this.next.Blob_setBytes(blob, pos, bytes, offset, len);
        }
        return blob.do_setBytes(pos, bytes, offset, len);
    }

    @Override
    public OutputStream Blob_setBinaryStream(DmdbBlob blob, long pos) throws SQLException {
        if (this.next != null) {
            return this.next.Blob_setBinaryStream(blob, pos);
        }
        return blob.do_setBinaryStream(pos);
    }

    @Override
    public void Blob_truncate(DmdbBlob blob, long len) throws SQLException {
        if (this.next != null) {
            this.next.Blob_truncate(blob, len);
        } else {
            blob.do_truncate(len);
        }
    }

    @Override
    public void Blob_free(DmdbBlob blob) throws SQLException {
        if (this.next != null) {
            this.next.Blob_free(blob);
        } else {
            blob.do_free();
        }
    }

    @Override
    public InputStream Blob_getBinaryStream(DmdbBlob blob, long pos, long length) throws SQLException {
        if (this.next != null) {
            return this.next.Blob_getBinaryStream(blob, pos, length);
        }
        return blob.do_getBinaryStream(pos, length);
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, int sqlType) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType);
        } else {
            callableStatement.do_registerOutParameter(parameterIndex, sqlType);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, int scale) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, scale);
        } else {
            callableStatement.do_registerOutParameter(parameterIndex, sqlType, scale);
        }
    }

    @Override
    public boolean CallableStatement_wasNull(DmdbCallableStatement callableStatement) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_wasNull(callableStatement);
        }
        return callableStatement.do_wasNull();
    }

    @Override
    public String CallableStatement_getString(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getString(callableStatement, parameterIndex);
        }
        return callableStatement.do_getString(parameterIndex);
    }

    @Override
    public boolean CallableStatement_getBoolean(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getBoolean(callableStatement, parameterIndex);
        }
        return callableStatement.do_getBoolean(parameterIndex);
    }

    @Override
    public byte CallableStatement_getByte(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getByte(callableStatement, parameterIndex);
        }
        return callableStatement.do_getByte(parameterIndex);
    }

    @Override
    public short CallableStatement_getShort(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getShort(callableStatement, parameterIndex);
        }
        return callableStatement.do_getShort(parameterIndex);
    }

    @Override
    public int CallableStatement_getInt(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getInt(callableStatement, parameterIndex);
        }
        return callableStatement.do_getInt(parameterIndex);
    }

    @Override
    public long CallableStatement_getLong(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getLong(callableStatement, parameterIndex);
        }
        return callableStatement.do_getLong(parameterIndex);
    }

    @Override
    public float CallableStatement_getFloat(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getFloat(callableStatement, parameterIndex);
        }
        return callableStatement.do_getFloat(parameterIndex);
    }

    @Override
    public double CallableStatement_getDouble(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getDouble(callableStatement, parameterIndex);
        }
        return callableStatement.do_getDouble(parameterIndex);
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(DmdbCallableStatement callableStatement, int parameterIndex, int scale) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getBigDecimal(callableStatement, parameterIndex, scale);
        }
        return callableStatement.do_getBigDecimal(parameterIndex, scale);
    }

    @Override
    public byte[] CallableStatement_getBytes(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getBytes(callableStatement, parameterIndex);
        }
        return callableStatement.do_getBytes(parameterIndex);
    }

    @Override
    public java.sql.Date CallableStatement_getDate(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getDate(callableStatement, parameterIndex);
        }
        return callableStatement.do_getDate(parameterIndex);
    }

    @Override
    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getTime(callableStatement, parameterIndex);
        }
        return callableStatement.do_getTime(parameterIndex);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getTimestamp(callableStatement, parameterIndex);
        }
        return callableStatement.do_getTimestamp(parameterIndex);
    }

    @Override
    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getObject(callableStatement, parameterIndex);
        }
        return callableStatement.do_getObject(parameterIndex);
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getBigDecimal(callableStatement, parameterIndex);
        }
        return callableStatement.do_getBigDecimal(parameterIndex);
    }

    @Override
    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getObject(callableStatement, parameterIndex, map);
        }
        return callableStatement.do_getObject(parameterIndex, map);
    }

    @Override
    public Ref CallableStatement_getRef(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getRef(callableStatement, parameterIndex);
        }
        return callableStatement.do_getRef(parameterIndex);
    }

    @Override
    public Blob CallableStatement_getBlob(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getBlob(callableStatement, parameterIndex);
        }
        return callableStatement.do_getBlob(parameterIndex);
    }

    @Override
    public Clob CallableStatement_getClob(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getClob(callableStatement, parameterIndex);
        }
        return callableStatement.do_getClob(parameterIndex);
    }

    @Override
    public Array CallableStatement_getArray(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getArray(callableStatement, parameterIndex);
        }
        return callableStatement.do_getArray(parameterIndex);
    }

    @Override
    public java.sql.Date CallableStatement_getDate(DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getDate(callableStatement, parameterIndex, cal);
        }
        return callableStatement.do_getDate(parameterIndex, cal);
    }

    @Override
    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getTime(callableStatement, parameterIndex, cal);
        }
        return callableStatement.do_getTime(parameterIndex, cal);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getTimestamp(callableStatement, parameterIndex, cal);
        }
        return callableStatement.do_getTimestamp(parameterIndex, cal);
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, typeName);
        } else {
            callableStatement.do_registerOutParameter(parameterIndex, sqlType, typeName);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType);
        } else {
            callableStatement.do_registerOutParameter(parameterName, sqlType);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, int sqlType, int scale) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, scale);
        } else {
            callableStatement.do_registerOutParameter(parameterName, sqlType, scale);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, typeName);
        } else {
            callableStatement.do_registerOutParameter(parameterName, sqlType, typeName);
        }
    }

    @Override
    public URL CallableStatement_getURL(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getURL(callableStatement, parameterIndex);
        }
        return callableStatement.do_getURL(parameterIndex);
    }

    @Override
    public void CallableStatement_setURL(DmdbCallableStatement callableStatement, String parameterName, URL val) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setURL(callableStatement, parameterName, val);
        } else {
            callableStatement.do_setURL(parameterName, val);
        }
    }

    @Override
    public void CallableStatement_setNull(DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setNull(callableStatement, parameterName, sqlType);
        } else {
            callableStatement.do_setNull(parameterName, sqlType);
        }
    }

    @Override
    public void CallableStatement_setBoolean(DmdbCallableStatement callableStatement, String parameterName, boolean x2) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setBoolean(callableStatement, parameterName, x2);
        } else {
            callableStatement.do_setBoolean(parameterName, x2);
        }
    }

    @Override
    public void CallableStatement_setByte(DmdbCallableStatement callableStatement, String parameterName, byte x2) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setByte(callableStatement, parameterName, x2);
        } else {
            callableStatement.do_setByte(parameterName, x2);
        }
    }

    @Override
    public void CallableStatement_setShort(DmdbCallableStatement callableStatement, String parameterName, short x2) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setShort(callableStatement, parameterName, x2);
        } else {
            callableStatement.do_setShort(parameterName, x2);
        }
    }

    @Override
    public void CallableStatement_setInt(DmdbCallableStatement callableStatement, String parameterName, int x2) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setInt(callableStatement, parameterName, x2);
        } else {
            callableStatement.do_setInt(parameterName, x2);
        }
    }

    @Override
    public void CallableStatement_setLong(DmdbCallableStatement callableStatement, String parameterName, long x2) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setLong(callableStatement, parameterName, x2);
        } else {
            callableStatement.do_setLong(parameterName, x2);
        }
    }

    @Override
    public void CallableStatement_setFloat(DmdbCallableStatement callableStatement, String parameterName, float x2) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setFloat(callableStatement, parameterName, x2);
        } else {
            callableStatement.do_setFloat(parameterName, x2);
        }
    }

    @Override
    public void CallableStatement_setDouble(DmdbCallableStatement callableStatement, String parameterName, double x2) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setDouble(callableStatement, parameterName, x2);
        } else {
            callableStatement.do_setDouble(parameterName, x2);
        }
    }

    @Override
    public void CallableStatement_setBigDecimal(DmdbCallableStatement callableStatement, String parameterName, BigDecimal x2) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setBigDecimal(callableStatement, parameterName, x2);
        } else {
            callableStatement.do_setBigDecimal(parameterName, x2);
        }
    }

    @Override
    public void CallableStatement_setString(DmdbCallableStatement callableStatement, String parameterName, String x2) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setString(callableStatement, parameterName, x2);
        } else {
            callableStatement.do_setString(parameterName, x2);
        }
    }

    @Override
    public void CallableStatement_setBytes(DmdbCallableStatement callableStatement, String parameterName, byte[] x2) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setBytes(callableStatement, parameterName, x2);
        } else {
            callableStatement.do_setBytes(parameterName, x2);
        }
    }

    @Override
    public void CallableStatement_setDate(DmdbCallableStatement callableStatement, String parameterName, java.sql.Date x2) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setDate(callableStatement, parameterName, x2);
        } else {
            callableStatement.do_setDate(parameterName, x2);
        }
    }

    @Override
    public void CallableStatement_setTime(DmdbCallableStatement callableStatement, String parameterName, Time x2) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setTime(callableStatement, parameterName, x2);
        } else {
            callableStatement.do_setTime(parameterName, x2);
        }
    }

    @Override
    public void CallableStatement_setTimestamp(DmdbCallableStatement callableStatement, String parameterName, Timestamp x2) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setTimestamp(callableStatement, parameterName, x2);
        } else {
            callableStatement.do_setTimestamp(parameterName, x2);
        }
    }

    @Override
    public void CallableStatement_setAsciiStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setAsciiStream(callableStatement, parameterName, x2, length);
        } else {
            callableStatement.do_setAsciiStream(parameterName, x2, length);
        }
    }

    @Override
    public void CallableStatement_setBinaryStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setBinaryStream(callableStatement, parameterName, x2, length);
        } else {
            callableStatement.do_setBinaryStream(parameterName, x2, length);
        }
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType, int scale) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType, scale);
        } else {
            callableStatement.do_setObject(parameterName, x2, targetSqlType, scale);
        }
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType);
        } else {
            callableStatement.do_setObject(parameterName, x2, targetSqlType);
        }
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setObject(callableStatement, parameterName, x2);
        } else {
            callableStatement.do_setObject(parameterName, x2);
        }
    }

    @Override
    public void CallableStatement_setCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader reader, int length) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setCharacterStream(callableStatement, parameterName, reader, length);
        } else {
            callableStatement.do_setCharacterStream(parameterName, reader, length);
        }
    }

    @Override
    public void CallableStatement_setDate(DmdbCallableStatement callableStatement, String parameterName, java.sql.Date x2, Calendar cal) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setDate(callableStatement, parameterName, x2, cal);
        } else {
            callableStatement.do_setDate(parameterName, x2, cal);
        }
    }

    @Override
    public void CallableStatement_setTime(DmdbCallableStatement callableStatement, String parameterName, Time x2, Calendar cal) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setTime(callableStatement, parameterName, x2, cal);
        } else {
            callableStatement.do_setTime(parameterName, x2, cal);
        }
    }

    @Override
    public void CallableStatement_setTimestamp(DmdbCallableStatement callableStatement, String parameterName, Timestamp x2, Calendar cal) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setTimestamp(callableStatement, parameterName, x2, cal);
        } else {
            callableStatement.do_setTimestamp(parameterName, x2, cal);
        }
    }

    @Override
    public void CallableStatement_setNull(DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setNull(callableStatement, parameterName, sqlType, typeName);
        } else {
            callableStatement.do_setNull(parameterName, sqlType, typeName);
        }
    }

    @Override
    public String CallableStatement_getString(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getString(callableStatement, parameterName);
        }
        return callableStatement.do_getString(parameterName);
    }

    @Override
    public boolean CallableStatement_getBoolean(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getBoolean(callableStatement, parameterName);
        }
        return callableStatement.do_getBoolean(parameterName);
    }

    @Override
    public byte CallableStatement_getByte(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getByte(callableStatement, parameterName);
        }
        return callableStatement.do_getByte(parameterName);
    }

    @Override
    public short CallableStatement_getShort(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getShort(callableStatement, parameterName);
        }
        return callableStatement.do_getShort(parameterName);
    }

    @Override
    public int CallableStatement_getInt(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getInt(callableStatement, parameterName);
        }
        return callableStatement.do_getInt(parameterName);
    }

    @Override
    public long CallableStatement_getLong(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getLong(callableStatement, parameterName);
        }
        return callableStatement.do_getLong(parameterName);
    }

    @Override
    public float CallableStatement_getFloat(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getFloat(callableStatement, parameterName);
        }
        return callableStatement.do_getFloat(parameterName);
    }

    @Override
    public double CallableStatement_getDouble(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getDouble(callableStatement, parameterName);
        }
        return callableStatement.do_getDouble(parameterName);
    }

    @Override
    public byte[] CallableStatement_getBytes(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getBytes(callableStatement, parameterName);
        }
        return callableStatement.do_getBytes(parameterName);
    }

    @Override
    public java.sql.Date CallableStatement_getDate(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getDate(callableStatement, parameterName);
        }
        return callableStatement.do_getDate(parameterName);
    }

    @Override
    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getTime(callableStatement, parameterName);
        }
        return callableStatement.do_getTime(parameterName);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getTimestamp(callableStatement, parameterName);
        }
        return callableStatement.do_getTimestamp(parameterName);
    }

    @Override
    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getObject(callableStatement, parameterName);
        }
        return callableStatement.do_getObject(parameterName);
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getBigDecimal(callableStatement, parameterName);
        }
        return callableStatement.do_getBigDecimal(parameterName);
    }

    @Override
    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, String parameterName, Map<String, Class<?>> map) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getObject(callableStatement, parameterName, map);
        }
        return callableStatement.do_getObject(parameterName, map);
    }

    @Override
    public Ref CallableStatement_getRef(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getRef(callableStatement, parameterName);
        }
        return callableStatement.do_getRef(parameterName);
    }

    @Override
    public Blob CallableStatement_getBlob(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getBlob(callableStatement, parameterName);
        }
        return callableStatement.do_getBlob(parameterName);
    }

    @Override
    public Clob CallableStatement_getClob(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getClob(callableStatement, parameterName);
        }
        return callableStatement.do_getClob(parameterName);
    }

    @Override
    public Array CallableStatement_getArray(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getArray(callableStatement, parameterName);
        }
        return callableStatement.do_getArray(parameterName);
    }

    @Override
    public java.sql.Date CallableStatement_getDate(DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getDate(callableStatement, parameterName, cal);
        }
        return callableStatement.do_getDate(parameterName, cal);
    }

    @Override
    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getTime(callableStatement, parameterName, cal);
        }
        return callableStatement.do_getTime(parameterName, cal);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getTimestamp(callableStatement, parameterName, cal);
        }
        return callableStatement.do_getTimestamp(parameterName, cal);
    }

    @Override
    public URL CallableStatement_getURL(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getURL(callableStatement, parameterName);
        }
        return callableStatement.do_getURL(parameterName);
    }

    @Override
    public RowId CallableStatement_getRowId(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getRowId(callableStatement, parameterIndex);
        }
        return callableStatement.do_getRowId(parameterIndex);
    }

    @Override
    public RowId CallableStatement_getRowId(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getRowId(callableStatement, parameterName);
        }
        return callableStatement.do_getRowId(parameterName);
    }

    @Override
    public void CallableStatement_setRowId(DmdbCallableStatement callableStatement, String parameterName, RowId x2) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setRowId(callableStatement, parameterName, x2);
        } else {
            callableStatement.do_setRowId(parameterName, x2);
        }
    }

    @Override
    public void CallableStatement_setNString(DmdbCallableStatement callableStatement, String parameterName, String value) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setNString(callableStatement, parameterName, value);
        } else {
            callableStatement.do_setNString(parameterName, value);
        }
    }

    @Override
    public void CallableStatement_setNCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader value, long length) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setNCharacterStream(callableStatement, parameterName, value, length);
        } else {
            callableStatement.do_setNCharacterStream(parameterName, value, length);
        }
    }

    @Override
    public void CallableStatement_setNClob(DmdbCallableStatement callableStatement, String parameterName, NClob value) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setNClob(callableStatement, parameterName, value);
        } else {
            callableStatement.do_setNClob(parameterName, value);
        }
    }

    @Override
    public void CallableStatement_setClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setClob(callableStatement, parameterName, reader, length);
        } else {
            callableStatement.do_setClob(parameterName, reader, length);
        }
    }

    @Override
    public void CallableStatement_setBlob(DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream, long length) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setBlob(callableStatement, parameterName, inputStream, length);
        } else {
            callableStatement.do_setBlob(parameterName, inputStream, length);
        }
    }

    @Override
    public void CallableStatement_setNClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setNClob(callableStatement, parameterName, reader, length);
        } else {
            callableStatement.do_setNClob(parameterName, reader, length);
        }
    }

    @Override
    public NClob CallableStatement_getNClob(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getNClob(callableStatement, parameterIndex);
        }
        return callableStatement.do_getNClob(parameterIndex);
    }

    @Override
    public NClob CallableStatement_getNClob(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getNClob(callableStatement, parameterName);
        }
        return callableStatement.do_getNClob(parameterName);
    }

    @Override
    public void CallableStatement_setSQLXML(DmdbCallableStatement callableStatement, String parameterName, SQLXML xmlObject) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setSQLXML(callableStatement, parameterName, xmlObject);
        } else {
            callableStatement.do_setSQLXML(parameterName, xmlObject);
        }
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getSQLXML(callableStatement, parameterIndex);
        }
        return callableStatement.do_getSQLXML(parameterIndex);
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getSQLXML(callableStatement, parameterName);
        }
        return callableStatement.do_getSQLXML(parameterName);
    }

    @Override
    public String CallableStatement_getNString(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getNString(callableStatement, parameterIndex);
        }
        return callableStatement.do_getNString(parameterIndex);
    }

    @Override
    public String CallableStatement_getNString(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getNString(callableStatement, parameterName);
        }
        return callableStatement.do_getNString(parameterName);
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getNCharacterStream(callableStatement, parameterIndex);
        }
        return callableStatement.do_getNCharacterStream(parameterIndex);
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getNCharacterStream(callableStatement, parameterName);
        }
        return callableStatement.do_getNCharacterStream(parameterName);
    }

    @Override
    public Reader CallableStatement_getCharacterStream(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getCharacterStream(callableStatement, parameterIndex);
        }
        return callableStatement.do_getCharacterStream(parameterIndex);
    }

    @Override
    public Reader CallableStatement_getCharacterStream(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getCharacterStream(callableStatement, parameterName);
        }
        return callableStatement.do_getCharacterStream(parameterName);
    }

    @Override
    public void CallableStatement_setBlob(DmdbCallableStatement callableStatement, String parameterName, Blob x2) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setBlob(callableStatement, parameterName, x2);
        } else {
            callableStatement.do_setBlob(parameterName, x2);
        }
    }

    @Override
    public void CallableStatement_setClob(DmdbCallableStatement callableStatement, String parameterName, Clob x2) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setClob(callableStatement, parameterName, x2);
        } else {
            callableStatement.do_setClob(parameterName, x2);
        }
    }

    @Override
    public void CallableStatement_setAsciiStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setAsciiStream(callableStatement, parameterName, x2, length);
        } else {
            callableStatement.do_setAsciiStream(parameterName, x2, length);
        }
    }

    @Override
    public void CallableStatement_setBinaryStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setBinaryStream(callableStatement, parameterName, x2, length);
        } else {
            callableStatement.do_setBinaryStream(parameterName, x2, length);
        }
    }

    @Override
    public void CallableStatement_setCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setCharacterStream(callableStatement, parameterName, reader, length);
        } else {
            callableStatement.do_setCharacterStream(parameterName, reader, length);
        }
    }

    @Override
    public void CallableStatement_setAsciiStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setAsciiStream(callableStatement, parameterName, x2);
        } else {
            callableStatement.do_setAsciiStream(parameterName, x2);
        }
    }

    @Override
    public void CallableStatement_setBinaryStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setBinaryStream(callableStatement, parameterName, x2);
        } else {
            callableStatement.do_setBinaryStream(parameterName, x2);
        }
    }

    @Override
    public void CallableStatement_setCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setCharacterStream(callableStatement, parameterName, reader);
        } else {
            callableStatement.do_setCharacterStream(parameterName, reader);
        }
    }

    @Override
    public void CallableStatement_setNCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader value) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setNCharacterStream(callableStatement, parameterName, value);
        } else {
            callableStatement.do_setNCharacterStream(parameterName, value);
        }
    }

    @Override
    public void CallableStatement_setClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setClob(callableStatement, parameterName, reader);
        } else {
            callableStatement.do_setClob(parameterName, reader);
        }
    }

    @Override
    public void CallableStatement_setBlob(DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setBlob(callableStatement, parameterName, inputStream);
        } else {
            callableStatement.do_setBlob(parameterName, inputStream);
        }
    }

    @Override
    public void CallableStatement_setNClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setNClob(callableStatement, parameterName, reader);
        } else {
            callableStatement.do_setNClob(parameterName, reader);
        }
    }

    @Override
    public <T> T CallableStatement_getObject(DmdbCallableStatement callableStatement, int parameterIndex, Class<T> type) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getObject(callableStatement, parameterIndex, type);
        }
        return callableStatement.do_getObject(parameterIndex, type);
    }

    @Override
    public <T> T CallableStatement_getObject(DmdbCallableStatement callableStatement, String parameterName, Class<T> type) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getObject(callableStatement, parameterName, type);
        }
        return callableStatement.do_getObject(parameterName, type);
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType, scaleOrLength);
        } else {
            callableStatement.do_setObject(parameterName, x2, targetSqlType, scaleOrLength);
        }
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2, SQLType targetSqlType) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType);
        } else {
            callableStatement.do_setObject(parameterName, x2, targetSqlType);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType);
        } else {
            callableStatement.do_registerOutParameter(parameterIndex, sqlType);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, scale);
        } else {
            callableStatement.do_registerOutParameter(parameterIndex, sqlType, scale);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, typeName);
        } else {
            callableStatement.do_registerOutParameter(parameterIndex, sqlType, typeName);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType);
        } else {
            callableStatement.do_registerOutParameter(parameterName, sqlType);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType, int scale) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, scale);
        } else {
            callableStatement.do_registerOutParameter(parameterName, sqlType, scale);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType, String typeName) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, typeName);
        } else {
            callableStatement.do_registerOutParameter(parameterName, sqlType, typeName);
        }
    }

    @Override
    public DmdbIntervalYM CallableStatement_getINTERVALYM(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getINTERVALYM(callableStatement, parameterIndex);
        }
        return callableStatement.do_getINTERVALYM(parameterIndex);
    }

    @Override
    public DmdbIntervalDT CallableStatement_getINTERVALDT(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getINTERVALDT(callableStatement, parameterIndex);
        }
        return callableStatement.do_getINTERVALDT(parameterIndex);
    }

    @Override
    public DmdbTimestamp CallableStatement_getTIMESTAMP(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getTIMESTAMP(callableStatement, parameterIndex);
        }
        return callableStatement.do_getTIMESTAMP(parameterIndex);
    }

    @Override
    public ResultSet CallableStatement_getCursor(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getCursor(callableStatement, parameterIndex);
        }
        return callableStatement.do_getCursor(parameterIndex);
    }

    @Override
    public long Clob_length(DmdbClob clob) throws SQLException {
        if (this.next != null) {
            return this.next.Clob_length(clob);
        }
        return clob.do_length();
    }

    @Override
    public String Clob_getSubString(DmdbClob clob, long pos, int length) throws SQLException {
        if (this.next != null) {
            return this.next.Clob_getSubString(clob, pos, length);
        }
        return clob.do_getSubString(pos, length);
    }

    @Override
    public Reader Clob_getCharacterStream(DmdbClob clob) throws SQLException {
        if (this.next != null) {
            return this.next.Clob_getCharacterStream(clob);
        }
        return clob.do_getCharacterStream();
    }

    @Override
    public InputStream Clob_getAsciiStream(DmdbClob clob) throws SQLException {
        if (this.next != null) {
            return this.next.Clob_getAsciiStream(clob);
        }
        return clob.do_getAsciiStream();
    }

    @Override
    public long Clob_position(DmdbClob clob, String searchStr, long start) throws SQLException {
        if (this.next != null) {
            return this.next.Clob_position(clob, searchStr, start);
        }
        return clob.do_position(searchStr, start);
    }

    @Override
    public long Clob_position(DmdbClob clob, Clob searchStr, long start) throws SQLException {
        if (this.next != null) {
            return this.next.Clob_position(clob, searchStr, start);
        }
        return clob.do_position(searchStr, start);
    }

    @Override
    public int Clob_setString(DmdbClob clob, long pos, String str) throws SQLException {
        if (this.next != null) {
            return this.next.Clob_setString(clob, pos, str);
        }
        return clob.do_setString(pos, str);
    }

    @Override
    public int Clob_setString(DmdbClob clob, long pos, String str, int offset, int len) throws SQLException {
        if (this.next != null) {
            return this.next.Clob_setString(clob, pos, str, offset, len);
        }
        return clob.do_setString(pos, str, offset, len);
    }

    @Override
    public OutputStream Clob_setAsciiStream(DmdbClob clob, long pos) throws SQLException {
        if (this.next != null) {
            return this.next.Clob_setAsciiStream(clob, pos);
        }
        return clob.do_setAsciiStream(pos);
    }

    @Override
    public Writer Clob_setCharacterStream(DmdbClob clob, long pos) throws SQLException {
        if (this.next != null) {
            return this.next.Clob_setCharacterStream(clob, pos);
        }
        return clob.do_setCharacterStream(pos);
    }

    @Override
    public void Clob_truncate(DmdbClob clob, long len) throws SQLException {
        if (this.next != null) {
            this.next.Clob_truncate(clob, len);
        } else {
            clob.do_truncate(len);
        }
    }

    @Override
    public void Clob_free(DmdbClob clob) throws SQLException {
        if (this.next != null) {
            this.next.Clob_free(clob);
        } else {
            clob.do_free();
        }
    }

    @Override
    public Reader Clob_getCharacterStream(DmdbClob clob, long pos, long length) throws SQLException {
        if (this.next != null) {
            return this.next.Clob_getCharacterStream(clob, pos, length);
        }
        return clob.do_getCharacterStream(pos, length);
    }

    @Override
    public void Connection_reconnect(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            this.next.Connection_reconnect(connection);
        } else {
            connection.do_reconnect();
        }
    }

    @Override
    public Statement Connection_createStatement(DmdbConnection connection) throws SQLException {
        return this.Connection_createStatement(connection, connection.resultSetType, 1007, connection.resultSetHoldability);
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql) throws SQLException {
        this.feParamsList = new ArrayList<FeSQLParameter>();
        LinkedHashMap<Integer, Integer> indexMap = new LinkedHashMap<Integer, Integer>();
        try {
            sql = SQLProcessor.execOptFe(sql, this.feParamsList, connection.getServerEncoding(), indexMap);
        }
        catch (Exception exception) {
            DBError.EC_PARSE_ERROR.throwz(new Object[0]);
        }
        DmdbPreparedStatement fePs = connection.do_prepareStatement(sql);
        this.initFeCipher(fePs.serverParameters, connection);
        this.bindConstParam(fePs);
        fePs.indexMap = indexMap;
        return fePs;
    }

    @Override
    public FldrStatement Connection_fldrStatement(DmdbConnection connection, FldrConfig config) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_fldrStatement(connection, config);
        }
        return connection.do_fldrStatement(config);
    }

    @Override
    public CallableStatement Connection_prepareCall(DmdbConnection connection, String sql) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_prepareCall(connection, sql);
        }
        return connection.do_prepareCall(sql);
    }

    @Override
    public String Connection_nativeSQL(DmdbConnection connection, String sql) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_nativeSQL(connection, sql);
        }
        return connection.do_nativeSQL(sql);
    }

    @Override
    public void Connection_setAutoCommit(DmdbConnection connection, boolean autoCommit) throws SQLException {
        if (this.next != null) {
            this.next.Connection_setAutoCommit(connection, autoCommit);
        } else {
            connection.do_setAutoCommit(autoCommit);
        }
    }

    @Override
    public boolean Connection_getAutoCommit(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_getAutoCommit(connection);
        }
        return connection.do_getAutoCommit();
    }

    @Override
    public void Connection_commit(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            this.next.Connection_commit(connection);
        } else {
            connection.do_commit();
        }
    }

    @Override
    public void Connection_rollback(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            this.next.Connection_rollback(connection);
        } else {
            connection.do_rollback();
        }
    }

    @Override
    public void Connection_close(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            this.next.Connection_close(connection);
        } else {
            connection.do_close();
        }
    }

    @Override
    public boolean Connection_isClosed(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_isClosed(connection);
        }
        return connection.do_isClosed();
    }

    @Override
    public DatabaseMetaData Connection_getMetaData(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_getMetaData(connection);
        }
        return connection.do_getMetaData();
    }

    @Override
    public void Connection_setReadOnly(DmdbConnection connection, boolean readOnly) throws SQLException {
        if (this.next != null) {
            this.next.Connection_setReadOnly(connection, readOnly);
        } else {
            connection.do_setReadOnly(readOnly);
        }
    }

    @Override
    public boolean Connection_isReadOnly(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_isReadOnly(connection);
        }
        return connection.do_isReadOnly();
    }

    @Override
    public void Connection_setCatalog(DmdbConnection connection, String catalog) throws SQLException {
        if (this.next != null) {
            this.next.Connection_setCatalog(connection, catalog);
        } else {
            connection.do_setCatalog(catalog);
        }
    }

    @Override
    public String Connection_getCatalog(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_getCatalog(connection);
        }
        return connection.do_getCatalog();
    }

    @Override
    public void Connection_setTransactionIsolation(DmdbConnection connection, int level) throws SQLException {
        if (this.next != null) {
            this.next.Connection_setTransactionIsolation(connection, level);
        } else {
            connection.do_setTransactionIsolation(level);
        }
    }

    @Override
    public int Connection_getTransactionIsolation(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_getTransactionIsolation(connection);
        }
        return connection.do_getTransactionIsolation();
    }

    @Override
    public SQLWarning Connection_getWarnings(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_getWarnings(connection);
        }
        return connection.do_getWarnings();
    }

    @Override
    public void Connection_clearWarnings(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            this.next.Connection_clearWarnings(connection);
        } else {
            connection.do_clearWarnings();
        }
    }

    @Override
    public Statement Connection_createStatement(DmdbConnection connection, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.Connection_createStatement(connection, resultSetType, resultSetConcurrency, connection.resultSetHoldability);
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.feParamsList = new ArrayList<FeSQLParameter>();
        LinkedHashMap<Integer, Integer> indexMap = new LinkedHashMap<Integer, Integer>();
        try {
            sql = SQLProcessor.execOptFe(sql, this.feParamsList, connection.getServerEncoding(), indexMap);
        }
        catch (Exception exception) {
            DBError.EC_PARSE_ERROR.throwz(new Object[0]);
        }
        if (this.next != null) {
            DmdbPreparedStatement ps = (DmdbPreparedStatement)this.next.Connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency);
            this.initFeCipher(ps.serverParameters, connection);
            this.bindConstParam(ps);
            ps.indexMap = indexMap;
            return ps;
        }
        DmdbPreparedStatement ps = connection.do_prepareStatement(sql, resultSetType, resultSetConcurrency);
        this.initFeCipher(ps.serverParameters, connection);
        this.bindConstParam(ps);
        ps.indexMap = indexMap;
        return ps;
    }

    private void bindConstParam(DmdbPreparedStatement ps) throws SQLException {
        if (this.feParamsList != null && this.feParamsList.size() > 0) {
            int i2 = 0;
            while (i2 < this.feParamsList.size()) {
                int index = this.feParamsList.get((int)i2).index;
                if (index < 1 || index > ps.paramCount) {
                    DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
                }
                if (ps.serverParameters[i2].fullEncryptFlag) {
                    this.checkFullEncrypt(ps, index, Integer.MIN_VALUE, -1, this.feParamsList.get((int)i2).data);
                } else {
                    ps.do_setObject(index, this.feParamsList.get((int)i2).data, Integer.MIN_VALUE, -1);
                }
                ++i2;
            }
        }
    }

    @Override
    public CallableStatement Connection_prepareCall(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency);
        }
        return connection.do_prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> Connection_getTypeMap(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_getTypeMap(connection);
        }
        return connection.do_getTypeMap();
    }

    @Override
    public void Connection_setTypeMap(DmdbConnection connection, Map<String, Class<?>> map) throws SQLException {
        if (this.next != null) {
            this.next.Connection_setTypeMap(connection, map);
        } else {
            connection.do_setTypeMap(map);
        }
    }

    @Override
    public void Connection_setHoldability(DmdbConnection connection, int holdability) throws SQLException {
        if (this.next != null) {
            this.next.Connection_setHoldability(connection, holdability);
        } else {
            connection.do_setHoldability(holdability);
        }
    }

    @Override
    public int Connection_getHoldability(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_getHoldability(connection);
        }
        return connection.do_getHoldability();
    }

    @Override
    public Savepoint Connection_setSavepoint(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_setSavepoint(connection);
        }
        return connection.do_setSavepoint();
    }

    @Override
    public Savepoint Connection_setSavepoint(DmdbConnection connection, String name) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_setSavepoint(connection, name);
        }
        return connection.do_setSavepoint(name);
    }

    @Override
    public void Connection_rollback(DmdbConnection connection, Savepoint savepoint) throws SQLException {
        if (this.next != null) {
            this.next.Connection_rollback(connection, savepoint);
        } else {
            connection.do_rollback(savepoint);
        }
    }

    @Override
    public void Connection_releaseSavepoint(DmdbConnection connection, Savepoint savepoint) throws SQLException {
        if (this.next != null) {
            this.next.Connection_releaseSavepoint(connection, savepoint);
        } else {
            connection.do_releaseSavepoint(savepoint);
        }
    }

    @Override
    public Statement Connection_createStatement(DmdbConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_createStatement(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return connection.do_createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.feParamsList = new ArrayList<FeSQLParameter>();
        LinkedHashMap<Integer, Integer> indexMap = new LinkedHashMap<Integer, Integer>();
        try {
            sql = SQLProcessor.execOptFe(sql, this.feParamsList, connection.getServerEncoding(), indexMap);
        }
        catch (Exception exception) {
            DBError.EC_PARSE_ERROR.throwz(new Object[0]);
        }
        if (this.next != null) {
            DmdbPreparedStatement ps = (DmdbPreparedStatement)this.next.Connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.initFeCipher(ps.serverParameters, connection);
            this.bindConstParam(ps);
            ps.indexMap = indexMap;
            return ps;
        }
        DmdbPreparedStatement ps = connection.do_prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.initFeCipher(ps.serverParameters, connection);
        this.bindConstParam(ps);
        ps.indexMap = indexMap;
        return ps;
    }

    @Override
    public CallableStatement Connection_prepareCall(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return connection.do_prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        this.feParamsList = new ArrayList<FeSQLParameter>();
        LinkedHashMap<Integer, Integer> indexMap = new LinkedHashMap<Integer, Integer>();
        try {
            sql = SQLProcessor.execOptFe(sql, this.feParamsList, connection.getServerEncoding(), indexMap);
        }
        catch (Exception exception) {
            DBError.EC_PARSE_ERROR.throwz(new Object[0]);
        }
        if (this.next != null) {
            DmdbPreparedStatement ps = (DmdbPreparedStatement)this.next.Connection_prepareStatement(connection, sql, autoGeneratedKeys);
            this.initFeCipher(ps.serverParameters, connection);
            this.bindConstParam(ps);
            ps.indexMap = indexMap;
            return ps;
        }
        DmdbPreparedStatement ps = connection.do_prepareStatement(sql, autoGeneratedKeys);
        this.initFeCipher(ps.serverParameters, connection);
        this.bindConstParam(ps);
        ps.indexMap = indexMap;
        return ps;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int[] columnIndexes) throws SQLException {
        this.feParamsList = new ArrayList<FeSQLParameter>();
        LinkedHashMap<Integer, Integer> indexMap = new LinkedHashMap<Integer, Integer>();
        try {
            sql = SQLProcessor.execOptFe(sql, this.feParamsList, connection.getServerEncoding(), indexMap);
        }
        catch (Exception exception) {
            DBError.EC_PARSE_ERROR.throwz(new Object[0]);
        }
        if (this.next != null) {
            DmdbPreparedStatement ps = (DmdbPreparedStatement)this.next.Connection_prepareStatement(connection, sql, columnIndexes);
            this.initFeCipher(ps.serverParameters, connection);
            ps.indexMap = indexMap;
            return ps;
        }
        DmdbPreparedStatement ps = connection.do_prepareStatement(sql, columnIndexes);
        this.initFeCipher(ps.serverParameters, connection);
        this.bindConstParam(ps);
        ps.indexMap = indexMap;
        return ps;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, String[] columnNames) throws SQLException {
        this.feParamsList = new ArrayList<FeSQLParameter>();
        LinkedHashMap<Integer, Integer> indexMap = new LinkedHashMap<Integer, Integer>();
        try {
            sql = SQLProcessor.execOptFe(sql, this.feParamsList, connection.getServerEncoding(), indexMap);
        }
        catch (Exception exception) {
            DBError.EC_PARSE_ERROR.throwz(new Object[0]);
        }
        if (this.next != null) {
            DmdbPreparedStatement ps = (DmdbPreparedStatement)this.next.Connection_prepareStatement(connection, sql, columnNames);
            this.initFeCipher(ps.columns, connection);
            this.bindConstParam(ps);
            ps.indexMap = indexMap;
            return ps;
        }
        DmdbPreparedStatement ps = connection.do_prepareStatement(sql, columnNames);
        this.initFeCipher(ps.serverParameters, connection);
        this.bindConstParam(ps);
        ps.indexMap = indexMap;
        return ps;
    }

    @Override
    public Clob Connection_createClob(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_createClob(connection);
        }
        return connection.do_createClob();
    }

    @Override
    public Blob Connection_createBlob(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_createBlob(connection);
        }
        return connection.do_createBlob();
    }

    @Override
    public NClob Connection_createNClob(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            this.next.Connection_createNClob(connection);
        }
        return connection.do_createNClob();
    }

    @Override
    public SQLXML Connection_createSQLXML(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_createSQLXML(connection);
        }
        return connection.do_createSQLXML();
    }

    @Override
    public boolean Connection_isValid(DmdbConnection connection, int timeout) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_isValid(connection, timeout);
        }
        return connection.do_isValid(timeout);
    }

    @Override
    public void Connection_setClientInfo(DmdbConnection connection, String name, String value) throws SQLClientInfoException {
        if (this.next != null) {
            this.next.Connection_setClientInfo(connection, name, value);
        } else {
            connection.do_setClientInfo(name, value);
        }
    }

    @Override
    public void Connection_setClientInfo(DmdbConnection connection, Properties properties) throws SQLClientInfoException {
        if (this.next != null) {
            this.next.Connection_setClientInfo(connection, properties);
        } else {
            connection.do_setClientInfo(properties);
        }
    }

    @Override
    public String Connection_getClientInfo(DmdbConnection connection, String name) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_getClientInfo(connection, name);
        }
        return connection.do_getClientInfo(name);
    }

    @Override
    public Properties Connection_getClientInfo(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_getClientInfo(connection);
        }
        return connection.do_getClientInfo();
    }

    @Override
    public Array Connection_createArrayOf(DmdbConnection connection, String typeName, Object[] elements) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_createArrayOf(connection, typeName, elements);
        }
        return connection.do_createArrayOf(typeName, elements);
    }

    @Override
    public Struct Connection_createStruct(DmdbConnection connection, String typeName, Object[] attributes) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_createStruct(connection, typeName, attributes);
        }
        return connection.do_createStruct(typeName, attributes);
    }

    @Override
    public void Connection_setSchema(DmdbConnection connection, String schema) throws SQLException {
        if (this.next != null) {
            this.next.Connection_setSchema(connection, schema);
        } else {
            connection.do_setSchema(schema);
        }
    }

    @Override
    public String Connection_getSchema(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_getSchema(connection);
        }
        return connection.do_getSchema();
    }

    @Override
    public void Connection_abort(DmdbConnection connection, Executor executor) throws SQLException {
        if (this.next != null) {
            this.next.Connection_abort(connection, executor);
        } else {
            connection.do_abort(executor);
        }
    }

    @Override
    public void Connection_setNetworkTimeout(DmdbConnection connection, Executor executor, int milliseconds) throws SQLException {
        if (this.next != null) {
            this.next.Connection_setNetworkTimeout(connection, executor, milliseconds);
        } else {
            connection.do_setNetworkTimeout(executor, milliseconds);
        }
    }

    @Override
    public int Connection_getNetworkTimeout(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            return this.next.Connection_getNetworkTimeout(connection);
        }
        return connection.do_getNetworkTimeout();
    }

    @Override
    public boolean DatabaseMetaData_allProceduresAreCallable(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_allProceduresAreCallable(databaseMetaData);
        }
        return databaseMetaData.do_allProceduresAreCallable();
    }

    @Override
    public boolean DatabaseMetaData_allTablesAreSelectable(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_allTablesAreSelectable(databaseMetaData);
        }
        return databaseMetaData.do_allTablesAreSelectable();
    }

    @Override
    public String DatabaseMetaData_getURL(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getURL(databaseMetaData);
        }
        return databaseMetaData.do_getURL();
    }

    @Override
    public String DatabaseMetaData_getUserName(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getUserName(databaseMetaData);
        }
        return databaseMetaData.do_getUserName();
    }

    @Override
    public boolean DatabaseMetaData_isReadOnly(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_isReadOnly(databaseMetaData);
        }
        return databaseMetaData.do_isReadOnly();
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedHigh(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_nullsAreSortedHigh(databaseMetaData);
        }
        return databaseMetaData.do_nullsAreSortedHigh();
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedLow(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_nullsAreSortedLow(databaseMetaData);
        }
        return databaseMetaData.do_nullsAreSortedLow();
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedAtStart(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_nullsAreSortedAtStart(databaseMetaData);
        }
        return databaseMetaData.do_nullsAreSortedAtStart();
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedAtEnd(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_nullsAreSortedAtEnd(databaseMetaData);
        }
        return databaseMetaData.do_nullsAreSortedAtEnd();
    }

    @Override
    public String DatabaseMetaData_getDatabaseProductName(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getDatabaseProductName(databaseMetaData);
        }
        return databaseMetaData.do_getDatabaseProductName();
    }

    @Override
    public String DatabaseMetaData_getDatabaseProductVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getDatabaseProductVersion(databaseMetaData);
        }
        return databaseMetaData.do_getDatabaseProductVersion();
    }

    @Override
    public String DatabaseMetaData_getDriverName(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getDriverName(databaseMetaData);
        }
        return databaseMetaData.do_getDriverName();
    }

    @Override
    public String DatabaseMetaData_getDriverVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getDriverVersion(databaseMetaData);
        }
        return databaseMetaData.do_getDriverVersion();
    }

    @Override
    public int DatabaseMetaData_getDriverMajorVersion(DmdbDatabaseMetaData databaseMetaData) {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getDriverMajorVersion(databaseMetaData);
        }
        return databaseMetaData.do_getDriverMajorVersion();
    }

    @Override
    public int DatabaseMetaData_getDriverMinorVersion(DmdbDatabaseMetaData databaseMetaData) {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getDriverMinorVersion(databaseMetaData);
        }
        return databaseMetaData.do_getDriverMinorVersion();
    }

    @Override
    public boolean DatabaseMetaData_usesLocalFiles(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_usesLocalFiles(databaseMetaData);
        }
        return databaseMetaData.do_usesLocalFiles();
    }

    @Override
    public boolean DatabaseMetaData_usesLocalFilePerTable(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_usesLocalFilePerTable(databaseMetaData);
        }
        return databaseMetaData.do_usesLocalFilePerTable();
    }

    @Override
    public boolean DatabaseMetaData_supportsMixedCaseIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsMixedCaseIdentifiers(databaseMetaData);
        }
        return databaseMetaData.do_supportsMixedCaseIdentifiers();
    }

    @Override
    public boolean DatabaseMetaData_storesUpperCaseIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_storesUpperCaseIdentifiers(databaseMetaData);
        }
        return databaseMetaData.do_storesUpperCaseIdentifiers();
    }

    @Override
    public boolean DatabaseMetaData_storesLowerCaseIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_storesLowerCaseIdentifiers(databaseMetaData);
        }
        return databaseMetaData.do_storesLowerCaseIdentifiers();
    }

    @Override
    public boolean DatabaseMetaData_storesMixedCaseIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_storesMixedCaseIdentifiers(databaseMetaData);
        }
        return databaseMetaData.do_storesMixedCaseIdentifiers();
    }

    @Override
    public boolean DatabaseMetaData_supportsMixedCaseQuotedIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsMixedCaseQuotedIdentifiers(databaseMetaData);
        }
        return databaseMetaData.do_supportsMixedCaseQuotedIdentifiers();
    }

    @Override
    public boolean DatabaseMetaData_storesUpperCaseQuotedIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_storesUpperCaseQuotedIdentifiers(databaseMetaData);
        }
        return databaseMetaData.do_storesUpperCaseQuotedIdentifiers();
    }

    @Override
    public boolean DatabaseMetaData_storesLowerCaseQuotedIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_storesLowerCaseQuotedIdentifiers(databaseMetaData);
        }
        return databaseMetaData.do_storesLowerCaseQuotedIdentifiers();
    }

    @Override
    public boolean DatabaseMetaData_storesMixedCaseQuotedIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_storesMixedCaseQuotedIdentifiers(databaseMetaData);
        }
        return databaseMetaData.do_storesMixedCaseQuotedIdentifiers();
    }

    @Override
    public String DatabaseMetaData_getIdentifierQuoteString(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getIdentifierQuoteString(databaseMetaData);
        }
        return databaseMetaData.do_getIdentifierQuoteString();
    }

    @Override
    public String DatabaseMetaData_getSQLKeywords(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getSQLKeywords(databaseMetaData);
        }
        return databaseMetaData.do_getSQLKeywords();
    }

    @Override
    public String DatabaseMetaData_getNumericFunctions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getNumericFunctions(databaseMetaData);
        }
        return databaseMetaData.do_getNumericFunctions();
    }

    @Override
    public String DatabaseMetaData_getStringFunctions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getStringFunctions(databaseMetaData);
        }
        return databaseMetaData.do_getStringFunctions();
    }

    @Override
    public String DatabaseMetaData_getSystemFunctions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getSystemFunctions(databaseMetaData);
        }
        return databaseMetaData.do_getSystemFunctions();
    }

    @Override
    public String DatabaseMetaData_getTimeDateFunctions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getTimeDateFunctions(databaseMetaData);
        }
        return databaseMetaData.do_getTimeDateFunctions();
    }

    @Override
    public String DatabaseMetaData_getSearchStringEscape(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getSearchStringEscape(databaseMetaData);
        }
        return databaseMetaData.do_getSearchStringEscape();
    }

    @Override
    public String DatabaseMetaData_getExtraNameCharacters(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getExtraNameCharacters(databaseMetaData);
        }
        return databaseMetaData.do_getExtraNameCharacters();
    }

    @Override
    public boolean DatabaseMetaData_supportsAlterTableWithAddColumn(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsAlterTableWithAddColumn(databaseMetaData);
        }
        return databaseMetaData.do_supportsAlterTableWithAddColumn();
    }

    @Override
    public boolean DatabaseMetaData_supportsAlterTableWithDropColumn(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsAlterTableWithDropColumn(databaseMetaData);
        }
        return databaseMetaData.do_supportsAlterTableWithDropColumn();
    }

    @Override
    public boolean DatabaseMetaData_supportsColumnAliasing(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsColumnAliasing(databaseMetaData);
        }
        return databaseMetaData.do_supportsColumnAliasing();
    }

    @Override
    public boolean DatabaseMetaData_nullPlusNonNullIsNull(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_nullPlusNonNullIsNull(databaseMetaData);
        }
        return databaseMetaData.do_nullPlusNonNullIsNull();
    }

    @Override
    public boolean DatabaseMetaData_supportsConvert(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsConvert(databaseMetaData);
        }
        return databaseMetaData.do_supportsConvert();
    }

    @Override
    public boolean DatabaseMetaData_supportsConvert(DmdbDatabaseMetaData databaseMetaData, int fromType, int toType) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsConvert(databaseMetaData, fromType, toType);
        }
        return databaseMetaData.do_supportsConvert(fromType, toType);
    }

    @Override
    public boolean DatabaseMetaData_supportsTableCorrelationNames(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsTableCorrelationNames(databaseMetaData);
        }
        return databaseMetaData.do_supportsTableCorrelationNames();
    }

    @Override
    public boolean DatabaseMetaData_supportsDifferentTableCorrelationNames(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsDifferentTableCorrelationNames(databaseMetaData);
        }
        return databaseMetaData.do_supportsDifferentTableCorrelationNames();
    }

    @Override
    public boolean DatabaseMetaData_supportsExpressionsInOrderBy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsExpressionsInOrderBy(databaseMetaData);
        }
        return databaseMetaData.do_supportsExpressionsInOrderBy();
    }

    @Override
    public boolean DatabaseMetaData_supportsOrderByUnrelated(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsOrderByUnrelated(databaseMetaData);
        }
        return databaseMetaData.do_supportsOrderByUnrelated();
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupBy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsGroupBy(databaseMetaData);
        }
        return databaseMetaData.do_supportsGroupBy();
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupByUnrelated(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsGroupByUnrelated(databaseMetaData);
        }
        return databaseMetaData.do_supportsGroupByUnrelated();
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupByBeyondSelect(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsGroupByBeyondSelect(databaseMetaData);
        }
        return databaseMetaData.do_supportsGroupByBeyondSelect();
    }

    @Override
    public boolean DatabaseMetaData_supportsLikeEscapeClause(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsLikeEscapeClause(databaseMetaData);
        }
        return databaseMetaData.do_supportsLikeEscapeClause();
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleResultSets(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsMultipleResultSets(databaseMetaData);
        }
        return databaseMetaData.do_supportsMultipleResultSets();
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleTransactions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsMultipleTransactions(databaseMetaData);
        }
        return databaseMetaData.do_supportsMultipleTransactions();
    }

    @Override
    public boolean DatabaseMetaData_supportsNonNullableColumns(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsNonNullableColumns(databaseMetaData);
        }
        return databaseMetaData.do_supportsNonNullableColumns();
    }

    @Override
    public boolean DatabaseMetaData_supportsMinimumSQLGrammar(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsMinimumSQLGrammar(databaseMetaData);
        }
        return databaseMetaData.do_supportsMinimumSQLGrammar();
    }

    @Override
    public boolean DatabaseMetaData_supportsCoreSQLGrammar(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsCoreSQLGrammar(databaseMetaData);
        }
        return databaseMetaData.do_supportsCoreSQLGrammar();
    }

    @Override
    public boolean DatabaseMetaData_supportsExtendedSQLGrammar(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsExtendedSQLGrammar(databaseMetaData);
        }
        return databaseMetaData.do_supportsExtendedSQLGrammar();
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92EntryLevelSQL(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsANSI92EntryLevelSQL(databaseMetaData);
        }
        return databaseMetaData.do_supportsANSI92EntryLevelSQL();
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92IntermediateSQL(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsANSI92IntermediateSQL(databaseMetaData);
        }
        return databaseMetaData.do_supportsANSI92IntermediateSQL();
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92FullSQL(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsANSI92FullSQL(databaseMetaData);
        }
        return databaseMetaData.do_supportsANSI92FullSQL();
    }

    @Override
    public boolean DatabaseMetaData_supportsIntegrityEnhancementFacility(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsIntegrityEnhancementFacility(databaseMetaData);
        }
        return databaseMetaData.do_supportsIntegrityEnhancementFacility();
    }

    @Override
    public boolean DatabaseMetaData_supportsOuterJoins(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsOuterJoins(databaseMetaData);
        }
        return databaseMetaData.do_supportsOuterJoins();
    }

    @Override
    public boolean DatabaseMetaData_supportsFullOuterJoins(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsFullOuterJoins(databaseMetaData);
        }
        return databaseMetaData.do_supportsFullOuterJoins();
    }

    @Override
    public boolean DatabaseMetaData_supportsLimitedOuterJoins(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsLimitedOuterJoins(databaseMetaData);
        }
        return databaseMetaData.do_supportsLimitedOuterJoins();
    }

    @Override
    public String DatabaseMetaData_getSchemaTerm(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getSchemaTerm(databaseMetaData);
        }
        return databaseMetaData.do_getSchemaTerm();
    }

    @Override
    public String DatabaseMetaData_getProcedureTerm(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getProcedureTerm(databaseMetaData);
        }
        return databaseMetaData.do_getProcedureTerm();
    }

    @Override
    public String DatabaseMetaData_getCatalogTerm(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getCatalogTerm(databaseMetaData);
        }
        return databaseMetaData.do_getCatalogTerm();
    }

    @Override
    public boolean DatabaseMetaData_isCatalogAtStart(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_isCatalogAtStart(databaseMetaData);
        }
        return databaseMetaData.do_isCatalogAtStart();
    }

    @Override
    public String DatabaseMetaData_getCatalogSeparator(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getCatalogSeparator(databaseMetaData);
        }
        return databaseMetaData.do_getCatalogSeparator();
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInDataManipulation(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsSchemasInDataManipulation(databaseMetaData);
        }
        return databaseMetaData.do_supportsSchemasInDataManipulation();
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInProcedureCalls(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsSchemasInProcedureCalls(databaseMetaData);
        }
        return databaseMetaData.do_supportsSchemasInProcedureCalls();
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInTableDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsSchemasInTableDefinitions(databaseMetaData);
        }
        return databaseMetaData.do_supportsSchemasInTableDefinitions();
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInIndexDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsSchemasInIndexDefinitions(databaseMetaData);
        }
        return databaseMetaData.do_supportsSchemasInIndexDefinitions();
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(databaseMetaData);
        }
        return databaseMetaData.do_supportsSchemasInPrivilegeDefinitions();
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInDataManipulation(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsCatalogsInDataManipulation(databaseMetaData);
        }
        return databaseMetaData.do_supportsCatalogsInDataManipulation();
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInProcedureCalls(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsCatalogsInProcedureCalls(databaseMetaData);
        }
        return databaseMetaData.do_supportsCatalogsInProcedureCalls();
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInTableDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsCatalogsInTableDefinitions(databaseMetaData);
        }
        return databaseMetaData.do_supportsCatalogsInTableDefinitions();
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInIndexDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsCatalogsInIndexDefinitions(databaseMetaData);
        }
        return databaseMetaData.do_supportsCatalogsInIndexDefinitions();
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(databaseMetaData);
        }
        return databaseMetaData.do_supportsCatalogsInPrivilegeDefinitions();
    }

    @Override
    public boolean DatabaseMetaData_supportsPositionedDelete(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsPositionedDelete(databaseMetaData);
        }
        return databaseMetaData.do_supportsPositionedDelete();
    }

    @Override
    public boolean DatabaseMetaData_supportsPositionedUpdate(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsPositionedUpdate(databaseMetaData);
        }
        return databaseMetaData.do_supportsPositionedUpdate();
    }

    @Override
    public boolean DatabaseMetaData_supportsSelectForUpdate(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsSelectForUpdate(databaseMetaData);
        }
        return databaseMetaData.do_supportsSelectForUpdate();
    }

    @Override
    public boolean DatabaseMetaData_supportsStoredProcedures(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsStoredProcedures(databaseMetaData);
        }
        return databaseMetaData.do_supportsStoredProcedures();
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInComparisons(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsSubqueriesInComparisons(databaseMetaData);
        }
        return databaseMetaData.do_supportsSubqueriesInComparisons();
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInExists(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsSubqueriesInExists(databaseMetaData);
        }
        return databaseMetaData.do_supportsSubqueriesInExists();
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInIns(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsSubqueriesInIns(databaseMetaData);
        }
        return databaseMetaData.do_supportsSubqueriesInIns();
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInQuantifieds(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsSubqueriesInQuantifieds(databaseMetaData);
        }
        return databaseMetaData.do_supportsSubqueriesInQuantifieds();
    }

    @Override
    public boolean DatabaseMetaData_supportsCorrelatedSubqueries(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsCorrelatedSubqueries(databaseMetaData);
        }
        return databaseMetaData.do_supportsCorrelatedSubqueries();
    }

    @Override
    public boolean DatabaseMetaData_supportsUnion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsUnion(databaseMetaData);
        }
        return databaseMetaData.do_supportsUnion();
    }

    @Override
    public boolean DatabaseMetaData_supportsUnionAll(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsUnionAll(databaseMetaData);
        }
        return databaseMetaData.do_supportsUnionAll();
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenCursorsAcrossCommit(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsOpenCursorsAcrossCommit(databaseMetaData);
        }
        return databaseMetaData.do_supportsOpenCursorsAcrossCommit();
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenCursorsAcrossRollback(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsOpenCursorsAcrossRollback(databaseMetaData);
        }
        return databaseMetaData.do_supportsOpenCursorsAcrossRollback();
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenStatementsAcrossCommit(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsOpenStatementsAcrossCommit(databaseMetaData);
        }
        return databaseMetaData.do_supportsOpenStatementsAcrossCommit();
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenStatementsAcrossRollback(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsOpenStatementsAcrossRollback(databaseMetaData);
        }
        return databaseMetaData.do_supportsOpenStatementsAcrossRollback();
    }

    @Override
    public int DatabaseMetaData_getMaxBinaryLiteralLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getMaxBinaryLiteralLength(databaseMetaData);
        }
        return databaseMetaData.do_getMaxBinaryLiteralLength();
    }

    @Override
    public int DatabaseMetaData_getMaxCharLiteralLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getMaxCharLiteralLength(databaseMetaData);
        }
        return databaseMetaData.do_getMaxCharLiteralLength();
    }

    @Override
    public int DatabaseMetaData_getMaxColumnNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getMaxColumnNameLength(databaseMetaData);
        }
        return databaseMetaData.do_getMaxColumnNameLength();
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInGroupBy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getMaxColumnsInGroupBy(databaseMetaData);
        }
        return databaseMetaData.do_getMaxColumnsInGroupBy();
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInIndex(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getMaxColumnsInIndex(databaseMetaData);
        }
        return databaseMetaData.do_getMaxColumnsInIndex();
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInOrderBy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getMaxColumnsInOrderBy(databaseMetaData);
        }
        return databaseMetaData.do_getMaxColumnsInOrderBy();
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInSelect(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getMaxColumnsInSelect(databaseMetaData);
        }
        return databaseMetaData.do_getMaxColumnsInSelect();
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInTable(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getMaxColumnsInTable(databaseMetaData);
        }
        return databaseMetaData.do_getMaxColumnsInTable();
    }

    @Override
    public int DatabaseMetaData_getMaxConnections(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getMaxConnections(databaseMetaData);
        }
        return databaseMetaData.do_getMaxConnections();
    }

    @Override
    public int DatabaseMetaData_getMaxCursorNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getMaxCursorNameLength(databaseMetaData);
        }
        return databaseMetaData.do_getMaxCursorNameLength();
    }

    @Override
    public int DatabaseMetaData_getMaxIndexLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getMaxCursorNameLength(databaseMetaData);
        }
        return databaseMetaData.do_getMaxIndexLength();
    }

    @Override
    public int DatabaseMetaData_getMaxSchemaNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getMaxSchemaNameLength(databaseMetaData);
        }
        return databaseMetaData.do_getMaxSchemaNameLength();
    }

    @Override
    public int DatabaseMetaData_getMaxProcedureNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getMaxProcedureNameLength(databaseMetaData);
        }
        return databaseMetaData.do_getMaxProcedureNameLength();
    }

    @Override
    public int DatabaseMetaData_getMaxCatalogNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getMaxCatalogNameLength(databaseMetaData);
        }
        return databaseMetaData.do_getMaxCatalogNameLength();
    }

    @Override
    public int DatabaseMetaData_getMaxRowSize(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getMaxRowSize(databaseMetaData);
        }
        return databaseMetaData.do_getMaxRowSize();
    }

    @Override
    public boolean DatabaseMetaData_doesMaxRowSizeIncludeBlobs(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_doesMaxRowSizeIncludeBlobs(databaseMetaData);
        }
        return databaseMetaData.do_doesMaxRowSizeIncludeBlobs();
    }

    @Override
    public int DatabaseMetaData_getMaxStatementLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getMaxStatementLength(databaseMetaData);
        }
        return databaseMetaData.do_getMaxStatementLength();
    }

    @Override
    public int DatabaseMetaData_getMaxStatements(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getMaxStatements(databaseMetaData);
        }
        return databaseMetaData.do_getMaxStatements();
    }

    @Override
    public int DatabaseMetaData_getMaxTableNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getMaxTableNameLength(databaseMetaData);
        }
        return databaseMetaData.do_getMaxTableNameLength();
    }

    @Override
    public int DatabaseMetaData_getMaxTablesInSelect(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getMaxTablesInSelect(databaseMetaData);
        }
        return databaseMetaData.do_getMaxTablesInSelect();
    }

    @Override
    public int DatabaseMetaData_getMaxUserNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getMaxUserNameLength(databaseMetaData);
        }
        return databaseMetaData.do_getMaxUserNameLength();
    }

    @Override
    public int DatabaseMetaData_getDefaultTransactionIsolation(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getDefaultTransactionIsolation(databaseMetaData);
        }
        return databaseMetaData.do_getDefaultTransactionIsolation();
    }

    @Override
    public boolean DatabaseMetaData_supportsTransactions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsTransactions(databaseMetaData);
        }
        return databaseMetaData.do_supportsTransactions();
    }

    @Override
    public boolean DatabaseMetaData_supportsTransactionIsolationLevel(DmdbDatabaseMetaData databaseMetaData, int level) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsTransactionIsolationLevel(databaseMetaData, level);
        }
        return databaseMetaData.do_supportsTransactionIsolationLevel(level);
    }

    @Override
    public boolean DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(databaseMetaData);
        }
        return databaseMetaData.do_supportsDataDefinitionAndDataManipulationTransactions();
    }

    @Override
    public boolean DatabaseMetaData_supportsDataManipulationTransactionsOnly(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsDataManipulationTransactionsOnly(databaseMetaData);
        }
        return databaseMetaData.do_supportsDataManipulationTransactionsOnly();
    }

    @Override
    public boolean DatabaseMetaData_dataDefinitionCausesTransactionCommit(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_dataDefinitionCausesTransactionCommit(databaseMetaData);
        }
        return databaseMetaData.do_dataDefinitionCausesTransactionCommit();
    }

    @Override
    public boolean DatabaseMetaData_dataDefinitionIgnoredInTransactions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_dataDefinitionIgnoredInTransactions(databaseMetaData);
        }
        return databaseMetaData.do_dataDefinitionIgnoredInTransactions();
    }

    @Override
    public ResultSet DatabaseMetaData_getProcedures(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getProcedures(databaseMetaData, catalog, schemaPattern, procedureNamePattern);
        }
        return databaseMetaData.do_getProcedures(catalog, schemaPattern, procedureNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getProcedureColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getProcedureColumns(databaseMetaData, catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        }
        return databaseMetaData.do_getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getTables(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getTables(databaseMetaData, catalog, schemaPattern, tableNamePattern, types);
        }
        return databaseMetaData.do_getTables(catalog, schemaPattern, tableNamePattern, types);
    }

    @Override
    public ResultSet DatabaseMetaData_getSchemas(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getSchemas(databaseMetaData);
        }
        return databaseMetaData.do_getSchemas();
    }

    @Override
    public ResultSet DatabaseMetaData_getCatalogs(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getCatalogs(databaseMetaData);
        }
        return databaseMetaData.do_getCatalogs();
    }

    @Override
    public ResultSet DatabaseMetaData_getTableTypes(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getTableTypes(databaseMetaData);
        }
        return databaseMetaData.do_getTableTypes();
    }

    @Override
    public ResultSet DatabaseMetaData_getColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getColumns(databaseMetaData, catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
        return databaseMetaData.do_getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getColumnPrivileges(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getColumnPrivileges(databaseMetaData, catalog, schema, table, columnNamePattern);
        }
        return databaseMetaData.do_getColumnPrivileges(catalog, schema, table, columnNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getTablePrivileges(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getTablePrivileges(databaseMetaData, catalog, schemaPattern, tableNamePattern);
        }
        return databaseMetaData.do_getTablePrivileges(catalog, schemaPattern, tableNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getBestRowIdentifier(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getBestRowIdentifier(databaseMetaData, catalog, schema, table, scope, nullable);
        }
        return databaseMetaData.do_getBestRowIdentifier(catalog, schema, table, scope, nullable);
    }

    @Override
    public ResultSet DatabaseMetaData_getVersionColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getVersionColumns(databaseMetaData, catalog, schema, table);
        }
        return databaseMetaData.do_getVersionColumns(catalog, schema, table);
    }

    @Override
    public ResultSet DatabaseMetaData_getPrimaryKeys(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getPrimaryKeys(databaseMetaData, catalog, schema, table);
        }
        return databaseMetaData.do_getPrimaryKeys(catalog, schema, table);
    }

    @Override
    public ResultSet DatabaseMetaData_getImportedKeys(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getImportedKeys(databaseMetaData, catalog, schema, table);
        }
        return databaseMetaData.do_getImportedKeys(catalog, schema, table);
    }

    @Override
    public ResultSet DatabaseMetaData_getExportedKeys(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getExportedKeys(databaseMetaData, catalog, schema, table);
        }
        return databaseMetaData.do_getExportedKeys(catalog, schema, table);
    }

    @Override
    public ResultSet DatabaseMetaData_getCrossReference(DmdbDatabaseMetaData databaseMetaData, String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getCrossReference(databaseMetaData, parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
        }
        return databaseMetaData.do_getCrossReference(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
    }

    @Override
    public ResultSet DatabaseMetaData_getTypeInfo(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getTypeInfo(databaseMetaData);
        }
        return databaseMetaData.do_getTypeInfo();
    }

    @Override
    public ResultSet DatabaseMetaData_getIndexInfo(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getIndexInfo(databaseMetaData, catalog, schema, table, unique, approximate);
        }
        return databaseMetaData.do_getIndexInfo(catalog, schema, table, unique, approximate);
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetType(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsResultSetType(databaseMetaData, type);
        }
        return databaseMetaData.do_supportsResultSetType(type);
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetConcurrency(DmdbDatabaseMetaData databaseMetaData, int type, int concurrency) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsResultSetConcurrency(databaseMetaData, type, concurrency);
        }
        return databaseMetaData.do_supportsResultSetConcurrency(type, concurrency);
    }

    @Override
    public boolean DatabaseMetaData_ownUpdatesAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_ownUpdatesAreVisible(databaseMetaData, type);
        }
        return databaseMetaData.do_ownUpdatesAreVisible(type);
    }

    @Override
    public boolean DatabaseMetaData_ownDeletesAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_ownDeletesAreVisible(databaseMetaData, type);
        }
        return databaseMetaData.do_ownDeletesAreVisible(type);
    }

    @Override
    public boolean DatabaseMetaData_ownInsertsAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_ownInsertsAreVisible(databaseMetaData, type);
        }
        return databaseMetaData.do_ownInsertsAreVisible(type);
    }

    @Override
    public boolean DatabaseMetaData_othersUpdatesAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_othersUpdatesAreVisible(databaseMetaData, type);
        }
        return databaseMetaData.do_othersUpdatesAreVisible(type);
    }

    @Override
    public boolean DatabaseMetaData_othersDeletesAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_othersDeletesAreVisible(databaseMetaData, type);
        }
        return databaseMetaData.do_othersDeletesAreVisible(type);
    }

    @Override
    public boolean DatabaseMetaData_othersInsertsAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_othersInsertsAreVisible(databaseMetaData, type);
        }
        return databaseMetaData.do_othersInsertsAreVisible(type);
    }

    @Override
    public boolean DatabaseMetaData_updatesAreDetected(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_updatesAreDetected(databaseMetaData, type);
        }
        return databaseMetaData.do_updatesAreDetected(type);
    }

    @Override
    public boolean DatabaseMetaData_deletesAreDetected(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_deletesAreDetected(databaseMetaData, type);
        }
        return databaseMetaData.do_deletesAreDetected(type);
    }

    @Override
    public boolean DatabaseMetaData_insertsAreDetected(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_insertsAreDetected(databaseMetaData, type);
        }
        return databaseMetaData.do_insertsAreDetected(type);
    }

    @Override
    public boolean DatabaseMetaData_supportsBatchUpdates(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsBatchUpdates(databaseMetaData);
        }
        return databaseMetaData.do_supportsBatchUpdates();
    }

    @Override
    public ResultSet DatabaseMetaData_getUDTs(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getUDTs(databaseMetaData, catalog, schemaPattern, typeNamePattern, types);
        }
        return databaseMetaData.do_getUDTs(catalog, schemaPattern, typeNamePattern, types);
    }

    @Override
    public Connection DatabaseMetaData_getConnection(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getConnection(databaseMetaData);
        }
        return databaseMetaData.do_getConnection();
    }

    @Override
    public boolean DatabaseMetaData_supportsSavepoints(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsSavepoints(databaseMetaData);
        }
        return databaseMetaData.do_supportsSavepoints();
    }

    @Override
    public boolean DatabaseMetaData_supportsNamedParameters(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsNamedParameters(databaseMetaData);
        }
        return databaseMetaData.do_supportsNamedParameters();
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleOpenResults(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsMultipleOpenResults(databaseMetaData);
        }
        return databaseMetaData.do_supportsMultipleOpenResults();
    }

    @Override
    public boolean DatabaseMetaData_supportsGetGeneratedKeys(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsGetGeneratedKeys(databaseMetaData);
        }
        return databaseMetaData.do_supportsGetGeneratedKeys();
    }

    @Override
    public ResultSet DatabaseMetaData_getSuperTypes(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getSuperTypes(databaseMetaData, catalog, schemaPattern, typeNamePattern);
        }
        return databaseMetaData.do_getSuperTypes(catalog, schemaPattern, typeNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getSuperTables(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getSuperTables(databaseMetaData, catalog, schemaPattern, tableNamePattern);
        }
        return databaseMetaData.do_getSuperTables(catalog, schemaPattern, tableNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getAttributes(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getAttributes(databaseMetaData, catalog, schemaPattern, typeNamePattern, attributeNamePattern);
        }
        return databaseMetaData.do_getAttributes(catalog, schemaPattern, typeNamePattern, attributeNamePattern);
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetHoldability(DmdbDatabaseMetaData databaseMetaData, int holdability) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsResultSetHoldability(databaseMetaData, holdability);
        }
        return databaseMetaData.do_supportsResultSetHoldability(holdability);
    }

    @Override
    public int DatabaseMetaData_getResultSetHoldability(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getResultSetHoldability(databaseMetaData);
        }
        return databaseMetaData.do_getResultSetHoldability();
    }

    @Override
    public int DatabaseMetaData_getDatabaseMajorVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getDatabaseMajorVersion(databaseMetaData);
        }
        return databaseMetaData.do_getDatabaseMajorVersion();
    }

    @Override
    public int DatabaseMetaData_getDatabaseMinorVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getDatabaseMinorVersion(databaseMetaData);
        }
        return databaseMetaData.do_getDatabaseMinorVersion();
    }

    @Override
    public int DatabaseMetaData_getJDBCMajorVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getJDBCMajorVersion(databaseMetaData);
        }
        return databaseMetaData.do_getJDBCMajorVersion();
    }

    @Override
    public int DatabaseMetaData_getJDBCMinorVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getJDBCMinorVersion(databaseMetaData);
        }
        return databaseMetaData.do_getJDBCMinorVersion();
    }

    @Override
    public int DatabaseMetaData_getSQLStateType(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getSQLStateType(databaseMetaData);
        }
        return databaseMetaData.do_getSQLStateType();
    }

    @Override
    public boolean DatabaseMetaData_locatorsUpdateCopy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_locatorsUpdateCopy(databaseMetaData);
        }
        return databaseMetaData.do_locatorsUpdateCopy();
    }

    @Override
    public boolean DatabaseMetaData_supportsStatementPooling(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsStatementPooling(databaseMetaData);
        }
        return databaseMetaData.do_supportsStatementPooling();
    }

    @Override
    public RowIdLifetime DatabaseMetaData_getRowIdLifetime(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getRowIdLifetime(databaseMetaData);
        }
        return databaseMetaData.do_getRowIdLifetime();
    }

    @Override
    public ResultSet DatabaseMetaData_getSchemas(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getSchemas(databaseMetaData, catalog, schemaPattern);
        }
        return databaseMetaData.do_getSchemas(catalog, schemaPattern);
    }

    @Override
    public boolean DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(databaseMetaData);
        }
        return databaseMetaData.do_supportsStoredFunctionsUsingCallSyntax();
    }

    @Override
    public boolean DatabaseMetaData_autoCommitFailureClosesAllResultSets(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_autoCommitFailureClosesAllResultSets(databaseMetaData);
        }
        return databaseMetaData.do_autoCommitFailureClosesAllResultSets();
    }

    @Override
    public ResultSet DatabaseMetaData_getClientInfoProperties(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getClientInfoProperties(databaseMetaData);
        }
        return databaseMetaData.do_getClientInfoProperties();
    }

    @Override
    public ResultSet DatabaseMetaData_getFunctions(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getFunctions(databaseMetaData, catalog, schemaPattern, functionNamePattern);
        }
        return databaseMetaData.do_getFunctions(catalog, schemaPattern, functionNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getFunctionColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getFunctionColumns(databaseMetaData, catalog, schemaPattern, functionNamePattern, columnNamePattern);
        }
        return databaseMetaData.do_getFunctionColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getPseudoColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getPseudoColumns(databaseMetaData, catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
        return databaseMetaData.do_getPseudoColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    @Override
    public boolean DatabaseMetaData_generatedKeyAlwaysReturned(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_generatedKeyAlwaysReturned(databaseMetaData);
        }
        return databaseMetaData.do_generatedKeyAlwaysReturned();
    }

    @Override
    public long DatabaseMetaData_getMaxLogicalLobSize(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_getMaxLogicalLobSize(databaseMetaData);
        }
        return databaseMetaData.do_getMaxLogicalLobSize();
    }

    @Override
    public boolean DatabaseMetaData_supportsRefCursors(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.DatabaseMetaData_supportsRefCursors(databaseMetaData);
        }
        return databaseMetaData.do_supportsRefCursors();
    }

    @Override
    public Connection Driver_connect(DmDriver driver, DmProperties props) throws SQLException {
        if (this.next != null) {
            return this.next.Driver_connect(driver, props);
        }
        return driver.do_connect(props);
    }

    @Override
    public int ParameterMetaData_getParameterCount(DmdbParameterMetaData parameterMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.ParameterMetaData_getParameterCount(parameterMetaData);
        }
        return parameterMetaData.do_getParameterCount();
    }

    @Override
    public int ParameterMetaData_isNullable(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        if (this.next != null) {
            return this.next.ParameterMetaData_isNullable(parameterMetaData, param);
        }
        return parameterMetaData.do_isNullable(param);
    }

    @Override
    public boolean ParameterMetaData_isSigned(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        if (this.next != null) {
            return this.next.ParameterMetaData_isSigned(parameterMetaData, param);
        }
        return parameterMetaData.do_isSigned(param);
    }

    @Override
    public int ParameterMetaData_getPrecision(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        if (this.next != null) {
            return this.next.ParameterMetaData_getPrecision(parameterMetaData, param);
        }
        return parameterMetaData.do_getPrecision(param);
    }

    @Override
    public int ParameterMetaData_getScale(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        if (this.next != null) {
            return this.next.ParameterMetaData_getScale(parameterMetaData, param);
        }
        return parameterMetaData.do_getScale(param);
    }

    @Override
    public int ParameterMetaData_getParameterType(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        if (this.next != null) {
            return this.next.ParameterMetaData_getParameterType(parameterMetaData, param);
        }
        return parameterMetaData.do_getParameterType(param);
    }

    @Override
    public String ParameterMetaData_getParameterTypeName(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        if (this.next != null) {
            return this.next.ParameterMetaData_getParameterTypeName(parameterMetaData, param);
        }
        return parameterMetaData.do_getParameterTypeName(param);
    }

    @Override
    public String ParameterMetaData_getParameterClassName(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        if (this.next != null) {
            return this.next.ParameterMetaData_getParameterClassName(parameterMetaData, param);
        }
        return parameterMetaData.do_getParameterClassName(param);
    }

    @Override
    public int ParameterMetaData_getParameterMode(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        if (this.next != null) {
            return this.next.ParameterMetaData_getParameterMode(parameterMetaData, param);
        }
        return parameterMetaData.do_getParameterMode(param);
    }

    @Override
    public ResultSet PreparedStatement_executeQuery(DmdbPreparedStatement preparedStatement) throws SQLException {
        DmdbResultSet resultSet = preparedStatement.do_executeQuery();
        this.initFeCipher(resultSet.columns, resultSet.connection);
        return resultSet;
    }

    @Override
    public int PreparedStatement_executeUpdate(DmdbPreparedStatement preparedStatement) throws SQLException {
        if (this.next != null) {
            return this.next.PreparedStatement_executeUpdate(preparedStatement);
        }
        return preparedStatement.do_executeUpdate();
    }

    @Override
    public int[] PreparedStatement_executeBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        if (this.next != null) {
            return this.next.PreparedStatement_executeBatch(preparedStatement);
        }
        return preparedStatement.do_executeBatch();
    }

    @Override
    public long[] PreparedStatement_executeLargeBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        if (this.next != null) {
            return this.next.PreparedStatement_executeLargeBatch(preparedStatement);
        }
        return preparedStatement.do_executeLargeBatch();
    }

    private int getIndexMap(LinkedHashMap<Integer, Integer> indexMap, int parameterIndex) {
        Integer index;
        if (indexMap != null && (index = indexMap.get(parameterIndex)) != null) {
            return index;
        }
        return parameterIndex;
    }

    @Override
    public void PreparedStatement_setNull(DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType) throws SQLException {
        parameterIndex = this.getIndexMap(preparedStatement.indexMap, parameterIndex);
        if (this.next != null) {
            this.next.PreparedStatement_setNull(preparedStatement, parameterIndex, sqlType);
        } else {
            preparedStatement.do_setNull(parameterIndex, sqlType);
        }
    }

    private void checkFullEncrypt(DmdbPreparedStatement ps, int index, int targetSqlType, int scaleOrLength, Object obj) throws SQLException {
        Object x2;
        FeSQLParameter feSQLParameter = obj instanceof FeSQLParameter ? (FeSQLParameter)obj : null;
        Object object = x2 = obj instanceof FeSQLParameter ? ((FeSQLParameter)obj).data : obj;
        if (scaleOrLength != -1 && (targetSqlType == 3 || targetSqlType == 2) && DmdbType.canCastToDecimal(x2)) {
            String strValue = "";
            strValue = x2 instanceof Boolean ? ((Boolean)x2 != false ? "1" : "0") : String.valueOf(x2);
            BigDecimal bgd = new BigDecimal(strValue);
            x2 = bgd.setScale(scaleOrLength, 4);
        }
        Parameter parameter = this.cloneParameter(ps, index);
        Object o2 = null;
        byte[] data = null;
        if (x2 instanceof InputStream) {
            o2 = J2DB.fromBinaryStream((InputStream)x2, parameter, ps.connection, scaleOrLength);
        } else if (x2 instanceof Reader) {
            o2 = J2DB.fromReader((Reader)x2, parameter, ps.connection, scaleOrLength);
        } else if (9 == parameter.type) {
            BigDecimal decimal = new BigDecimal(x2.toString());
            int curPrecision = decimal.precision() - decimal.scale();
            int n2 = curPrecision = curPrecision > 0 ? curPrecision : 0;
            if (curPrecision > parameter.prec - parameter.scale || decimal.scale() > parameter.scale) {
                DBError.ECJDBC_STRING_CUT.throwz(new Object[0]);
            }
            o2 = J2DB.fromBigDecimal(decimal, parameter, ps.connection);
        } else {
            if (parameter.type == 18 && !x2.toString().toUpperCase().startsWith("0X") && feSQLParameter != null) {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
            o2 = J2DB.fromObject(x2, parameter, ps.connection);
        }
        data = o2 instanceof byte[] ? (byte[])o2 : ((OffRowData)o2).readAll();
        if (data.length > parameter.prec && parameter.prec > 0) {
            DBError.ECJDBC_STRING_CUT.throwz(new Object[0]);
        }
        this.setFeData(ps, index, data);
    }

    private boolean checkIndexAndFE(int parameterIndex, DmdbPreparedStatement preparedStatement) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > preparedStatement.paramCount) {
            DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
        }
        return preparedStatement.serverParameters[parameterIndex - 1].fullEncryptFlag;
    }

    private boolean checkIndexAndFE(int parameterIndex, DmdbResultSet resultSet) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > resultSet.columns.length) {
            DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
        }
        return resultSet.columns[parameterIndex - 1].fullEncryptFlag;
    }

    private void setFeData(DmdbPreparedStatement ps, int index, byte[] data) throws SQLException {
        byte[] result = null;
        try {
            if (ps.serverParameters[index - 1].type != 18) {
                ps.serverParameters[index - 1].resetType(18);
            }
            result = feckEncryptMap.get(ps.serverParameters[index - 1].feColumn.feckId).doFinal(data);
        }
        catch (Exception e2) {
            DBError.throwRuntimeException(e2.getMessage());
        }
        if (result.length > Short.MAX_VALUE) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        ps.do_setBytes(index, result);
    }

    private Parameter cloneParameter(DmdbPreparedStatement ps, int index) throws SQLException {
        --index;
        if (this.paramsMap == null) {
            this.paramsMap = new HashMap();
        }
        if (this.paramsMap.get(index) == null || this.paramsMap.get((Object)Integer.valueOf((int)index)).type != ps.serverParameters[index].type) {
            Parameter parameter = new Parameter();
            parameter.reset(ps.serverParameters[index]);
            if (ps.serverParameters[index].cursorStmt != null && !ps.serverParameters[index].cursorStmt.closed && ps.connection != null && ps != null) {
                parameter.cursorStmt = ps.connection.createCursorStatement(ps.resultSetType, ps.resultSetConcurrency, ps.resultSetHoldability);
            }
            parameter.resetType(ps.serverParameters[index].feColumn.dtype);
            parameter.prec = ps.serverParameters[index].feColumn.length;
            parameter.scale = ps.serverParameters[index].feColumn.prec;
            this.paramsMap.put(index, parameter);
            return parameter;
        }
        return this.paramsMap.get(index);
    }

    private byte[] getOriginalFeData(int index, DmdbResultSet resultSet) throws SQLException {
        byte[] data = resultSet.getColumnData(index);
        if (data == null || data.length == 0) {
            return null;
        }
        Cipher cipher = feckDecryptMap.get(resultSet.columns[index - 1].feColumn.feckId);
        try {
            return cipher.doFinal(data);
        }
        catch (Exception exception) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
            return null;
        }
    }

    private Column getColumn(DmdbResultSet resultSet, int index) throws SQLException {
        Column column = resultSet.columns[--index];
        return column;
    }

    @Override
    public void PreparedStatement_setBoolean(DmdbPreparedStatement preparedStatement, int parameterIndex, boolean x2) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, (Object)x2, Integer.MIN_VALUE, -1);
    }

    @Override
    public void PreparedStatement_setByte(DmdbPreparedStatement preparedStatement, int parameterIndex, byte x2) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, (Object)x2, Integer.MIN_VALUE, -1);
    }

    @Override
    public void PreparedStatement_setShort(DmdbPreparedStatement preparedStatement, int parameterIndex, short x2) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, (Object)x2, Integer.MIN_VALUE, -1);
    }

    @Override
    public void PreparedStatement_setInt(DmdbPreparedStatement preparedStatement, int parameterIndex, int x2) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, (Object)x2, Integer.MIN_VALUE, -1);
    }

    @Override
    public void PreparedStatement_setLong(DmdbPreparedStatement preparedStatement, int parameterIndex, long x2) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, (Object)x2, Integer.MIN_VALUE, -1);
    }

    @Override
    public void PreparedStatement_setFloat(DmdbPreparedStatement preparedStatement, int parameterIndex, float x2) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, (Object)Float.valueOf(x2), Integer.MIN_VALUE, -1);
    }

    @Override
    public void PreparedStatement_setDouble(DmdbPreparedStatement preparedStatement, int parameterIndex, double x2) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, (Object)x2, Integer.MIN_VALUE, -1);
    }

    @Override
    public void PreparedStatement_setBigDecimal(DmdbPreparedStatement preparedStatement, int parameterIndex, BigDecimal x2) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, (Object)x2, Integer.MIN_VALUE, -1);
    }

    @Override
    public void PreparedStatement_setString(DmdbPreparedStatement preparedStatement, int parameterIndex, String x2) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, (Object)x2, Integer.MIN_VALUE, -1);
    }

    @Override
    public void PreparedStatement_setBytes(DmdbPreparedStatement preparedStatement, int parameterIndex, byte[] x2) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, (Object)x2, Integer.MIN_VALUE, -1);
    }

    @Override
    public void PreparedStatement_setDate(DmdbPreparedStatement preparedStatement, int parameterIndex, java.sql.Date x2) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, (Object)x2, Integer.MIN_VALUE, -1);
    }

    @Override
    public void PreparedStatement_setTime(DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, (Object)x2, Integer.MIN_VALUE, -1);
    }

    @Override
    public void PreparedStatement_setTimestamp(DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, (Object)x2, Integer.MIN_VALUE, -1);
    }

    @Override
    public void PreparedStatement_setAsciiStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        int index = this.getIndexMap(preparedStatement.indexMap, parameterIndex);
        if (this.checkIndexAndFE(index, preparedStatement)) {
            Parameter parameter = this.cloneParameter(preparedStatement, index);
            Object data = J2DB.fromAsciiStream(x2, parameter, preparedStatement.connection, length);
            this.PreparedStatement_setObject(preparedStatement, parameterIndex, data);
            return;
        }
        preparedStatement.do_setAsciiStream(index, x2, length);
    }

    @Override
    public void PreparedStatement_setUnicodeStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        int index = this.getIndexMap(preparedStatement.indexMap, parameterIndex);
        if (this.checkIndexAndFE(index, preparedStatement)) {
            Parameter parameter = this.cloneParameter(preparedStatement, index);
            Object data = J2DB.fromUnicodeStream(x2, parameter, preparedStatement.connection, length);
            this.PreparedStatement_setObject(preparedStatement, parameterIndex, data);
            return;
        }
        preparedStatement.do_setUnicodeStream(index, x2, length);
    }

    @Override
    public void PreparedStatement_setBinaryStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        int index = this.getIndexMap(preparedStatement.indexMap, parameterIndex);
        if (this.checkIndexAndFE(index, preparedStatement)) {
            Parameter parameter = this.cloneParameter(preparedStatement, index);
            Object data = J2DB.fromBinaryStream(x2, parameter, preparedStatement.connection, length);
            this.PreparedStatement_setObject(preparedStatement, parameterIndex, data);
            return;
        }
        preparedStatement.do_setBinaryStream(index, x2, length);
    }

    @Override
    public void PreparedStatement_clearParameters(DmdbPreparedStatement preparedStatement) throws SQLException {
        if (this.next != null) {
            this.next.PreparedStatement_clearParameters(preparedStatement);
        } else {
            preparedStatement.do_clearParameters();
        }
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType, -1);
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, Integer.MIN_VALUE, -1);
    }

    private void fillFeConstParams(DmdbPreparedStatement ps) throws SQLException {
        if (this.feParamsList != null && this.feParamsList.size() > 0) {
            for (FeSQLParameter parameter : this.feParamsList) {
                if (ps.serverParameters[parameter.index - 1].fullEncryptFlag) {
                    if (ps.curRowDatas[parameter.index - 1] != null || parameter.data == null) continue;
                    this.checkFullEncrypt(ps, parameter.index, parameter.type, -1, parameter.data);
                    continue;
                }
                if (ps.curRowDatas[parameter.index - 1] != null || parameter.data == null) continue;
                ps.do_setObject(parameter.index, parameter.data);
            }
        }
    }

    @Override
    public boolean PreparedStatement_execute(DmdbPreparedStatement preparedStatement) throws SQLException {
        this.fillFeConstParams(preparedStatement);
        if (this.next != null) {
            return this.next.PreparedStatement_execute(preparedStatement);
        }
        return preparedStatement.do_execute();
    }

    @Override
    public void PreparedStatement_addBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        this.fillFeConstParams(preparedStatement);
        if (this.next != null) {
            this.next.PreparedStatement_addBatch(preparedStatement);
        } else {
            preparedStatement.do_addBatch();
        }
    }

    @Override
    public void PreparedStatement_setCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, int length) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, (Object)reader, Integer.MIN_VALUE, -1);
    }

    @Override
    public void PreparedStatement_setRef(DmdbPreparedStatement preparedStatement, int parameterIndex, Ref x2) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, (Object)x2, Integer.MIN_VALUE, -1);
    }

    @Override
    public void PreparedStatement_setBlob(DmdbPreparedStatement preparedStatement, int parameterIndex, Blob x2) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, (Object)x2, Integer.MIN_VALUE, -1);
    }

    @Override
    public void PreparedStatement_setClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Clob x2) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, (Object)x2, Integer.MIN_VALUE, -1);
    }

    @Override
    public void PreparedStatement_setArray(DmdbPreparedStatement preparedStatement, int parameterIndex, Array x2) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, (Object)x2, Integer.MIN_VALUE, -1);
    }

    @Override
    public ResultSetMetaData PreparedStatement_getMetaData(DmdbPreparedStatement preparedStatement) throws SQLException {
        if (this.next != null) {
            return this.next.PreparedStatement_getMetaData(preparedStatement);
        }
        return preparedStatement.do_getMetaData();
    }

    @Override
    public void PreparedStatement_setDate(DmdbPreparedStatement preparedStatement, int parameterIndex, java.sql.Date x2, Calendar cal) throws SQLException {
        int index = this.getIndexMap(preparedStatement.indexMap, parameterIndex);
        if (this.checkIndexAndFE(index, preparedStatement)) {
            Parameter parameter = this.cloneParameter(preparedStatement, index);
            byte[] bytes = J2DB.fromDate(x2, parameter, preparedStatement.connection, cal);
            this.setFeData(preparedStatement, index, bytes);
            return;
        }
        preparedStatement.do_setDate(parameterIndex, x2, cal);
    }

    @Override
    public void PreparedStatement_setTime(DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2, Calendar cal) throws SQLException {
        int index = this.getIndexMap(preparedStatement.indexMap, parameterIndex);
        if (this.checkIndexAndFE(index, preparedStatement)) {
            Parameter parameter = this.cloneParameter(preparedStatement, index);
            byte[] bytes = J2DB.fromDate(x2, parameter, preparedStatement.connection, cal);
            this.setFeData(preparedStatement, index, bytes);
            return;
        }
        preparedStatement.do_setTime(index, x2, cal);
    }

    @Override
    public void PreparedStatement_setTimestamp(DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        int index = this.getIndexMap(preparedStatement.indexMap, parameterIndex);
        if (this.checkIndexAndFE(index, preparedStatement)) {
            Parameter parameter = this.cloneParameter(preparedStatement, index);
            byte[] bytes = J2DB.fromDate(x2, parameter, preparedStatement.connection, cal);
            this.setFeData(preparedStatement, index, bytes);
            return;
        }
        preparedStatement.do_setTimestamp(index, x2, cal);
    }

    @Override
    public void PreparedStatement_setNull(DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, null, sqlType);
    }

    @Override
    public void PreparedStatement_setURL(DmdbPreparedStatement preparedStatement, int parameterIndex, URL x2) throws SQLException {
        int index = this.getIndexMap(preparedStatement.indexMap, parameterIndex);
        if (this.checkIndexAndFE(index, preparedStatement)) {
            this.PreparedStatement_setObject(preparedStatement, parameterIndex, x2.toString());
        }
        preparedStatement.do_setURL(index, x2);
    }

    @Override
    public ParameterMetaData PreparedStatement_getParameterMetaData(DmdbPreparedStatement preparedStatement) throws SQLException {
        Parameter[] parameters = preparedStatement.serverParameters;
        if (preparedStatement.indexMap != null) {
            Parameter[] feSQLParams = new Parameter[preparedStatement.indexMap.size()];
            int index = 0;
            for (Map.Entry entry : preparedStatement.indexMap.entrySet()) {
                feSQLParams[index++] = parameters[(Integer)entry.getValue() - 1];
            }
            return new DmdbParameterMetaData(preparedStatement.connection, feSQLParams);
        }
        return new DmdbParameterMetaData(preparedStatement.connection, preparedStatement.serverParameters);
    }

    @Override
    public void PreparedStatement_setRowId(DmdbPreparedStatement preparedStatement, int parameterIndex, RowId x2) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setNString(DmdbPreparedStatement preparedStatement, int parameterIndex, String value) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, value);
    }

    @Override
    public void PreparedStatement_setNCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value, long length) throws SQLException {
        this.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, value, length);
    }

    @Override
    public void PreparedStatement_setNClob(DmdbPreparedStatement preparedStatement, int parameterIndex, NClob value) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, value);
    }

    @Override
    public void PreparedStatement_setClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        this.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setBlob(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, inputStream, length);
    }

    @Override
    public void PreparedStatement_setNClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        this.PreparedStatement_setClob(preparedStatement, parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setSQLXML(DmdbPreparedStatement preparedStatement, int parameterIndex, SQLXML xmlObject) throws SQLException {
        int index = this.getIndexMap(preparedStatement.indexMap, parameterIndex);
        if (this.checkIndexAndFE(index, preparedStatement)) {
            if (xmlObject == null) {
                this.PreparedStatement_setNull(preparedStatement, parameterIndex, 2009);
            }
            this.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, ((DmdbSQLXML)xmlObject).serializeAsCharacterStream());
            return;
        }
        preparedStatement.do_setSQLXML(index, xmlObject);
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType, int scaleOrLength) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > preparedStatement.paramCount) {
            DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
        }
        parameterIndex = this.getIndexMap(preparedStatement.indexMap, parameterIndex);
        if (preparedStatement.serverParameters[parameterIndex - 1].fullEncryptFlag) {
            this.checkFullEncrypt(preparedStatement, parameterIndex, -1, scaleOrLength, x2);
            return;
        }
        preparedStatement.do_setObject(parameterIndex, x2, targetSqlType, scaleOrLength);
    }

    @Override
    public void PreparedStatement_setAsciiStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        int index = this.getIndexMap(preparedStatement.indexMap, parameterIndex);
        if (this.checkIndexAndFE(index, preparedStatement)) {
            Parameter parameter = this.cloneParameter(preparedStatement, index);
            Object data = J2DB.fromAsciiStream(x2, parameter, preparedStatement.connection, length);
            this.PreparedStatement_setObject(preparedStatement, parameterIndex, data);
            return;
        }
        preparedStatement.do_setBinaryStream(index, x2, length);
    }

    @Override
    public void PreparedStatement_setBinaryStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        int index = this.getIndexMap(preparedStatement.indexMap, parameterIndex);
        if (this.checkIndexAndFE(index, preparedStatement)) {
            Parameter parameter = this.cloneParameter(preparedStatement, index);
            Object data = J2DB.fromBinaryStream(x2, parameter, preparedStatement.connection, length);
            this.PreparedStatement_setObject(preparedStatement, parameterIndex, data);
            return;
        }
        preparedStatement.do_setBinaryStream(index, x2, length);
    }

    @Override
    public void PreparedStatement_setCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        int index = this.getIndexMap(preparedStatement.indexMap, parameterIndex);
        if (this.checkIndexAndFE(index, preparedStatement)) {
            Parameter parameter = this.cloneParameter(preparedStatement, index);
            Object data = J2DB.fromReader(reader, parameter, preparedStatement.connection, length);
            this.PreparedStatement_setObject(preparedStatement, parameterIndex, data);
            return;
        }
        preparedStatement.do_setCharacterStream(index, reader, length);
    }

    @Override
    public void PreparedStatement_setAsciiStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        this.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2, -1);
    }

    @Override
    public void PreparedStatement_setBinaryStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        this.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2, -1);
    }

    @Override
    public void PreparedStatement_setCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        this.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader, -1);
    }

    @Override
    public void PreparedStatement_setNCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value) throws SQLException {
        this.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, value);
    }

    @Override
    public void PreparedStatement_setClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        this.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader);
    }

    @Override
    public void PreparedStatement_setBlob(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream) throws SQLException {
        this.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, inputStream);
    }

    @Override
    public void PreparedStatement_setNClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        this.PreparedStatement_setClob(preparedStatement, parameterIndex, reader);
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType.getVendorTypeNumber(), scaleOrLength);
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, SQLType targetSqlType) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType.getVendorTypeNumber());
    }

    @Override
    public long PreparedStatement_executeLargeUpdate(DmdbPreparedStatement preparedStatement) throws SQLException {
        this.fillFeConstParams(preparedStatement);
        if (this.next != null) {
            return this.next.PreparedStatement_executeLargeUpdate(preparedStatement);
        }
        return preparedStatement.do_executeLargeUpdate();
    }

    @Override
    public void PreparedStatement_preCompile(DmdbPreparedStatement preparedStatement, String sql) throws SQLException {
        this.feParamsList = new ArrayList<FeSQLParameter>();
        preparedStatement.indexMap = new LinkedHashMap();
        try {
            sql = SQLProcessor.execOptFe(sql, this.feParamsList, preparedStatement.connection.getServerEncoding(), preparedStatement.indexMap);
        }
        catch (Exception exception) {
            DBError.EC_PARSE_ERROR.throwz(new Object[0]);
        }
        if (this.next != null) {
            this.next.PreparedStatement_preCompile(preparedStatement, sql);
        } else {
            preparedStatement.do_preCompile(sql);
        }
    }

    @Override
    public void PreparedStatement_setTIMESTAMP(DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbTimestamp x2) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setINTERVALYM(DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbIntervalYM x2) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setINTERVALDT(DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbIntervalDT x2) throws SQLException {
        this.PreparedStatement_setObject(preparedStatement, parameterIndex, x2);
    }

    @Override
    public boolean ResultSet_next(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_next(resultSet);
        }
        return resultSet.do_next();
    }

    @Override
    public void ResultSet_close(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            this.next.ResultSet_close(resultSet);
        } else {
            resultSet.do_close();
        }
    }

    @Override
    public boolean ResultSet_wasNull(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_wasNull(resultSet);
        }
        return resultSet.do_wasNull();
    }

    private void initFeCipher(Column[] columns, DmdbConnection conn) throws SQLException {
        if (columns == null || columns.length == 0) {
            return;
        }
        String parameters = "";
        LinkedHashSet<Integer> feckIdSet = new LinkedHashSet<Integer>();
        int i2 = 0;
        while (i2 < columns.length) {
            Column column = columns[i2];
            if (column.fullEncryptFlag && feckDecryptMap.get(column.feColumn.feckId) == null) {
                feckIdSet.add(column.feColumn.feckId);
            }
            ++i2;
        }
        if (feckIdSet.size() == 0) {
            return;
        }
        Object[] feckIdArray = feckIdSet.toArray();
        int i3 = 0;
        while (i3 < feckIdArray.length) {
            parameters = String.valueOf(parameters) + feckIdArray[i3];
            if (i3 != feckIdArray.length - 1) {
                parameters = String.valueOf(parameters) + ",";
            }
            ++i3;
        }
        try {
            String sql = String.format(feSQL, parameters);
            DmdbResultSet rs = DriverUtil.executeQuery(conn, sql);
            while (rs.do_next()) {
                Cipher mkCipher;
                String encryptedCk = new String(rs.do_getBytes(1));
                byte[] ckBytes = StringUtil.hexStringToBytes(encryptedCk);
                String mkName = rs.do_getString(2);
                int feckId = rs.do_getInt(3);
                int cipher_id = rs.do_getInt(4);
                if (cipher_id != 2050) {
                    DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
                }
                if ((mkCipher = femkPriCipherMap.get(mkName)) == null) {
                    mkCipher = this.getRSACipherFromPem(mkName);
                    femkPriCipherMap.put(mkName, mkCipher);
                }
                byte[] feck = mkCipher.doFinal(ckBytes);
                FullEncryptFilter.initAesCBC256Cipher(feckId, feck);
            }
            rs.do_close();
        }
        catch (Exception e2) {
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            DBError.ECJDBC_INVALID_CIPHER.throwz(new Object[0]);
        }
    }

    public static void initAesCBC256Cipher(int feckId, byte[] key) throws Exception {
        SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
        Cipher decryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        if (Cipher.getMaxAllowedKeyLength("AES") < 256) {
            DBError.ECJDBC_INVALID_CIPHER_KEY_SIZE.throwz(new Object[0]);
        }
        decryptCipher.init(2, (Key)keySpec, ivSpec);
        feckDecryptMap.put(feckId, decryptCipher);
        Cipher encryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        encryptCipher.init(1, (Key)keySpec, ivSpec);
        feckEncryptMap.put(feckId, encryptCipher);
    }

    private Cipher getRSACipherFromPem(String fileName) throws Exception {
        if (FILE_FORMAT == null) {
            FILE_FORMAT = FILE_FORMAT_LINUX;
            if ("windows".equalsIgnoreCase(System.getProperty("os.name"))) {
                FILE_FORMAT = FILE_FORMAT_WINDOWS;
            }
        }
        fileName = String.format(FILE_FORMAT, this.prefixFile, fileName);
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        br.readLine();
        String str = "";
        String s2 = br.readLine();
        while (s2.charAt(0) != '-') {
            str = String.valueOf(str) + s2 + "\r";
            s2 = br.readLine();
        }
        Base64Decoder base64Decoder = new Base64Decoder();
        byte[] bytes = base64Decoder.decodeBuffer(str);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        PrivateKey rsaPriKey = kf.generatePrivate(keySpec);
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPPadding");
        cipher.init(2, rsaPriKey);
        br.close();
        return cipher;
    }

    @Override
    public String ResultSet_getString(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toString(data, parameter, resultSet.connection);
        }
        return resultSet.do_getString(columnIndex);
    }

    @Override
    public boolean ResultSet_getBoolean(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toBoolean(data, parameter, resultSet.connection);
        }
        return resultSet.do_getBoolean(columnIndex);
    }

    @Override
    public byte ResultSet_getByte(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toByte(data, parameter, resultSet.connection);
        }
        return resultSet.do_getByte(columnIndex);
    }

    @Override
    public short ResultSet_getShort(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toShort(data, parameter, resultSet.connection);
        }
        return resultSet.do_getShort(columnIndex);
    }

    @Override
    public int ResultSet_getInt(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toInt(data, parameter, resultSet.connection);
        }
        return resultSet.do_getInt(columnIndex);
    }

    @Override
    public long ResultSet_getLong(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toLong(data, parameter, resultSet.connection);
        }
        return resultSet.do_getLong(columnIndex);
    }

    @Override
    public float ResultSet_getFloat(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toFloat(data, parameter, resultSet.connection);
        }
        return resultSet.do_getFloat(columnIndex);
    }

    @Override
    public double ResultSet_getDouble(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toDouble(data, parameter, resultSet.connection);
        }
        return resultSet.do_getDouble(columnIndex);
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(DmdbResultSet resultSet, int columnIndex, int scale) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toBigDecimal(data, parameter, resultSet.connection);
        }
        return resultSet.do_getBigDecimal(columnIndex, scale);
    }

    @Override
    public byte[] ResultSet_getBytes(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toBytes(data, parameter, resultSet.connection);
        }
        return resultSet.do_getBytes(columnIndex);
    }

    @Override
    public java.sql.Date ResultSet_getDate(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toDate(data, parameter, resultSet.connection, null);
        }
        return resultSet.do_getDate(columnIndex);
    }

    @Override
    public Time ResultSet_getTime(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toTime(data, parameter, resultSet.connection, null);
        }
        return resultSet.do_getTime(columnIndex);
    }

    @Override
    public Timestamp ResultSet_getTimestamp(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toTimestamp(data, parameter, resultSet.connection, null);
        }
        return resultSet.do_getTimestamp(columnIndex);
    }

    @Override
    public InputStream ResultSet_getAsciiStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toAsciiStream(data, parameter, resultSet.connection);
        }
        return resultSet.do_getAsciiStream(columnIndex);
    }

    @Override
    public InputStream ResultSet_getUnicodeStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toUnicodeStream(data, parameter, resultSet.connection);
        }
        return resultSet.do_getUnicodeStream(columnIndex);
    }

    @Override
    public InputStream ResultSet_getBinaryStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toBinaryStream(data, parameter, resultSet.connection);
        }
        return resultSet.do_getBinaryStream(columnIndex);
    }

    @Override
    public String ResultSet_getString(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getString(resultSet, index);
    }

    @Override
    public boolean ResultSet_getBoolean(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getBoolean(resultSet, index);
    }

    @Override
    public byte ResultSet_getByte(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getByte(resultSet, index);
    }

    @Override
    public short ResultSet_getShort(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getShort(resultSet, index);
    }

    @Override
    public int ResultSet_getInt(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getInt(resultSet, index);
    }

    @Override
    public long ResultSet_getLong(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getLong(resultSet, index);
    }

    @Override
    public float ResultSet_getFloat(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getFloat(resultSet, index);
    }

    @Override
    public double ResultSet_getDouble(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getDouble(resultSet, index);
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(DmdbResultSet resultSet, String columnLabel, int scale) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getBigDecimal(resultSet, index);
    }

    @Override
    public byte[] ResultSet_getBytes(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getBytes(resultSet, index);
    }

    @Override
    public java.sql.Date ResultSet_getDate(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getDate(resultSet, index);
    }

    @Override
    public Time ResultSet_getTime(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getTime(resultSet, index);
    }

    @Override
    public Timestamp ResultSet_getTimestamp(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getTimestamp(resultSet, index);
    }

    @Override
    public InputStream ResultSet_getAsciiStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getAsciiStream(resultSet, index);
    }

    @Override
    public InputStream ResultSet_getUnicodeStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getUnicodeStream(resultSet, index);
    }

    @Override
    public InputStream ResultSet_getBinaryStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getBinaryStream(resultSet, index);
    }

    @Override
    public SQLWarning ResultSet_getWarnings(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_getWarnings(resultSet);
        }
        return resultSet.do_getWarnings();
    }

    @Override
    public void ResultSet_clearWarnings(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            this.next.ResultSet_clearWarnings(resultSet);
        } else {
            resultSet.do_clearWarnings();
        }
    }

    @Override
    public String ResultSet_getCursorName(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_getCursorName(resultSet);
        }
        return resultSet.do_getCursorName();
    }

    @Override
    public ResultSetMetaData ResultSet_getMetaData(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_getMetaData(resultSet);
        }
        return resultSet.do_getMetaData();
    }

    @Override
    public Object ResultSet_getObject(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toObject(data, parameter, resultSet.connection, resultSet.connection.do_getTypeMap());
        }
        return resultSet.do_getObject(columnIndex);
    }

    @Override
    public Object ResultSet_getObject(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getObject(resultSet, index);
    }

    @Override
    public int ResultSet_findColumn(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_findColumn(resultSet, columnLabel);
        }
        return resultSet.do_findColumn(columnLabel);
    }

    @Override
    public Reader ResultSet_getCharacterStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toCharacterStream(data, parameter, resultSet.connection);
        }
        return resultSet.do_getCharacterStream(columnIndex);
    }

    @Override
    public Reader ResultSet_getCharacterStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getCharacterStream(resultSet, index);
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toBigDecimal(data, parameter, resultSet.connection);
        }
        return resultSet.do_getBigDecimal(columnIndex);
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getBigDecimal(resultSet, index);
    }

    @Override
    public boolean ResultSet_isBeforeFirst(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_isBeforeFirst(resultSet);
        }
        return resultSet.do_isBeforeFirst();
    }

    @Override
    public boolean ResultSet_isAfterLast(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_isAfterLast(resultSet);
        }
        return resultSet.do_isAfterLast();
    }

    @Override
    public boolean ResultSet_isFirst(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_isFirst(resultSet);
        }
        return resultSet.do_isFirst();
    }

    @Override
    public boolean ResultSet_isLast(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_isLast(resultSet);
        }
        return resultSet.do_isLast();
    }

    @Override
    public void ResultSet_beforeFirst(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            this.next.ResultSet_beforeFirst(resultSet);
        } else {
            resultSet.do_beforeFirst();
        }
    }

    @Override
    public void ResultSet_afterLast(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            this.next.ResultSet_afterLast(resultSet);
        } else {
            resultSet.do_afterLast();
        }
    }

    @Override
    public boolean ResultSet_first(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_first(resultSet);
        }
        return resultSet.do_first();
    }

    @Override
    public boolean ResultSet_last(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_last(resultSet);
        }
        return resultSet.do_last();
    }

    @Override
    public int ResultSet_getRow(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_getRow(resultSet);
        }
        return resultSet.do_getRow();
    }

    @Override
    public boolean ResultSet_absolute(DmdbResultSet resultSet, int row) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_absolute(resultSet, row);
        }
        return resultSet.do_absolute(row);
    }

    @Override
    public boolean ResultSet_relative(DmdbResultSet resultSet, int rows) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_relative(resultSet, rows);
        }
        return resultSet.do_relative(rows);
    }

    @Override
    public boolean ResultSet_previous(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_previous(resultSet);
        }
        return resultSet.do_previous();
    }

    @Override
    public void ResultSet_setFetchDirection(DmdbResultSet resultSet, int direction) throws SQLException {
        if (this.next != null) {
            this.next.ResultSet_setFetchDirection(resultSet, direction);
        } else {
            resultSet.do_setFetchDirection(direction);
        }
    }

    @Override
    public int ResultSet_getFetchDirection(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_getFetchDirection(resultSet);
        }
        return resultSet.do_getFetchDirection();
    }

    @Override
    public void ResultSet_setFetchSize(DmdbResultSet resultSet, int rows) throws SQLException {
        if (this.next != null) {
            this.next.ResultSet_setFetchSize(resultSet, rows);
        } else {
            resultSet.do_setFetchSize(rows);
        }
    }

    @Override
    public int ResultSet_getFetchSize(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_getFetchSize(resultSet);
        }
        return resultSet.do_getFetchSize();
    }

    @Override
    public int ResultSet_getType(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_getType(resultSet);
        }
        return resultSet.do_getType();
    }

    @Override
    public int ResultSet_getConcurrency(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_getConcurrency(resultSet);
        }
        return resultSet.do_getConcurrency();
    }

    @Override
    public boolean ResultSet_rowUpdated(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_rowUpdated(resultSet);
        }
        return resultSet.do_rowUpdated();
    }

    @Override
    public boolean ResultSet_rowInserted(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_rowInserted(resultSet);
        }
        return resultSet.do_rowInserted();
    }

    @Override
    public boolean ResultSet_rowDeleted(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_rowDeleted(resultSet);
        }
        return resultSet.do_rowDeleted();
    }

    @Override
    public void ResultSet_updateNull(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.next != null) {
            this.next.ResultSet_updateNull(resultSet, columnIndex);
        } else {
            resultSet.do_updateNull(columnIndex);
        }
    }

    @Override
    public void ResultSet_updateBoolean(DmdbResultSet resultSet, int columnIndex, boolean x2) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            byte[] data = J2DB.fromBoolean(x2, parameter, resultSet.connection);
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateBoolean(columnIndex, x2);
        }
    }

    @Override
    public void ResultSet_updateByte(DmdbResultSet resultSet, int columnIndex, byte x2) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            byte[] data = J2DB.fromLong(x2, parameter, resultSet.connection);
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateByte(columnIndex, x2);
        }
    }

    @Override
    public void ResultSet_updateShort(DmdbResultSet resultSet, int columnIndex, short x2) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            byte[] data = J2DB.fromLong(x2, parameter, resultSet.connection);
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateShort(columnIndex, x2);
        }
    }

    @Override
    public void ResultSet_updateInt(DmdbResultSet resultSet, int columnIndex, int x2) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            byte[] data = J2DB.fromLong(x2, parameter, resultSet.connection);
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateInt(columnIndex, x2);
        }
    }

    @Override
    public void ResultSet_updateLong(DmdbResultSet resultSet, int columnIndex, long x2) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            byte[] data = J2DB.fromLong(x2, parameter, resultSet.connection);
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateLong(columnIndex, x2);
        }
    }

    @Override
    public void ResultSet_updateFloat(DmdbResultSet resultSet, int columnIndex, float x2) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            byte[] data = J2DB.fromFloat(x2, parameter, resultSet.connection);
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateFloat(columnIndex, x2);
        }
    }

    @Override
    public void ResultSet_updateDouble(DmdbResultSet resultSet, int columnIndex, double x2) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            byte[] data = J2DB.fromDouble(x2, parameter, resultSet.connection);
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateDouble(columnIndex, x2);
        }
    }

    @Override
    public void ResultSet_updateBigDecimal(DmdbResultSet resultSet, int columnIndex, BigDecimal x2) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            byte[] data = J2DB.fromBigDecimal(x2, parameter, resultSet.connection);
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateBigDecimal(columnIndex, x2);
        }
    }

    @Override
    public void ResultSet_updateString(DmdbResultSet resultSet, int columnIndex, String x2) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            byte[] data = J2DB.fromObject(x2, parameter, resultSet.connection);
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateString(columnIndex, x2);
        }
    }

    @Override
    public void ResultSet_updateBytes(DmdbResultSet resultSet, int columnIndex, byte[] x2) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = null;
            Cipher cipher = feckEncryptMap.get(resultSet.columns[columnIndex - 1].feColumn.feckId);
            try {
                data = cipher.doFinal(x2);
            }
            catch (Exception e2) {
                throw new SQLException(e2);
            }
            resultSet.do_updateBytes(columnIndex, data);
        } else {
            resultSet.do_updateBytes(columnIndex, x2);
        }
    }

    @Override
    public void ResultSet_updateDate(DmdbResultSet resultSet, int columnIndex, java.sql.Date x2) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            byte[] data = J2DB.fromDate(x2, parameter, resultSet.connection, null);
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateDate(columnIndex, x2);
        }
    }

    @Override
    public void ResultSet_updateTime(DmdbResultSet resultSet, int columnIndex, Time x2) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            byte[] data = J2DB.fromDate(x2, parameter, resultSet.connection, null);
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateTime(columnIndex, x2);
        }
    }

    @Override
    public void ResultSet_updateTimestamp(DmdbResultSet resultSet, int columnIndex, Timestamp x2) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            byte[] data = J2DB.fromDate(x2, parameter, resultSet.connection, null);
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateTimestamp(columnIndex, x2);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, int columnIndex, InputStream x2, int length) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            Object o2 = J2DB.fromAsciiStream(x2, parameter, resultSet.connection, length);
            if (o2 instanceof byte[]) {
                this.ResultSet_updateBytes(resultSet, columnIndex, (byte[])o2);
            } else {
                this.ResultSet_updateBytes(resultSet, columnIndex, ((OffRowData)o2).readAll());
            }
        } else {
            resultSet.do_updateAsciiStream(columnIndex, x2, length);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, int columnIndex, InputStream x2, int length) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            Object o2 = J2DB.fromBinaryStream(x2, parameter, resultSet.connection, length);
            if (o2 instanceof byte[]) {
                this.ResultSet_updateBytes(resultSet, columnIndex, (byte[])o2);
            } else {
                this.ResultSet_updateBytes(resultSet, columnIndex, ((OffRowData)o2).readAll());
            }
        } else {
            resultSet.do_updateBinaryStream(columnIndex, x2, length);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x2, int length) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            Object o2 = J2DB.fromReader(x2, parameter, resultSet.connection, length);
            if (o2 instanceof byte[]) {
                this.ResultSet_updateBytes(resultSet, columnIndex, (byte[])o2);
            } else {
                this.ResultSet_updateBytes(resultSet, columnIndex, ((OffRowData)o2).readAll());
            }
        } else {
            resultSet.do_updateCharacterStream(columnIndex, x2, length);
        }
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, int columnIndex, Object x2, int scaleOrLength) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Parameter parameter = new Parameter();
            parameter.resetType(1111);
            resultSet.currentRow[columnIndex - 1].scaleOrLength = scaleOrLength;
            byte[] data = J2DB.fromObject(x2, parameter, resultSet.connection);
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateObject(columnIndex, x2, scaleOrLength);
        }
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, int columnIndex, Object x2) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            byte[] data = J2DB.fromObject(x2, parameter, resultSet.connection);
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateObject(columnIndex, x2);
        }
    }

    @Override
    public void ResultSet_updateNull(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateNull(resultSet, index);
    }

    @Override
    public void ResultSet_updateBoolean(DmdbResultSet resultSet, String columnLabel, boolean x2) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateBoolean(resultSet, index, x2);
    }

    @Override
    public void ResultSet_updateByte(DmdbResultSet resultSet, String columnLabel, byte x2) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateByte(resultSet, index, x2);
    }

    @Override
    public void ResultSet_updateShort(DmdbResultSet resultSet, String columnLabel, short x2) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateShort(resultSet, index, x2);
    }

    @Override
    public void ResultSet_updateInt(DmdbResultSet resultSet, String columnLabel, int x2) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateInt(resultSet, index, x2);
    }

    @Override
    public void ResultSet_updateLong(DmdbResultSet resultSet, String columnLabel, long x2) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateLong(resultSet, index, x2);
    }

    @Override
    public void ResultSet_updateFloat(DmdbResultSet resultSet, String columnLabel, float x2) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateFloat(resultSet, index, x2);
    }

    @Override
    public void ResultSet_updateDouble(DmdbResultSet resultSet, String columnLabel, double x2) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateDouble(resultSet, index, x2);
    }

    @Override
    public void ResultSet_updateBigDecimal(DmdbResultSet resultSet, String columnLabel, BigDecimal x2) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateBigDecimal(resultSet, index, x2);
    }

    @Override
    public void ResultSet_updateString(DmdbResultSet resultSet, String columnLabel, String x2) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateString(resultSet, index, x2);
    }

    @Override
    public void ResultSet_updateBytes(DmdbResultSet resultSet, String columnLabel, byte[] x2) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateBytes(resultSet, index, x2);
    }

    @Override
    public void ResultSet_updateDate(DmdbResultSet resultSet, String columnLabel, java.sql.Date x2) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateDate(resultSet, index, x2);
    }

    @Override
    public void ResultSet_updateTime(DmdbResultSet resultSet, String columnLabel, Time x2) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateTime(resultSet, index, x2);
    }

    @Override
    public void ResultSet_updateTimestamp(DmdbResultSet resultSet, String columnLabel, Timestamp x2) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateTimestamp(resultSet, index, x2);
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, String columnLabel, InputStream x2, int length) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateAsciiStream(resultSet, index, x2, length);
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, String columnLabel, InputStream x2, int length) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateBinaryStream(resultSet, index, x2, length);
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader, int length) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateCharacterStream(resultSet, index, reader, length);
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, String columnLabel, Object x2, int scaleOrLength) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateObject(resultSet, index, x2, scaleOrLength);
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, String columnLabel, Object x2) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateObject(resultSet, index, x2);
    }

    @Override
    public void ResultSet_insertRow(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            this.next.ResultSet_insertRow(resultSet);
        } else {
            resultSet.do_insertRow();
        }
    }

    @Override
    public void ResultSet_updateRow(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            this.next.ResultSet_updateRow(resultSet);
        } else {
            resultSet.do_updateRow();
        }
    }

    @Override
    public void ResultSet_deleteRow(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            this.next.ResultSet_deleteRow(resultSet);
        } else {
            resultSet.do_deleteRow();
        }
    }

    @Override
    public void ResultSet_refreshRow(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            this.next.ResultSet_refreshRow(resultSet);
        } else {
            resultSet.do_refreshRow();
        }
    }

    @Override
    public void ResultSet_cancelRowUpdates(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            this.next.ResultSet_cancelRowUpdates(resultSet);
        } else {
            resultSet.do_cancelRowUpdates();
        }
    }

    @Override
    public void ResultSet_moveToInsertRow(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            this.next.ResultSet_moveToInsertRow(resultSet);
        } else {
            resultSet.do_moveToInsertRow();
        }
    }

    @Override
    public void ResultSet_moveToCurrentRow(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            this.next.ResultSet_moveToCurrentRow(resultSet);
        } else {
            resultSet.do_moveToCurrentRow();
        }
    }

    @Override
    public Statement ResultSet_getStatement(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_getStatement(resultSet);
        }
        return resultSet.do_getStatement();
    }

    @Override
    public Object ResultSet_getObject(DmdbResultSet resultSet, int columnIndex, Map<String, Class<?>> map) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toObject(data, parameter, resultSet.connection, map);
        }
        return resultSet.do_getObject(columnIndex, map);
    }

    @Override
    public Ref ResultSet_getRef(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter;
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Object o2 = DB2J.toObject(data, parameter = this.getColumn(resultSet, columnIndex), resultSet.connection, resultSet.connection.typeMap);
            if (o2 == null) {
                return null;
            }
            if (o2 instanceof Struct || o2 instanceof SQLData) {
                return new DmdbRef(o2);
            }
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            return null;
        }
        return resultSet.do_getRef(columnIndex);
    }

    @Override
    public Blob ResultSet_getBlob(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toBlob(data, parameter, resultSet.connection);
        }
        return resultSet.do_getBlob(columnIndex);
    }

    @Override
    public Clob ResultSet_getClob(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toClob(data, parameter, resultSet.connection);
        }
        return resultSet.do_getClob(columnIndex);
    }

    @Override
    public Array ResultSet_getArray(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toArray(data, parameter, resultSet.connection);
        }
        return resultSet.do_getArray(columnIndex);
    }

    @Override
    public Object ResultSet_getObject(DmdbResultSet resultSet, String columnLabel, Map<String, Class<?>> map) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getObject(resultSet, index, map);
    }

    @Override
    public Ref ResultSet_getRef(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getRef(resultSet, index);
    }

    @Override
    public Blob ResultSet_getBlob(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getBlob(resultSet, index);
    }

    @Override
    public Clob ResultSet_getClob(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getClob(resultSet, index);
    }

    @Override
    public Array ResultSet_getArray(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getArray(resultSet, index);
    }

    @Override
    public java.sql.Date ResultSet_getDate(DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toDate(data, parameter, resultSet.connection, cal);
        }
        return resultSet.do_getDate(columnIndex, cal);
    }

    @Override
    public java.sql.Date ResultSet_getDate(DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getDate(resultSet, index);
    }

    @Override
    public Time ResultSet_getTime(DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toTime(data, parameter, resultSet.connection, cal);
        }
        return resultSet.do_getTime(columnIndex, cal);
    }

    @Override
    public Time ResultSet_getTime(DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getTime(resultSet, index, cal);
    }

    @Override
    public Timestamp ResultSet_getTimestamp(DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toTimestamp(data, parameter, resultSet.connection, cal);
        }
        return resultSet.do_getTimestamp(columnIndex, cal);
    }

    @Override
    public Timestamp ResultSet_getTimestamp(DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getTimestamp(resultSet, index, cal);
    }

    @Override
    public URL ResultSet_getURL(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter;
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            String str = DB2J.toString(data, parameter = this.getColumn(resultSet, columnIndex), resultSet.connection);
            if (StringUtil.isEmpty(str)) {
                return null;
            }
            try {
                return new URL(str);
            }
            catch (Exception e2) {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
                return null;
            }
        }
        return resultSet.do_getURL(columnIndex);
    }

    @Override
    public URL ResultSet_getURL(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getURL(resultSet, index);
    }

    @Override
    public void ResultSet_updateRef(DmdbResultSet resultSet, int columnIndex, Ref x2) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Object o2 = x2 == null ? null : x2.getObject();
            Column parameter = this.getColumn(resultSet, columnIndex);
            byte[] data = J2DB.fromObject(o2, parameter, resultSet.connection);
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateRef(columnIndex, x2);
        }
    }

    @Override
    public void ResultSet_updateRef(DmdbResultSet resultSet, String columnLabel, Ref x2) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateRef(resultSet, index, x2);
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, int columnIndex, Blob x2) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            Object o2 = J2DB.fromBlob((DmdbBlob)x2, parameter, resultSet.connection);
            byte[] data = null;
            data = o2 instanceof byte[] ? (byte[])o2 : ((OffRowData)o2).readAll();
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateBlob(columnIndex, x2);
        }
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, String columnLabel, Blob x2) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateBlob(resultSet, index, x2);
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, int columnIndex, Clob x2) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            Object o2 = J2DB.fromClob((DmdbClob)x2, parameter, resultSet.connection);
            byte[] data = null;
            data = o2 instanceof byte[] ? (byte[])o2 : ((OffRowData)o2).readAll();
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateClob(columnIndex, x2);
        }
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, String columnLabel, Clob x2) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateClob(resultSet, index, x2);
    }

    @Override
    public void ResultSet_updateArray(DmdbResultSet resultSet, int columnIndex, Array x2) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            Object o2 = J2DB.fromArray((DmdbArray)x2, parameter, resultSet.connection);
            byte[] data = null;
            data = o2 instanceof byte[] ? (byte[])o2 : ((OffRowData)o2).readAll();
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateArray(columnIndex, x2);
        }
    }

    @Override
    public void ResultSet_updateArray(DmdbResultSet resultSet, String columnLabel, Array x2) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateArray(resultSet, index, x2);
    }

    @Override
    public RowId ResultSet_getRowId(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            return DB2J.toRowId(data, parameter, resultSet.connection);
        }
        return resultSet.do_getRowId(columnIndex);
    }

    @Override
    public RowId ResultSet_getRowId(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getRowId(resultSet, index);
    }

    @Override
    public void ResultSet_updateRowId(DmdbResultSet resultSet, int columnIndex, RowId x2) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            byte[] data = (byte[])J2DB.fromRowId(x2, parameter, resultSet.connection);
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateRowId(columnIndex, x2);
        }
    }

    @Override
    public void ResultSet_updateRowId(DmdbResultSet resultSet, String columnLabel, RowId x2) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateRowId(resultSet, index, x2);
    }

    @Override
    public int ResultSet_getHoldability(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_getHoldability(resultSet);
        }
        return resultSet.do_getHoldability();
    }

    @Override
    public boolean ResultSet_isClosed(DmdbResultSet resultSet) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSet_isClosed(resultSet);
        }
        return resultSet.do_isClosed();
    }

    @Override
    public void ResultSet_updateNString(DmdbResultSet resultSet, int columnIndex, String nString) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            Object o2 = J2DB.fromString(nString, parameter, resultSet.connection);
            byte[] data = null;
            data = o2 instanceof byte[] ? (byte[])o2 : ((OffRowData)o2).readAll();
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateNString(columnIndex, nString);
        }
    }

    @Override
    public void ResultSet_updateNString(DmdbResultSet resultSet, String columnLabel, String nString) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateNString(resultSet, index, nString);
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, int columnIndex, NClob nClob) throws SQLException {
        this.ResultSet_updateClob(resultSet, columnIndex, (Clob)nClob);
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, String columnLabel, NClob nClob) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateNClob(resultSet, index, nClob);
    }

    @Override
    public NClob ResultSet_getNClob(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return (NClob)this.ResultSet_getClob(resultSet, columnIndex);
    }

    @Override
    public NClob ResultSet_getNClob(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getNClob(resultSet, index);
    }

    @Override
    public SQLXML ResultSet_getSQLXML(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            if (data == null) {
                return null;
            }
            return new DmdbSQLXML(data, parameter, resultSet.connection);
        }
        return resultSet.do_getSQLXML(columnIndex);
    }

    @Override
    public SQLXML ResultSet_getSQLXML(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getSQLXML(resultSet, index);
    }

    @Override
    public void ResultSet_updateSQLXML(DmdbResultSet resultSet, int columnIndex, SQLXML xmlObject) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            Reader reader = xmlObject == null ? null : ((DmdbSQLXML)xmlObject).serializeAsCharacterStream();
            byte[] bytes = J2DB.fromObject(reader, parameter, resultSet.connection);
            this.ResultSet_updateBytes(resultSet, columnIndex, bytes);
        } else {
            resultSet.do_updateSQLXML(columnIndex, xmlObject);
        }
    }

    @Override
    public void ResultSet_updateSQLXML(DmdbResultSet resultSet, String columnLabel, SQLXML xmlObject) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateSQLXML(resultSet, index, xmlObject);
    }

    @Override
    public String ResultSet_getNString(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return this.ResultSet_getString(resultSet, columnIndex);
    }

    @Override
    public String ResultSet_getNString(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getNString(resultSet, index);
    }

    @Override
    public Reader ResultSet_getNCharacterStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return this.ResultSet_getCharacterStream(resultSet, columnIndex);
    }

    @Override
    public Reader ResultSet_getNCharacterStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getNCharacterStream(resultSet, index);
    }

    @Override
    public void ResultSet_updateNCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x2, long length) throws SQLException {
        this.ResultSet_updateCharacterStream(resultSet, columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateNCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateNCharacterStream(resultSet, index, reader, length);
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, int columnIndex, InputStream x2, long length) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            Object o2 = J2DB.fromAsciiStream(x2, parameter, resultSet.connection, length);
            byte[] data = null;
            data = o2 instanceof byte[] ? (byte[])o2 : ((OffRowData)o2).readAll();
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateAsciiStream(columnIndex, x2, length);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, int columnIndex, InputStream x2, long length) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            Object o2 = J2DB.fromBinaryStream(x2, parameter, resultSet.connection, length);
            byte[] data = null;
            data = o2 instanceof byte[] ? (byte[])o2 : ((OffRowData)o2).readAll();
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateBinaryStream(columnIndex, x2, length);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x2, long length) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            Object o2 = J2DB.fromReader(x2, parameter, resultSet.connection, length);
            byte[] data = null;
            data = o2 instanceof byte[] ? (byte[])o2 : ((OffRowData)o2).readAll();
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateCharacterStream(columnIndex, x2, length);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, String columnLabel, InputStream x2, long length) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateAsciiStream(resultSet, index, x2, length);
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, String columnLabel, InputStream x2, long length) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateBinaryStream(resultSet, index, x2, length);
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateCharacterStream(resultSet, index, reader, length);
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, int columnIndex, InputStream inputStream, long length) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            Object o2 = J2DB.fromBinaryStream(inputStream, parameter, resultSet.connection, length);
            byte[] data = null;
            data = o2 instanceof byte[] ? (byte[])o2 : ((OffRowData)o2).readAll();
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateBlob(columnIndex, inputStream, length);
        }
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, String columnLabel, InputStream inputStream, long length) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateBlob(resultSet, index, inputStream, length);
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, int columnIndex, Reader reader, long length) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            Column parameter = this.getColumn(resultSet, columnIndex);
            Object o2 = J2DB.fromReader(reader, parameter, resultSet.connection, length);
            byte[] data = null;
            data = o2 instanceof byte[] ? (byte[])o2 : ((OffRowData)o2).readAll();
            this.ResultSet_updateBytes(resultSet, columnIndex, data);
        } else {
            resultSet.do_updateClob(columnIndex, reader, length);
        }
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateClob(resultSet, index, reader, length);
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, int columnIndex, Reader reader, long length) throws SQLException {
        this.ResultSet_updateClob(resultSet, columnIndex, reader, length);
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateClob(resultSet, index, reader, length);
    }

    @Override
    public void ResultSet_updateNCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x2) throws SQLException {
        this.ResultSet_updateCharacterStream(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateNCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        this.ResultSet_updateCharacterStream(resultSet, index, reader);
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, int columnIndex, InputStream x2) throws SQLException {
        this.ResultSet_updateAsciiStream(resultSet, columnIndex, x2, -1);
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, int columnIndex, InputStream x2) throws SQLException {
        this.ResultSet_updateBinaryStream(resultSet, columnIndex, x2, -1);
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x2) throws SQLException {
        this.ResultSet_updateCharacterStream(resultSet, columnIndex, x2, -1);
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, String columnLabel, InputStream x2) throws SQLException {
        this.ResultSet_updateAsciiStream(resultSet, columnLabel, x2, -1);
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, String columnLabel, InputStream x2) throws SQLException {
        this.ResultSet_updateBinaryStream(resultSet, columnLabel, x2, -1);
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        this.ResultSet_updateCharacterStream(resultSet, columnLabel, reader, -1);
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, int columnIndex, InputStream inputStream) throws SQLException {
        this.ResultSet_updateBlob(resultSet, columnIndex, inputStream, -1L);
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, String columnLabel, InputStream inputStream) throws SQLException {
        this.ResultSet_updateBlob(resultSet, columnLabel, inputStream, -1L);
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, int columnIndex, Reader reader) throws SQLException {
        this.ResultSet_updateClob(resultSet, columnIndex, reader, -1L);
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        this.ResultSet_updateClob(resultSet, columnLabel, reader, -1L);
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, int columnIndex, Reader reader) throws SQLException {
        this.ResultSet_updateNClob(resultSet, columnIndex, reader, -1L);
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        this.ResultSet_updateNClob(resultSet, columnLabel, reader, -1L);
    }

    @Override
    public <T> T ResultSet_getObject(DmdbResultSet resultSet, int columnIndex, Class<T> type) throws SQLException {
        if (this.checkIndexAndFE(columnIndex, resultSet)) {
            byte[] data = this.getOriginalFeData(columnIndex, resultSet);
            Column parameter = this.getColumn(resultSet, columnIndex);
            if (type == String.class) {
                return (T)DB2J.toString(data, parameter, resultSet.connection);
            }
            if (type == Clob.class) {
                return (T)DB2J.toClob(data, parameter, resultSet.connection);
            }
            if (type == NClob.class) {
                return (T)DB2J.toClob(data, parameter, resultSet.connection);
            }
            if (type == Boolean.class) {
                return (T)Boolean.valueOf(DB2J.toBoolean(data, parameter, resultSet.connection));
            }
            if (type == Long.class) {
                return (T)Long.valueOf(DB2J.toLong(data, parameter, resultSet.connection));
            }
            if (type == Integer.class) {
                return (T)Integer.valueOf(DB2J.toInt(data, parameter, resultSet.connection));
            }
            if (type == Short.class) {
                return (T)Short.valueOf(DB2J.toShort(data, parameter, resultSet.connection));
            }
            if (type == BigDecimal.class) {
                return (T)DB2J.toBigDecimal(data, parameter, resultSet.connection);
            }
            if (type == Float.class) {
                return (T)Float.valueOf(DB2J.toFloat(data, parameter, resultSet.connection));
            }
            if (type == Double.class) {
                return (T)Double.valueOf(DB2J.toDouble(data, parameter, resultSet.connection));
            }
            if (type == Byte.class) {
                return (T)Byte.valueOf(DB2J.toByte(data, parameter, resultSet.connection));
            }
            if (type == byte[].class) {
                return (T)data;
            }
            if (type == Blob.class) {
                return (T)DB2J.toBlob(data, parameter, resultSet.connection);
            }
            if (type == java.sql.Date.class) {
                return (T)DB2J.toDate(data, parameter, resultSet.connection, null);
            }
            if (type == Time.class) {
                return (T)DB2J.toTime(data, parameter, resultSet.connection, null);
            }
            if (type == Timestamp.class) {
                return (T)DB2J.toTimestamp(data, parameter, resultSet.connection, null);
            }
            if (type == Date.class) {
                Timestamp t2 = DB2J.toTimestamp(data, parameter, resultSet.connection, null);
                return (T)(t2 == null ? null : new Date(t2.getTime()));
            }
            if (type == LocalDateTime.class) {
                DmdbTimestamp t3 = DB2J.toDmdbTimestamp(data, parameter, resultSet.connection);
                return (T)(t3 == null ? null : LocalDateTime.of(t3.dt[0], t3.dt[1], t3.dt[2], t3.dt[3], t3.dt[4], t3.dt[5], t3.dt[6]));
            }
            if (type == LocalDate.class) {
                DmdbTimestamp t4 = DB2J.toDmdbTimestamp(data, parameter, resultSet.connection);
                return (T)(t4 == null ? null : LocalDate.of(t4.dt[0], t4.dt[1], t4.dt[2]));
            }
            if (type == LocalTime.class) {
                DmdbTimestamp t5 = DB2J.toDmdbTimestamp(data, parameter, resultSet.connection);
                return (T)(t5 == null ? null : LocalTime.of(t5.dt[3], t5.dt[4], t5.dt[5], t5.dt[6]));
            }
            if (type == ZonedDateTime.class) {
                DmdbTimestamp t6 = DB2J.toDmdbTimestamp(data, parameter, resultSet.connection);
                return (T)(t6 == null ? null : ZonedDateTime.of(t6.dt[0], t6.dt[1], t6.dt[2], t6.dt[3], t6.dt[4], t6.dt[5], t6.dt[6], ZoneOffset.ofTotalSeconds(t6.dt[7] != Integer.MIN_VALUE ? t6.dt[7] * 60 : resultSet.connection.localTimezone * 60)));
            }
            if (type == OffsetDateTime.class) {
                DmdbTimestamp t7 = DB2J.toDmdbTimestamp(data, parameter, resultSet.connection);
                return (T)(t7 == null ? null : OffsetDateTime.of(t7.dt[0], t7.dt[1], t7.dt[2], t7.dt[3], t7.dt[4], t7.dt[5], t7.dt[6], ZoneOffset.ofTotalSeconds(t7.dt[7] != Integer.MIN_VALUE ? t7.dt[7] * 60 : resultSet.connection.localTimezone * 60)));
            }
            if (type == OffsetTime.class) {
                DmdbTimestamp t8 = DB2J.toDmdbTimestamp(data, parameter, resultSet.connection);
                return (T)(t8 == null ? null : OffsetTime.of(t8.dt[3], t8.dt[4], t8.dt[5], t8.dt[6], ZoneOffset.ofTotalSeconds(t8.dt[7] != Integer.MIN_VALUE ? t8.dt[7] * 60 : resultSet.connection.localTimezone * 60)));
            }
            if (type == Array.class) {
                return (T)DB2J.toArray(data, parameter, resultSet.connection);
            }
            if (type == Struct.class) {
                return (T)DB2J.toStruct(data, parameter, resultSet.connection);
            }
            if (type == Ref.class) {
                return (T)this.ResultSet_getRef(resultSet, columnIndex);
            }
            if (type == SQLXML.class) {
                return (T)this.ResultSet_getSQLXML(resultSet, columnIndex);
            }
            if (type == URL.class) {
                return (T)this.ResultSet_getURL(resultSet, columnIndex);
            }
            if (type == RowId.class) {
                return (T)DB2J.toRowId(data, parameter, resultSet.connection);
            }
            DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
            return null;
        }
        return resultSet.do_getObject(columnIndex, type);
    }

    @Override
    public <T> T ResultSet_getObject(DmdbResultSet resultSet, String columnLabel, Class<T> type) throws SQLException {
        int index = resultSet.do_findColumn(columnLabel);
        return this.ResultSet_getObject(resultSet, index, type);
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, int columnIndex, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        if (this.next != null) {
            this.next.ResultSet_updateObject(resultSet, columnIndex, x2, targetSqlType, scaleOrLength);
        } else {
            resultSet.do_updateObject(columnIndex, x2, targetSqlType, scaleOrLength);
        }
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, String columnLabel, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        if (this.next != null) {
            this.next.ResultSet_updateObject(resultSet, columnLabel, x2, targetSqlType, scaleOrLength);
        } else {
            resultSet.do_updateObject(columnLabel, x2, targetSqlType, scaleOrLength);
        }
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, int columnIndex, Object x2, SQLType targetSqlType) throws SQLException {
        if (this.next != null) {
            this.next.ResultSet_updateObject(resultSet, columnIndex, x2, targetSqlType);
        } else {
            resultSet.do_updateObject(columnIndex, x2, targetSqlType);
        }
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, String columnLabel, Object x2, SQLType targetSqlType) throws SQLException {
        if (this.next != null) {
            this.next.ResultSet_updateObject(resultSet, columnLabel, x2, targetSqlType);
        } else {
            resultSet.do_updateObject(columnLabel, x2, targetSqlType);
        }
    }

    @Override
    public int ResultSetMetaData_getColumnCount(DmdbResultSetMetaData resultSetMetaData) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSetMetaData_getColumnCount(resultSetMetaData);
        }
        return resultSetMetaData.do_getColumnCount();
    }

    @Override
    public boolean ResultSetMetaData_isAutoIncrement(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSetMetaData_isAutoIncrement(resultSetMetaData, column);
        }
        return resultSetMetaData.do_isAutoIncrement(column);
    }

    @Override
    public boolean ResultSetMetaData_isCaseSensitive(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSetMetaData_isCaseSensitive(resultSetMetaData, column);
        }
        return resultSetMetaData.do_isCaseSensitive(column);
    }

    @Override
    public boolean ResultSetMetaData_isSearchable(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSetMetaData_isSearchable(resultSetMetaData, column);
        }
        return resultSetMetaData.do_isSearchable(column);
    }

    @Override
    public boolean ResultSetMetaData_isCurrency(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSetMetaData_isCurrency(resultSetMetaData, column);
        }
        return resultSetMetaData.do_isCurrency(column);
    }

    @Override
    public int ResultSetMetaData_isNullable(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSetMetaData_isNullable(resultSetMetaData, column);
        }
        return resultSetMetaData.do_isNullable(column);
    }

    @Override
    public boolean ResultSetMetaData_isSigned(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSetMetaData_isSigned(resultSetMetaData, column);
        }
        return resultSetMetaData.do_isSigned(column);
    }

    @Override
    public int ResultSetMetaData_getColumnDisplaySize(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSetMetaData_getColumnDisplaySize(resultSetMetaData, column);
        }
        return resultSetMetaData.do_getColumnDisplaySize(column);
    }

    @Override
    public String ResultSetMetaData_getColumnLabel(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSetMetaData_getColumnLabel(resultSetMetaData, column);
        }
        return resultSetMetaData.do_getColumnLabel(column);
    }

    @Override
    public String ResultSetMetaData_getColumnName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSetMetaData_getColumnName(resultSetMetaData, column);
        }
        return resultSetMetaData.do_getColumnName(column);
    }

    @Override
    public String ResultSetMetaData_getSchemaName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSetMetaData_getSchemaName(resultSetMetaData, column);
        }
        return resultSetMetaData.do_getSchemaName(column);
    }

    @Override
    public int ResultSetMetaData_getPrecision(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSetMetaData_getPrecision(resultSetMetaData, column);
        }
        return resultSetMetaData.do_getPrecision(column);
    }

    @Override
    public int ResultSetMetaData_getScale(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSetMetaData_getScale(resultSetMetaData, column);
        }
        return resultSetMetaData.do_getScale(column);
    }

    @Override
    public String ResultSetMetaData_getTableName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSetMetaData_getTableName(resultSetMetaData, column);
        }
        return resultSetMetaData.do_getTableName(column);
    }

    @Override
    public String ResultSetMetaData_getCatalogName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSetMetaData_getCatalogName(resultSetMetaData, column);
        }
        return resultSetMetaData.do_getCatalogName(column);
    }

    @Override
    public int ResultSetMetaData_getColumnType(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSetMetaData_getColumnType(resultSetMetaData, column);
        }
        return resultSetMetaData.do_getColumnType(column);
    }

    @Override
    public String ResultSetMetaData_getColumnTypeName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSetMetaData_getColumnTypeName(resultSetMetaData, column);
        }
        return resultSetMetaData.do_getColumnTypeName(column);
    }

    @Override
    public boolean ResultSetMetaData_isReadOnly(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSetMetaData_isReadOnly(resultSetMetaData, column);
        }
        return resultSetMetaData.do_isReadOnly(column);
    }

    @Override
    public boolean ResultSetMetaData_isWritable(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSetMetaData_isWritable(resultSetMetaData, column);
        }
        return resultSetMetaData.do_isWritable(column);
    }

    @Override
    public boolean ResultSetMetaData_isDefinitelyWritable(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSetMetaData_isDefinitelyWritable(resultSetMetaData, column);
        }
        return resultSetMetaData.do_isDefinitelyWritable(column);
    }

    @Override
    public String ResultSetMetaData_getColumnClassName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        if (this.next != null) {
            return this.next.ResultSetMetaData_getColumnClassName(resultSetMetaData, column);
        }
        return resultSetMetaData.do_getColumnClassName(column);
    }

    @Override
    public ResultSet Statement_executeQuery(DmdbStatement statement, String sql) throws SQLException {
        this.feParamsList = new ArrayList<FeSQLParameter>();
        statement.indexMap = new LinkedHashMap();
        try {
            if (sql.toUpperCase().contains("EXPLAIN")) {
                return statement.do_executeQuery(sql);
            }
            sql = SQLProcessor.execOptFe(sql, this.feParamsList, statement.connection.getServerEncoding(), statement.indexMap);
            DmdbConnection conn = statement.connection;
            DmdbPreparedStatement ps = conn.do_prepareStatement(sql);
            this.refreshPreparedStatementStauts(ps, statement);
            statement.fePreparedStatement = ps;
            this.initFeCipher(ps.serverParameters, statement.connection);
            int index = 0;
            while (index < this.feParamsList.size()) {
                this.PreparedStatement_setObject(ps, index + 1, this.feParamsList.get(index));
                ++index;
            }
            statement.curResultSet = ps.do_executeQuery();
            this.initFeCipher(statement.curResultSet.columns, statement.connection);
            return statement.curResultSet;
        }
        catch (Exception e2) {
            if (e2 instanceof SQLException) {
                throw new SQLException(e2.getMessage(), ((SQLException)e2).getSQLState(), ((SQLException)e2).getErrorCode());
            }
            DBError.EC_PARSE_ERROR.throwz(new Object[0]);
            return null;
        }
    }

    private void refreshPreparedStatementStauts(DmdbPreparedStatement ps, DmdbStatement stmt) {
        ps.innerExec = stmt.innerExec;
        ps.cursorName = stmt.cursorName;
        ps.readBaseColName = stmt.readBaseColName;
        ps.resultSetType = stmt.resultSetType;
        ps.resultSetConcurrency = stmt.resultSetConcurrency;
        ps.resultSetHoldability = stmt.resultSetHoldability;
        ps.nativeSql = stmt.nativeSql;
        ps.maxFieldSize = stmt.maxFieldSize;
        ps.maxRows = stmt.maxRows;
        ps.escapeProcessing = stmt.escapeProcessing;
        ps.queryTimeout = stmt.queryTimeout;
        ps.fetchDirection = stmt.fetchDirection;
        ps.fetchSize = stmt.fetchSize;
        ps.cursorUpdateRow = stmt.cursorUpdateRow;
        ps.closeOnCompletion = false;
        ps.closed = stmt.closed;
        ps.warnings = stmt.warnings;
        ps.batchSqls = stmt.batchSqls;
        ps.curResultSet = stmt.curResultSet;
        ps.openedResultSets = stmt.openedResultSets;
        ps.poolable = stmt.poolable;
        ps.type = stmt.type;
        ps.running = stmt.running;
        ps.clearBatch = stmt.clearBatch;
        ps.tempMap = stmt.tempMap;
        ps.sqlType = stmt.sqlType;
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql) throws SQLException {
        this.feParamsList = new ArrayList<FeSQLParameter>();
        statement.indexMap = new LinkedHashMap();
        try {
            if (sql.toUpperCase().contains("EXPLAIN")) {
                return statement.do_executeUpdate(sql);
            }
            sql = SQLProcessor.execOptFe(sql, this.feParamsList, statement.connection.getServerEncoding(), statement.indexMap);
        }
        catch (Exception exception) {
            DBError.EC_PARSE_ERROR.throwz(new Object[0]);
        }
        DmdbConnection conn = statement.connection;
        DmdbPreparedStatement ps = conn.do_prepareStatement(sql);
        this.refreshPreparedStatementStauts(ps, statement);
        statement.fePreparedStatement = ps;
        this.initFeCipher(ps.serverParameters, statement.connection);
        int index = 0;
        while (index < this.feParamsList.size()) {
            this.PreparedStatement_setObject(ps, index + 1, this.feParamsList.get(index));
            ++index;
        }
        int rows = ps.do_executeUpdate();
        return rows;
    }

    @Override
    public void Statement_close(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            statement.fePreparedStatement.do_close();
        }
        if (this.next != null) {
            this.next.Statement_close(statement);
        } else {
            statement.do_close();
        }
    }

    @Override
    public int Statement_getMaxFieldSize(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            return statement.fePreparedStatement.do_getMaxFieldSize();
        }
        return statement.do_getMaxFieldSize();
    }

    @Override
    public void Statement_setMaxFieldSize(DmdbStatement statement, int max) throws SQLException {
        if (statement.fePreparedStatement != null) {
            statement.fePreparedStatement.do_setMaxFieldSize(max);
        }
        if (this.next != null) {
            this.next.Statement_setMaxFieldSize(statement, max);
        } else {
            statement.do_setMaxFieldSize(max);
        }
    }

    @Override
    public int Statement_getMaxRows(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            return statement.fePreparedStatement.do_getMaxRows();
        }
        return statement.do_getMaxRows();
    }

    @Override
    public void Statement_setMaxRows(DmdbStatement statement, int max) throws SQLException {
        if (statement.fePreparedStatement != null) {
            statement.fePreparedStatement.do_setMaxRows(max);
        }
        if (this.next != null) {
            this.next.Statement_setMaxRows(statement, max);
        } else {
            statement.do_setMaxRows(max);
        }
    }

    @Override
    public void Statement_setEscapeProcessing(DmdbStatement statement, boolean enable) throws SQLException {
        if (statement.fePreparedStatement != null) {
            statement.fePreparedStatement.do_setEscapeProcessing(enable);
        }
        if (this.next != null) {
            this.next.Statement_setEscapeProcessing(statement, enable);
        } else {
            statement.do_setEscapeProcessing(enable);
        }
    }

    @Override
    public int Statement_getQueryTimeout(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            return statement.fePreparedStatement.do_getQueryTimeout();
        }
        return statement.do_getQueryTimeout();
    }

    @Override
    public void Statement_setQueryTimeout(DmdbStatement statement, int seconds) throws SQLException {
        if (statement.fePreparedStatement != null) {
            statement.fePreparedStatement.do_setQueryTimeout(seconds);
        }
        if (this.next != null) {
            this.next.Statement_setQueryTimeout(statement, seconds);
        } else {
            statement.do_setQueryTimeout(seconds);
        }
    }

    @Override
    public void Statement_cancel(DmdbStatement statement) throws SQLException {
        if (this.next != null) {
            this.next.Statement_cancel(statement);
        } else {
            statement.do_cancel();
        }
    }

    @Override
    public SQLWarning Statement_getWarnings(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            return statement.fePreparedStatement.do_getWarnings();
        }
        return statement.do_getWarnings();
    }

    @Override
    public void Statement_clearWarnings(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            statement.fePreparedStatement.do_clearWarnings();
        }
        if (this.next != null) {
            this.next.Statement_clearWarnings(statement);
        } else {
            statement.do_clearWarnings();
        }
    }

    @Override
    public void Statement_setCursorName(DmdbStatement statement, String name) throws SQLException {
        if (statement.fePreparedStatement != null) {
            statement.fePreparedStatement.do_setCursorName(name);
        }
        if (this.next != null) {
            this.next.Statement_setCursorName(statement, name);
        } else {
            statement.do_setCursorName(name);
        }
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql) throws SQLException {
        this.feParamsList = new ArrayList<FeSQLParameter>();
        statement.indexMap = new LinkedHashMap();
        try {
            if (sql.toUpperCase().contains("EXPLAIN")) {
                return statement.do_execute(sql);
            }
            sql = SQLProcessor.execOptFe(sql, this.feParamsList, statement.connection.getServerEncoding(), statement.indexMap);
        }
        catch (Exception exception) {
            DBError.EC_PARSE_ERROR.throwz(new Object[0]);
        }
        DmdbConnection conn = statement.connection;
        DmdbPreparedStatement ps = conn.do_prepareStatement(sql);
        this.refreshPreparedStatementStauts(ps, statement);
        statement.fePreparedStatement = ps;
        this.initFeCipher(ps.serverParameters, statement.connection);
        int index = 0;
        while (index < this.feParamsList.size()) {
            this.PreparedStatement_setObject(ps, index + 1, this.feParamsList.get(index));
            ++index;
        }
        boolean result = ps.do_execute();
        if (result) {
            statement.curResultSet = ps.do_getResultSet();
        }
        return result;
    }

    @Override
    public ResultSet Statement_getResultSet(DmdbStatement statement) throws SQLException {
        if (this.next != null) {
            return this.next.Statement_getResultSet(statement);
        }
        DmdbResultSet resultSet = statement.do_getResultSet();
        this.initFeCipher(resultSet.columns, resultSet.connection);
        return resultSet;
    }

    @Override
    public int Statement_getUpdateCount(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            return statement.fePreparedStatement.do_getUpdateCount();
        }
        return statement.do_getUpdateCount();
    }

    @Override
    public boolean Statement_getMoreResults(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            return statement.fePreparedStatement.do_getMoreResults();
        }
        return statement.do_getMoreResults();
    }

    @Override
    public void Statement_setFetchDirection(DmdbStatement statement, int direction) throws SQLException {
        if (statement.fePreparedStatement != null) {
            statement.fePreparedStatement.do_setFetchDirection(direction);
        }
        if (this.next != null) {
            this.next.Statement_setFetchDirection(statement, direction);
        } else {
            statement.do_setFetchDirection(direction);
        }
    }

    @Override
    public int Statement_getFetchDirection(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            return statement.fePreparedStatement.do_getFetchDirection();
        }
        return statement.do_getFetchDirection();
    }

    @Override
    public void Statement_setFetchSize(DmdbStatement statement, int rows) throws SQLException {
        if (statement.fePreparedStatement != null) {
            statement.fePreparedStatement.do_setFetchSize(rows);
        }
        if (this.next != null) {
            this.next.Statement_setFetchSize(statement, rows);
        } else {
            statement.do_setFetchSize(rows);
        }
    }

    @Override
    public int Statement_getFetchSize(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            return statement.fePreparedStatement.do_getFetchSize();
        }
        return statement.do_getFetchSize();
    }

    @Override
    public int Statement_getResultSetConcurrency(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            return statement.fePreparedStatement.do_getResultSetConcurrency();
        }
        return statement.do_getResultSetConcurrency();
    }

    @Override
    public int Statement_getResultSetType(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            return statement.fePreparedStatement.do_getResultSetType();
        }
        return statement.do_getResultSetType();
    }

    @Override
    public void Statement_addBatch(DmdbStatement statement, String sql) throws SQLException {
        if (statement.fePreparedStatement != null) {
            statement.fePreparedStatement.do_addBatch(sql);
        }
        if (this.next != null) {
            this.next.Statement_addBatch(statement, sql);
        } else {
            statement.do_addBatch(sql);
        }
    }

    @Override
    public void Statement_clearBatch(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            statement.fePreparedStatement.do_clearBatch();
        }
        if (this.next != null) {
            this.next.Statement_clearBatch(statement);
        } else {
            statement.do_clearBatch();
        }
    }

    @Override
    public int[] Statement_executeBatch(DmdbStatement statement) throws SQLException {
        if (statement.batchSqls == null || statement.batchSqls.size() == 0) {
            return null;
        }
        int[] result = new int[statement.batchSqls.size()];
        int index = 0;
        while (index < statement.batchSqls.size()) {
            boolean updateFlag = this.Statement_execute(statement, statement.batchSqls.get(index));
            result[index] = updateFlag ? 0 : statement.do_getUpdateCount();
            ++index;
        }
        statement.batchSqls.clear();
        return result;
    }

    @Override
    public Connection Statement_getConnection(DmdbStatement statement) throws SQLException {
        if (this.next != null) {
            return this.next.Statement_getConnection(statement);
        }
        return statement.do_getConnection();
    }

    @Override
    public boolean Statement_getMoreResults(DmdbStatement statement, int current) throws SQLException {
        if (statement.fePreparedStatement != null) {
            return statement.fePreparedStatement.do_getMoreResults(current);
        }
        return statement.do_getMoreResults(current);
    }

    @Override
    public ResultSet Statement_getGeneratedKeys(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            return statement.fePreparedStatement.do_getGeneratedKeys();
        }
        return statement.do_getGeneratedKeys();
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        this.feParamsList = new ArrayList<FeSQLParameter>();
        statement.indexMap = new LinkedHashMap();
        try {
            if (sql.toUpperCase().contains("EXPLAIN")) {
                return statement.do_executeUpdate(sql);
            }
            sql = SQLProcessor.execOptFe(sql, this.feParamsList, statement.connection.getServerEncoding(), statement.indexMap);
        }
        catch (Exception exception) {
            DBError.EC_PARSE_ERROR.throwz(new Object[0]);
        }
        DmdbConnection conn = statement.connection;
        DmdbPreparedStatement ps = conn.do_prepareStatement(sql);
        this.refreshPreparedStatementStauts(ps, statement);
        statement.fePreparedStatement = ps;
        this.initFeCipher(ps.serverParameters, statement.connection);
        int index = 0;
        while (index < this.feParamsList.size()) {
            this.PreparedStatement_setObject(ps, index + 1, this.feParamsList.get(index));
            ++index;
        }
        int rows = ps.do_executeUpdate(sql, autoGeneratedKeys);
        return rows;
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        this.feParamsList = new ArrayList<FeSQLParameter>();
        statement.indexMap = new LinkedHashMap();
        try {
            if (sql.toUpperCase().contains("EXPLAIN")) {
                return statement.do_executeUpdate(sql);
            }
            sql = SQLProcessor.execOptFe(sql, this.feParamsList, statement.connection.getServerEncoding(), statement.indexMap);
        }
        catch (Exception exception) {
            DBError.EC_PARSE_ERROR.throwz(new Object[0]);
        }
        DmdbConnection conn = statement.connection;
        DmdbPreparedStatement ps = conn.do_prepareStatement(sql);
        this.refreshPreparedStatementStauts(ps, statement);
        statement.fePreparedStatement = ps;
        this.initFeCipher(ps.serverParameters, statement.connection);
        int index = 0;
        while (index < this.feParamsList.size()) {
            this.PreparedStatement_setObject(ps, index + 1, this.feParamsList.get(index));
            ++index;
        }
        int rows = ps.do_executeUpdate(sql, columnIndexes);
        return rows;
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        this.feParamsList = new ArrayList<FeSQLParameter>();
        statement.indexMap = new LinkedHashMap();
        try {
            if (sql.toUpperCase().contains("EXPLAIN")) {
                return statement.do_executeUpdate(sql);
            }
            sql = SQLProcessor.execOptFe(sql, this.feParamsList, statement.connection.getServerEncoding(), statement.indexMap);
        }
        catch (Exception exception) {
            DBError.EC_PARSE_ERROR.throwz(new Object[0]);
        }
        DmdbConnection conn = statement.connection;
        DmdbPreparedStatement ps = conn.do_prepareStatement(sql);
        this.refreshPreparedStatementStauts(ps, statement);
        statement.fePreparedStatement = ps;
        this.initFeCipher(ps.serverParameters, statement.connection);
        int index = 0;
        while (index < this.feParamsList.size()) {
            this.PreparedStatement_setObject(ps, index + 1, this.feParamsList.get(index));
            ++index;
        }
        int rows = ps.do_executeUpdate(sql, columnNames);
        return rows;
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        this.feParamsList = new ArrayList<FeSQLParameter>();
        statement.indexMap = new LinkedHashMap();
        try {
            if (sql.toUpperCase().contains("EXPLAIN")) {
                return statement.do_execute(sql);
            }
            sql = SQLProcessor.execOptFe(sql, this.feParamsList, statement.connection.getServerEncoding(), statement.indexMap);
        }
        catch (Exception exception) {
            DBError.EC_PARSE_ERROR.throwz(new Object[0]);
        }
        DmdbConnection conn = statement.connection;
        DmdbPreparedStatement ps = conn.do_prepareStatement(sql);
        this.refreshPreparedStatementStauts(ps, statement);
        statement.fePreparedStatement = ps;
        this.initFeCipher(ps.serverParameters, statement.connection);
        int index = 0;
        while (index < this.feParamsList.size()) {
            this.PreparedStatement_setObject(ps, index + 1, this.feParamsList.get(index));
            ++index;
        }
        return ps.do_execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        this.feParamsList = new ArrayList<FeSQLParameter>();
        statement.indexMap = new LinkedHashMap();
        try {
            if (sql.toUpperCase().contains("EXPLAIN")) {
                return statement.do_execute(sql);
            }
            sql = SQLProcessor.execOptFe(sql, this.feParamsList, statement.connection.getServerEncoding(), statement.indexMap);
        }
        catch (Exception exception) {
            DBError.EC_PARSE_ERROR.throwz(new Object[0]);
        }
        DmdbConnection conn = statement.connection;
        DmdbPreparedStatement ps = conn.do_prepareStatement(sql);
        this.refreshPreparedStatementStauts(ps, statement);
        statement.fePreparedStatement = ps;
        this.initFeCipher(ps.serverParameters, statement.connection);
        int index = 0;
        while (index < this.feParamsList.size()) {
            this.PreparedStatement_setObject(ps, index + 1, this.feParamsList.get(index));
            ++index;
        }
        return ps.do_execute(sql, columnIndexes);
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        this.feParamsList = new ArrayList<FeSQLParameter>();
        statement.indexMap = new LinkedHashMap();
        try {
            if (sql.toUpperCase().contains("EXPLAIN")) {
                return statement.do_execute(sql);
            }
            sql = SQLProcessor.execOptFe(sql, this.feParamsList, statement.connection.getServerEncoding(), statement.indexMap);
        }
        catch (Exception exception) {
            DBError.EC_PARSE_ERROR.throwz(new Object[0]);
        }
        DmdbConnection conn = statement.connection;
        DmdbPreparedStatement ps = conn.do_prepareStatement(sql);
        this.refreshPreparedStatementStauts(ps, statement);
        statement.fePreparedStatement = ps;
        this.initFeCipher(ps.serverParameters, statement.connection);
        int index = 0;
        while (index < this.feParamsList.size()) {
            this.PreparedStatement_setObject(ps, index + 1, this.feParamsList.get(index));
            ++index;
        }
        return ps.do_execute(sql, columnNames);
    }

    @Override
    public int Statement_getResultSetHoldability(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            return statement.fePreparedStatement.do_getResultSetHoldability();
        }
        return statement.do_getResultSetHoldability();
    }

    @Override
    public boolean Statement_isClosed(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            return statement.fePreparedStatement.do_isClosed();
        }
        return statement.do_isClosed();
    }

    @Override
    public void Statement_setPoolable(DmdbStatement statement, boolean poolable) throws SQLException {
        if (statement.fePreparedStatement != null) {
            statement.fePreparedStatement.do_setPoolable(poolable);
        }
        if (this.next != null) {
            this.next.Statement_setPoolable(statement, poolable);
        } else {
            statement.do_setPoolable(poolable);
        }
    }

    @Override
    public boolean Statement_isPoolable(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            return statement.fePreparedStatement.do_isPoolable();
        }
        return statement.do_isPoolable();
    }

    @Override
    public void Statement_closeOnCompletion(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            statement.fePreparedStatement.do_closeOnCompletion();
        }
        if (this.next != null) {
            this.next.Statement_closeOnCompletion(statement);
        } else {
            statement.do_closeOnCompletion();
        }
    }

    @Override
    public boolean Statement_isCloseOnCompletion(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            return statement.fePreparedStatement.do_isCloseOnCompletion();
        }
        return statement.do_isCloseOnCompletion();
    }

    @Override
    public long Statement_getLargeUpdateCount(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            return statement.fePreparedStatement.do_getLargeUpdateCount();
        }
        return statement.do_getLargeUpdateCount();
    }

    @Override
    public void Statement_setLargeMaxRows(DmdbStatement statement, long max) throws SQLException {
        if (statement.fePreparedStatement != null) {
            statement.fePreparedStatement.do_setLargeMaxRows(max);
        }
        if (this.next != null) {
            this.next.Statement_setLargeMaxRows(statement, max);
        } else {
            statement.do_setLargeMaxRows(max);
        }
    }

    @Override
    public long Statement_getLargeMaxRows(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            return statement.fePreparedStatement.do_getLargeMaxRows();
        }
        return statement.do_getLargeMaxRows();
    }

    @Override
    public long[] Statement_executeLargeBatch(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            return statement.fePreparedStatement.do_executeLargeBatch();
        }
        return statement.do_executeLargeBatch();
    }

    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql) throws SQLException {
        return this.Statement_executeLargeUpdate(statement, sql, 2);
    }

    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        this.feParamsList = new ArrayList<FeSQLParameter>();
        statement.indexMap = new LinkedHashMap();
        try {
            if (sql.toUpperCase().contains("EXPLAIN")) {
                return statement.do_executeLargeUpdate(sql, autoGeneratedKeys);
            }
            sql = SQLProcessor.execOptFe(sql, this.feParamsList, statement.connection.getServerEncoding(), statement.indexMap);
        }
        catch (Exception exception) {
            DBError.EC_PARSE_ERROR.throwz(new Object[0]);
        }
        DmdbConnection conn = statement.connection;
        DmdbPreparedStatement ps = conn.do_prepareStatement(sql);
        this.refreshPreparedStatementStauts(ps, statement);
        statement.fePreparedStatement = ps;
        this.initFeCipher(ps.serverParameters, statement.connection);
        int index = 0;
        while (index < this.feParamsList.size()) {
            this.PreparedStatement_setObject(ps, index + 1, this.feParamsList.get(index));
            ++index;
        }
        long rows = ps.do_executeLargeUpdate();
        return rows;
    }

    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        this.feParamsList = new ArrayList<FeSQLParameter>();
        statement.indexMap = new LinkedHashMap();
        try {
            if (sql.toUpperCase().contains("EXPLAIN")) {
                return statement.do_executeLargeUpdate(sql);
            }
            sql = SQLProcessor.execOptFe(sql, this.feParamsList, statement.connection.getServerEncoding(), statement.indexMap);
        }
        catch (Exception exception) {
            DBError.EC_PARSE_ERROR.throwz(new Object[0]);
        }
        DmdbConnection conn = statement.connection;
        DmdbPreparedStatement ps = conn.do_prepareStatement(sql);
        this.refreshPreparedStatementStauts(ps, statement);
        statement.fePreparedStatement = ps;
        this.initFeCipher(ps.serverParameters, statement.connection);
        int index = 0;
        while (index < this.feParamsList.size()) {
            this.PreparedStatement_setObject(ps, index + 1, this.feParamsList.get(index));
            ++index;
        }
        long rows = ps.do_executeLargeUpdate(sql, columnIndexes);
        return rows;
    }

    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        this.feParamsList = new ArrayList<FeSQLParameter>();
        statement.indexMap = new LinkedHashMap();
        try {
            if (sql.toUpperCase().contains("EXPLAIN")) {
                return statement.do_executeLargeUpdate(sql);
            }
            sql = SQLProcessor.execOptFe(sql, this.feParamsList, statement.connection.getServerEncoding(), statement.indexMap);
        }
        catch (Exception exception) {
            DBError.EC_PARSE_ERROR.throwz(new Object[0]);
        }
        DmdbConnection conn = statement.connection;
        DmdbPreparedStatement ps = conn.do_prepareStatement(sql);
        this.refreshPreparedStatementStauts(ps, statement);
        statement.fePreparedStatement = ps;
        this.initFeCipher(ps.serverParameters, statement.connection);
        int index = 0;
        while (index < this.feParamsList.size()) {
            this.PreparedStatement_setObject(ps, index + 1, this.feParamsList.get(index));
            ++index;
        }
        long rows = ps.do_executeLargeUpdate(sql, columnNames);
        return rows;
    }

    @Override
    public long Statement_getExecuteId(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            statement.fePreparedStatement.do_getExecuteId();
        }
        return statement.do_getExecuteId();
    }

    @Override
    public String Statement_getPrintMsg(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            return statement.fePreparedStatement.do_getPrintMsg();
        }
        return statement.do_getPrintMsg();
    }

    @Override
    public int Statement_getSqlType(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            return statement.fePreparedStatement.do_getSqlType();
        }
        return statement.do_getSqlType();
    }

    @Override
    public RowId Statement_getRowId(DmdbStatement statement) throws SQLException {
        if (statement.fePreparedStatement != null) {
            return statement.fePreparedStatement.do_getRowId();
        }
        return statement.do_getRowId();
    }

    @Override
    public ResultSet[] Statement_getResultSets(DmdbStatement statement) throws SQLException {
        ResultSet[] resultSets;
        ResultSet[] resultSetArray = resultSets = statement.do_getResultSets();
        int n2 = resultSets.length;
        int n3 = 0;
        while (n3 < n2) {
            ResultSet set = resultSetArray[n3];
            this.initFeCipher(((DmdbResultSet)set).columns, statement.connection);
            ++n3;
        }
        return resultSets;
    }

    @Override
    public void Connection_reset(DmdbConnection connection) throws SQLException {
        if (this.next != null) {
            this.next.Connection_reset(connection);
        } else {
            connection.do_reset();
        }
    }

    @Override
    public String Statement_getExplain(DmdbStatement dmdbStatement) {
        if (dmdbStatement.fePreparedStatement != null) {
            return dmdbStatement.fePreparedStatement.do_getExplain();
        }
        return dmdbStatement.do_getExplain();
    }

    @Override
    public ResultSet CallableStatement_getCursor(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getCursor(callableStatement, parameterName);
        }
        return callableStatement.do_getCursor(parameterName);
    }

    @Override
    public void CallableStatement_setINTERVALDT(DmdbCallableStatement callableStatement, String paramName, DmdbIntervalDT x2) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setINTERVALDT(callableStatement, paramName, x2);
        } else {
            callableStatement.do_setINTERVALDT(paramName, x2);
        }
    }

    @Override
    public void CallableStatement_setINTERVALYM(DmdbCallableStatement callableStatement, String paramName, DmdbIntervalYM x2) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setINTERVALYM(callableStatement, paramName, x2);
        } else {
            callableStatement.do_setINTERVALYM(paramName, x2);
        }
    }

    @Override
    public void CallableStatement_setTIMESTAMP(DmdbCallableStatement callableStatement, String paramName, DmdbTimestamp x2) throws SQLException {
        if (this.next != null) {
            this.next.CallableStatement_setTIMESTAMP(callableStatement, paramName, x2);
        } else {
            callableStatement.do_setTIMESTAMP(paramName, x2);
        }
    }

    @Override
    public DmdbTimestamp CallableStatement_getTIMESTAMP(DmdbCallableStatement callableStatement, String paramName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getTIMESTAMP(callableStatement, paramName);
        }
        return callableStatement.do_getTIMESTAMP(paramName);
    }

    @Override
    public DmdbIntervalDT CallableStatement_getINTERVALDT(DmdbCallableStatement callableStatement, String paramName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getINTERVALDT(callableStatement, paramName);
        }
        return callableStatement.do_getINTERVALDT(paramName);
    }

    @Override
    public DmdbIntervalYM CallableStatement_getINTERVALYM(DmdbCallableStatement callableStatement, String paramName) throws SQLException {
        if (this.next != null) {
            return this.next.CallableStatement_getINTERVALYM(callableStatement, paramName);
        }
        return callableStatement.do_getINTERVALYM(paramName);
    }

    @Override
    public void XAResource_start(DmdbXAResource xaResource, Xid xid, int flags) throws XAException {
        if (this.next != null) {
            this.next.XAResource_start(xaResource, xid, flags);
        } else {
            xaResource.do_start(xid, flags);
        }
    }

    @Override
    public void XAResource_end(DmdbXAResource xaResource, Xid xid, int flags) throws XAException {
        if (this.next != null) {
            this.next.XAResource_end(xaResource, xid, flags);
        } else {
            xaResource.do_end(xid, flags);
        }
    }

    @Override
    public boolean XAResource_setTransactionTimeout(DmdbXAResource xaResource, int seconds) throws XAException {
        if (this.next != null) {
            return this.next.XAResource_setTransactionTimeout(xaResource, seconds);
        }
        return xaResource.do_setTransactionTimeout(seconds);
    }

    @Override
    public int XAResource_getTransactionTimeout(DmdbXAResource xaResource) throws XAException {
        if (this.next != null) {
            return this.next.XAResource_getTransactionTimeout(xaResource);
        }
        return xaResource.do_getTransactionTimeout();
    }

    @Override
    public void XAResource_rollback(DmdbXAResource xaResource, Xid xid) throws XAException {
        if (this.next != null) {
            this.next.XAResource_rollback(xaResource, xid);
        } else {
            xaResource.do_rollback(xid);
        }
    }

    @Override
    public void XAResource_commit(DmdbXAResource xaResource, Xid xid, boolean onePhase) throws XAException {
        if (this.next != null) {
            this.next.XAResource_commit(xaResource, xid, onePhase);
        } else {
            xaResource.do_commit(xid, onePhase);
        }
    }

    @Override
    public Xid[] XAResource_recover(DmdbXAResource xaResource, int flag) throws XAException {
        if (this.next != null) {
            return this.next.XAResource_recover(xaResource, flag);
        }
        return xaResource.do_recover(flag);
    }

    @Override
    public int XAResource_prepare(DmdbXAResource xaResource, Xid xid) throws XAException {
        if (this.next != null) {
            return this.next.XAResource_prepare(xaResource, xid);
        }
        return xaResource.do_prepare(xid);
    }

    @Override
    public boolean XAResource_isSameRM(DmdbXAResource xaResource, XAResource xaRes) throws XAException {
        if (this.next != null) {
            return this.next.XAResource_isSameRM(xaResource, xaRes);
        }
        return xaResource.do_isSameRM(xaRes);
    }

    @Override
    public void XAResource_forget(DmdbXAResource xaResource, Xid xid) throws XAException {
        if (this.next != null) {
            this.next.XAResource_forget(xaResource, xid);
        } else {
            xaResource.do_forget(xid);
        }
    }
}

