/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal.desc;

import dm.jdbc.driver.Configuration;
import dm.jdbc.util.StringUtil;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public class MetaSQL {
    private static final String ESCAPE = " ESCAPE '!' ";
    public static final int TABLE_DB_TYPE_NORMAL = 0;
    public static final int TABLE_DB_TYPE_VERTICAL = 3;
    public static final int TABLE_DB_TYPE_VERTICAL_PARTITION = 4;
    public static final int TABLE_DB_TYPE_VERTICAL_PARTITION_S = 5;
    public static final int TABLE_DB_TYPE_RANGE_PARTITION = 6;
    public static final int TABLE_DB_TYPE_RANGE_PARTITION_S = 7;
    public static final int TABLE_DB_TYPE_HASH_PARTITION = 8;
    public static final int TABLE_DB_TYPE_HASH_PARTITION_S = 9;
    public static final int TABLE_DB_TYPE_BITMAP_JOIN = 10;
    public static final int TABLE_DB_TYPE_LIST_PARTITION = 11;
    public static final int TABLE_DB_TYPE_LIST_PARTITION_S = 12;
    public static final int TABLE_DB_TYPE_EXTERNAL = 13;
    public static final int TABLE_DB_TYPE_ARR = 14;
    public static final int TABLE_DB_TYPE_REMOTE = 15;
    public static final int TABLE_DB_TYPE_HUGE = 19;
    public static final int TABLE_DB_TYPE_V_RANGE_PARTITION = 17;
    public static final int TABLE_DB_TYPE_V_RANGE_PARTITION_S = 18;
    public static final int TABLE_DB_TYPE_V_HASH_PARTITION = 20;
    public static final int TABLE_DB_TYPE_V_HASH_PARTITION_S = 21;
    public static final int TABLE_DB_TYPE_V_LIST_PARTITION = 22;
    public static final int TABLE_DB_TYPE_V_LIST_PARTITION_S = 23;
    public static final int TABLE_DB_TYPE_HUG_RANGE_PARTITION = 24;
    public static final int TABLE_DB_TYPE_HUG_RANGE_PARTITION_S = 25;
    public static final int TABLE_DB_TYPE_HUG_HASH_PARTITION = 26;
    public static final int TABLE_DB_TYPE_HUG_HASH_PARTITION_S = 27;
    public static final int TABLE_DB_TYPE_HUG_LIST_PARTITION = 28;
    public static final int TABLE_DB_TYPE_HUG_LIST_PARTITION_S = 29;
    public static final int TABLE_DB_TYPE_BITMAP = 32;
    public static final int TABLE_TEMP_TYPE_NO_TEMP = 0;
    public static final int TABLE_TEMP_TYPE_GLOBAL_TEMP = 1;
    public static final int TABLE_TEMP_TYPE_LOCAL_TEMP = 2;
    private boolean compatibleOracle = false;
    private String currentSchema;

    public MetaSQL(String currentSchema, boolean compatibleOracle) {
        this.compatibleOracle = compatibleOracle;
        this.currentSchema = StringUtil.isEmpty(currentSchema) ? "" : currentSchema;
    }

    public String getAttributes(List<Object> paramList, String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) {
        String sql = "/*DMJDBC*/ SELECT CAST(NULL AS VARCHAR(128)) AS TYPE_CAT,CAST(NULL AS VARCHAR(128)) AS TYPE_SCHEM,CAST(NULL AS VARCHAR(128)) AS TYPE_NAME,CAST(NULL AS VARCHAR(128)) AS ATTR_NAME,CAST(NULL AS INT) AS DATA_TYPE,CAST(NULL AS VARCHAR(128)) AS ATTR_TYPE_NAME,CAST(NULL AS INT) AS ATTR_SIZE,CAST(NULL AS INT) AS DECIMAL_DIGITS,CAST(NULL AS INT) AS NUM_PREC_RADIX,CAST(NULL AS INT) AS NULLABLE,CAST(NULL AS VARCHAR(128)) AS REMARKS,CAST(NULL AS VARCHAR(128)) AS ATTR_DEF,CAST(NULL AS INT) AS SQL_DATA_TYPE,CAST(NULL AS INT) AS SQL_DATETIME_SUB,CAST(NULL AS INT) AS CHAR_OCTET_LENGTH,CAST(NULL AS INT) AS ORDINAL_POSITION,CAST(NULL AS VARCHAR(128)) AS IS_NULLABLE,CAST(NULL AS VARCHAR(128)) AS SCOPE_CATALOG,CAST(NULL AS VARCHAR(128)) AS SCOPE_SCHEMA,CAST(NULL AS VARCHAR(128)) AS SCOPE_TABLE,CAST(NULL AS SMALLINT) AS SOURCE_DATA_TYPE FROM DUAL WHERE 1 = 2";
        return sql;
    }

    public String getTableTypes() {
        String sql = "/*DMJDBC*/ (SELECT 'SYSTEM TABLE' AS TABLE_TYPE FROM SYS.SYSDUAL) UNION (SELECT 'TABLE' AS TABLE_TYPE FROM SYS.SYSDUAL) UNION (SELECT 'VIEW' AS TABLE_TYPE FROM SYS.SYSDUAL) UNION (SELECT 'GLOBAL TEMPORARY' AS TABLE_TYPE FROM SYS.SYSDUAL) UNION (SELECT 'LOCAL TEMPORARY' AS TABLE_TYPE FROM SYS.SYSDUAL) UNION (SELECT 'SYNONYM' AS TABLE_TYPE FROM SYS.SYSDUAL) ";
        return sql;
    }

    public String getTypeInfo() {
        String sql = "/*DMJDBC*/ select TYPEINFO.TYPE_NAME, TYPEINFO.DATA_TYPE, TYPEINFO.PRECISION, TYPEINFO.LITERAL_PREFIX, TYPEINFO.LITERAL_SUFFIX, TYPEINFO.CREATE_PARAMS, TYPEINFO.NULLABLE, TYPEINFO.CASE_SENSITIVE, TYPEINFO.SEARCHABLE,TYPEINFO.UNSIGNED_ATTRIBUTE, TYPEINFO.FIXED_PREC_SCALE, TYPEINFO.\"AUTO_INCREMENT\", TYPEINFO.LOCAL_TYPE_NAME, TYPEINFO.MINIMUM_SCALE, TYPEINFO.MAXIMUM_SCALE, TYPEINFO.SQL_DATA_TYPE, TYPEINFO.SQL_DATETIME_SUB, TYPEINFO.NUM_PREC_RADIX from (";
        sql = String.valueOf(sql) + "SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT TYPE_NAME AS TYPE_NAME,";
        sql = String.valueOf(sql) + " CASE DATA_TYPE WHEN 101 THEN 2000 WHEN 102 THEN 2000 WHEN 103 THEN 2000 WHEN 104 THEN 2000 WHEN 105 THEN 2000 WHEN 106 THEN 2000 WHEN 107 THEN 2000 WHEN 108 THEN 2000 WHEN 109 THEN 2000 WHEN 110 THEN 2000 WHEN 111 THEN 2000 WHEN 112 THEN 2000 WHEN 113 THEN 2000 ELSE DATA_TYPE END AS DATA_TYPE,";
        sql = String.valueOf(sql) + " COLUMN_SIZE AS \"PRECISION\",LITERAL_PREFIX AS LITERAL_PREFIX,LITERAL_SUFFIX AS LITERAL_SUFFIX,CREATE_PARAMS AS CREATE_PARAMS,NULLABLE$ AS NULLABLE,CASE_SENSITIVE AS CASE_SENSITIVE,SEARCHABLE AS SEARCHABLE,UNSIGNED_ATTRIBUTE AS UNSIGNED_ATTRIBUTE,FIXED_PREC_SCALE AS FIXED_PREC_SCALE,AUTO_UNIQUE_VALUE AS \"AUTO_INCREMENT\",LOCAL_TYPE_NAME AS LOCAL_TYPE_NAME,MINIMUM_SCALE AS MINIMUM_SCALE,MAXIMUM_SCALE AS MAXIMUM_SCALE,NULL AS SQL_DATA_TYPE,NULL AS SQL_DATETIME_SUB,NUM_PREC_RADIX AS NUM_PREC_RADIX";
        sql = String.valueOf(sql) + " FROM SYS.SYSTYPEINFOS WHERE (TYPE_VERSION = 'O3' OR TYPE_VERSION = 'J3') AND TYPE_NAME <> 'double precision' AND TYPE_NAME <> 'image' AND TYPE_NAME <> 'text' AND TYPE_NAME <> 'money'";
        sql = String.valueOf(sql) + " ORDER BY DATA_TYPE) TYPEINFO;";
        return sql;
    }

    public String getCatalogs() {
        String sql = "/*DMJDBC*/ SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS TABLE_CAT FROM SYS.SYSDUAL WHERE 1=2;";
        return sql;
    }

    public String getSchemas() {
        String sql = "/*DMJDBC*/ SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NAME AS TABLE_SCHEM, NULL AS TABLE_CATALOG ";
        sql = String.valueOf(sql) + " FROM SYS.SYSOBJECTS USERS WHERE TYPE$='SCH' ";
        sql = String.valueOf(sql) + " ORDER BY TABLE_SCHEM ASC;";
        return sql;
    }

    public String getSchemas(List<Object> paramList, String catalog, String schemaPattern) {
        schemaPattern = StringUtil.isEmpty(schemaPattern) ? "%" : schemaPattern;
        String sql = "/*DMJDBC*/ SELECT DISTINCT NAME AS TABLE_SCHEM, NULL AS TABLE_CATALOG FROM SYS.SYSOBJECTS USERS WHERE TYPE$='SCH' ";
        if (!MetaSQL.containsEscape(schemaPattern)) {
            sql = String.valueOf(sql) + " AND NAME = ? ";
            paramList.add(schemaPattern);
        } else if (!schemaPattern.equals("%")) {
            sql = String.valueOf(sql) + " AND NAME LIKE ?  ESCAPE '!' ";
            paramList.add(schemaPattern);
        }
        sql = String.valueOf(sql) + " ORDER BY TABLE_SCHEM ASC;";
        return sql;
    }

    public String getTables(List<Object> paramList, String catalog, String schemaPattern, String tableNamePattern, String[] types) {
        schemaPattern = StringUtil.isEmpty(schemaPattern) ? "%" : schemaPattern;
        tableNamePattern = tableNamePattern == null ? "%" : tableNamePattern;
        StringBuilder sql = new StringBuilder("");
        sql.append("/*DMJDBC*/ SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS TABLE_CAT,SCHEMAS.NAME AS TABLE_SCHEM,TABS.NAME AS TABLE_NAME, CASE TABS.SUBTYPE$ WHEN 'UTAB' THEN 'TABLE' WHEN 'VIEW' THEN 'VIEW' WHEN 'STAB' THEN 'SYSTEM TABLE' WHEN 'SYNOM' THEN 'SYNONYM' END AS TABLE_TYPE, (SELECT COMMENT$ FROM SYS.SYSTABLECOMMENTS WHERE SCHNAME = SCHEMAS.NAME AND TVNAME = TABS.NAME) AS REMARKS, NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS SELF_REFERENCING_COL_NAME, NULL AS REF_GENERATION ");
        sql.append(" FROM");
        sql.append(this.schemaClause(paramList, schemaPattern, "SCHEMAS,"));
        sql.append(this.tableClause(paramList, tableNamePattern, types, "TABS"));
        sql.append(" WHERE TABS.SCHID = SCHEMAS.ID ");
        sql.append(" AND (SF_CHECK_PRIV_OPT(UID(), CURRENT_USERTYPE(), TABS.ID, SCHEMAS.PID, -1, TABS.ID) = 1) ");
        sql.append(" ORDER BY TABLE_TYPE ASC,TABLE_SCHEM ASC,TABLE_NAME ASC;");
        return sql.toString();
    }

    public String getTablePrivileges(List<Object> paramList, String catalog, String schemaPattern, String tableNamePattern) {
        schemaPattern = StringUtil.isEmpty(schemaPattern) ? "%" : schemaPattern;
        tableNamePattern = tableNamePattern == null ? "%" : tableNamePattern;
        StringBuilder sql = new StringBuilder();
        sql.append("/*DMJDBC*/ SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NULL AS TABLE_CAT,");
        sql.append("USERS.NAME AS TABLE_SCHEM, ");
        sql.append("TABS.NAME AS TABLE_NAME,");
        sql.append("GRANTORS.NAME AS GRANTOR,");
        sql.append("GRANTEES.NAME AS GRANTEE,");
        sql.append("SF_GET_SYS_PRIV(CAST (TVGRANTS.PRIVID AS INT)) AS PRIVILEGE,");
        sql.append("CASE TVGRANTS.GRANTABLE WHEN 'Y' THEN 'YES' WHEN 'N' THEN 'NO' END AS IS_GRANTABLE");
        sql.append(" FROM ");
        sql.append(this.schemaClause(paramList, schemaPattern, "USERS")).append(",");
        sql.append(this.utableClause(paramList, tableNamePattern, "TABS")).append(",");
        sql.append("(SELECT ID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'UR' AND SUBTYPE$ = 'USER')GRANTORS,");
        sql.append("(SELECT ID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'UR' AND SUBTYPE$ = 'USER')GRANTEES,");
        sql.append("(SELECT * FROM SYS.SYSGRANTS WHERE PRIVID <> -1 )TVGRANTS");
        sql.append(" WHERE");
        sql.append(" TABS.SCHID = USERS.ID AND ");
        sql.append(" TVGRANTS.OBJID = TABS.ID AND TVGRANTS.URID = GRANTEES.ID AND ");
        sql.append(" TVGRANTS.GRANTOR = GRANTORS.ID");
        sql.append(" ORDER BY  TABLE_SCHEM ASC, TABLE_NAME ASC,  PRIVILEGE ASC;");
        return sql.toString();
    }

    public String getColumns(List<Object> paramList, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) {
        schemaPattern = StringUtil.isEmpty(schemaPattern) ? "%" : schemaPattern;
        tableNamePattern = tableNamePattern == null ? "%" : tableNamePattern;
        columnNamePattern = columnNamePattern == null ? "%" : columnNamePattern;
        StringBuilder sql = new StringBuilder();
        sql.append("/*DMJDBC*/ SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT ");
        sql.append("NULL AS TABLE_CAT, ");
        sql.append("SCHS.NAME AS TABLE_SCHEM, ");
        sql.append("TABS.NAME AS TABLE_NAME, ");
        sql.append("COLS.NAME AS COLUMN_NAME, ");
        sql.append(this.makeDataTypeClause("COLS.TYPE$", "COLS.SCALE"));
        sql.append("AS DATA_TYPE,");
        sql.append(this.makeDataTypeNameClause("COLS.TYPE$"));
        sql.append("AS TYPE_NAME,");
        sql.append("CASE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) ");
        sql.append("WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END ");
        sql.append("AS COLUMN_SIZE,");
        sql.append("CASE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) ");
        sql.append("WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END ");
        sql.append("AS BUFFER_LENGTH,");
        sql.append("CASE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) ");
        sql.append("WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) END ");
        sql.append("AS DECIMAL_DIGITS,");
        sql.append("10 AS NUM_PREC_RADIX,");
        sql.append("CASE COLS.NULLABLE$ WHEN 'Y' THEN 1 ELSE 0 END AS NULLABLE,");
        sql.append("(SELECT COMMENT$ FROM SYS.SYSCOLUMNCOMMENTS WHERE SCHNAME=SCHS.NAME AND TVNAME=TABS.NAME AND COLNAME=COLS.NAME) AS REMARKS,");
        sql.append("COLS.DEFVAL AS COLUMN_DEF,");
        sql.append("0 AS SQL_DATA_TYPE,");
        sql.append("0 AS SQL_DATETIME_SUB,");
        sql.append("CASE SF_GET_OCT_LENGTH(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) ");
        sql.append("WHEN -2 THEN NULL ").append("ELSE SF_GET_OCT_LENGTH(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END ").append("AS CHAR_OCTET_LENGTH,");
        sql.append("COLS.COLID + 1 AS ORDINAL_POSITION,");
        sql.append("CASE COLS.NULLABLE$ WHEN 'Y' THEN 'YES' ELSE 'NO' END AS IS_NULLABLE,");
        sql.append("NULL AS SCOPE_CATALOG,");
        sql.append("NULL AS SCOPE_SCHEMA,");
        sql.append("NULL AS SCOPE_TABLE,");
        sql.append("0 AS SOURCE_DATA_TYPE, ");
        sql.append("CASE COLS.INFO2 & 0x01 WHEN 1 THEN 'YES' ELSE 'NO' END AS IS_AUTOINCREMENT, ");
        sql.append("CASE (select INFO1 & 0x01 from SYS.SYSCOLINFOS where ID = COLS.ID and COLID = COLS.COLID) WHEN 1 THEN 'YES' ELSE 'NO' END AS IS_GENERATEDCOLUMN ");
        sql.append("FROM ");
        sql.append(this.schemaClause(paramList, schemaPattern, "SCHS"));
        sql.append(", ");
        sql.append(this.tableClause(paramList, tableNamePattern, "TABS"));
        sql.append(", ");
        sql.append(this.argClause(paramList, columnNamePattern, "COLS"));
        sql.append(" WHERE TABS.ID = COLS.ID AND SCHS.ID = TABS.SCHID ");
        sql.append(" ORDER BY TABLE_SCHEM ASC,TABLE_NAME ASC,ORDINAL_POSITION ASC;");
        return sql.toString();
    }

    public String getColumnPrivileges(List<Object> paramList, String catalog, String schema, String table, String columnNamePattern) {
        schema = StringUtil.isEmpty(schema) ? this.currentSchema : schema;
        table = table == null ? "%" : table;
        columnNamePattern = columnNamePattern == null ? "%" : columnNamePattern;
        StringBuilder sql = new StringBuilder();
        sql.append("/*DMJDBC*/ SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NULL AS TABLE_CAT,");
        sql.append("SCHEMAS.NAME AS TABLE_SCHEM,");
        sql.append("TABS.NAME AS TABLE_NAME, ");
        sql.append("COLS.NAME AS COLUMN_NAME, ");
        sql.append("GRANTORS.NAME AS GRANTOR,");
        sql.append("GRANTEES.NAME AS GRANTEE,");
        sql.append("SF_GET_SYS_PRIV(CAST (COLGRANTS.PRIVID AS INT)) AS PRIVILEGE, ");
        sql.append("CASE COLGRANTS.GRANTABLE WHEN 'Y' THEN 'YES' WHEN 'N' THEN 'NO' END AS IS_GRANTABLE ");
        sql.append("FROM SYS.SYSGRANTS COLGRANTS, ");
        sql.append(this.argClause(paramList, columnNamePattern, "COLS")).append(",");
        sql.append("SYS.SYSOBJECTS GRANTORS, ");
        sql.append("(SELECT ID, NAME FROM SYS.SYSOBJECTS WHERE SUBTYPE$='USER' OR SUBTYPE$='ROLE') GRANTEES,");
        sql.append(this.schemaEqualClause(paramList, schema, "SCHEMAS")).append(",");
        sql.append(this.utableEqualClause(paramList, table, "TABS"));
        sql.append(" WHERE TABS.SCHID = SCHEMAS.ID");
        sql.append(" AND COLGRANTS.OBJID = TABS.ID ");
        sql.append(" AND COLGRANTS.GRANTOR = GRANTORS.ID AND COLGRANTS.URID = GRANTEES.ID AND ");
        sql.append("COLGRANTS.COLID = COLS.COLID AND COLGRANTS.OBJID = COLS.ID");
        sql.append(" ORDER BY COLUMN_NAME ASC,PRIVILEGE ASC;");
        return sql.toString();
    }

    public String getPkgProcedures(List<Object> paramList, String schemaPattern, String pkgPattern, String procedureNamePattern, int procType) {
        schemaPattern = schemaPattern == null ? "%" : schemaPattern;
        pkgPattern = pkgPattern == null ? "%" : pkgPattern;
        procedureNamePattern = procedureNamePattern == null ? "%" : procedureNamePattern;
        StringBuilder sql = new StringBuilder("");
        sql.append("/*DMJDBC*/ SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT ");
        sql.append("PACKAGES.NAME AS PROCEDURE_CAT,");
        sql.append("SCHEMAS.NAME AS PROCEDURE_SCHEM,");
        sql.append("PKGPROCS.MTDNAME AS PROCEDURE_NAME,");
        sql.append("'RESERVED1' AS RESERVED1,'RESERVED2' AS RESERVED2,'RESERVED3' AS RESERVED3, NULL AS REMARKS, CASE PKGPROCS.IS_PROC WHEN 'Y' THEN 1 ELSE  2 END AS PROCEDURE_TYPE");
        sql.append(" FROM ");
        sql.append(this.schemaClause(paramList, schemaPattern, "SCHEMAS,"));
        sql.append(this.pkgClause(paramList, pkgPattern, "PACKAGES,"));
        sql.append(this.pkgprocClause(paramList, pkgPattern, procedureNamePattern, procType, "PKGPROCS"));
        sql.append(" WHERE PKGPROCS.PKGID = PACKAGES.ID AND PACKAGES.SCHID = SCHEMAS.ID");
        sql.append(" ORDER BY PROCEDURE_SCHEM ASC, PROCEDURE_CAT ASC, PROCEDURE_NAME ASC;");
        return sql.toString();
    }

    public String getPrimaryKeys(List<Object> paramList, String catalog, String schema, String table) {
        schema = StringUtil.isEmpty(schema) ? this.currentSchema : schema;
        table = table == null ? "%" : table;
        StringBuilder sql = new StringBuilder();
        sql.append("/*DMJDBC*/ SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS TABLE_CAT,");
        sql.append("SCHEMAS.NAME AS TABLE_SCHEM,");
        sql.append("TAB.NAME AS TABLE_NAME,COLS.NAME AS COLUMN_NAME,SF_GET_INDEX_KEY_SEQ(INDS.KEYNUM, INDS.KEYINFO, COLS.COLID) AS KEY_SEQ,");
        if (this.compatibleOracle) {
            sql.append(" OBJ_INDS.NAME AS PK_NAME, ");
        } else {
            sql.append(" CONS.NAME AS PK_NAME, ");
        }
        sql.append(" COLS.ID TABID, COLS.COLID COLID ");
        sql.append(" FROM");
        sql.append(" SYS.SYSINDEXES INDS,");
        sql.append("(SELECT OBJ.NAME, CON.ID, CON.TYPE$, CON.TABLEID, CON.COLID, CON.INDEXID FROM SYS.SYSCONS AS CON, SYS.SYSOBJECTS AS OBJ WHERE CON.TYPE$ = 'P' AND OBJ.SUBTYPE$='CONS' AND OBJ.ID=CON.ID) CONS,");
        sql.append("SYS.SYSCOLUMNS COLS,");
        sql.append(this.schemaEqualClause(paramList, schema, "SCHEMAS")).append(",");
        sql.append(this.utableEqualClause(paramList, table, "TAB")).append(",");
        sql.append("(SELECT ID, NAME FROM SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX')OBJ_INDS");
        sql.append(" WHERE SCHEMAS.ID = TAB.SCHID AND CONS.INDEXID=INDS.ID AND INDS.ID=OBJ_INDS.ID AND TAB.ID=COLS.ID AND CONS.TABLEID=TAB.ID AND SF_COL_IS_IDX_KEY(INDS.KEYNUM, INDS.KEYINFO,COLS.COLID)=1");
        sql.append("ORDER BY COLUMN_NAME ASC");
        return sql.toString();
    }

    public String getBestRowIdentifier(List<Object> paramList, List<String> pkTabids, List<String> pkColids, int scope) throws SQLException {
        StringBuilder sql = new StringBuilder();
        String tabid = StringUtil.join(pkTabids.toArray(), ", ");
        String colid = StringUtil.join(pkColids.toArray(), ", ");
        sql.append("/*DMJDBC*/ SELECT /*+ MAX_OPT_N_TABLES(5) */ '").append(scope).append("' as \"SCOPE\",COLS.NAME AS COLUMN_NAME,").append(this.makeDataTypeClause("COLS.TYPE$", "COLS.SCALE")).append("AS DATA_TYPE, ").append(this.makeDataTypeNameClause("COLS.TYPE$")).append("AS TYPE_NAME, ");
        sql.append("CASE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END AS COLUMN_SIZE,CASE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END AS BUFFER_LENGTH,CASE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) END AS DECIMAL_DIGITS,0 AS PSEUDO_COLUMN");
        sql.append(" FROM SYS.SYSCOLUMNS COLS where COLS.ID in ( " + tabid + ") AND COLS.COLID in ( " + colid + ")");
        return sql.toString();
    }

    public String getBestRowIdentifier(List<Object> paramList, String catalog, String schema, String table, int scope, boolean nullable) {
        schema = StringUtil.isEmpty(schema) ? this.currentSchema : schema;
        table = table == null ? "%" : table;
        StringBuilder sql = new StringBuilder();
        sql.append("/*DMJDBC*/ select /*+ MAX_OPT_N_TABLES(5) */ '").append(scope).append("' as \"SCOPE\",'ROWID' as COLUMN_NAME,-2 as DATA_TYPE,'LONG' as TYPE_NAME,8 as COLUMN_SIZE,8 as BUFFER_LENGTH,0 as DECIMAL_DIGITS,0 as PSEUDO_COLUMN");
        sql.append(" FROM ");
        sql.append(this.schemaEqualClause(paramList, schema, "SCHEMAS")).append(",");
        sql.append(this.utableEqualClause(paramList, table, "TAB"));
        sql.append(" WHERE SCHEMAS.ID = TAB.SCHID ");
        return sql.toString();
    }

    public String getImportedKeys(List<Object> paramList, String catalog, String schema, String table) {
        schema = StringUtil.isEmpty(schema) ? this.currentSchema : schema;
        table = table == null ? "%" : table;
        String sql = "/*DMJDBC*/ SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS PKTABLE_CAT,T_REFED.SCHNAME AS PKTABLE_SCHEM, T_REFED.NAME AS PKTABLE_NAME, T_REFED.REFED_COL_NAME AS PKCOLUMN_NAME, NULL AS FKTABLE_CAT,T_REF.SCHNAME AS FKTABLE_SCHEM,T_REF.NAME AS FKTABLE_NAME, T_REF.REF_COL_NAME AS FKCOLUMN_NAME, T_REF.REF_KEYNO AS KEY_SEQ, SF_GET_UPD_RULE(T_REF.FACTION) AS UPDATE_RULE, SF_GET_DEL_RULE(T_REF.FACTION) AS DELETE_RULE, T_REF.REF_CONS_NAME AS FK_NAME, T_REFED.REFED_CONS_NAME AS PK_NAME, 0 AS DEFERRABILITY FROM (SELECT T_REF_TAB.NAME AS NAME, T_REF_TAB.SCHNAME AS SCHNAME, T_REF_CONS.FINDEXID AS REFED_ID, T_REF_CONS.NAME AS REF_CONS_NAME, SF_GET_INDEX_KEY_SEQ(T_REF_IND.KEYNUM, T_REF_IND.KEYINFO, T_REF_COL.COLID) AS REF_KEYNO, T_REF_COL.NAME AS REF_COL_NAME, T_REF_CONS.FACTION AS FACTION FROM (SELECT NAME, INDEXID, FINDEXID, TABLEID, FACTION, CONS.TYPE$ as TYPE FROM SYS.SYSCONS CONS, SYS.SYSOBJECTS OBJECTS WHERE CONS.ID = OBJECTS.ID) AS T_REF_CONS, (SELECT TABS.NAME AS NAME, TABS.ID, SCHEMAS.NAME AS SCHNAME FROM" + this.schemaEqualClause(paramList, schema, "SCHEMAS") + "," + this.utableEqualClause(paramList, table, "TABS") + " WHERE SCHEMAS.ID == TABS.SCHID)T_REF_TAB," + "SYS.SYSINDEXES AS T_REF_IND, " + "(SELECT ID, PID FROM SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REF_INDS_OBJ, " + "SYS.SYSCOLUMNS AS T_REF_COL " + "WHERE " + "T_REF_TAB.ID = T_REF_CONS.TABLEID AND T_REF_CONS.TYPE='F' AND T_REF_TAB.ID = T_REF_INDS_OBJ.PID AND T_REF_TAB.ID = T_REF_COL.ID " + "AND T_REF_CONS.INDEXID = T_REF_INDS_OBJ.ID AND T_REF_IND.ID = T_REF_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REF_IND.KEYNUM, T_REF_IND.KEYINFO, T_REF_COL.COLID)=1) AS T_REF, " + "(SELECT T_REFED_CONS.INDEXID AS REFED_ID, T_REFED_TAB.SCH_NAME AS SCHNAME, " + "T_REFED_TAB.TAB_NAME AS NAME, T_REFED_IND.ID AS REFED_IND_ID, " + "T_REFED_CONS.NAME AS REFED_CONS_NAME, SF_GET_INDEX_KEY_SEQ(T_REFED_IND.KEYNUM, T_REFED_IND.KEYINFO, T_REFED_COL.COLID) AS REFED_KEYNO, " + "T_REFED_COL.NAME AS REFED_COL_NAME FROM " + "(SELECT NAME, INDEXID, FINDEXID, TABLEID, FACTION, CONS.TYPE$ as TYPE FROM SYS.SYSCONS CONS, SYS.SYSOBJECTS OBJECTS WHERE CONS.ID = OBJECTS.ID) AS T_REFED_CONS, " + "(SELECT TAB.ID AS ID, TAB.NAME AS TAB_NAME, SCH.NAME AS SCH_NAME FROM " + "SYS.SYSOBJECTS TAB, " + "SYS.SYSOBJECTS SCH WHERE TAB.SUBTYPE$='UTAB' AND SCH.TYPE$='SCH' AND TAB.SCHID=SCH.ID) AS T_REFED_TAB, " + "SYS.SYSINDEXES AS T_REFED_IND, (SELECT ID, PID, NAME FROM " + "SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REFED_INDS_OBJ, " + "SYS.SYSCOLUMNS AS T_REFED_COL WHERE " + "T_REFED_TAB.ID = T_REFED_CONS.TABLEID AND T_REFED_CONS.TYPE='P' AND T_REFED_TAB.ID = T_REFED_INDS_OBJ.PID AND T_REFED_TAB.ID = T_REFED_COL.ID" + " AND T_REFED_CONS.INDEXID = T_REFED_INDS_OBJ.ID AND T_REFED_IND.ID = T_REFED_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REFED_IND.KEYNUM, T_REFED_IND.KEYINFO, T_REFED_COL.COLID)=1) AS T_REFED " + "WHERE T_REF.REFED_ID = T_REFED.REFED_ID AND T_REF.REF_KEYNO = T_REFED.REFED_KEYNO " + "ORDER BY FKTABLE_CAT ASC, FKTABLE_SCHEM ASC, FKTABLE_NAME ASC, KEY_SEQ ASC";
        return sql;
    }

    public String getExportedKeys(List<Object> paramList, String catalog, String schema, String table) {
        schema = StringUtil.isEmpty(schema) ? this.currentSchema : schema;
        table = table == null ? "%" : table;
        String sql = "/*DMJDBC*/ SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS PKTABLE_CAT,T_REFED.SCHNAME AS PKTABLE_SCHEM,T_REFED.NAME AS PKTABLE_NAME, T_REFED.REFED_COL_NAME AS PKCOLUMN_NAME, NULL AS FKTABLE_CAT, T_REF.REF_SCH_NAME AS FKTABLE_SCHEM, T_REF.REF_TAB_NAME AS FKTABLE_NAME, T_REF.REF_COL_NAME AS FKCOLUMN_NAME, T_REF.REF_KEYNO AS KEY_SEQ, SF_GET_UPD_RULE(T_REF.FACTION) AS UPDATE_RULE, SF_GET_DEL_RULE(T_REF.FACTION) AS DELETE_RULE, (SELECT NAME FROM SYS.SYSOBJECTS WHERE ID = T_REF.REF_CONS_ID) AS FK_NAME, (SELECT NAME FROM SYS.SYSOBJECTS WHERE ID = T_REFED.REFED_CONS_ID) AS PK_NAME, 0 AS DEFERRABILITY FROM (SELECT T_REF_TAB.SCH_NAME AS REF_SCH_NAME, T_REF_TAB.TAB_NAME AS REF_TAB_NAME, T_REF_CONS.ID AS REF_CONS_ID, SF_GET_INDEX_KEY_SEQ(T_REF_IND.KEYNUM, T_REF_IND.KEYINFO, T_REF_COL.COLID) AS REF_KEYNO, T_REF_COL.NAME AS REF_COL_NAME, T_REF_CONS.FINDEXID AS REFED_ID, T_REF_CONS.FACTION AS FACTION FROM SYS.SYSCONS AS T_REF_CONS, (SELECT TAB.ID AS ID, TAB.NAME AS TAB_NAME, SCH.NAME AS SCH_NAME FROM SYS.SYSOBJECTS TAB, SYS.SYSOBJECTS SCH WHERE TAB.SUBTYPE$='UTAB' AND SCH.TYPE$='SCH' AND TAB.SCHID=SCH.ID) AS T_REF_TAB, SYS.SYSINDEXES AS T_REF_IND,(SELECT ID, PID, NAME FROM SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REF_INDS_OBJ, SYS.SYSCOLUMNS AS T_REF_COL WHERE T_REF_TAB.ID = T_REF_CONS.TABLEID AND T_REF_CONS.TYPE$='F' AND T_REF_TAB.ID = T_REF_INDS_OBJ.PID AND T_REF_TAB.ID = T_REF_COL.ID AND T_REF_CONS.INDEXID = T_REF_INDS_OBJ.ID AND T_REF_IND.ID = T_REF_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REF_IND.KEYNUM, T_REF_IND.KEYINFO, T_REF_COL.COLID)=1) AS T_REF, (SELECT T_REFED_TAB.NAME AS NAME, T_REFED_TAB.SCHNAME AS SCHNAME, T_REFED_CONS.ID AS REFED_CONS_ID, SF_GET_INDEX_KEY_SEQ(T_REFED_IND.KEYNUM, T_REFED_IND.KEYINFO, T_REFED_COL.COLID) AS REFED_KEYNO, T_REFED_COL.NAME AS REFED_COL_NAME, T_REFED_CONS.INDEXID AS REFED_ID FROM SYS.SYSCONS AS T_REFED_CONS, (SELECT TABS.NAME AS NAME, TABS.ID AS ID, SCHEMAS.NAME AS SCHNAME  FROM " + this.schemaEqualClause(paramList, schema, "SCHEMAS") + "," + this.utableEqualClause(paramList, table, "TABS") + " WHERE TABS.SCHID = SCHEMAS.ID" + ") AS T_REFED_TAB, " + "SYS.SYSINDEXES AS T_REFED_IND, " + "(SELECT ID, PID, NAME FROM " + "SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REFED_INDS_OBJ, " + "SYS.SYSCOLUMNS AS T_REFED_COL WHERE " + "T_REFED_TAB.ID = T_REFED_CONS.TABLEID AND T_REFED_CONS.TYPE$='P' AND T_REFED_TAB.ID = T_REFED_INDS_OBJ.PID AND T_REFED_TAB.ID = T_REFED_COL.ID " + "AND T_REFED_CONS.INDEXID = T_REFED_INDS_OBJ.ID AND T_REFED_IND.ID = T_REFED_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REFED_IND.KEYNUM, T_REFED_IND.KEYINFO, T_REFED_COL.COLID)=1) AS T_REFED " + " WHERE T_REF.REFED_ID = T_REFED.REFED_ID AND " + "T_REF.REF_KEYNO = T_REFED.REFED_KEYNO ORDER BY FKTABLE_CAT ASC, " + "FKTABLE_SCHEM ASC, FKTABLE_NAME ASC, KEY_SEQ ASC";
        return sql;
    }

    public String getCrossReference(List<Object> paramList, String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) {
        parentSchema = StringUtil.isEmpty(parentSchema) ? this.currentSchema : parentSchema;
        parentTable = parentTable == null ? "" : parentTable;
        foreignSchema = StringUtil.isEmpty(foreignSchema) ? this.currentSchema : foreignSchema;
        foreignTable = foreignTable == null ? "" : foreignTable;
        String sql = "/*DMJDBC*/ SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS PKTABLE_CAT,T_REFED.SCHNAME AS PKTABLE_SCHEM,T_REFED.NAME AS PKTABLE_NAME,T_REFED.REFED_COL_NAME AS PKCOLUMN_NAME, NULL AS FKTABLE_CAT,T_REF.SCHNAME AS FKTABLE_SCHEM,T_REF.NAME AS FKTABLE_NAME,T_REF.REF_COL_NAME AS FKCOLUMN_NAME,T_REF.REF_KEYNO AS KEY_SEQ, SF_GET_UPD_RULE(FACTION) AS UPDATE_RULE, SF_GET_DEL_RULE(FACTION) AS DELETE_RULE,T_REF.REF_CONS_NAME AS FK_NAME,T_REFED.REFED_CONS_NAME AS PK_NAME,0 AS DEFERRABILITY FROM (SELECT T_REF_TAB.NAME AS NAME, T_REF_TAB.SCHNAME AS SCHNAME, T_REF_CONS.FINDEXID AS REFED_IND_ID,T_REF_INDS_OBJ.NAME AS REF_CONS_NAME, SF_GET_INDEX_KEY_SEQ(T_REF_INDS.KEYNUM, T_REF_INDS.KEYINFO, T_REF_COL.COLID) AS REF_KEYNO,T_REF_COL.NAME AS REF_COL_NAME, T_REF_CONS.FACTION AS FACTION FROM SYS.SYSCONS AS T_REF_CONS,(SELECT TABS.NAME AS NAME, TABS.ID AS ID, SCHEMAS.NAME AS SCHNAME FROM" + this.schemaEqualClause(paramList, foreignSchema, "SCHEMAS") + "," + this.utableEqualClause(paramList, foreignTable, "TABS") + " WHERE SCHEMAS.ID = TABS.SCHID)AS T_REF_TAB," + "SYS.SYSINDEXES AS T_REF_INDS, (SELECT ID, PID, NAME FROM " + "SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REF_INDS_OBJ, " + "SYS.SYSCOLUMNS AS T_REF_COL WHERE " + "T_REF_TAB.ID = T_REF_CONS.TABLEID AND T_REF_CONS.TYPE$='F' AND T_REF_TAB.ID = T_REF_INDS_OBJ.PID AND T_REF_TAB.ID = T_REF_COL.ID " + "AND T_REF_CONS.INDEXID = T_REF_INDS_OBJ.ID AND T_REF_INDS.ID = T_REF_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REF_INDS.KEYNUM, T_REF_INDS.KEYINFO, T_REF_COL.COLID)=1) AS T_REF, " + "(SELECT T_REFED_TAB.NAME AS NAME, T_REFED_TAB.SCHNAME AS SCHNAME, T_REFED_INDS.ID AS REFED_IND_ID,T_REFED_INDS_OBJ.NAME AS REFED_CONS_NAME, SF_GET_INDEX_KEY_SEQ(T_REFED_INDS.KEYNUM, T_REFED_INDS.KEYINFO, T_REFED_COL.COLID) AS REFED_KEYNO,T_REFED_COL.NAME AS REFED_COL_NAME FROM " + "SYS.SYSCONS AS T_REFED_CONS," + "(SELECT TABS.NAME AS NAME, TABS.ID AS ID, SCHEMAS.NAME AS SCHNAME FROM " + this.schemaEqualClause(paramList, parentSchema, "SCHEMAS") + "," + this.utableEqualClause(paramList, parentTable, "TABS") + " WHERE SCHEMAS.ID = TABS.SCHID) AS T_REFED_TAB," + "SYS.SYSINDEXES AS T_REFED_INDS, (SELECT ID, PID, NAME FROM " + "SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REFED_INDS_OBJ," + "SYS.SYSCOLUMNS AS T_REFED_COL WHERE " + "T_REFED_TAB.ID = T_REFED_CONS.TABLEID AND T_REFED_CONS.TYPE$='P' AND T_REFED_TAB.ID = T_REFED_INDS_OBJ.PID AND T_REFED_TAB.ID = T_REFED_COL.ID " + "AND T_REFED_CONS.INDEXID = T_REFED_INDS_OBJ.ID AND T_REFED_INDS.ID = T_REFED_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REFED_INDS.KEYNUM, T_REFED_INDS.KEYINFO, T_REFED_COL.COLID)=1) AS T_REFED" + " WHERE T_REF.REFED_IND_ID = T_REFED.REFED_IND_ID AND T_REF.REF_KEYNO = T_REFED.REFED_KEYNO ORDER BY FKTABLE_CAT ASC,FKTABLE_SCHEM ASC,FKTABLE_NAME ASC,KEY_SEQ ASC";
        return sql;
    }

    public String getIndexInfo(List<Object> paramList, String catalog, String schema, String table, boolean unique, boolean approximate) {
        schema = StringUtil.isEmpty(schema) ? this.currentSchema : schema;
        table = table == null ? "%" : table;
        StringBuilder sql = new StringBuilder();
        sql.append("/*DMJDBC*/ SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NULL");
        sql.append(" AS TABLE_CAT,USERS.NAME AS TABLE_SCHEM,TAB.NAME AS TABLE_NAME, ");
        sql.append("CASE INDS.ISUNIQUE WHEN 'Y' THEN 0 ELSE 1 END AS NON_UNIQUE, NULL AS INDEX_QUALIFIER, ");
        sql.append("OBJ_INDS.NAME AS INDEX_NAME, ");
        sql.append("CASE INDS.XTYPE & 0x01 WHEN 0 THEN 1 ");
        sql.append("ELSE 3 END AS \"TYPE\", ");
        sql.append("SF_GET_INDEX_KEY_SEQ(INDS.KEYNUM, INDS.KEYINFO, COLS.COLID) AS ORDINAL_POSITION, ");
        sql.append("COLS.NAME AS COLUMN_NAME, ");
        sql.append("SF_GET_INDEX_KEY_ORDER(INDS.KEYNUM, INDS.KEYINFO, COLS.COLID) AS ASC_OR_DESC, ");
        sql.append("0 AS CARDINALITY, 0 AS PAGES, NULL AS FILTER_CONDITION ");
        sql.append(" FROM ");
        sql.append(this.schemaEqualClause(paramList, schema, "USERS")).append(",");
        sql.append(this.utableEqualClause(paramList, table, "TAB")).append(",");
        sql.append("(SELECT ID, PID, NAME FROM SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS OBJ_INDS,");
        sql.append("SYS.SYSINDEXES AS INDS,");
        sql.append("SYS.SYSCOLUMNS AS COLS ");
        sql.append("WHERE TAB.ID=COLS.ID AND TAB.ID=OBJ_INDS.PID ");
        sql.append("AND INDS.ID=OBJ_INDS.ID AND TAB.SCHID = USERS.ID AND ");
        sql.append("SF_COL_IS_IDX_KEY(INDS.KEYNUM, INDS.KEYINFO, COLS.COLID)=1");
        if (unique) {
            sql.append(" AND INDS.ISUNIQUE = 'Y' ORDER BY NON_UNIQUE ASC,TYPE ASC,INDEX_NAME ASC,ORDINAL_POSITION ASC;");
        } else {
            sql.append(" ORDER BY NON_UNIQUE ASC,TYPE ASC,INDEX_NAME ASC,ORDINAL_POSITION ASC;");
        }
        return sql.toString();
    }

    public String getUDTs(List<Object> paramList, String catalog, String schemaPattern, String typeNamePattern, int[] types) {
        String sql = "/*DMJDBC*/ SELECT CAST(NULL AS VARCHAR(128)) AS TYPE_CAT, CAST(NULL AS VARCHAR(128)) AS TYPE_SCHEM, CAST(NULL AS VARCHAR(128)) AS TYPE_NAME, CAST(NULL AS VARCHAR(128)) AS CLASS_NAME, CAST(NULL AS INT) AS DATA_TYPE, CAST(NULL AS VARCHAR(1024)) AS REMARKS, CAST(NULL AS SMALLINT) AS BASE_TYPE FROM DUAL WHERE 1 = 2";
        return sql;
    }

    public String getSuperTypes(List<Object> paramList, String catalog, String schemaPattern, String typeNamePattern) {
        String sql = "/*DMJDBC*/ SELECT CAST(NULL AS VARCHAR(128)) AS TYPE_CAT, CAST(NULL AS VARCHAR(128)) AS TYPE_SCHEM, CAST(NULL AS VARCHAR(128)) AS TYPE_NAME, CAST(NULL AS VARCHAR(128)) AS SUPERTYPE_CAT,CAST(NULL AS VARCHAR(128)) AS SUPERTYPE_SCHEM,CAST(NULL AS VARCHAR(128)) AS SUPERTYPE_NAME FROM DUAL WHERE 1 = 2";
        return sql;
    }

    public String getSuperTables(List<Object> paramList, String catalog, String schemaPattern, String tableNamePattern) {
        String sql = "/*DMJDBC*/ SELECT CAST(NULL AS VARCHAR(128))  AS TABLE_CAT,CAST(NULL AS VARCHAR(128)) AS TABLE_SCHEM,CAST(NULL AS VARCHAR(128)) AS TABLE_NAME,CAST(NULL AS VARCHAR(128)) AS SUPERTABLE_NAME FROM DUAL WHERE 1 = 2";
        return sql;
    }

    public String getProcedureColumns(List<Object> paramList, String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) {
        if (this.compatibleOracle && StringUtil.isNotEmpty(catalog)) {
            return this.getPkgProcedureColumns(paramList, schemaPattern, catalog, procedureNamePattern, columnNamePattern, 0);
        }
        schemaPattern = StringUtil.isEmpty(schemaPattern) ? "%" : schemaPattern;
        procedureNamePattern = procedureNamePattern == null ? "%" : procedureNamePattern;
        columnNamePattern = columnNamePattern == null ? "%" : columnNamePattern;
        StringBuilder sql = new StringBuilder();
        sql.append("/*DMJDBC*/ SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT ");
        sql.append("NULL AS PROCEDURE_CAT,");
        sql.append("SCHEMAS.NAME AS PROCEDURE_SCHEM,");
        sql.append("PROCS.NAME AS PROCEDURE_NAME,");
        if (this.compatibleOracle) {
            sql.append("CASE ARG.INFO1 WHEN 3 THEN NULL ELSE ARG.NAME END AS COLUMN_NAME, ");
        } else {
            sql.append("ARG.NAME AS COLUMN_NAME,");
        }
        sql.append("CASE ARG.INFO1 WHEN 0 THEN 1 WHEN 1 THEN 4 WHEN 2 THEN 2 WHEN 3 THEN 5 END AS COLUMN_TYPE, ");
        sql.append(this.makeDataTypeClause("ARG.TYPE$", "ARG.SCALE"));
        sql.append("AS DATA_TYPE, ");
        sql.append(this.makeDataTypeNameClause("ARG.TYPE$"));
        sql.append("AS TYPE_NAME, ");
        sql.append("CASE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) ");
        sql.append("WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END ");
        sql.append("AS \"PRECISION\", ");
        sql.append("CASE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) ");
        sql.append("WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END ");
        sql.append("AS LENGTH, ");
        sql.append("CASE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) ");
        sql.append("WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) END ");
        sql.append("AS SCALE, ");
        sql.append("10 AS RADIX, ");
        sql.append("1 AS NULLABLE, ");
        sql.append("NULL AS REMARKS, ");
        sql.append("ARG.DEFVAL AS COLUMN_DEF, ");
        sql.append("NULL AS SQL_DATA_TYPE, ");
        sql.append("NULL AS SQL_DATETIME_SUB, ");
        sql.append("NULL AS CHAR_OCTET_LENGTH, ");
        sql.append("ARG.COLID AS ORDINAL_POSITION, ");
        sql.append("CASE ARG.NULLABLE$ WHEN 'Y' THEN 'YES' ELSE 'NO' END AS IS_NULLABLE, ");
        sql.append("NULL AS SPECIFIC_NAME ");
        sql.append("FROM ");
        sql.append(this.schemaClause(paramList, schemaPattern, "SCHEMAS")).append(",");
        sql.append(MetaSQL.procClause(paramList, procedureNamePattern, "PROCS", this.compatibleOracle)).append(",");
        sql.append(this.argClause(paramList, columnNamePattern, "ARG"));
        sql.append(" WHERE SCHEMAS.ID = PROCS.SCHID AND PROCS.ID = ARG.ID ");
        sql.append(" ORDER BY PROCEDURE_SCHEM ASC,PROCEDURE_NAME ASC, ORDINAL_POSITION ASC;");
        return sql.toString();
    }

    public String getFunctionColumns(List<Object> paramList, String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) {
        if (this.compatibleOracle && StringUtil.isNotEmpty(catalog)) {
            return this.getPkgProcedureColumns(paramList, schemaPattern, catalog, functionNamePattern, columnNamePattern, 2);
        }
        catalog = catalog == null ? catalog : catalog.trim();
        schemaPattern = StringUtil.isEmpty(schemaPattern) ? "%" : schemaPattern;
        functionNamePattern = functionNamePattern == null ? "%" : functionNamePattern;
        columnNamePattern = columnNamePattern == null ? "%" : columnNamePattern;
        StringBuilder sql = new StringBuilder();
        sql.append("/*DMJDBC*/ SELECT DISTINCT ");
        if (catalog == null) {
            sql.append("NULL");
        } else {
            sql.append("'").append(catalog).append("'");
        }
        sql.append(" AS FUNCTION_CAT,");
        sql.append("USERS.NAME AS FUNCTION_SCHEM,");
        sql.append("FUNCS.NAME AS FUNCTION_NAME,");
        if (this.compatibleOracle) {
            sql.append("CASE ARG.INFO1 WHEN 3 THEN NULL ELSE ARG.NAME END AS COLUMN_NAME, ");
        } else {
            sql.append("ARG.NAME AS COLUMN_NAME,");
        }
        sql.append("CASE ARG.INFO1 WHEN 0 THEN 1 WHEN 1 THEN 3 WHEN 2 THEN 2 WHEN 3 THEN 4 END AS COLUMN_TYPE,");
        sql.append(this.makeDataTypeClause("ARG.TYPE$", "ARG.SCALE"));
        sql.append("AS DATA_TYPE,");
        sql.append(this.makeDataTypeNameClause("ARG.TYPE$"));
        sql.append("AS TYPE_NAME,");
        sql.append("CASE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END AS \"PRECISION\",");
        sql.append("CASE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END AS LENGTH,");
        sql.append("CASE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) END AS SCALE,");
        sql.append("10 AS RADIX,");
        sql.append("1 AS NULLABLE,");
        sql.append("NULL AS REMARKS, ");
        sql.append("CASE SF_GET_OCT_LENGTH(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_OCT_LENGTH(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END AS CHAR_OCTET_LENGTH, ");
        sql.append("CASE ARG.INFO1 WHEN 3 THEN 0 ELSE ARG.COLID + 1 END AS ORDINAL_POSITION, ");
        sql.append("CASE ARG.NULLABLE$ WHEN 'Y' THEN 'YES' ELSE 'NO' END AS IS_NULLABLE, ");
        sql.append("FUNCS.NAME AS SPECIFIC_NAME, ");
        sql.append("ARG.COLID ");
        sql.append(" FROM ");
        sql.append(this.schemaClause(paramList, schemaPattern, "USERS")).append(",");
        sql.append(MetaSQL.funcClause(paramList, functionNamePattern, "FUNCS")).append(",");
        sql.append(this.argClause(paramList, columnNamePattern, "ARG"));
        sql.append(" WHERE USERS.ID = FUNCS.SCHID AND FUNCS.ID = ARG.ID");
        sql.append(" ORDER BY FUNCTION_SCHEM ASC,FUNCTION_NAME ASC, ARG.COLID ASC;");
        return sql.toString();
    }

    public String getClientInfoProperties() {
        StringBuilder sql = new StringBuilder("/*DMJDBC*/ declare \ntype RowVal is record (NAME varchar, MAX_LEN int, DEFAULT_VALUE varchar, DESCRIPTION varchar); \ntype RowVals is array RowVal[];\nr RowVal; \nrs RowVals;\n");
        sql.append("begin \n");
        sql.append("rs = new RowVal[").append(Configuration.values().size()).append("]; \n");
        int index = 1;
        for (Configuration prop : Configuration.values()) {
            sql.append("r.name = '").append(prop.getName()).append("';\n");
            sql.append("r.max_len = 128;\n");
            sql.append("r.default_value = '").append(prop.getDefault()).append("';\n");
            sql.append("r.description = '").append(StringUtil.processSingleQuoteOfName(prop.getDescription())).append("';\n");
            sql.append("rs[").append(index).append("] = r;\n");
            ++index;
        }
        sql.append("select * from array rs;\n");
        sql.append("end;");
        return sql.toString();
    }

    public String getVersionColumns(List<Object> paramList, String catalog, String schema, String table) {
        String sql = "";
        sql = String.valueOf(sql) + "/*DMJDBC*/ SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NULL AS \"SCOPE\",COLS.NAME AS COLUMN_NAME, ";
        sql = String.valueOf(sql) + this.makeDataTypeClause("COLS.TYPE$", "COLS.SCALE") + "AS DATA_TYPE, ";
        sql = String.valueOf(sql) + this.makeDataTypeNameClause("COLS.TYPE$") + "AS TYPE_NAME, ";
        sql = String.valueOf(sql) + "CASE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END AS COLUMN_SIZE,CASE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END AS BUFFER_LENGTH,CASE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) END AS DECIMAL_DIGITS,0 AS PSEUDO_COLUMN";
        sql = String.valueOf(sql) + " FROM SYS.SYSCOLUMNS COLS WHERE 1 = 2;";
        return sql;
    }

    public String getProcedures(List<Object> paramList, String catalog, String schemaPattern, String procedureNamePattern) {
        schemaPattern = StringUtil.isEmpty(schemaPattern) ? "%" : schemaPattern;
        procedureNamePattern = procedureNamePattern == null ? "%" : procedureNamePattern;
        StringBuilder sql = new StringBuilder("");
        sql.append("/*DMJDBC*/ SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NULL AS PROCEDURE_CAT,");
        sql.append("SCHEMAS.NAME AS PROCEDURE_SCHEM,");
        sql.append("PROCS.NAME AS PROCEDURE_NAME,");
        sql.append("'RESERVED1' AS RESERVED1,'RESERVED2' AS RESERVED2,'RESERVED3' AS RESERVED3, NULL AS REMARKS, 1 AS PROCEDURE_TYPE, ");
        sql.append("NULL AS SPECIFIC_NAME ");
        sql.append(" FROM ");
        sql.append(this.schemaClause(paramList, schemaPattern, "SCHEMAS")).append(",");
        sql.append(MetaSQL.procClause(paramList, procedureNamePattern, "PROCS", this.compatibleOracle));
        sql.append(" WHERE SCHEMAS.ID = PROCS.SCHID");
        sql.append(" ORDER BY PROCEDURE_SCHEM ASC,PROCEDURE_NAME ASC;");
        return sql.toString();
    }

    public String getFunctions(List<Object> paramList, String catalog, String schemaPattern, String functionNamePattern) {
        catalog = catalog == null ? catalog : catalog.trim();
        schemaPattern = StringUtil.isEmpty(schemaPattern) ? "%" : schemaPattern;
        functionNamePattern = functionNamePattern == null ? "%" : functionNamePattern;
        StringBuilder sql = new StringBuilder("");
        sql.append("/*DMJDBC*/ SELECT DISTINCT ");
        if (catalog == null) {
            sql.append("NULL");
        } else {
            sql.append(" ? ");
            paramList.add(catalog);
        }
        sql.append(" AS FUNCTION_CAT, SCHEMAS.NAME AS FUNCTION_SCHEM, FUNCS.NAME AS FUNCTION_NAME, NULL AS REMARKS, 2 AS FUNCTION_TYPE, FUNCS.NAME AS SPECIFIC_NAME");
        sql.append(" FROM ");
        sql.append(MetaSQL.funcClause(paramList, functionNamePattern, "FUNCS")).append(",");
        sql.append(this.schemaClause(paramList, schemaPattern, "SCHEMAS"));
        sql.append(" WHERE SCHEMAS.ID = FUNCS.SCHID");
        sql.append(" ORDER BY FUNCTION_SCHEM ASC,FUNCTION_NAME ASC;");
        return sql.toString();
    }

    private String getPkgProcedureColumns(List<Object> paramList, String schemaPattern, String pkgPattern, String procedureNamePattern, String columnNamePattern, int procType) {
        schemaPattern = schemaPattern == null ? "%" : schemaPattern;
        pkgPattern = pkgPattern == null ? "%" : pkgPattern;
        procedureNamePattern = procedureNamePattern == null ? "%" : procedureNamePattern;
        columnNamePattern = columnNamePattern == null ? "%" : columnNamePattern;
        StringBuilder sql = new StringBuilder("");
        sql.append("/*DMJDBC*/ SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT ");
        sql.append("PACKAGES.NAME AS PROCEDURE_CAT,");
        sql.append("SCHEMAS.NAME AS PROCEDURE_SCHEM,");
        sql.append("PROCS.MTDNAME AS PROCEDURE_NAME,");
        sql.append("CASE TRIM(ARG.IOFLAG) WHEN 'R' THEN NULL ELSE ARG.NAME END AS COLUMN_NAME, ");
        sql.append("CASE TRIM(ARG.IOFLAG)");
        sql.append(" WHEN 'I' THEN 1");
        sql.append(" WHEN 'O' THEN 4");
        sql.append(" WHEN 'IO' THEN 2");
        sql.append(" WHEN 'R' THEN 5");
        sql.append(" END AS COLUMN_TYPE, ");
        sql.append(this.makeDataTypeClause("ARG.TYPE$", "ARG.SCALE"));
        sql.append("AS DATA_TYPE, ");
        sql.append(this.makeDataTypeNameClause("ARG.TYPE$"));
        sql.append("AS TYPE_NAME, ");
        sql.append("CASE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) ");
        sql.append("WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END ");
        sql.append("AS \"PRECISION\", ");
        sql.append("CASE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) ");
        sql.append("WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END ");
        sql.append("AS LENGTH, ");
        sql.append("CASE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) ");
        sql.append("WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) END ");
        sql.append("AS SCALE, ");
        sql.append("10 AS RADIX, ");
        sql.append("1 AS NULLABLE, ");
        sql.append("NULL AS REMARKS, ");
        sql.append("ARG.DEFVAL AS COLUMN_DEF, ");
        sql.append("NULL AS SQL_DATA_TYPE, ");
        sql.append("NULL AS SQL_DATETIME_SUB, ");
        sql.append("NULL AS CHAR_OCTET_LENGTH, ");
        sql.append("ARG.PARAMID AS ORDINAL_POSITION, ");
        sql.append("CASE ARG.NULLABLE WHEN 'Y' THEN 'YES' ELSE 'NO' END AS IS_NULLABLE, ");
        sql.append("NULL AS SPECIFIC_NAME ");
        sql.append("FROM");
        sql.append(this.schemaClause(paramList, schemaPattern, "SCHEMAS")).append(",");
        sql.append(this.pkgClause(paramList, pkgPattern, "PACKAGES")).append(",");
        sql.append(this.pkgprocClause(paramList, pkgPattern, procedureNamePattern, procType, "PROCS")).append(",");
        sql.append(this.pkgprocargClause(paramList, columnNamePattern, "ARG"));
        sql.append(" WHERE");
        sql.append(" PROCS.PKGID = PACKAGES.ID");
        sql.append(" AND PACKAGES.SCHID = SCHEMAS.ID");
        sql.append(" AND ARG.PKGID = PROCS.PKGID");
        sql.append(" AND ARG.MTDID = PROCS.MTDID");
        sql.append(" ORDER BY PROCEDURE_SCHEM ASC, PROCEDURE_CAT ASC, PROCEDURE_NAME ASC, ORDINAL_POSITION ASC;");
        return sql.toString();
    }

    private String makeDataTypeClause(String typeColName, String scaleColName) {
        StringBuilder sBuffer = new StringBuilder();
        sBuffer.append("CASE ").append(typeColName);
        sBuffer.append(" WHEN 'BOOL' THEN 16");
        sBuffer.append(" WHEN 'BOOLEAN' THEN 16");
        sBuffer.append(" WHEN 'BIT' THEN -7");
        sBuffer.append(" WHEN 'NUMBER' THEN 3");
        sBuffer.append(" WHEN 'NUMERIC' THEN 3");
        sBuffer.append(" WHEN 'DEC' THEN 3");
        sBuffer.append(" WHEN 'DECIMAL' THEN 3");
        if (this.compatibleOracle) {
            sBuffer.append(" WHEN 'INT' THEN 3");
            sBuffer.append(" WHEN 'INTEGER' THEN 3");
            sBuffer.append(" WHEN 'BIGINT' THEN 3");
            sBuffer.append(" WHEN 'TINYINT' THEN 3");
            sBuffer.append(" WHEN 'SMALLINT' THEN 3");
        } else {
            sBuffer.append(" WHEN 'INT' THEN 4");
            sBuffer.append(" WHEN 'INTEGER' THEN 4");
            sBuffer.append(" WHEN 'BIGINT' THEN -5");
            sBuffer.append(" WHEN 'TINYINT' THEN -6");
            sBuffer.append(" WHEN 'SMALLINT' THEN 5");
        }
        sBuffer.append(" WHEN 'FLOAT' THEN 6");
        sBuffer.append(" WHEN 'DOUBLE' THEN 8");
        sBuffer.append(" WHEN 'REAL' THEN 7");
        sBuffer.append(" WHEN 'DOUBLE PRECISION' THEN 8");
        sBuffer.append(" WHEN 'CHARACTER' THEN 1");
        sBuffer.append(" WHEN 'VARCHAR' THEN 12");
        sBuffer.append(" WHEN 'VARCHAR2' THEN 12");
        sBuffer.append(" WHEN 'TEXT' THEN -1");
        sBuffer.append(" WHEN 'LONGVARCHAR' THEN -1");
        sBuffer.append(" WHEN 'CLOB' THEN 2005");
        sBuffer.append(" WHEN 'BYTE' THEN -6");
        sBuffer.append(" WHEN 'BINARY' THEN -2");
        sBuffer.append(" WHEN 'VARBINARY' THEN -3");
        sBuffer.append(" WHEN 'LONGVARBINARY' THEN -4");
        sBuffer.append(" WHEN 'BLOB' THEN 2004");
        sBuffer.append(" WHEN 'IMAGE' THEN -4");
        sBuffer.append(" WHEN 'TIMESTAMP' THEN 93");
        sBuffer.append(" WHEN 'DATE' THEN 91");
        sBuffer.append(" WHEN 'TIME' THEN 92");
        sBuffer.append(" WHEN 'DATETIME' THEN 93");
        sBuffer.append(" WHEN 'CURSOR' THEN -10");
        sBuffer.append(" ELSE SF_GET_DATA_TYPE(").append(typeColName).append(", CAST(").append(scaleColName).append(" AS INT), 3)");
        sBuffer.append(" END ");
        return sBuffer.toString();
    }

    private String makeDataTypeNameClause(String typeColName) {
        if (this.compatibleOracle) {
            StringBuilder sb = new StringBuilder();
            sb.append("CASE ");
            sb.append("(CASE INSTR(" + typeColName + ",'CLASS',1,1) WHEN 0 THEN " + typeColName + " ELSE SF_GET_CLASS_NAME(" + typeColName + ") END)  ");
            sb.append("WHEN 'INT' THEN 'NUMBER' ");
            sb.append("WHEN 'INTEGER' THEN 'NUMBER' ");
            sb.append("WHEN 'BIGINT' THEN 'NUMBER' ");
            sb.append("WHEN 'TINYINT' THEN 'NUMBER' ");
            sb.append("WHEN 'SMALLINT' THEN 'NUMBER' ");
            sb.append("WHEN 'NUMERIC' THEN 'NUMBER' ");
            sb.append("WHEN 'DEC' THEN 'NUMBER' ");
            sb.append("WHEN 'DECIMAL' THEN 'NUMBER' ");
            sb.append("ELSE ");
            sb.append("(CASE INSTR(" + typeColName + ",'CLASS',1,1) WHEN 0 THEN " + typeColName + " ELSE SF_GET_CLASS_NAME(" + typeColName + ") END)  ");
            sb.append("END ");
            return sb.toString();
        }
        return "CASE INSTR(" + typeColName + ",'CLASS',1,1) WHEN 0 THEN " + typeColName + " ELSE SF_GET_CLASS_NAME(" + typeColName + ") END ";
    }

    private String makeTableTypeClause(String[] types) {
        StringBuilder typeClause = new StringBuilder();
        String retTypeClause = "(";
        String subpartitionClause = "CAST((INFO3 & 0x00FF & 0x003F) AS INT) not in ( 9, 27, 29, 25, 12,7, 21, 23, 18, 5) ";
        if (types != null) {
            String[] stringArray = types;
            int n2 = types.length;
            int n3 = 0;
            while (n3 < n2) {
                String type = stringArray[n3];
                if (type != null) {
                    if (type.equalsIgnoreCase("TABLE")) {
                        typeClause.append("OR (SUBTYPE$='UTAB' AND ").append(subpartitionClause).append(")");
                    } else if (type.equalsIgnoreCase("VIEW")) {
                        typeClause.append("OR SUBTYPE$='VIEW' ");
                    } else if (type.equalsIgnoreCase("SYSTEM TABLE")) {
                        typeClause.append("OR SUBTYPE$='STAB' ");
                    } else if (type.equalsIgnoreCase("SYNONYM")) {
                        typeClause.append("OR SUBTYPE$='SYNOM' ");
                    } else if (type.equalsIgnoreCase("GLOBAL TEMPORARY")) {
                        typeClause.append("OR ((info3 & 0x40) >> 6) =1 ");
                    } else if (type.equalsIgnoreCase("LOCAL TEMPORARY")) {
                        typeClause.append("OR ((info3 & 0x40) >> 6) =2 ");
                    }
                }
                ++n3;
            }
            if (typeClause.length() > 3) {
                retTypeClause = String.valueOf(retTypeClause) + typeClause.substring(3);
                retTypeClause = String.valueOf(retTypeClause) + ")";
                return retTypeClause;
            }
        } else {
            typeClause.append("( ");
            typeClause.append("(SUBTYPE$='UTAB' AND ").append(subpartitionClause).append(") ");
            typeClause.append("OR SUBTYPE$ in ('STAB', 'VIEW', 'SYNOM') ");
            typeClause.append(")");
            return typeClause.toString();
        }
        return null;
    }

    private String schemaClause(List<Object> paramList, String schemaPattern, String alias) {
        String schemaClause = "(SELECT ID, PID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCH'";
        if (!MetaSQL.containsEscape(schemaPattern)) {
            schemaClause = String.valueOf(schemaClause) + " AND NAME = ?";
            paramList.add(schemaPattern);
        } else if (!schemaPattern.equals("%")) {
            schemaClause = String.valueOf(schemaClause) + " AND NAME LIKE ?  ESCAPE '!' ";
            paramList.add(schemaPattern);
        }
        schemaClause = String.valueOf(schemaClause) + ") " + alias;
        return schemaClause;
    }

    private String schemaEqualClause(List<Object> paramList, String schema, String alias) {
        String schemaClause = "(SELECT ID, PID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCH' AND NAME = ?) " + alias;
        paramList.add(schema);
        return schemaClause;
    }

    private String pkgClause(List<Object> paramList, String pkgPattern, String alias) {
        String pkgClause = "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'PKG'";
        if (!MetaSQL.containsEscape(pkgPattern)) {
            pkgClause = String.valueOf(pkgClause) + " AND NAME = ? ";
            paramList.add(pkgPattern);
        } else if (!pkgPattern.equals("%")) {
            pkgClause = String.valueOf(pkgClause) + " AND NAME LIKE ?  ESCAPE '!' ";
            paramList.add(pkgPattern);
        }
        pkgClause = String.valueOf(pkgClause) + ")" + alias;
        return pkgClause;
    }

    private String pkgprocClause(List<Object> paramList, String pkgPattern, String procedureNamePattern, int proctype, String alias) {
        String pkgprocClause = "(SELECT PKGID, MTDID, IS_PROC, MTDNAME FROM SYS.V$PKGPROCS where true ";
        if (!MetaSQL.containsEscape(pkgPattern)) {
            pkgprocClause = String.valueOf(pkgprocClause) + " AND PKGNAME = ? ";
            paramList.add(pkgPattern);
        } else if (!pkgPattern.equals("%")) {
            pkgprocClause = String.valueOf(pkgprocClause) + " AND PKGNAME LIKE ?  ESCAPE '!' ";
            paramList.add(pkgPattern);
        }
        if (!procedureNamePattern.equals("%")) {
            if (!MetaSQL.containsEscape(procedureNamePattern)) {
                pkgprocClause = String.valueOf(pkgprocClause) + " AND MTDNAME = ? ";
                paramList.add(procedureNamePattern);
            } else if (!procedureNamePattern.equals("%")) {
                pkgprocClause = String.valueOf(pkgprocClause) + " AND MTDNAME LIKE ?  ESCAPE '!' ";
                paramList.add(procedureNamePattern);
            }
        }
        if (proctype == 1 || proctype == 2) {
            if (proctype == 1) {
                pkgprocClause = String.valueOf(pkgprocClause) + " AND IS_PROC = 'Y'";
            } else if (proctype == 2) {
                pkgprocClause = String.valueOf(pkgprocClause) + " AND IS_PROC = 'N'";
            }
        }
        pkgprocClause = String.valueOf(pkgprocClause) + ")" + alias;
        return pkgprocClause;
    }

    private String argClause(List<Object> paramList, String argPattern, String alias) {
        String argClause = "(SELECT A.NAME AS NAME, A.ID AS ID,A.COLID AS COLID, CASE WHEN B.INFO1 IS NULL OR ((B.INFO1>>2) & 0x01)=0 THEN A.TYPE$ WHEN (B.INFO2 & 0xFF) = 0 THEN 'NUMBER' ELSE 'FLOAT' END AS TYPE$, CASE WHEN B.INFO1 IS NULL OR ((B.INFO1>>2) & 0x01)=0 THEN A.LENGTH$ ELSE (B.INFO2 & 0xFF) END AS LENGTH$,CASE WHEN B.INFO1 IS NULL OR ((B.INFO1>>2) & 0x01)=0 THEN A.SCALE WHEN (B.INFO2 & 0xFF) = 0 THEN 0 ELSE 129 END AS SCALE,A.NULLABLE$ AS NULLABLE$,A.DEFVAL AS DEFVAL,A.INFO1 AS INFO1,A.INFO2 AS INFO2 FROM SYS.SYSCOLUMNS A LEFT JOIN SYS.SYSCOLINFOS B ON A.ID = B.ID AND A.COLID = B.COLID ";
        if (!MetaSQL.containsEscape(argPattern)) {
            argClause = String.valueOf(argClause) + " WHERE NAME = ? ";
            paramList.add(argPattern);
        } else if (!argPattern.equals("%")) {
            argClause = String.valueOf(argClause) + " WHERE NAME LIKE ?  ESCAPE '!' ";
            paramList.add(argPattern);
        }
        argClause = String.valueOf(argClause) + ")" + alias;
        return argClause;
    }

    private String pkgprocargClause(List<Object> paramList, String argPattern, String alias) {
        String argClause = "(SELECT *  FROM SYS.V$PKGPROCPARAMS";
        if (!MetaSQL.containsEscape(argPattern)) {
            argClause = String.valueOf(argClause) + " WHERE NAME = ? ";
            paramList.add(argPattern);
        } else if (!argPattern.equalsIgnoreCase("%")) {
            argClause = String.valueOf(argClause) + " WHERE NAME LIKE ?  ESCAPE '!' ";
            paramList.add(argPattern);
        }
        argClause = String.valueOf(argClause) + ")" + alias;
        return argClause;
    }

    private String tableClause(List<Object> paramList, String tablePattern, String[] types, String alias) {
        String tabClause = "(SELECT ID, SCHID, SUBTYPE$, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ IN ('UTAB', 'STAB', 'VIEW', 'SYNOM')";
        String typeClaue = this.makeTableTypeClause(types);
        if (typeClaue != null) {
            tabClause = String.valueOf(tabClause) + " AND " + typeClaue;
        }
        if (!tablePattern.equals("%")) {
            if (!MetaSQL.containsEscape(tablePattern)) {
                tabClause = String.valueOf(tabClause) + " AND NAME = ? ";
                paramList.add(tablePattern);
            } else {
                tabClause = String.valueOf(tabClause) + " AND NAME LIKE ?  ESCAPE '!' ";
                paramList.add(tablePattern);
            }
        }
        tabClause = String.valueOf(tabClause) + ")" + alias;
        return tabClause;
    }

    private String tableClause(List<Object> paramList, String tablePattern, String alias) {
        String tabClause = "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ IN ('UTAB', 'STAB', 'VIEW')";
        if (!tablePattern.equals("%")) {
            if (!MetaSQL.containsEscape(tablePattern)) {
                tabClause = String.valueOf(tabClause) + "AND NAME = ? ";
                paramList.add(tablePattern);
            } else {
                tabClause = String.valueOf(tabClause) + "AND NAME LIKE ?  ESCAPE '!' ";
                paramList.add(tablePattern);
            }
        }
        tabClause = String.valueOf(tabClause) + ")" + alias;
        return tabClause;
    }

    private String utableClause(List<Object> paramList, String tablePattern, String alias) {
        String tabClause = "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'UTAB'";
        if (!tablePattern.equals("%")) {
            if (!MetaSQL.containsEscape(tablePattern)) {
                tabClause = String.valueOf(tabClause) + "AND NAME = ?";
                paramList.add(tablePattern);
            } else {
                tabClause = String.valueOf(tabClause) + "AND NAME LIKE ?  ESCAPE '!' ";
                paramList.add(tablePattern);
            }
        }
        tabClause = String.valueOf(tabClause) + ")" + alias;
        return tabClause;
    }

    private String utableEqualClause(List<Object> paramList, String table, String alias) {
        String tabClause = "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'UTAB' AND NAME = ?) " + alias;
        paramList.add(table);
        return tabClause;
    }

    private static String procClause(List<Object> paramList, String procedureNamePattern, String alias, boolean compatibleOralce) {
        String procclause = "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'PROC'";
        if (!MetaSQL.containsEscape(procedureNamePattern)) {
            procclause = String.valueOf(procclause) + " AND NAME = ? ";
            paramList.add(procedureNamePattern);
        } else if (!procedureNamePattern.equals("%")) {
            procclause = String.valueOf(procclause) + " AND NAME LIKE ?  ESCAPE '!' ";
            paramList.add(procedureNamePattern);
        }
        procclause = String.valueOf(procclause) + ")" + alias;
        return procclause;
    }

    private static String funcClause(List<Object> paramList, String procedureNamePattern, String alias) {
        String procclause = "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'PROC'";
        if (!MetaSQL.containsEscape(procedureNamePattern)) {
            procclause = String.valueOf(procclause) + " AND NAME = ? ";
            paramList.add(procedureNamePattern);
        } else if (!procedureNamePattern.equalsIgnoreCase("%")) {
            procclause = String.valueOf(procclause) + " AND NAME LIKE ?  ESCAPE '!' ";
            paramList.add(procedureNamePattern);
        }
        procclause = String.valueOf(procclause) + " AND INFO1&0X01 = 0";
        procclause = String.valueOf(procclause) + ")" + alias;
        return procclause;
    }

    private static boolean containsEscape(String str) {
        int len = str.length();
        boolean flag = false;
        int i2 = len - 1;
        while (i2 >= 0) {
            if (str.charAt(i2) == '%' || str.charAt(i2) == '_') {
                flag = true;
            }
            --i2;
        }
        return flag;
    }

    public static String gatewayFormat(Object obj) {
        if (obj == null) {
            return "null";
        }
        String retString = "";
        retString = obj instanceof String ? (String)obj : (obj instanceof Boolean ? ((Boolean)obj != false ? "1" : "0") : (obj instanceof String[] ? Arrays.toString((String[])obj) : obj.toString()));
        return "'" + retString + "'";
    }
}

