/*
 * Decompiled with CFR 0.152.
 */
package uhf;

import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.transport.socket.SocketSessionConfig;
import uhf.AsyncSocketState;
import uhf.DevTypes;
import uhf.DeviceInformationTable;
import uhf.MultiLableCallBack;
import uhf.Reader;
import uhf.RecvData;

public class Handler
extends IoHandlerAdapter {
    private DeviceInformationTable _devinfo;
    MultiLableCallBack mc;
    List<AsyncSocketState> clients;
    public RecvData recvdata;
    public Reader _reader;

    public Handler(MultiLableCallBack mc, DeviceInformationTable devinfo, Reader reader) {
        this._reader = reader;
        this.mc = mc;
        this._devinfo = devinfo;
        this.recvdata = new RecvData(mc, reader);
    }

    public void sessionOpened(IoSession session) throws Exception {
        SocketSessionConfig cfg = (SocketSessionConfig)session.getConfig();
        cfg.setKeepAlive(true);
        cfg.setSoLinger(0);
        this.AddClient(session);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        String Message = message.toString();
        byte[] RecvData2 = Handler.toBytes(Message);
        AsyncSocketState state = this.GetClient(session);
        state.LsatRecvMsgTime = this.createdate();
        if (state.IsIdleMsg.booleanValue()) {
            if (state.NetErrorGiveUpDataLen > 0) {
                int i = 0;
                while (i < RecvData2.length) {
                    --state.NetErrorGiveUpDataLen;
                    ++i;
                }
            }
            if (state.NetErrorGiveUpDataLen < 0) {
                int GetDataLen = 0 - state.NetErrorGiveUpDataLen;
                byte[] NewData = new byte[GetDataLen];
                System.arraycopy(RecvData2, RecvData2.length - GetDataLen, NewData, 0, GetDataLen);
                this.RecvData(NewData, session);
                state.IsIdleMsg = false;
            }
            if (state.NetErrorGiveUpDataLen == 0) {
                state.IsIdleMsg = false;
            }
            state.NetErrorCount = 0;
        } else {
            this.RecvData(RecvData2, session);
        }
        super.messageReceived(session, message);
    }

    public void sessionClosed(IoSession session) throws Exception {
        this.NGClient(session);
    }

    public void SendMessage(AsyncSocketState state, byte[] message) {
        state._session.write((Object)IoBuffer.wrap((byte[])message));
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        super.sessionIdle(session, status);
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        this.NGClient(session);
        super.exceptionCaught(session, cause);
    }

    public AsyncSocketState GetClient(IoSession session) {
        AsyncSocketState state = new AsyncSocketState();
        this.clients = this._reader.GetClientInfo();
        String Address = "" + session.getRemoteAddress();
        Address = Address.substring(1, Address.length());
        String[] str_address = Address.split(":");
        int i = 0;
        while (i < this.clients.size()) {
            if (this.clients.get((int)i).ip_addr.equals(str_address[0]) && this.clients.get((int)i).port.equals(str_address[1]) && this.clients.get((int)i).state.equals("OK")) {
                state = this.clients.get(i);
                break;
            }
            ++i;
        }
        return state;
    }

    public void AddClient(IoSession session) {
        AsyncSocketState state = new AsyncSocketState(session);
        String Address = "" + session.getRemoteAddress();
        Address = Address.substring(1, Address.length());
        String[] str_address = Address.split(":");
        state.dev = "";
        state.ip_addr = str_address[0];
        state.port = str_address[1];
        state.state = "OK";
        state.com = "";
        state.types = "NET";
        this._devinfo.AddDevice(state);
    }

    public void NGClient(IoSession session) {
        this.clients = this._reader.GetClientInfo();
        String Address = "" + session.getRemoteAddress();
        Address = Address.substring(1, Address.length());
        String[] str_address = Address.split(":");
        int i = 0;
        while (i < this.clients.size()) {
            if (this.clients.get((int)i).ip_addr.equals(str_address[0]) && this.clients.get((int)i).port.equals(str_address[1]) && this.clients.get((int)i).state.equals("OK")) {
                this.clients.get((int)i).state = "NG";
                break;
            }
            ++i;
        }
        try {
            session.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void RecvData(byte[] data, IoSession session) {
        AsyncSocketState state = new AsyncSocketState();
        this.clients = this._reader.GetClientInfo();
        String Address = "" + session.getRemoteAddress();
        Address = Address.substring(1, Address.length());
        String[] str_address = Address.split(":");
        int i = 0;
        while (i < this.clients.size()) {
            if (this.clients.get((int)i).ip_addr.equals(str_address[0]) && this.clients.get((int)i).port.equals(str_address[1]) && this.clients.get((int)i).state.equals("OK")) {
                state = this.clients.get(i);
                break;
            }
            ++i;
        }
        if (state.dev_mode == -1) {
            this.RecvDataHandle(state, data);
        } else {
            this.recvdata.CommandParsing(data, state);
            state.recvLength = data.length;
        }
    }

    public void RecvDataHandle(AsyncSocketState clientstate, byte[] data) {
        System.arraycopy(data, 0, clientstate.RecvNetData, clientstate.WriteIndex, data.length);
        clientstate.WriteIndex += data.length;
        int i = 0;
        while (i < clientstate.WriteIndex) {
            if (clientstate.RecvNetData[i] == -69 && clientstate.WriteIndex >= 3 && clientstate.WriteIndex > (clientstate.RecvNetData[i + 2] & 0xFF) + 3 + 3 && clientstate.RecvNetData[i + (clientstate.RecvNetData[i + 2] + 3 + 1)] == 13 && clientstate.RecvNetData[i + (clientstate.RecvNetData[i + 2] + 3 + 2)] == 10) {
                if (clientstate.RecvNetData[i + (clientstate.RecvNetData[i + 2] + 3 + 3)] == -69) {
                    clientstate.dev_mode = DevTypes.Moudle;
                    byte[] SendData = new byte[clientstate.WriteIndex];
                    System.arraycopy(clientstate.RecvNetData, 0, SendData, 0, clientstate.WriteIndex);
                    this.recvdata.CommandParsing(SendData, clientstate);
                    clientstate.WriteIndex = 0;
                    break;
                }
                if (clientstate.RecvNetData[i + (clientstate.RecvNetData[i + 2] + 3 + 3)] == 126 && clientstate.RecvNetData[i + (clientstate.RecvNetData[i + 2] + 3 + 4)] == 126) {
                    clientstate.dev_mode = DevTypes.Machine;
                    clientstate.dev = String.valueOf(Handler.bytes2HexString(clientstate.RecvNetData[i + (clientstate.RecvNetData[i + 2] + 3 + 5)])) + Handler.bytes2HexString(clientstate.RecvNetData[i + (clientstate.RecvNetData[i + 2] + 3 + 6)]) + Handler.bytes2HexString(clientstate.RecvNetData[i + (clientstate.RecvNetData[i + 2] + 3 + 7)]) + Handler.bytes2HexString(clientstate.RecvNetData[i + (clientstate.RecvNetData[i + 2] + 3 + 8)]);
                    byte[] SendData = new byte[clientstate.WriteIndex];
                    System.arraycopy(clientstate.RecvNetData, 0, SendData, 0, clientstate.WriteIndex);
                    this.recvdata.CommandParsing(SendData, clientstate);
                    if (this._reader.IsCloseLastClient.booleanValue()) {
                        this.NG_Client(clientstate.dev);
                    }
                    clientstate.WriteIndex = 0;
                    break;
                }
            }
            ++i;
        }
    }

    public void NG_Client(String dev) {
        try {
            this.clients = this._reader.GetClientInfo();
            int Num = 0;
            int index = 0;
            int i = 0;
            while (i < this.clients.size()) {
                if (this.clients.get((int)i).dev.equals(dev) && this.clients.get((int)i).state.equals("OK")) {
                    if (Num == 0) {
                        index = i;
                    }
                    ++Num;
                }
                ++i;
            }
            if (Num > 1) {
                this.clients.get((int)index).state = "NG";
                this.clients.get((int)index)._session.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String bytes2HexString(byte b) {
        StringBuffer result = new StringBuffer();
        String hex = Integer.toHexString(b & 0xFF);
        if (hex.length() == 1) {
            hex = String.valueOf('0') + hex;
        }
        result.append(hex.toUpperCase());
        return result.toString();
    }

    public static byte[] toBytes(String str) {
        if (str == null || str.trim().equals("")) {
            return new byte[0];
        }
        byte[] bytes = new byte[str.length() / 2];
        int i = 0;
        while (i < str.length() / 2) {
            String subStr = str.substring(i * 2, i * 2 + 2);
            bytes[i] = (byte)Integer.parseInt(subStr, 16);
            ++i;
        }
        return bytes;
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < bytes.length) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
            ++i;
        }
        return sb.toString();
    }

    public static String string2HexUnicode(String strPart) {
        return Handler.string2HexString(strPart, "unicode");
    }

    public static String string2HexString(String strPart, String tochartype) {
        try {
            return Handler.bytes2HexString(strPart.getBytes(tochartype));
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String bytes2HexString(byte[] b) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            result.append(String.format("%02X", b[i]));
            ++i;
        }
        return result.toString();
    }

    private String parseMessage(Object message) {
        IoBuffer buf = (IoBuffer)message;
        IoBuffer.allocate((int)1024);
        buf.setAutoExpand(true);
        ByteBuffer bf = buf.buf();
        byte[] tmpBuffer = new byte[bf.limit()];
        bf.get(tmpBuffer);
        String result = "";
        int i = 0;
        while (i < tmpBuffer.length) {
            String getM = String.valueOf(Integer.toHexString(tmpBuffer[i] & 0xFF));
            if (getM.length() < 2) {
                getM = "0" + getM;
            }
            result = String.valueOf(result) + getM + " ";
            ++i;
        }
        return result;
    }

    public String createdate() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
        String createdate = sdf.format(date);
        return createdate;
    }
}

