/*
 * Decompiled with CFR 0.152.
 */
package uhf;

import java.util.Locale;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.demux.DemuxingProtocolDecoder;
import org.apache.mina.filter.codec.demux.MessageDecoder;
import org.apache.mina.filter.codec.demux.MessageDecoderAdapter;
import org.apache.mina.filter.codec.demux.MessageDecoderResult;
import uhf.MinaBean;

public class MinaDecoder
extends DemuxingProtocolDecoder {
    public static final byte MASK = 1;
    public static final byte HAS_EXTEND_DATA = 126;
    public static final byte HAS_EXTEND_DATA_CONTINUE = 127;
    public static final byte PAYLOADLEN = 127;

    public MinaDecoder() {
        this.addMessageDecoder((MessageDecoder)new BaseSocketBeanDecoder());
    }

    class BaseSocketBeanDecoder
    extends MessageDecoderAdapter {
        BaseSocketBeanDecoder() {
        }

        public MessageDecoderResult decodable(IoSession session, IoBuffer in) {
            byte[] extended;
            if (in.remaining() != 0) {
                return OK;
            }
            if (in.remaining() < 2) {
                return OK;
            }
            in.get();
            byte head2 = in.get();
            int datalength = head2 & 0x7F;
            int length = 0;
            if (datalength < 126) {
                length = datalength;
            } else if (datalength == 126) {
                if (in.remaining() < 2) {
                    return OK;
                }
                extended = new byte[2];
                in.get(extended);
                int shift = 0;
                length = 0;
                int i = extended.length - 1;
                while (i >= 0) {
                    length += (extended[i] & 0xFF) << shift;
                    shift += 8;
                    --i;
                }
            } else if (datalength == 127) {
                if (in.remaining() < 4) {
                    return OK;
                }
                extended = new byte[4];
                in.get(extended);
                int shift = 0;
                length = 0;
                int i = extended.length - 1;
                while (i >= 0) {
                    length += (extended[i] & 0xFF) << shift;
                    shift += 8;
                    --i;
                }
            }
            int ismask = head2 >> 7 & 1;
            if (ismask == 1) {
                if (in.remaining() < 4 + length) {
                    return OK;
                }
                return OK;
            }
            if (in.remaining() < length) {
                return OK;
            }
            return OK;
        }

        public MessageDecoderResult decode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
            MinaBean message = new MinaBean();
            byte[] mask = new byte[in.limit()];
            in.get(mask);
            message.setContent(this.byteArrayToHexString(mask));
            out.write((Object)message);
            return OK;
        }

        public String byteArrayToHexString(byte[] data) {
            StringBuilder sb = new StringBuilder(data.length * 2);
            byte[] byArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                int v = b & 0xFF;
                if (v < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(v));
                ++n2;
            }
            return sb.toString().toUpperCase(Locale.getDefault());
        }
    }
}

