/*
 * Decompiled with CFR 0.152.
 */
package uhf;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import uhf.AsyncSocketState;
import uhf.Command;
import uhf.DeviceInformationTable;
import uhf.MultiLableCallBack;
import uhf.RecvData;
import uhf.Respond;
import uhf.SerialPortAndroid;
import uhf.SerialPortSR;
import uhf.SocketTCPServer;

public class Reader {
    public Respond OperRespond;
    private SerialPortSR Serial;
    private SocketTCPServer tcpserver;
    AsyncSocketState state;
    private DeviceInformationTable devinfo;
    private SerialPortAndroid SerialAndroid;
    public MultiLableCallBack mc;
    List<AsyncSocketState> clients;
    public static int CommandType = 1;
    Boolean net_state = false;
    Boolean com_state = false;
    public Command cmd;
    public String RecvData = "";
    public String ServerErrorStr = "";
    public String OpenAndroidSerialPortErrorMsg = "";
    public String CloseError = "";
    public Boolean IsCloseLastClient = true;
    String SDKBB = "2019.11.19";

    public Reader(MultiLableCallBack mc) {
        this.tcpserver = new SocketTCPServer(mc, this);
        try {
            this.Serial = new SerialPortSR(mc, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.SerialAndroid = new SerialPortAndroid(mc, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cmd = new Command(this);
        this.devinfo = new DeviceInformationTable();
    }

    public Boolean ComStart(String portName, int baudrate) {
        try {
            this.Serial.openPort(portName, baudrate, this.devinfo);
            this.com_state = true;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Boolean ServerStart(String IP, int Port) {
        try {
            this.ServerErrorStr = "";
            this.tcpserver.ServerStart(IP, Port, this.devinfo);
            return true;
        }
        catch (Exception e) {
            this.ServerErrorStr = "\u65f6\u95f4:" + this.NowTime() + "\r\n" + "\u5f00\u542f\u670d\u52a1\u5668\u5931\u8d25\u4fe1\u606f:" + e.getMessage();
            return false;
        }
    }

    public Boolean OpenSerialPort_Android(String SerialName) {
        try {
            Boolean ret = this.SerialAndroid.OpenSerialPort(SerialName, this.devinfo);
            return ret;
        }
        catch (Exception e) {
            this.OpenAndroidSerialPortErrorMsg = "" + e;
            return false;
        }
    }

    public Boolean CloseSerialPort_Android() {
        this.SerialAndroid.CloseSerialPort();
        int i = 0;
        while (i < DeviceInformationTable._clients.size()) {
            if (DeviceInformationTable._clients.get((int)i).port.equals("--")) {
                DeviceInformationTable._clients.remove(i);
            }
            ++i;
        }
        return true;
    }

    public Boolean SerialPortClose() {
        this.Serial.closePort();
        int i = 0;
        while (i < DeviceInformationTable._clients.size()) {
            if (DeviceInformationTable._clients.get((int)i).port.equals("--")) {
                DeviceInformationTable._clients.remove(i);
            }
            ++i;
        }
        return true;
    }

    public Boolean ServerClose() {
        try {
            int i = 0;
            while (i < DeviceInformationTable._clients.size()) {
                if (DeviceInformationTable._clients.get((int)i).types.equals("NET")) {
                    try {
                        DeviceInformationTable._clients.get((int)i)._session.close(true);
                    }
                    catch (Exception ex) {
                        this.CloseError = "" + ex;
                    }
                    DeviceInformationTable._clients.get((int)i).state = "NG";
                    DeviceInformationTable._clients.remove(i);
                }
                ++i;
            }
            this.tcpserver.ServerClose();
            return true;
        }
        catch (Exception e) {
            this.CloseError = "" + e;
            return false;
        }
    }

    public String Get_SDK() {
        return this.SDKBB;
    }

    public List<AsyncSocketState> GetClientInfo() {
        return DeviceInformationTable._clients;
    }

    public List<AsyncSocketState> GetClientInfo_OK() {
        ArrayList<AsyncSocketState> _clients = new ArrayList<AsyncSocketState>();
        int i = 0;
        while (i < DeviceInformationTable._clients.size()) {
            if (DeviceInformationTable._clients.get((int)i).types.equals("NET")) {
                if (DeviceInformationTable._clients.get((int)i).state.equals("OK")) {
                    _clients.add(DeviceInformationTable._clients.get(i));
                }
            } else {
                _clients.add(DeviceInformationTable._clients.get(i));
            }
            ++i;
        }
        return _clients;
    }

    public void Register(AsyncSocketState state) {
        this.devinfo.Register(state);
    }

    public boolean Send(AsyncSocketState state, byte[] command) {
        try {
            if (state.types.equals("COM")) {
                SerialPortSR.sendToPort(command);
            } else if (state.types.equals("NET")) {
                this.tcpserver.MinaServer.SendMessage(state, command);
            } else {
                this.SerialAndroid.Send(command);
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public boolean SetCommandType(byte type) {
        this.cmd.CommandType = type;
        return true;
    }

    public void SetHeartState(Boolean rec) {
        RecvData cfr_ignored_0 = this.Serial.recvdata;
        uhf.RecvData.heart_state = rec;
    }

    public boolean GetHeartState() {
        RecvData cfr_ignored_0 = this.Serial.recvdata;
        return uhf.RecvData.heart_state;
    }

    public String GoToByte(AsyncSocketState state, byte[] command) {
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String StartMultiEPC() {
        String result = "";
        int i = 0;
        while (i < DeviceInformationTable._clients.size()) {
            if (DeviceInformationTable._clients.get((int)i).state.equals("NG") || (result = this.StartMultiEPC(DeviceInformationTable._clients.get(i))) == "-4") {
                // empty if block
            }
            ++i;
        }
        return result;
    }

    public String StartMultiEPC(AsyncSocketState state) {
        byte[] msgbody = new byte[2];
        byte type = 23;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String StopMultiEPC() {
        String result = "";
        int i = 0;
        while (i < DeviceInformationTable._clients.size()) {
            if (DeviceInformationTable._clients.get((int)i).state.equals("NG") || (result = this.StopMultiEPC(DeviceInformationTable._clients.get(i))) == "-4") {
                // empty if block
            }
            ++i;
        }
        return result;
    }

    public String StopMultiEPC(AsyncSocketState state) {
        byte[] msgbody = new byte[0];
        byte type = 24;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String ReadBatchTags(AsyncSocketState state) {
        byte type = 81;
        byte[] byArray = new byte[4];
        byArray[0] = 3;
        byArray[1] = 7;
        byte[] msgbody = byArray;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetPower(AsyncSocketState state, byte readpower, byte writepower) {
        byte type = 0;
        byte[] msgbody = new byte[3];
        msgbody[1] = readpower;
        msgbody[2] = writepower;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetPower(AsyncSocketState state, byte ant1_power, byte ant2_power, byte ant3_power, byte ant4_power) {
        byte type = 0;
        byte[] byArray = new byte[9];
        byArray[1] = ant1_power;
        byArray[2] = ant1_power;
        byArray[3] = ant2_power;
        byArray[4] = ant2_power;
        byArray[5] = ant3_power;
        byArray[6] = ant3_power;
        byArray[7] = ant4_power;
        byArray[8] = ant4_power;
        byte[] msgbody = byArray;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetGpio(AsyncSocketState state, byte gpio, byte gpiostate) {
        byte type = 1;
        byte[] msgbody = new byte[]{gpio, gpiostate};
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String Init(AsyncSocketState state, byte Autorun, byte ver, byte txpower, byte rxpower, byte workstate, byte channel, byte tagtype, byte mode) {
        byte type = -6;
        byte subtype = 0;
        byte[] msgbody = new byte[]{subtype, Autorun, ver, txpower, rxpower, workstate, channel, tagtype, mode};
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String StartCarrier(AsyncSocketState state) {
        byte type = -6;
        byte subtype = 4;
        byte[] msgbody = new byte[]{subtype};
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String StopCarrier(AsyncSocketState state) {
        byte type = -6;
        byte subtype = 5;
        byte[] msgbody = new byte[]{subtype};
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String Restart(AsyncSocketState state) {
        byte type = -6;
        byte subtype = 6;
        byte[] msgbody = new byte[]{subtype};
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String FliterData(AsyncSocketState state, byte num, byte[] fliterdata) {
        byte type = -6;
        byte[] subtype = new byte[]{7};
        byte[] msgbody = new byte[subtype.length + fliterdata.length];
        System.arraycopy(subtype, 0, msgbody, 0, subtype.length);
        System.arraycopy(fliterdata, 0, msgbody, subtype.length, fliterdata.length);
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String ReadInfo(AsyncSocketState state) {
        byte type = -6;
        byte subtype = 64;
        byte[] msgbody = new byte[]{subtype};
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String readVersion(AsyncSocketState state) {
        byte type = -6;
        byte subtype = 65;
        byte[] msgbody = new byte[]{subtype};
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetTagfocus(AsyncSocketState state, byte Tagfocus) {
        byte type = 41;
        byte[] msgbody = new byte[]{Tagfocus};
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetFRequencyPoint(AsyncSocketState state, byte num, String[] points) {
        byte type = 2;
        byte[] msgbody = new byte[num * 3 + 1];
        int tmppoint = 0;
        int realnum = 0;
        int index = 0;
        while (index < num) {
            if (points[index] == "") break;
            tmppoint = Integer.parseInt(points[index]);
            msgbody[index * 3 + 1] = (byte)(tmppoint >> 16);
            msgbody[index * 3 + 2] = (byte)(tmppoint >> 8);
            msgbody[index * 3 + 3] = (byte)tmppoint;
            ++realnum;
            ++index;
        }
        msgbody[0] = (byte)realnum;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetWorkAnt(AsyncSocketState state, byte ant) {
        byte type = 8;
        byte[] msgbody = new byte[]{ant};
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetRFLink(AsyncSocketState state, byte link, byte DDSave) {
        byte type = 3;
        byte[] msgbody = new byte[]{DDSave, link};
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetEAT(AsyncSocketState state) {
        byte[] msgbody = new byte[1];
        byte type = 83;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetEAT(AsyncSocketState state, byte eatID, byte SaveMark) {
        byte type = 82;
        byte[] msgbody = new byte[]{eatID, SaveMark};
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetBranchAnt(AsyncSocketState state, byte[] AntState) {
        byte[] msgbody = AntState;
        byte type = 8;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetFrequencyArea(AsyncSocketState state, byte area, byte save) {
        byte type = 9;
        byte[] msgbody = new byte[]{save, area};
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (Respond.Result == 1) {
            Respond.Result = -1;
            return Respond.Gerneral;
        }
        Respond.Result = -1;
        return "ERROR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int KeepAlive() {
        List<AsyncSocketState> list = DeviceInformationTable._clients;
        synchronized (list) {
            int i = 0;
            while (i < DeviceInformationTable._clients.size()) {
                this.KeepAlive(DeviceInformationTable._clients.get(i));
                ++i;
            }
        }
        return 0;
    }

    public int KeepAlive(AsyncSocketState state) {
        byte[] command = new byte[]{126};
        this.Send(state, command);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String SingleEPC() {
        String result = "";
        List<AsyncSocketState> list = DeviceInformationTable._clients;
        synchronized (list) {
            int i = 0;
            while (i < DeviceInformationTable._clients.size()) {
                result = this.SingleEPC(DeviceInformationTable._clients.get(i));
                if (result == "-4") {
                    // empty if block
                }
                ++i;
            }
        }
        return result;
    }

    public String SingleEPC(AsyncSocketState state) {
        byte[] msgbody = new byte[0];
        byte type = 22;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String ReadTags(AsyncSocketState state, String str_pwd, byte fliter, String fliterdata, byte bank, int startAdd, int datalen) {
        int int_pwd = 0;
        byte[] pwd = new byte[]{(byte)(int_pwd >> 24), (byte)(int_pwd >> 16), (byte)(int_pwd >> 8), (byte)int_pwd};
        if (str_pwd != "") {
            pwd = Command.toBytes(str_pwd);
        }
        byte type = 25;
        byte[] by_fliter = new byte[]{fliter};
        byte[] by_fliterlen = new byte[2];
        byte[] by_bank = new byte[]{bank};
        byte[] by_startadd = new byte[]{(byte)(startAdd >> 8), (byte)startAdd};
        byte[] by_datalen = new byte[]{(byte)(datalen >> 8), (byte)datalen};
        int len = fliterdata.length();
        if (fliterdata.length() % 4 != 0) {
            return "ERROR";
        }
        int fliterlen = fliterdata.length() / 2;
        by_fliterlen[0] = (byte)(fliterlen >> 8);
        by_fliterlen[1] = (byte)fliterlen;
        byte[] by_fliterdata = this.cmd.StrToHexByte(fliterdata);
        byte[] msgbody = new byte[pwd.length + by_fliter.length + by_fliterlen.length + by_fliterdata.length + by_bank.length + by_startadd.length + by_datalen.length];
        System.arraycopy(pwd, 0, msgbody, 0, pwd.length);
        System.arraycopy(by_fliter, 0, msgbody, pwd.length, by_fliter.length);
        System.arraycopy(by_fliterlen, 0, msgbody, pwd.length + by_fliter.length, by_fliterlen.length);
        System.arraycopy(by_fliterdata, 0, msgbody, pwd.length + by_fliter.length + by_fliterlen.length, by_fliterdata.length);
        System.arraycopy(by_bank, 0, msgbody, pwd.length + by_fliter.length + by_fliterlen.length + by_fliterdata.length, by_bank.length);
        System.arraycopy(by_startadd, 0, msgbody, pwd.length + by_fliter.length + by_fliterlen.length + by_fliterdata.length + by_bank.length, by_startadd.length);
        System.arraycopy(by_datalen, 0, msgbody, pwd.length + by_fliter.length + by_fliterlen.length + by_fliterdata.length + by_bank.length + by_startadd.length, by_datalen.length);
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String WriteTags(AsyncSocketState state, String str_pwd, byte fliter, String fliterdata, byte bank, int startAdd, int datalen, String data) {
        int int_pwd = 0;
        byte[] pwd = new byte[]{(byte)(int_pwd >> 24), (byte)(int_pwd >> 16), (byte)(int_pwd >> 8), (byte)int_pwd};
        if (str_pwd != "") {
            pwd = Command.toBytes(str_pwd);
        }
        byte[] by_fliter = new byte[]{fliter};
        byte[] by_fliterlen = new byte[2];
        byte[] by_bank = new byte[]{bank};
        byte[] by_startadd = new byte[]{(byte)(startAdd >> 8), (byte)startAdd};
        byte[] by_datalen = new byte[]{(byte)(datalen >> 8), (byte)datalen};
        if (fliterdata.length() % 4 != 0) {
            return "ERROR";
        }
        int fliterlen = fliterdata.length() / 2;
        by_fliterlen[0] = (byte)(fliterlen >> 8);
        by_fliterlen[1] = (byte)fliterlen;
        byte[] by_fliterdata = this.cmd.StrToHexByte(fliterdata);
        byte[] by_data = new byte[datalen * 2];
        byte[] write_data = this.cmd.StrToHexByte(data);
        System.arraycopy(write_data, 0, by_data, 0, write_data.length);
        byte type = 26;
        byte[] msgbody = new byte[pwd.length + by_fliter.length + by_fliterlen.length + by_fliterdata.length + by_bank.length + by_startadd.length + by_datalen.length + by_data.length];
        System.arraycopy(pwd, 0, msgbody, 0, pwd.length);
        System.arraycopy(by_fliter, 0, msgbody, pwd.length, by_fliter.length);
        System.arraycopy(by_fliterlen, 0, msgbody, pwd.length + by_fliter.length, by_fliterlen.length);
        System.arraycopy(by_fliterdata, 0, msgbody, pwd.length + by_fliter.length + by_fliterlen.length, by_fliterdata.length);
        System.arraycopy(by_bank, 0, msgbody, pwd.length + by_fliter.length + by_fliterlen.length + by_fliterdata.length, by_bank.length);
        System.arraycopy(by_startadd, 0, msgbody, pwd.length + by_fliter.length + by_fliterlen.length + by_fliterdata.length + by_bank.length, by_startadd.length);
        System.arraycopy(by_datalen, 0, msgbody, pwd.length + by_fliter.length + by_fliterlen.length + by_fliterdata.length + by_bank.length + by_startadd.length, by_datalen.length);
        System.arraycopy(by_data, 0, msgbody, pwd.length + by_fliter.length + by_fliterlen.length + by_fliterdata.length + by_bank.length + by_startadd.length + by_datalen.length, by_data.length);
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String LockTags(AsyncSocketState state, String str_pwd, byte fliter, String fliterdata, byte[] Lock) {
        byte type = 27;
        int int_pwd = 0;
        byte[] pwd = new byte[]{(byte)(int_pwd >> 24), (byte)(int_pwd >> 16), (byte)(int_pwd >> 8), (byte)int_pwd};
        if (str_pwd != "") {
            pwd = Command.toBytes(str_pwd);
        }
        byte[] by_fliter = new byte[]{fliter};
        byte[] by_fliterlen = new byte[2];
        if (fliterdata.length() % 4 != 0) {
            return "ERROR";
        }
        int fliterlen = fliterdata.length() / 2;
        by_fliterlen[0] = (byte)(fliterlen >> 8);
        by_fliterlen[1] = (byte)fliterlen;
        byte[] by_fliterdata = this.cmd.StrToHexByte(fliterdata);
        byte[] msgbody = new byte[pwd.length + by_fliter.length + by_fliterlen.length + by_fliterdata.length + Lock.length];
        System.arraycopy(pwd, 0, msgbody, 0, pwd.length);
        System.arraycopy(by_fliter, 0, msgbody, pwd.length, by_fliter.length);
        System.arraycopy(by_fliterlen, 0, msgbody, pwd.length + by_fliter.length, by_fliterlen.length);
        System.arraycopy(by_fliterdata, 0, msgbody, pwd.length + by_fliter.length + by_fliterlen.length, by_fliterdata.length);
        System.arraycopy(Lock, 0, msgbody, pwd.length + by_fliter.length + by_fliterlen.length + by_fliterdata.length, Lock.length);
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String KillTags(AsyncSocketState state, String str_pwd, byte fliter, String fliterdata) {
        Respond.Killtags = "";
        byte type = 28;
        int int_pwd = 0;
        byte[] pwd = new byte[]{(byte)(int_pwd >> 24), (byte)(int_pwd >> 16), (byte)(int_pwd >> 8), (byte)int_pwd};
        if (str_pwd != "") {
            pwd = Command.toBytes(str_pwd);
        }
        byte[] by_fliter = new byte[]{fliter};
        byte[] by_fliterlen = new byte[2];
        if (fliterdata.length() % 4 != 0) {
            return "ERROR";
        }
        int fliterlen = fliterdata.length() / 2;
        by_fliterlen[0] = (byte)(fliterlen >> 8);
        by_fliterlen[1] = (byte)fliterlen;
        byte[] by_fliterdata = this.cmd.StrToHexByte(fliterdata);
        byte[] msgbody = new byte[pwd.length + by_fliter.length + by_fliterlen.length + by_fliterdata.length];
        System.arraycopy(pwd, 0, msgbody, 0, pwd.length);
        System.arraycopy(by_fliter, 0, msgbody, pwd.length, by_fliter.length);
        System.arraycopy(by_fliterlen, 0, msgbody, pwd.length + by_fliter.length, by_fliterlen.length);
        System.arraycopy(by_fliterdata, 0, msgbody, pwd.length + by_fliter.length + by_fliterlen.length, by_fliterdata.length);
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetWorkTime(AsyncSocketState state, int u_ant1, int u_ant2, int u_ant3, int u_ant4, int waittime) {
        byte type = 31;
        byte[] ant1 = new byte[]{(byte)(u_ant1 >> 8), (byte)u_ant1};
        byte[] ant2 = new byte[]{(byte)(u_ant2 >> 8), (byte)u_ant2};
        byte[] ant3 = new byte[]{(byte)(u_ant3 >> 8), (byte)u_ant3};
        byte[] ant4 = new byte[]{(byte)(u_ant4 >> 8), (byte)u_ant4};
        byte[] wait = new byte[]{(byte)(waittime >> 8), (byte)waittime};
        byte[] msgbody = new byte[ant1.length + ant2.length + ant3.length + ant4.length + wait.length];
        System.arraycopy(ant1, 0, msgbody, 0, ant1.length);
        System.arraycopy(ant2, 0, msgbody, ant1.length, ant2.length);
        System.arraycopy(ant3, 0, msgbody, ant1.length + ant2.length, ant3.length);
        System.arraycopy(ant4, 0, msgbody, ant1.length + ant2.length + ant3.length, ant4.length);
        System.arraycopy(wait, 0, msgbody, ant1.length + ant2.length + ant3.length + ant4.length, wait.length);
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetHardVersion(AsyncSocketState state) {
        byte[] msgbody = new byte[0];
        byte type = 10;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetFirmVersion(AsyncSocketState state) {
        byte[] msgbody = new byte[0];
        byte type = 11;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetRFLink(AsyncSocketState state) {
        byte[] msgbody = new byte[0];
        byte type = 14;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetBeep(AsyncSocketState state, byte count, int length) {
        byte type = 73;
        byte[] msgbody = new byte[]{count, (byte)(length >> 8), (byte)length};
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetGPIODelay(AsyncSocketState state, byte gpio, byte level, int length) {
        byte type = 62;
        byte[] msgbody = new byte[]{gpio, level, (byte)(length >> 8), (byte)length};
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetSingleChannelAnt(AsyncSocketState state, int worktime, int waittime) {
        byte type = 29;
        byte[] msgbody = new byte[]{(byte)(worktime >> 8), (byte)worktime, (byte)(waittime >> 8), (byte)waittime};
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetSingleChannelAnt(AsyncSocketState state) {
        byte[] msgbody = new byte[0];
        byte type = 30;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetMultiChannelAnt(AsyncSocketState state, int workant) {
        byte type = 8;
        byte[] byArray = new byte[4];
        byArray[0] = (byte)(workant >> 8);
        byArray[1] = (byte)workant;
        byte[] msgbody = byArray;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetMultiChannelAnt(AsyncSocketState state) {
        byte[] msgbody = new byte[0];
        byte type = 16;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetFactoty(AsyncSocketState state) {
        byte type = 61;
        byte[] msgbody = new byte[]{90, -91, 121};
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetCommunicationInfo(AsyncSocketState state) {
        byte[] msgbody = new byte[0];
        byte type = 43;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetCommunicationInfo(AsyncSocketState state, String strMac, String strReaderIP, String strMask, String strGateway, String strDNS, String strServerIP, int strReaderPort, int strServerPort, byte moreport) {
        byte type = 51;
        byte[] Mac = this.cmd.StrToHexByte(strMac.replace("-", ""));
        byte[] ReaderIP = this.cmd.StrarrayToBytearray(strReaderIP.split("\\."));
        byte[] Mask = this.cmd.StrarrayToBytearray(strMask.split("\\."));
        byte[] Gateway = this.cmd.StrarrayToBytearray(strGateway.split("\\."));
        byte[] DNS = this.cmd.StrarrayToBytearray(strDNS.split("\\."));
        byte[] ServerIP = this.cmd.StrarrayToBytearray(strServerIP.split("\\."));
        byte[] ReaderPort = new byte[]{(byte)(strReaderPort >> 8), (byte)strReaderPort};
        byte[] ServerPort = new byte[]{(byte)(strServerPort >> 8), (byte)strServerPort};
        byte[] MorePort = new byte[]{moreport};
        byte[] msgbody = new byte[Mac.length + ReaderIP.length + Mask.length + Gateway.length + DNS.length + ServerIP.length + ReaderPort.length + ServerPort.length + MorePort.length];
        System.arraycopy(Mac, 0, msgbody, 0, Mac.length);
        System.arraycopy(ReaderIP, 0, msgbody, Mac.length, ReaderIP.length);
        System.arraycopy(Mask, 0, msgbody, Mac.length + ReaderIP.length, Mask.length);
        System.arraycopy(Gateway, 0, msgbody, Mac.length + ReaderIP.length + Mask.length, Gateway.length);
        System.arraycopy(DNS, 0, msgbody, Mac.length + ReaderIP.length + Mask.length + Gateway.length, DNS.length);
        System.arraycopy(ServerIP, 0, msgbody, Mac.length + ReaderIP.length + Mask.length + Gateway.length + DNS.length, ServerIP.length);
        System.arraycopy(ReaderPort, 0, msgbody, Mac.length + ReaderIP.length + Mask.length + Gateway.length + DNS.length + ServerIP.length, ReaderPort.length);
        System.arraycopy(ServerPort, 0, msgbody, Mac.length + ReaderIP.length + Mask.length + Gateway.length + DNS.length + ServerIP.length + ReaderPort.length, ServerPort.length);
        System.arraycopy(MorePort, 0, msgbody, Mac.length + ReaderIP.length + Mask.length + Gateway.length + DNS.length + ServerIP.length + ReaderPort.length + ServerPort.length, MorePort.length);
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetSIMConfig(AsyncSocketState state, String APN, String USR, String PWD, String ServerIP, int port) {
        byte type = 60;
        try {
            byte[] apn = new byte[16];
            System.arraycopy(Command.toBytes(this.cmd.convertStringToHex(APN)), 0, apn, 0, Command.toBytes(this.cmd.convertStringToHex(APN)).length);
            byte[] usr = new byte[16];
            System.arraycopy(Command.toBytes(this.cmd.convertStringToHex(USR)), 0, usr, 0, Command.toBytes(this.cmd.convertStringToHex(USR)).length);
            byte[] pwd = new byte[16];
            System.arraycopy(Command.toBytes(this.cmd.convertStringToHex(PWD)), 0, pwd, 0, Command.toBytes(this.cmd.convertStringToHex(PWD)).length);
            byte[] serverIP = this.cmd.StrarrayToBytearray(ServerIP.split("\\."));
            byte[] ReaderPort = new byte[]{(byte)(port >> 8), (byte)port};
            byte[] reserve = new byte[6];
            byte[] msgbody = new byte[apn.length + usr.length + pwd.length + serverIP.length + ReaderPort.length + reserve.length];
            System.arraycopy(apn, 0, msgbody, 0, apn.length);
            System.arraycopy(usr, 0, msgbody, apn.length, usr.length);
            System.arraycopy(pwd, 0, msgbody, apn.length + usr.length, pwd.length);
            System.arraycopy(serverIP, 0, msgbody, apn.length + usr.length + pwd.length, serverIP.length);
            System.arraycopy(ReaderPort, 0, msgbody, apn.length + usr.length + pwd.length + serverIP.length, ReaderPort.length);
            System.arraycopy(reserve, 0, msgbody, apn.length + usr.length + pwd.length + serverIP.length + ReaderPort.length, reserve.length);
            byte[] command = this.cmd.PackSelector(msgbody, type);
            if (!this.Send(state, command)) {
                return "-4";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "0";
    }

    public String SetWifiConfig(AsyncSocketState state, String SSID, String Pwd, String ip, String mask, String gateway, String serverip, int port, byte mode, byte algorithm) {
        byte type = 63;
        try {
            byte[] ssid = new byte[16];
            System.arraycopy(Command.toBytes(this.cmd.convertStringToHex(SSID)), 0, ssid, 0, Command.toBytes(this.cmd.convertStringToHex(SSID)).length);
            byte[] pwd = new byte[64];
            System.arraycopy(Command.toBytes(this.cmd.convertStringToHex(Pwd)), 0, pwd, 0, Command.toBytes(this.cmd.convertStringToHex(Pwd)).length);
            byte[] ReaderIP = this.cmd.StrarrayToBytearray(ip.split("\\."));
            byte[] Readermask = this.cmd.StrarrayToBytearray(mask.split("\\."));
            byte[] Readergw = this.cmd.StrarrayToBytearray(gateway.split("\\."));
            byte[] Serverip = this.cmd.StrarrayToBytearray(serverip.split("\\."));
            byte[] ServerPort = new byte[]{(byte)(port >> 8), (byte)port};
            byte[] modealgorithm = new byte[]{mode, algorithm};
            byte[] reserve = new byte[2];
            byte[] msgbody = new byte[ssid.length + pwd.length + ReaderIP.length + Readermask.length + Readergw.length + Serverip.length + ServerPort.length + modealgorithm.length + reserve.length];
            System.arraycopy(ssid, 0, msgbody, 0, ssid.length);
            System.arraycopy(pwd, 0, msgbody, ssid.length, pwd.length);
            System.arraycopy(ReaderIP, 0, msgbody, ssid.length + pwd.length, ReaderIP.length);
            System.arraycopy(Readermask, 0, msgbody, ssid.length + pwd.length + ReaderIP.length, Readermask.length);
            System.arraycopy(Readergw, 0, msgbody, ssid.length + pwd.length + ReaderIP.length + Readermask.length, Readergw.length);
            System.arraycopy(Serverip, 0, msgbody, ssid.length + pwd.length + ReaderIP.length + Readermask.length + Readergw.length, Serverip.length);
            System.arraycopy(ServerPort, 0, msgbody, ssid.length + pwd.length + ReaderIP.length + Readermask.length + Readergw.length + Serverip.length, ServerPort.length);
            System.arraycopy(modealgorithm, 0, msgbody, ssid.length + pwd.length + ReaderIP.length + Readermask.length + Readergw.length + Serverip.length + ServerPort.length, modealgorithm.length);
            System.arraycopy(reserve, 0, msgbody, ssid.length + pwd.length + ReaderIP.length + Readermask.length + Readergw.length + Serverip.length + ServerPort.length + modealgorithm.length, reserve.length);
            byte[] command = this.cmd.PackSelector(msgbody, type);
            if (!this.Send(state, command)) {
                return "-4";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "0";
    }

    public String GetSIMInfo(AsyncSocketState state) {
        byte[] msgbody = new byte[0];
        byte type = 59;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetWifiConfig(AsyncSocketState state) {
        byte[] msgbody = new byte[0];
        byte type = 65;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetTemperature(AsyncSocketState state) {
        byte[] msgbody = new byte[0];
        byte type = 18;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetPower(AsyncSocketState state) {
        Respond.Power = "";
        byte[] msgbody = new byte[0];
        byte type = 12;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetFrequencyPoints(AsyncSocketState state) {
        Respond.FrequencyPoint = "";
        byte[] msgbody = new byte[0];
        byte type = 13;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetWorkAnt(AsyncSocketState state) {
        Respond.WorkAnt = "";
        byte[] msgbody = new byte[0];
        byte type = 16;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetFrequencyArea(AsyncSocketState state) {
        Respond.FrequencyArea = "";
        byte[] msgbody = new byte[0];
        byte type = 17;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetGpio(AsyncSocketState state, byte gpio) {
        Respond.Gpio = "ERROR";
        byte type = 19;
        byte[] msgbody = new byte[]{gpio};
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetRflink(AsyncSocketState state) {
        byte[] msgbody = new byte[0];
        byte type = 33;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetWorkTime(AsyncSocketState state) {
        Respond.WorkTime = "";
        byte[] msgbody = new byte[0];
        byte type = 32;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetFastID(AsyncSocketState state) {
        Respond.FastID = "";
        byte[] msgbody = new byte[0];
        byte type = 34;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetCarrier(AsyncSocketState state) {
        Respond.FastID = "";
        byte[] msgbody = new byte[0];
        byte type = 15;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetfastID(AsyncSocketState state, byte fastID) {
        Respond.Gerneral = "";
        byte type = 33;
        byte[] msgbody = new byte[]{fastID};
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetCarrier(AsyncSocketState state, byte fastID) {
        Respond.Gerneral = "";
        byte type = 5;
        byte[] msgbody = new byte[]{fastID};
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetMACDev(AsyncSocketState state) {
        Respond.FirmVersion = "";
        byte[] msgbody = new byte[0];
        byte type = 57;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetMQTTUser(AsyncSocketState state) {
        Respond.FirmVersion = "";
        byte[] msgbody = new byte[0];
        byte type = 70;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetMQTTTheme(AsyncSocketState state) {
        Respond.FirmVersion = "";
        byte[] msgbody = new byte[0];
        byte type = 72;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetMACDev(AsyncSocketState state, String strMac, String strDev, int devviceType) {
        Respond.Temperature = "";
        byte type = 56;
        byte[] key = new byte[]{105, -106};
        byte[] Mac = this.cmd.StrToHexByte(strMac.replace("-", ""));
        byte[] dev = this.cmd.StrToHexByte(strDev);
        byte[] devices = new byte[]{(byte)(devviceType >> 8), (byte)devviceType};
        byte[] msgbody = new byte[key.length + Mac.length + dev.length + devices.length];
        System.arraycopy(key, 0, msgbody, 0, key.length);
        System.arraycopy(Mac, 0, msgbody, key.length, Mac.length);
        System.arraycopy(dev, 0, msgbody, key.length + Mac.length, dev.length);
        System.arraycopy(devices, 0, msgbody, key.length + Mac.length + dev.length, devices.length);
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetDataMode(AsyncSocketState state, byte datamode, byte baudRate) {
        Respond.Temperature = "";
        byte type = 56;
        byte[] msgbody = new byte[]{117, -125, datamode, baudRate};
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetMQTTUser(AsyncSocketState state, String user, String pwd, int keeptime) {
        Respond.Temperature = "";
        byte type = 69;
        byte[] User = new byte[32];
        System.arraycopy(Command.toBytes(this.cmd.convertStringToHex(user)), 0, User, 0, Command.toBytes(this.cmd.convertStringToHex(user)).length);
        byte[] PWD = new byte[32];
        System.arraycopy(Command.toBytes(this.cmd.convertStringToHex(pwd)), 0, PWD, 0, Command.toBytes(this.cmd.convertStringToHex(pwd)).length);
        byte[] time = new byte[]{(byte)(keeptime >> 8), (byte)keeptime};
        byte[] msgbody = new byte[User.length + PWD.length + time.length];
        System.arraycopy(User, 0, msgbody, 0, User.length);
        System.arraycopy(PWD, 0, msgbody, User.length, PWD.length);
        System.arraycopy(time, 0, msgbody, User.length + PWD.length, time.length);
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetMQTTTheme(AsyncSocketState state, String theme) {
        Respond.Temperature = "";
        byte type = 71;
        byte[] Theme = new byte[16];
        System.arraycopy(Command.toBytes(this.cmd.convertStringToHex(theme)), 0, Theme, 0, Command.toBytes(this.cmd.convertStringToHex(theme)).length);
        byte[] msgbody = new byte[Theme.length];
        System.arraycopy(Theme, 0, msgbody, 0, Theme.length);
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetWorkMode(AsyncSocketState state, byte delay, byte weigand_en, byte weigand, byte mode_opt, byte trigger, byte single_loop, byte read_buzzer, byte write_buzzer, byte heartbeat_en, byte send_duty, byte time, byte fliter_type, int fliter_time, byte check, byte checkdata1, byte checkdata2, byte alarmmode, byte count, byte alerttime) {
        Respond.Gerneral = "";
        byte type = 55;
        byte addresshigh = (byte)(fliter_time >> 8);
        byte addresslow = (byte)fliter_time;
        byte[] msgbody = new byte[]{delay, weigand_en, weigand, mode_opt, trigger, single_loop, read_buzzer, write_buzzer, heartbeat_en, send_duty, time, fliter_type, addresshigh, addresslow, alarmmode, check, checkdata1, checkdata2, count, alerttime};
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetWorkMode(AsyncSocketState state) {
        Respond.Workmode = "";
        byte[] msgbody = new byte[0];
        byte type = 52;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetTagfocus(AsyncSocketState state) {
        Respond.Tagfocus = "";
        byte[] msgbody = new byte[0];
        byte type = 42;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetQT(AsyncSocketState state, byte[] pwd, byte[] fliter, byte[] fliterlen, byte[] fliterdata) {
        Respond.QT = "";
        byte type = 39;
        byte[] msgbody = new byte[pwd.length + fliter.length + fliterlen.length + fliterdata.length];
        System.arraycopy(pwd, 0, msgbody, 0, pwd.length);
        System.arraycopy(fliter, 0, msgbody, pwd.length, fliter.length);
        System.arraycopy(fliterlen, 0, msgbody, pwd.length + fliter.length, fliterlen.length);
        System.arraycopy(fliterdata, 0, msgbody, pwd.length + fliter.length + fliterlen.length, fliterdata.length);
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetEPC(AsyncSocketState state) {
        byte[] msgbody = new byte[1];
        byte type = 68;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetEPC(AsyncSocketState state, String epc) {
        byte type = 67;
        byte[] by_data = this.cmd.StrToHexByte(epc);
        byte[] msgbody = new byte[by_data.length + 1];
        msgbody[0] = (byte)(by_data.length / 2);
        System.arraycopy(by_data, 0, msgbody, 1, by_data.length);
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String AntCheck(AsyncSocketState state, byte Ant_State) {
        byte type = -2;
        byte[] byArray = new byte[3];
        byArray[0] = 1;
        byArray[2] = Ant_State;
        byte[] msgbody = byArray;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String ReadTagTemp(AsyncSocketState state, byte State2) {
        byte type = -10;
        byte[] byArray = new byte[5];
        byArray[0] = 1;
        byArray[1] = State2;
        byte[] msgbody = byArray;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetReadTagMode(AsyncSocketState state, byte mode) {
        byte type = -2;
        byte[] byArray = new byte[3];
        byArray[2] = mode;
        byte[] msgbody = byArray;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetModuleVersion_9200(AsyncSocketState state) {
        byte type = -2;
        byte[] byArray = new byte[3];
        byArray[0] = 1;
        byArray[1] = -126;
        byte[] msgbody = byArray;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetModuleVersion_9200(AsyncSocketState state, byte Data5, byte Data6, byte Data7) {
        byte type = -2;
        byte[] msgbody = new byte[]{8, 2, -84, -74, -109, 101, Data5, Data6, Data7};
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String GetGPIOData(AsyncSocketState state) {
        byte type = 85;
        byte[] byArray = new byte[2];
        byArray[0] = 33;
        byte[] msgbody = byArray;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String SetGPIOData(AsyncSocketState state, String gpio, byte baud1, byte baud4, byte hearttime) {
        byte type = 85;
        int int_gpio0 = Integer.parseInt(gpio.substring(0, 8), 2);
        byte GPIO0 = (byte)int_gpio0;
        int int_gpio1 = Integer.parseInt(gpio.substring(8, 16), 2);
        byte GPIO1 = (byte)int_gpio1;
        byte[] byArray = new byte[14];
        byArray[0] = 32;
        byArray[2] = GPIO0;
        byArray[3] = GPIO1;
        byArray[4] = baud1;
        byArray[6] = baud4;
        byArray[9] = hearttime;
        byte[] msgbody = byArray;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String Send_ThroughData(AsyncSocketState state, byte port, byte[] throughdata) {
        byte type = 85;
        byte[] msgbody = new byte[throughdata.length + 2];
        msgbody[0] = port;
        msgbody[1] = 0;
        System.arraycopy(throughdata, 0, msgbody, 2, throughdata.length);
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String Send_ThroughData(AsyncSocketState state, byte port, byte gpio_num, byte start_state, byte end_state, byte num, byte[] start_keeptime, byte[] end_keeptime) {
        byte type = 85;
        byte[] byArray = new byte[10];
        byArray[0] = port;
        byArray[2] = gpio_num;
        byArray[3] = start_state;
        byArray[4] = end_state;
        byArray[5] = num;
        byArray[6] = start_keeptime[0];
        byArray[7] = start_keeptime[1];
        byArray[8] = end_keeptime[0];
        byArray[9] = end_keeptime[1];
        byte[] msgbody = byArray;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String ResetDev(AsyncSocketState state, byte part, byte[] time) {
        byte type = 85;
        byte[] byArray = new byte[7];
        byArray[0] = 45;
        byArray[2] = 121;
        byArray[3] = -105;
        byArray[4] = part;
        byArray[5] = time[0];
        byArray[6] = time[1];
        byte[] msgbody = byArray;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String ReadNetName(AsyncSocketState state) {
        byte[] msgbody = new byte[1];
        byte type = 86;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String WriteNetName(AsyncSocketState state, byte[] NetName) {
        byte type = 86;
        byte[] msgbody = new byte[NetName.length + 2];
        msgbody[0] = 1;
        msgbody[1] = (byte)NetName.length;
        System.arraycopy(NetName, 0, msgbody, 2, NetName.length);
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String START_MuiltTags_Temp(AsyncSocketState state) {
        byte type = -10;
        byte[] byArray = new byte[5];
        byArray[0] = 2;
        byArray[1] = 1;
        byte[] msgbody = byArray;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public String STOP_MuiltTags_Temp(AsyncSocketState state) {
        byte type = -10;
        byte[] byArray = new byte[5];
        byArray[0] = 2;
        byte[] msgbody = byArray;
        byte[] command = this.cmd.PackSelector(msgbody, type);
        if (!this.Send(state, command)) {
            return "-4";
        }
        return "0";
    }

    public static String bytes2HexString(byte[] b) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            result.append(hex.toUpperCase());
            ++i;
        }
        return result.toString();
    }

    public String NowTime() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
        String createdate = sdf.format(date);
        return createdate;
    }
}

