/*
 * Decompiled with CFR 0.152.
 */
package uhf;

import android_serialport_api.SerialPort;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uhf.AsyncSocketState;
import uhf.DevTypes;
import uhf.DeviceInformationTable;
import uhf.MultiLableCallBack;
import uhf.Reader;
import uhf.RecvData;

public class SerialPortAndroid {
    private SerialPort mSerialPort;
    private OutputStream mOutputStream;
    private InputStream mInputStream;
    private DeviceInformationTable _devinfo;
    AsyncSocketState state;
    public Reader reader;
    public MultiLableCallBack mc;
    public RecvData recvdata;
    private ReadThread ReadThread;
    byte[] RecvNetData = new byte[102400];
    int WriteIndex = 0;

    public SerialPortAndroid(MultiLableCallBack mc, Reader reader) {
        this.reader = reader;
        this.mc = mc;
        this.recvdata = new RecvData(mc, reader);
    }

    public Boolean OpenSerialPort(String SerialName, DeviceInformationTable devinfo) {
        try {
            this.state = new AsyncSocketState();
            this.mSerialPort = new SerialPort(new File(SerialName), 115200, 0);
            this.mOutputStream = this.mSerialPort.getOutputStream();
            this.mInputStream = this.mSerialPort.getInputStream();
            this.AddState("Android", SerialName, devinfo);
            this.ReadThread_start();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void CloseSerialPort() {
        this.ReadThread_stop();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        this.mSerialPort.close();
        this.mSerialPort = null;
        try {
            this.mOutputStream.close();
            this.mOutputStream = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.mInputStream.close();
            this.mInputStream = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void Send(byte[] data) {
        try {
            this.mOutputStream.write(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void ReadThread_start() {
        if (this.ReadThread == null) {
            this.ReadThread = new ReadThread();
            this.ReadThread.start();
        }
    }

    private void ReadThread_stop() {
        if (this.ReadThread != null) {
            this.ReadThread.stop = true;
            this.ReadThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RecvData(byte[] data) {
        try {
            byte[] byArray = data;
            synchronized (data) {
                this.recvdata.CommandParsing(data, this.state);
                this.state.recvLength = data.length;
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (Exception ex) {
            String error = "" + ex;
            String string = String.valueOf(error);
        }
        {
            return;
        }
    }

    public void AddState(String type, String PortName, DeviceInformationTable devinfo) {
        this._devinfo = devinfo;
        this.state.types = type;
        this.state.com = PortName;
        this.state.ip_addr = "";
        this.state.port = "--";
        this.state.dev = "";
        this.state.state = "";
        this.state.dev_mode = -1;
        this._devinfo.AddDevice(this.state);
    }

    public void RecvDataHandle(AsyncSocketState clientstate, byte[] data) {
        System.arraycopy(data, 0, this.RecvNetData, this.WriteIndex, data.length);
        this.WriteIndex += data.length;
        int i = 0;
        while (i < this.WriteIndex) {
            if (this.RecvNetData[i] == -69 && this.WriteIndex >= 3 && this.WriteIndex > (this.RecvNetData[i + 2] & 0xFF) + 3 + 3 && this.RecvNetData[i + (this.RecvNetData[i + 2] + 3 + 1)] == 13 && this.RecvNetData[i + (this.RecvNetData[i + 2] + 3 + 2)] == 10) {
                if (this.RecvNetData[i + (this.RecvNetData[i + 2] + 3 + 3)] == -69) {
                    clientstate.dev_mode = DevTypes.Moudle;
                    byte[] SendData = new byte[this.WriteIndex];
                    System.arraycopy(this.RecvNetData, 0, SendData, 0, this.WriteIndex);
                    this.recvdata.CommandParsing(SendData, clientstate);
                    this.state.recvLength = SendData.length;
                    this.WriteIndex = 0;
                    break;
                }
                if (this.RecvNetData[i + (this.RecvNetData[i + 2] + 3 + 3)] == 126 && this.RecvNetData[i + (this.RecvNetData[i + 2] + 3 + 4)] == 126) {
                    clientstate.dev_mode = DevTypes.Machine;
                    clientstate.dev = String.valueOf(SerialPortAndroid.bytes2HexString(this.RecvNetData[i + (this.RecvNetData[i + 2] + 3 + 5)])) + SerialPortAndroid.bytes2HexString(this.RecvNetData[i + (this.RecvNetData[i + 2] + 3 + 6)]) + SerialPortAndroid.bytes2HexString(this.RecvNetData[i + (this.RecvNetData[i + 2] + 3 + 7)]) + SerialPortAndroid.bytes2HexString(this.RecvNetData[i + (this.RecvNetData[i + 2] + 3 + 8)]);
                    byte[] SendData = new byte[this.WriteIndex];
                    System.arraycopy(this.RecvNetData, 0, SendData, 0, this.WriteIndex);
                    this.recvdata.CommandParsing(SendData, clientstate);
                    this.state.recvLength = SendData.length;
                    this.WriteIndex = 0;
                    break;
                }
            }
            ++i;
        }
    }

    public static String bytes2HexString(byte[] b) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            result.append(hex.toUpperCase());
            ++i;
        }
        return result.toString();
    }

    public static String bytes2HexString(byte b) {
        StringBuffer result = new StringBuffer();
        String hex = Integer.toHexString(b & 0xFF);
        if (hex.length() == 1) {
            hex = String.valueOf('0') + hex;
        }
        result.append(hex.toUpperCase());
        return result.toString();
    }

    private class ReadThread
    extends Thread {
        public Boolean stop = false;

        private ReadThread() {
        }

        @Override
        public void run() {
            while (!this.stop.booleanValue()) {
                try {
                    if (SerialPortAndroid.this.mInputStream == null) {
                        return;
                    }
                    byte[] buffer = new byte[1024];
                    int datalen = SerialPortAndroid.this.mInputStream.available();
                    if (datalen > 0) {
                        Thread.sleep(5L);
                        int size = SerialPortAndroid.this.mInputStream.read(buffer);
                        byte[] RecvData2 = new byte[size];
                        System.arraycopy(buffer, 0, RecvData2, 0, size);
                        if (SerialPortAndroid.this.state.dev_mode == -1) {
                            SerialPortAndroid.this.RecvDataHandle(SerialPortAndroid.this.state, RecvData2);
                            continue;
                        }
                        SerialPortAndroid.this.RecvData(RecvData2);
                        continue;
                    }
                    Thread.sleep(10L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

