/*
 * Decompiled with CFR 0.152.
 */
package uhf;

import com.fazecast.jSerialComm.SerialPort;
import uhf.AsyncSocketState;
import uhf.DevTypes;
import uhf.DeviceInformationTable;
import uhf.MultiLableCallBack;
import uhf.Reader;
import uhf.RecvData;

public class SerialPortSR {
    public static SerialPort comPort;
    private DeviceInformationTable _devinfo;
    AsyncSocketState state;
    public Reader reader;
    public MultiLableCallBack mc;
    public RecvData recvdata;
    private Recv_Thread Recv_Thread;
    byte[] RecvNetData = new byte[102400];
    int WriteIndex = 0;

    public SerialPortSR(MultiLableCallBack mc, Reader reader) {
        this.reader = reader;
        this.mc = mc;
        this.recvdata = new RecvData(mc, reader);
    }

    public Boolean openPort(String portName, int baudrate, DeviceInformationTable devinfo) {
        Boolean ret = false;
        try {
            this.state = new AsyncSocketState();
            SerialPort[] comlist = SerialPort.getCommPorts();
            String ComName = "";
            int i = 0;
            while (i < comlist.length) {
                ComName = SerialPort.getCommPorts()[i].getSystemPortName();
                if (ComName.equals(portName)) {
                    if (!ret.booleanValue()) {
                        ret = true;
                        comPort = SerialPort.getCommPorts()[i];
                        comPort.setBaudRate(baudrate);
                        ret = comPort.openPort();
                        if (ret.booleanValue()) {
                            this.Recv_Thread_start();
                            this.AddState("COM", portName, devinfo);
                        } else {
                            ret = false;
                        }
                    }
                    break;
                }
                ++i;
            }
        }
        catch (Exception e1) {
            ret = false;
            String error = "" + e1;
            error = String.valueOf(error);
            return ret;
        }
        return ret;
    }

    public Boolean closePort() {
        try {
            if (comPort != null) {
                comPort.closePort();
                comPort = null;
                this.Recv_Thread_stop();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void AddState(String type, String PortName, DeviceInformationTable devinfo) {
        this._devinfo = devinfo;
        this.state.types = type;
        this.state.com = PortName;
        this.state.ip_addr = "";
        this.state.port = "--";
        this.state.dev = "";
        this.state.state = "";
        this._devinfo.AddDevice(this.state);
    }

    public static void sendToPort(byte[] order) {
        try {
            if (comPort != null) {
                comPort.writeBytes(order, (long)order.length);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void RecvDataHandle(AsyncSocketState clientstate, byte[] data) {
        System.arraycopy(data, 0, this.RecvNetData, this.WriteIndex, data.length);
        this.WriteIndex += data.length;
        int i = 0;
        while (i < this.WriteIndex) {
            if (this.RecvNetData[i] == -69 && this.WriteIndex >= 3 && this.WriteIndex > (this.RecvNetData[i + 2] & 0xFF) + 3 + 3 && this.RecvNetData[i + (this.RecvNetData[i + 2] + 3 + 1)] == 13 && this.RecvNetData[i + (this.RecvNetData[i + 2] + 3 + 2)] == 10) {
                if (this.RecvNetData[i + (this.RecvNetData[i + 2] + 3 + 3)] == -69) {
                    clientstate.dev_mode = DevTypes.Moudle;
                    byte[] SendData = new byte[this.WriteIndex];
                    System.arraycopy(this.RecvNetData, 0, SendData, 0, this.WriteIndex);
                    this.recvdata.CommandParsing(SendData, clientstate);
                    this.state.recvLength = SendData.length;
                    this.WriteIndex = 0;
                    break;
                }
                if (this.RecvNetData[i + (this.RecvNetData[i + 2] + 3 + 3)] == 126 && this.RecvNetData[i + (this.RecvNetData[i + 2] + 3 + 4)] == 126) {
                    clientstate.dev_mode = DevTypes.Machine;
                    clientstate.dev = String.valueOf(SerialPortSR.bytes2HexString(this.RecvNetData[i + (this.RecvNetData[i + 2] + 3 + 5)])) + SerialPortSR.bytes2HexString(this.RecvNetData[i + (this.RecvNetData[i + 2] + 3 + 6)]) + SerialPortSR.bytes2HexString(this.RecvNetData[i + (this.RecvNetData[i + 2] + 3 + 7)]) + SerialPortSR.bytes2HexString(this.RecvNetData[i + (this.RecvNetData[i + 2] + 3 + 8)]);
                    byte[] SendData = new byte[this.WriteIndex];
                    System.arraycopy(this.RecvNetData, 0, SendData, 0, this.WriteIndex);
                    this.recvdata.CommandParsing(SendData, clientstate);
                    this.state.recvLength = SendData.length;
                    this.WriteIndex = 0;
                    break;
                }
            }
            ++i;
        }
    }

    public void RecvDataS(byte[] data) {
        String StrData = SerialPortSR.bytes2HexString(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RecvData(byte[] data) {
        try {
            byte[] byArray = data;
            synchronized (data) {
                this.recvdata.CommandParsing(data, this.state);
                this.state.recvLength = data.length;
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (Exception ex) {
            String error = "" + ex;
            String string = String.valueOf(error);
        }
        {
            return;
        }
    }

    private void Recv_Thread_start() {
        if (this.Recv_Thread == null) {
            this.Recv_Thread = new Recv_Thread();
            this.Recv_Thread.start();
        }
    }

    private void Recv_Thread_stop() {
        if (this.Recv_Thread != null) {
            this.Recv_Thread.stop = true;
            this.Recv_Thread = null;
        }
    }

    public static String bytes2HexString(byte[] b) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            result.append(hex.toUpperCase());
            ++i;
        }
        return result.toString();
    }

    public static String bytes2HexString(byte b) {
        StringBuffer result = new StringBuffer();
        String hex = Integer.toHexString(b & 0xFF);
        if (hex.length() == 1) {
            hex = String.valueOf('0') + hex;
        }
        result.append(hex.toUpperCase());
        return result.toString();
    }

    private class Recv_Thread
    extends Thread {
        public boolean stop;

        private Recv_Thread() {
        }

        @Override
        public void run() {
            while (!this.stop) {
                try {
                    byte[] readBuffer = new byte[comPort.bytesAvailable()];
                    int numRead = comPort.readBytes(readBuffer, (long)readBuffer.length);
                    if (numRead > 0) {
                        if (SerialPortSR.this.state.dev_mode == -1) {
                            SerialPortSR.this.RecvDataHandle(SerialPortSR.this.state, readBuffer);
                            continue;
                        }
                        SerialPortSR.this.RecvData(readBuffer);
                        continue;
                    }
                    Thread.sleep(10L);
                }
                catch (Exception e) {
                    String error = "" + e;
                    String string = String.valueOf(error);
                }
            }
        }
    }
}

