/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.mina.util.Base64;

public class WebSocketUtil {
    public static String getSecWebSocketAccept(String key) {
        String secKey = WebSocketUtil.getSecWebSocketKey(key);
        String guid = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        secKey = String.valueOf(secKey) + guid;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(secKey.getBytes("iso-8859-1"), 0, secKey.length());
            byte[] sha1Hash = md.digest();
            secKey = new String(Base64.encodeBase64((byte[])sha1Hash));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String rtn = "HTTP/1.1 101 Switching Protocols\r\nUpgrade: websocket\r\nConnection: Upgrade\r\nSec-WebSocket-Accept: " + secKey + "\r\n\r\n";
        return rtn;
    }

    private static String getSecWebSocketKey(String req) {
        Pattern p = Pattern.compile("^(Sec-WebSocket-Key:).+", 10);
        Matcher m = p.matcher(req);
        if (m.find()) {
            String foundstring = m.group();
            return foundstring.split(":")[1].trim();
        }
        return null;
    }

    public static byte[] encode(String msg) throws UnsupportedEncodingException {
        int masking_key_startIndex = 2;
        byte[] msgByte = msg.getBytes("UTF-8");
        if (msgByte.length <= 125) {
            masking_key_startIndex = 2;
        } else if (msgByte.length > 65536) {
            masking_key_startIndex = 10;
        } else if (msgByte.length > 125) {
            masking_key_startIndex = 4;
        }
        byte[] result = new byte[msgByte.length + masking_key_startIndex];
        result[0] = -127;
        if (msgByte.length <= 125) {
            result[1] = (byte)msgByte.length;
        } else if (msgByte.length > 65536) {
            result[1] = 127;
        } else if (msgByte.length > 125) {
            result[1] = 126;
            result[2] = (byte)(msgByte.length >> 8);
            result[3] = (byte)(msgByte.length % 256);
        }
        int i = 0;
        while (i < msgByte.length) {
            result[i + masking_key_startIndex] = msgByte[i];
            ++i;
        }
        return result;
    }
}

