/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http;

import java.io.IOException;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.ResponseHandler;
import me.chanjar.weixin.common.util.http.apache.ApacheSimplePostRequestExecutor;
import me.chanjar.weixin.common.util.http.jodd.JoddHttpSimplePostRequestExecutor;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpSimplePostRequestExecutor;
import org.jetbrains.annotations.NotNull;

public abstract class SimplePostRequestExecutor<H, P>
implements RequestExecutor<String, String> {
    protected RequestHttp<H, P> requestHttp;

    public SimplePostRequestExecutor(RequestHttp requestHttp) {
        this.requestHttp = requestHttp;
    }

    @Override
    public void execute(String uri, String data, ResponseHandler<String> handler, WxType wxType) throws WxErrorException, IOException {
        handler.handle((String)this.execute(uri, data, wxType));
    }

    public static RequestExecutor<String, String> create(RequestHttp requestHttp) {
        switch (requestHttp.getRequestType()) {
            case APACHE_HTTP: {
                return new ApacheSimplePostRequestExecutor(requestHttp);
            }
            case JODD_HTTP: {
                return new JoddHttpSimplePostRequestExecutor(requestHttp);
            }
            case OK_HTTP: {
                return new OkHttpSimplePostRequestExecutor(requestHttp);
            }
        }
        throw new IllegalArgumentException("\u975e\u6cd5\u8bf7\u6c42\u53c2\u6570");
    }

    @NotNull
    public String handleResponse(WxType wxType, String responseContent) throws WxErrorException {
        if (responseContent.isEmpty()) {
            throw new WxErrorException("\u65e0\u54cd\u5e94\u5185\u5bb9");
        }
        if (responseContent.startsWith("<xml>")) {
            return responseContent;
        }
        WxError error = WxError.fromJson(responseContent, wxType);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return responseContent;
    }
}

