package me.chanjar.weixin.cp.bean.messagebuilder;

import me.chanjar.weixin.common.api.WxConsts;
import me.chanjar.weixin.cp.bean.message.WxCpMessage;

/**
 * 文本消息builder
 * <pre>
 * 用法: WxCustomMessage m = WxCustomMessage.TEXT().content(...).toUser(...).build();
 * </pre>
 *
 * @author Daniel Qian
 */
public final class TextBuilder extends BaseBuilder<TextBuilder> {
  private String content;

  /**
   * Instantiates a new Text builder.
   */
  public TextBuilder() {
    this.msgType = WxConsts.KefuMsgType.TEXT;
  }

  /**
   * Content text builder.
   *
   * @param content the content
   * @return the text builder
   */
  public TextBuilder content(String content) {
    this.content = content;
    return this;
  }

  @Override
  public WxCpMessage build() {
    WxCpMessage m = super.build();
    m.setContent(this.content);
    return m;
  }
}
