/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.JsonObject;
import java.text.Format;
import java.util.Date;
import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpDataCubeService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.datacube.WxDataCubeArticleResult;
import me.chanjar.weixin.mp.bean.datacube.WxDataCubeArticleTotal;
import me.chanjar.weixin.mp.bean.datacube.WxDataCubeInterfaceResult;
import me.chanjar.weixin.mp.bean.datacube.WxDataCubeMsgResult;
import me.chanjar.weixin.mp.bean.datacube.WxDataCubeUserCumulate;
import me.chanjar.weixin.mp.bean.datacube.WxDataCubeUserSummary;
import org.apache.commons.lang3.time.FastDateFormat;

public class WxMpDataCubeServiceImpl
implements WxMpDataCubeService {
    private final Format dateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    private WxMpService wxMpService;

    public WxMpDataCubeServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }

    @Override
    public List<WxDataCubeUserSummary> getUserSummary(Date beginDate, Date endDate) throws WxErrorException {
        String responseContent = this.wxMpService.post("https://api.weixin.qq.com/datacube/getusersummary", this.buildParams(beginDate, endDate));
        return WxDataCubeUserSummary.fromJson(responseContent);
    }

    @Override
    public List<WxDataCubeUserCumulate> getUserCumulate(Date beginDate, Date endDate) throws WxErrorException {
        String responseContent = this.wxMpService.post("https://api.weixin.qq.com/datacube/getusercumulate", this.buildParams(beginDate, endDate));
        return WxDataCubeUserCumulate.fromJson(responseContent);
    }

    @Override
    public List<WxDataCubeArticleResult> getArticleSummary(Date beginDate, Date endDate) throws WxErrorException {
        return this.getArticleResults("https://api.weixin.qq.com/datacube/getarticlesummary", beginDate, endDate);
    }

    @Override
    public List<WxDataCubeArticleTotal> getArticleTotal(Date beginDate, Date endDate) throws WxErrorException {
        String responseContent = this.wxMpService.post("https://api.weixin.qq.com/datacube/getarticletotal", this.buildParams(beginDate, endDate));
        return WxDataCubeArticleTotal.fromJson(responseContent);
    }

    @Override
    public List<WxDataCubeArticleResult> getUserRead(Date beginDate, Date endDate) throws WxErrorException {
        return this.getArticleResults("https://api.weixin.qq.com/datacube/getuserread", beginDate, endDate);
    }

    @Override
    public List<WxDataCubeArticleResult> getUserReadHour(Date beginDate, Date endDate) throws WxErrorException {
        return this.getArticleResults("https://api.weixin.qq.com/datacube/getuserreadhour", beginDate, endDate);
    }

    @Override
    public List<WxDataCubeArticleResult> getUserShare(Date beginDate, Date endDate) throws WxErrorException {
        return this.getArticleResults("https://api.weixin.qq.com/datacube/getusershare", beginDate, endDate);
    }

    @Override
    public List<WxDataCubeArticleResult> getUserShareHour(Date beginDate, Date endDate) throws WxErrorException {
        return this.getArticleResults("https://api.weixin.qq.com/datacube/getusersharehour", beginDate, endDate);
    }

    private List<WxDataCubeArticleResult> getArticleResults(String url, Date beginDate, Date endDate) throws WxErrorException {
        String responseContent = this.wxMpService.post(url, this.buildParams(beginDate, endDate));
        return WxDataCubeArticleResult.fromJson(responseContent);
    }

    @Override
    public List<WxDataCubeMsgResult> getUpstreamMsg(Date beginDate, Date endDate) throws WxErrorException {
        return this.getUpstreamMsg("https://api.weixin.qq.com/datacube/getupstreammsg", beginDate, endDate);
    }

    @Override
    public List<WxDataCubeMsgResult> getUpstreamMsgHour(Date beginDate, Date endDate) throws WxErrorException {
        return this.getUpstreamMsg("https://api.weixin.qq.com/datacube/getupstreammsghour", beginDate, endDate);
    }

    @Override
    public List<WxDataCubeMsgResult> getUpstreamMsgWeek(Date beginDate, Date endDate) throws WxErrorException {
        return this.getUpstreamMsg("https://api.weixin.qq.com/datacube/getupstreammsgweek", beginDate, endDate);
    }

    @Override
    public List<WxDataCubeMsgResult> getUpstreamMsgMonth(Date beginDate, Date endDate) throws WxErrorException {
        return this.getUpstreamMsg("https://api.weixin.qq.com/datacube/getupstreammsgmonth", beginDate, endDate);
    }

    @Override
    public List<WxDataCubeMsgResult> getUpstreamMsgDist(Date beginDate, Date endDate) throws WxErrorException {
        return this.getUpstreamMsg("https://api.weixin.qq.com/datacube/getupstreammsgdist", beginDate, endDate);
    }

    @Override
    public List<WxDataCubeMsgResult> getUpstreamMsgDistWeek(Date beginDate, Date endDate) throws WxErrorException {
        return this.getUpstreamMsg("https://api.weixin.qq.com/datacube/getupstreammsgdistweek", beginDate, endDate);
    }

    @Override
    public List<WxDataCubeMsgResult> getUpstreamMsgDistMonth(Date beginDate, Date endDate) throws WxErrorException {
        return this.getUpstreamMsg("https://api.weixin.qq.com/datacube/getupstreammsgdistmonth", beginDate, endDate);
    }

    private List<WxDataCubeMsgResult> getUpstreamMsg(String url, Date beginDate, Date endDate) throws WxErrorException {
        String responseContent = this.wxMpService.post(url, this.buildParams(beginDate, endDate));
        return WxDataCubeMsgResult.fromJson(responseContent);
    }

    @Override
    public List<WxDataCubeInterfaceResult> getInterfaceSummary(Date beginDate, Date endDate) throws WxErrorException {
        String responseContent = this.wxMpService.post("https://api.weixin.qq.com/datacube/getinterfacesummary", this.buildParams(beginDate, endDate));
        return WxDataCubeInterfaceResult.fromJson(responseContent);
    }

    private String buildParams(Date beginDate, Date endDate) {
        JsonObject param = new JsonObject();
        param.addProperty("begin_date", this.dateFormat.format(beginDate));
        param.addProperty("end_date", this.dateFormat.format(endDate));
        return param.toString();
    }

    @Override
    public List<WxDataCubeInterfaceResult> getInterfaceSummaryHour(Date beginDate, Date endDate) throws WxErrorException {
        String responseContent = this.wxMpService.post("https://api.weixin.qq.com/datacube/getinterfacesummaryhour", this.buildParams(beginDate, endDate));
        return WxDataCubeInterfaceResult.fromJson(responseContent);
    }
}

