/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.bean.message;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlCData;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.Serializable;
import me.chanjar.weixin.common.util.crypto.WxCryptUtil;
import me.chanjar.weixin.common.util.xml.XStreamCDataConverter;
import me.chanjar.weixin.mp.builder.outxml.DeviceBuilder;
import me.chanjar.weixin.mp.builder.outxml.ImageBuilder;
import me.chanjar.weixin.mp.builder.outxml.MusicBuilder;
import me.chanjar.weixin.mp.builder.outxml.NewsBuilder;
import me.chanjar.weixin.mp.builder.outxml.TextBuilder;
import me.chanjar.weixin.mp.builder.outxml.TransferCustomerServiceBuilder;
import me.chanjar.weixin.mp.builder.outxml.VideoBuilder;
import me.chanjar.weixin.mp.builder.outxml.VoiceBuilder;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.mp.util.crypto.WxMpCryptUtil;
import me.chanjar.weixin.mp.util.xml.XStreamTransformer;

@XStreamAlias(value="xml")
@JacksonXmlRootElement(localName="xml")
public abstract class WxMpXmlOutMessage
implements Serializable {
    private static final long serialVersionUID = -381382011286216263L;
    @XStreamAlias(value="ToUserName")
    @XStreamConverter(value=XStreamCDataConverter.class)
    @JacksonXmlProperty(localName="ToUserName")
    @JacksonXmlCData
    protected String toUserName;
    @XStreamAlias(value="FromUserName")
    @XStreamConverter(value=XStreamCDataConverter.class)
    @JacksonXmlProperty(localName="FromUserName")
    @JacksonXmlCData
    protected String fromUserName;
    @XStreamAlias(value="CreateTime")
    @JacksonXmlProperty(localName="CreateTime")
    protected Long createTime;
    @XStreamAlias(value="MsgType")
    @XStreamConverter(value=XStreamCDataConverter.class)
    @JacksonXmlProperty(localName="MsgType")
    @JacksonXmlCData
    protected String msgType;
    @XStreamAlias(value="Encrypt")
    @XStreamConverter(value=XStreamCDataConverter.class)
    @JacksonXmlProperty(localName="Encrypt")
    @JacksonXmlCData
    private String encrypt;
    @XStreamAlias(value="MsgSignature")
    @XStreamConverter(value=XStreamCDataConverter.class)
    @JacksonXmlProperty(localName="MsgSignature")
    @JacksonXmlCData
    private String msgSignature;
    @XStreamAlias(value="TimeStamp")
    @XStreamConverter(value=XStreamCDataConverter.class)
    @JacksonXmlProperty(localName="TimeStamp")
    @JacksonXmlCData
    private String timeStamp;
    @XStreamAlias(value="Nonce")
    @XStreamConverter(value=XStreamCDataConverter.class)
    @JacksonXmlProperty(localName="Nonce")
    @JacksonXmlCData
    private String nonce;

    public static TextBuilder TEXT() {
        return new TextBuilder();
    }

    public static ImageBuilder IMAGE() {
        return new ImageBuilder();
    }

    public static VoiceBuilder VOICE() {
        return new VoiceBuilder();
    }

    public static VideoBuilder VIDEO() {
        return new VideoBuilder();
    }

    public static MusicBuilder MUSIC() {
        return new MusicBuilder();
    }

    public static NewsBuilder NEWS() {
        return new NewsBuilder();
    }

    public static TransferCustomerServiceBuilder TRANSFER_CUSTOMER_SERVICE() {
        return new TransferCustomerServiceBuilder();
    }

    public static DeviceBuilder DEVICE() {
        return new DeviceBuilder();
    }

    public String toXml() {
        return XStreamTransformer.toXml(this.getClass(), this);
    }

    public WxMpXmlOutMessage toEncrypted(WxMpConfigStorage wxMpConfigStorage) {
        String plainXml = this.toXml();
        WxMpCryptUtil pc = new WxMpCryptUtil(wxMpConfigStorage);
        WxCryptUtil.EncryptContext context = pc.encryptContext(plainXml);
        WxMpXmlOutMessage res = new WxMpXmlOutMessage(){};
        res.setNonce(context.getNonce());
        res.setEncrypt(context.getEncrypt());
        res.setTimeStamp(context.getTimeStamp());
        res.setMsgSignature(context.getSignature());
        return res;
    }

    public String toEncryptedXml(WxMpConfigStorage wxMpConfigStorage) {
        String plainXml = this.toXml();
        WxMpCryptUtil pc = new WxMpCryptUtil(wxMpConfigStorage);
        return pc.encrypt(plainXml);
    }

    public String getToUserName() {
        return this.toUserName;
    }

    public String getFromUserName() {
        return this.fromUserName;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public String getEncrypt() {
        return this.encrypt;
    }

    public String getMsgSignature() {
        return this.msgSignature;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setToUserName(String toUserName) {
        this.toUserName = toUserName;
    }

    public void setFromUserName(String fromUserName) {
        this.fromUserName = fromUserName;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public void setEncrypt(String encrypt) {
        this.encrypt = encrypt;
    }

    public void setMsgSignature(String msgSignature) {
        this.msgSignature = msgSignature;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxMpXmlOutMessage)) {
            return false;
        }
        WxMpXmlOutMessage other = (WxMpXmlOutMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$toUserName = this.getToUserName();
        String other$toUserName = other.getToUserName();
        if (this$toUserName == null ? other$toUserName != null : !this$toUserName.equals(other$toUserName)) {
            return false;
        }
        String this$fromUserName = this.getFromUserName();
        String other$fromUserName = other.getFromUserName();
        if (this$fromUserName == null ? other$fromUserName != null : !this$fromUserName.equals(other$fromUserName)) {
            return false;
        }
        Long this$createTime = this.getCreateTime();
        Long other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$encrypt = this.getEncrypt();
        String other$encrypt = other.getEncrypt();
        if (this$encrypt == null ? other$encrypt != null : !this$encrypt.equals(other$encrypt)) {
            return false;
        }
        String this$msgSignature = this.getMsgSignature();
        String other$msgSignature = other.getMsgSignature();
        if (this$msgSignature == null ? other$msgSignature != null : !this$msgSignature.equals(other$msgSignature)) {
            return false;
        }
        String this$timeStamp = this.getTimeStamp();
        String other$timeStamp = other.getTimeStamp();
        if (this$timeStamp == null ? other$timeStamp != null : !this$timeStamp.equals(other$timeStamp)) {
            return false;
        }
        String this$nonce = this.getNonce();
        String other$nonce = other.getNonce();
        return !(this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxMpXmlOutMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $toUserName = this.getToUserName();
        result = result * 59 + ($toUserName == null ? 43 : $toUserName.hashCode());
        String $fromUserName = this.getFromUserName();
        result = result * 59 + ($fromUserName == null ? 43 : $fromUserName.hashCode());
        Long $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $encrypt = this.getEncrypt();
        result = result * 59 + ($encrypt == null ? 43 : $encrypt.hashCode());
        String $msgSignature = this.getMsgSignature();
        result = result * 59 + ($msgSignature == null ? 43 : $msgSignature.hashCode());
        String $timeStamp = this.getTimeStamp();
        result = result * 59 + ($timeStamp == null ? 43 : $timeStamp.hashCode());
        String $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
        return result;
    }

    public String toString() {
        return "WxMpXmlOutMessage(toUserName=" + this.getToUserName() + ", fromUserName=" + this.getFromUserName() + ", createTime=" + this.getCreateTime() + ", msgType=" + this.getMsgType() + ", encrypt=" + this.getEncrypt() + ", msgSignature=" + this.getMsgSignature() + ", timeStamp=" + this.getTimeStamp() + ", nonce=" + this.getNonce() + ")";
    }
}

