/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.handler;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.handler.DefaultXmlHandler;
import com.obs.services.internal.handler.SimpleHandler;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AbstractNotification;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.BucketCors;
import com.obs.services.model.BucketCorsRule;
import com.obs.services.model.BucketCustomDomainInfo;
import com.obs.services.model.BucketDirectColdAccess;
import com.obs.services.model.BucketEncryption;
import com.obs.services.model.BucketLoggingConfiguration;
import com.obs.services.model.BucketNotificationConfiguration;
import com.obs.services.model.BucketQuota;
import com.obs.services.model.BucketStorageInfo;
import com.obs.services.model.BucketStoragePolicyConfiguration;
import com.obs.services.model.BucketTagInfo;
import com.obs.services.model.BucketTypeEnum;
import com.obs.services.model.BucketVersioningConfiguration;
import com.obs.services.model.CanonicalGrantee;
import com.obs.services.model.CopyPartResult;
import com.obs.services.model.DeleteObjectsResult;
import com.obs.services.model.EventTypeEnum;
import com.obs.services.model.FunctionGraphConfiguration;
import com.obs.services.model.GrantAndPermission;
import com.obs.services.model.GranteeInterface;
import com.obs.services.model.GroupGrantee;
import com.obs.services.model.HistoricalObjectReplicationEnum;
import com.obs.services.model.InitiateMultipartUploadResult;
import com.obs.services.model.LifecycleConfiguration;
import com.obs.services.model.ListBucketAliasResult;
import com.obs.services.model.Multipart;
import com.obs.services.model.MultipartUpload;
import com.obs.services.model.ObsBucket;
import com.obs.services.model.ObsObject;
import com.obs.services.model.Owner;
import com.obs.services.model.Permission;
import com.obs.services.model.ProtocolEnum;
import com.obs.services.model.Redirect;
import com.obs.services.model.RedirectAllRequest;
import com.obs.services.model.ReplicationConfiguration;
import com.obs.services.model.RequestPaymentConfiguration;
import com.obs.services.model.RequestPaymentEnum;
import com.obs.services.model.RouteRule;
import com.obs.services.model.RouteRuleCondition;
import com.obs.services.model.RuleStatusEnum;
import com.obs.services.model.SSEAlgorithmEnum;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.TopicConfiguration;
import com.obs.services.model.VersionOrDeleteMarker;
import com.obs.services.model.VersioningStatusEnum;
import com.obs.services.model.WebsiteConfiguration;
import com.obs.services.model.fs.DirContentSummary;
import com.obs.services.model.fs.DirSummary;
import com.obs.services.model.fs.FolderContentSummary;
import com.obs.services.model.fs.ListContentSummaryFsResult;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlResponsesSaxParser {
    private static final ILogger log = LoggerBuilder.getLogger("com.obs.services.internal.RestStorageService");
    private XMLReader xmlReader = ServiceUtils.loadXMLReader();

    protected void parseXmlInputStream(DefaultHandler handler, InputStream inputStream) throws ServiceException {
        if (inputStream == null) {
            return;
        }
        try {
            this.xmlReader.setErrorHandler(handler);
            this.xmlReader.setContentHandler(handler);
            this.xmlReader.parse(new InputSource(inputStream));
        }
        catch (Exception t) {
            throw new ServiceException("Failed to parse XML document with handler " + handler.getClass(), t);
        }
        finally {
            ServiceUtils.closeStream(inputStream);
        }
    }

    protected InputStream sanitizeXmlDocument(InputStream inputStream) throws ServiceException {
        if (inputStream == null) {
            return null;
        }
        BufferedReader br = null;
        try {
            StringBuilder listingDocBuffer = new StringBuilder();
            br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            char[] buf = new char[8192];
            int read = -1;
            while ((read = br.read(buf)) != -1) {
                listingDocBuffer.append(buf, 0, read);
            }
            String listingDoc = listingDocBuffer.toString().replaceAll("\r", "&#013;");
            if (log.isTraceEnabled()) {
                log.trace("Response entity: " + listingDoc);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(listingDoc.getBytes(StandardCharsets.UTF_8));
            return byteArrayInputStream;
        }
        catch (Throwable t) {
            throw new ServiceException("Failed to sanitize XML document destined", t);
        }
        finally {
            block13: {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        if (!log.isWarnEnabled()) break block13;
                        log.warn("close failed.", e);
                    }
                }
            }
            ServiceUtils.closeStream(inputStream);
        }
    }

    public <T> T parse(InputStream inputStream, Class<T> handlerClass, boolean sanitize) throws ServiceException {
        try {
            T handler = null;
            if (SimpleHandler.class.isAssignableFrom(handlerClass)) {
                Constructor<T> c = handlerClass.getConstructor(XMLReader.class);
                handler = c.newInstance(this.xmlReader);
            } else {
                handler = handlerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (handler instanceof DefaultHandler) {
                if (sanitize) {
                    inputStream = this.sanitizeXmlDocument(inputStream);
                }
                this.parseXmlInputStream((DefaultHandler)handler, inputStream);
            }
            return handler;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public static String getDecodedString(String value, boolean needDecode) {
        if (needDecode && value != null) {
            try {
                return URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException exception) {
                throw new ServiceException(exception);
            }
        }
        return value;
    }

    public static class BucketDirectColdAccessHandler
    extends DefaultXmlHandler {
        private BucketDirectColdAccess access = new BucketDirectColdAccess();

        public BucketDirectColdAccess getBucketDirectColdAccess() {
            return this.access;
        }

        @Override
        public void endElement(String name, String elementText) {
            if ("Status".equals(name)) {
                this.access.setStatus(RuleStatusEnum.getValueFromCode(elementText));
            }
        }
    }

    public static class BucketReplicationConfigurationHandler
    extends DefaultXmlHandler {
        private ReplicationConfiguration replicationConfiguration = new ReplicationConfiguration();
        private ReplicationConfiguration.Rule currentRule;

        public ReplicationConfiguration getReplicationConfiguration() {
            return this.replicationConfiguration;
        }

        @Override
        public void startElement(String name) {
            if ("Rule".equals(name)) {
                this.currentRule = new ReplicationConfiguration.Rule();
            } else if ("Destination".equals(name)) {
                this.currentRule.setDestination(new ReplicationConfiguration.Destination());
            }
        }

        @Override
        public void endElement(String name, String content) {
            if (null != this.replicationConfiguration) {
                if ("Agency".equals(name)) {
                    this.replicationConfiguration.setAgency(content);
                } else if ("Rule".equals(name)) {
                    this.replicationConfiguration.getRules().add(this.currentRule);
                }
            }
            if (null == this.currentRule) {
                if (log.isErrorEnabled()) {
                    log.error("Response xml is not well-formt");
                }
                return;
            }
            if ("ID".equals(name)) {
                this.currentRule.setId(content);
            } else if ("Status".equals(name)) {
                this.currentRule.setStatus(RuleStatusEnum.getValueFromCode(content));
            } else if ("Prefix".equals(name)) {
                this.currentRule.setPrefix(content);
            } else if ("Bucket".equals(name)) {
                this.currentRule.getDestination().setBucket(content);
            } else if ("StorageClass".equals(name)) {
                this.currentRule.getDestination().setObjectStorageClass(StorageClassEnum.getValueFromCode(content));
            } else if ("HistoricalObjectReplication".equals(name)) {
                this.currentRule.setHistoricalObjectReplication(HistoricalObjectReplicationEnum.getValueFromCode(content));
            }
        }
    }

    public static class BucketStorageInfoHandler
    extends DefaultXmlHandler {
        private BucketStorageInfo storageInfo;

        public BucketStorageInfo getStorageInfo() {
            return this.storageInfo;
        }

        @Override
        public void startElement(String name) {
            if (name.equals("GetBucketStorageInfoResult")) {
                this.storageInfo = new BucketStorageInfo();
            }
        }

        @Override
        public void endElement(String name, String content) {
            if (null == this.storageInfo) {
                if (log.isWarnEnabled()) {
                    log.warn("Response xml is not well-formt");
                }
                return;
            }
            if (name.equals("Size")) {
                this.storageInfo.setSize(Long.parseLong(content));
            } else if (name.equals("ObjectNumber")) {
                this.storageInfo.setObjectNumber(Long.parseLong(content));
            }
        }
    }

    public static class BucketStoragePolicyHandler
    extends DefaultXmlHandler {
        protected BucketStoragePolicyConfiguration storagePolicyConfiguration;

        public BucketStoragePolicyConfiguration getStoragePolicy() {
            return this.storagePolicyConfiguration;
        }

        @Override
        public void startElement(String name) {
            if (name.equals("StoragePolicy") || name.equals("StorageClass")) {
                this.storagePolicyConfiguration = new BucketStoragePolicyConfiguration();
            }
        }

        @Override
        public void endElement(String name, String content) {
            if ((name.equals("DefaultStorageClass") || name.equals("StorageClass")) && this.storagePolicyConfiguration != null) {
                this.storagePolicyConfiguration.setBucketStorageClass(StorageClassEnum.getValueFromCode(content));
            }
        }
    }

    public static class BucketEncryptionHandler
    extends DefaultXmlHandler {
        protected BucketEncryption encryption;

        public BucketEncryption getEncryption() {
            return this.encryption;
        }

        @Override
        public void startElement(String name) {
            if (name.equals("ApplyServerSideEncryptionByDefault")) {
                this.encryption = new BucketEncryption();
            }
        }

        @Override
        public void endElement(String name, String content) {
            if (null == this.encryption) {
                if (log.isWarnEnabled()) {
                    log.warn("Response xml is not well-formt");
                }
                return;
            }
            if (name.equals("SSEAlgorithm")) {
                this.encryption.setSseAlgorithm(SSEAlgorithmEnum.getValueFromCode(content.replace("aws:", "")));
            } else if (name.equals("KMSMasterKeyID")) {
                this.encryption.setKmsKeyId(content);
            }
        }
    }

    public static class BucketQuotaHandler
    extends DefaultXmlHandler {
        protected BucketQuota quota;

        public BucketQuota getQuota() {
            return this.quota;
        }

        @Override
        public void startElement(String name) {
            if (name.equals("Quota")) {
                this.quota = new BucketQuota();
            }
        }

        @Override
        public void endElement(String name, String content) {
            if (name.equals("StorageQuota") && this.quota != null) {
                this.quota.setBucketQuota(Long.parseLong(content));
            }
        }
    }

    public static class AccessControlListHandler
    extends DefaultXmlHandler {
        protected AccessControlList accessControlList;
        protected Owner owner;
        protected GranteeInterface currentGrantee;
        protected Permission currentPermission;
        protected boolean currentDelivered;
        protected boolean insideACL = false;

        public AccessControlList getAccessControlList() {
            return this.accessControlList;
        }

        @Override
        public void startElement(String name) {
            switch (name) {
                case "AccessControlPolicy": {
                    this.accessControlList = new AccessControlList();
                    break;
                }
                case "Owner": {
                    this.owner = new Owner();
                    this.accessControlList.setOwner(this.owner);
                    break;
                }
                case "AccessControlList": {
                    this.insideACL = true;
                    break;
                }
            }
        }

        @Override
        public void endElement(String name, String content) {
            if (name.equals("ID") && !this.insideACL) {
                this.owner.setId(content);
            } else if (name.equals("DisplayName") && !this.insideACL) {
                this.owner.setDisplayName(content);
            } else if (name.equals("ID")) {
                this.currentGrantee = new CanonicalGrantee();
                this.currentGrantee.setIdentifier(content);
            } else if (name.equals("URI") || name.equals("Canned")) {
                this.currentGrantee = new GroupGrantee();
                this.currentGrantee.setIdentifier(content);
            } else if (name.equals("DisplayName")) {
                if (this.currentGrantee instanceof CanonicalGrantee) {
                    ((CanonicalGrantee)this.currentGrantee).setDisplayName(content);
                }
            } else if (name.equals("Permission")) {
                this.currentPermission = Permission.parsePermission(content);
            } else if (name.equals("Delivered")) {
                if (this.insideACL) {
                    this.currentDelivered = Boolean.parseBoolean(content);
                } else {
                    this.accessControlList.setDelivered(Boolean.parseBoolean(content));
                }
            } else if (name.equals("Grant")) {
                GrantAndPermission obj = this.accessControlList.grantPermission(this.currentGrantee, this.currentPermission);
                obj.setDelivered(this.currentDelivered);
            } else if (name.equals("AccessControlList")) {
                this.insideACL = false;
            }
        }
    }

    public static class BucketLifecycleConfigurationHandler
    extends SimpleHandler {
        private LifecycleConfiguration config = new LifecycleConfiguration();
        private LifecycleConfiguration.Rule latestRule;
        private LifecycleConfiguration.TimeEvent latestTimeEvent;

        public BucketLifecycleConfigurationHandler(XMLReader xr) {
            super(xr);
        }

        public LifecycleConfiguration getLifecycleConfig() {
            return this.config;
        }

        public void startExpiration() {
            this.latestTimeEvent = new LifecycleConfiguration.Expiration(this.config);
            this.latestRule.setExpiration((LifecycleConfiguration.Expiration)this.latestTimeEvent);
        }

        public void startNoncurrentVersionExpiration() {
            this.latestTimeEvent = new LifecycleConfiguration.NoncurrentVersionExpiration(this.config);
            this.latestRule.setNoncurrentVersionExpiration((LifecycleConfiguration.NoncurrentVersionExpiration)this.latestTimeEvent);
        }

        public void startTransition() {
            this.latestTimeEvent = new LifecycleConfiguration.Transition(this.config);
            this.latestRule.getTransitions().add((LifecycleConfiguration.Transition)this.latestTimeEvent);
        }

        public void startNoncurrentVersionTransition() {
            this.latestTimeEvent = new LifecycleConfiguration.NoncurrentVersionTransition(this.config);
            this.latestRule.getNoncurrentVersionTransitions().add((LifecycleConfiguration.NoncurrentVersionTransition)this.latestTimeEvent);
        }

        public void endStorageClass(String content) {
            LifecycleConfiguration.setStorageClass(this.latestTimeEvent, StorageClassEnum.getValueFromCode(content));
        }

        public void endDate(String content) throws ParseException {
            LifecycleConfiguration.setDate(this.latestTimeEvent, ServiceUtils.parseIso8601Date(content));
        }

        public void endNoncurrentDays(String content) {
            LifecycleConfiguration.setDays(this.latestTimeEvent, Integer.parseInt(content));
        }

        public void endDays(String content) {
            LifecycleConfiguration.setDays(this.latestTimeEvent, Integer.parseInt(content));
        }

        public void startRule() {
            this.latestRule = new LifecycleConfiguration.Rule(this.config);
        }

        public void endID(String content) {
            this.latestRule.setId(content);
        }

        public void endPrefix(String content) {
            this.latestRule.setPrefix(content);
        }

        public void endStatus(String content) {
            this.latestRule.setEnabled("Enabled".equals(content));
        }

        public void endRule(String content) {
            this.config.addRule(this.latestRule);
        }
    }

    public static class BucketNotificationConfigurationHandler
    extends DefaultXmlHandler {
        private BucketNotificationConfiguration bucketNotificationConfiguration = new BucketNotificationConfiguration();
        private String id;
        private String urn;
        private AbstractNotification.Filter filter;
        private List<EventTypeEnum> events = new ArrayList<EventTypeEnum>();
        private String ruleName;
        private String ruleValue;

        public BucketNotificationConfiguration getBucketNotificationConfiguration() {
            return this.bucketNotificationConfiguration;
        }

        @Override
        public void startElement(String name) {
            if ("Filter".equals(name)) {
                this.filter = new AbstractNotification.Filter();
            }
        }

        @Override
        public void endElement(String name, String content) {
            if ("Id".equals(name)) {
                this.id = content;
            } else if ("Topic".equals(name) || "FunctionGraph".equals(name)) {
                this.urn = content;
            } else if ("Event".equals(name)) {
                this.events.add(EventTypeEnum.getValueFromCode(content));
            } else if ("Name".equals(name)) {
                this.ruleName = content;
            } else if ("Value".equals(name)) {
                this.ruleValue = content;
            } else if ("FilterRule".equals(name)) {
                if (null == this.filter) {
                    if (log.isErrorEnabled()) {
                        log.error("Response xml is not well-formt");
                    }
                    return;
                }
                this.filter.addFilterRule(this.ruleName, this.ruleValue);
            } else if ("TopicConfiguration".equals(name)) {
                if (null == this.bucketNotificationConfiguration) {
                    if (log.isErrorEnabled()) {
                        log.error("Response xml is not well-formt");
                    }
                    return;
                }
                this.bucketNotificationConfiguration.addTopicConfiguration(new TopicConfiguration(this.id, this.filter, this.urn, this.events));
                this.events = new ArrayList<EventTypeEnum>();
            } else if ("FunctionGraphConfiguration".equals(name)) {
                if (null == this.bucketNotificationConfiguration) {
                    if (log.isErrorEnabled()) {
                        log.error("Response xml is not well-formt");
                    }
                    return;
                }
                this.bucketNotificationConfiguration.addFunctionGraphConfiguration(new FunctionGraphConfiguration(this.id, this.filter, this.urn, this.events));
                this.events = new ArrayList<EventTypeEnum>();
            }
        }
    }

    public static class BucketTagInfoHandler
    extends DefaultXmlHandler {
        private BucketTagInfo tagInfo = new BucketTagInfo();
        private String currentKey;
        private String currentValue;

        public BucketTagInfo getBucketTagInfo() {
            return this.tagInfo;
        }

        @Override
        public void endElement(String name, String content) {
            if ("Key".equals(name)) {
                this.currentKey = content;
            } else if ("Value".equals(name)) {
                this.currentValue = content;
            } else if ("Tag".equals(name)) {
                this.tagInfo.getTagSet().addTag(this.currentKey, this.currentValue);
            }
        }
    }

    public static class DeleteObjectsHandler
    extends DefaultXmlHandler {
        private DeleteObjectsResult result;
        private final List<DeleteObjectsResult.DeleteObjectResult> deletedObjectResults = new ArrayList<DeleteObjectsResult.DeleteObjectResult>();
        private final List<DeleteObjectsResult.ErrorResult> errorResults = new ArrayList<DeleteObjectsResult.ErrorResult>();
        private String key;
        private String version;
        private String deleteMarkerVersion;
        private String errorCode;
        private String message;
        private boolean withDeleteMarker;
        private String encodingType;
        private boolean needDecode;

        public DeleteObjectsResult getMultipleDeleteResult() {
            for (DeleteObjectsResult.DeleteObjectResult deleteObjectResult : this.result.getDeletedObjectResults()) {
                deleteObjectResult.setObjectKey(XmlResponsesSaxParser.getDecodedString(deleteObjectResult.getObjectKey(), this.needDecode));
            }
            for (DeleteObjectsResult.ErrorResult errorResult : this.result.getErrorResults()) {
                errorResult.setObjectKey(XmlResponsesSaxParser.getDecodedString(errorResult.getObjectKey(), this.needDecode));
            }
            return this.result;
        }

        @Override
        public void startElement(String name) {
            if (name.equals("DeleteResult")) {
                this.result = new DeleteObjectsResult();
            }
        }

        @Override
        public void endElement(String name, String content) {
            if ("Key".equals(name)) {
                this.key = content;
            } else if ("VersionId".equals(name)) {
                this.version = content;
            } else if ("DeleteMarker".equals(name)) {
                this.withDeleteMarker = Boolean.parseBoolean(content);
            } else if ("DeleteMarkerVersionId".equals(name)) {
                this.deleteMarkerVersion = content;
            } else if ("Code".equals(name)) {
                this.errorCode = content;
            } else if ("Message".equals(name)) {
                this.message = content;
            } else if ("Deleted".equals(name)) {
                DeleteObjectsResult.DeleteObjectResult r = new DeleteObjectsResult.DeleteObjectResult(this.key, this.version, this.withDeleteMarker, this.deleteMarkerVersion);
                this.deletedObjectResults.add(r);
                this.deleteMarkerVersion = null;
                this.version = null;
                this.key = null;
                this.withDeleteMarker = false;
            } else if ("Error".equals(name)) {
                this.errorResults.add(new DeleteObjectsResult.ErrorResult(this.key, this.version, this.errorCode, this.message));
                this.message = null;
                this.errorCode = null;
                this.version = null;
                this.key = null;
            } else if (name.equals("DeleteResult")) {
                this.result.getDeletedObjectResults().addAll(this.deletedObjectResults);
                this.result.getErrorResults().addAll(this.errorResults);
            } else if (name.equals("EncodingType")) {
                this.encodingType = content;
                if (this.encodingType.equals("url")) {
                    this.needDecode = true;
                }
            }
        }

        public String getEncodingType() {
            return this.encodingType;
        }
    }

    public static class BucketWebsiteConfigurationHandler
    extends DefaultXmlHandler {
        private WebsiteConfiguration config = new WebsiteConfiguration();
        private Redirect currentRedirectRule;
        private RedirectAllRequest currentRedirectAllRule;
        private RouteRule currentRoutingRule;
        private RouteRuleCondition currentCondition;

        public WebsiteConfiguration getWebsiteConfig() {
            return this.config;
        }

        @Override
        public void startElement(String name) {
            switch (name) {
                case "RedirectAllRequestsTo": {
                    this.currentRedirectAllRule = new RedirectAllRequest();
                    this.config.setRedirectAllRequestsTo(this.currentRedirectAllRule);
                    break;
                }
                case "RoutingRule": {
                    this.currentRoutingRule = new RouteRule();
                    this.config.getRouteRules().add(this.currentRoutingRule);
                    break;
                }
                case "Condition": {
                    this.currentCondition = new RouteRuleCondition();
                    this.currentRoutingRule.setCondition(this.currentCondition);
                    break;
                }
                case "Redirect": {
                    this.currentRedirectRule = new Redirect();
                    this.currentRoutingRule.setRedirect(this.currentRedirectRule);
                    break;
                }
            }
        }

        @Override
        public void endElement(String name, String content) {
            if (null != this.config) {
                if (name.equals("Suffix")) {
                    this.config.setSuffix(content);
                } else if (name.equals("Key")) {
                    this.config.setKey(content);
                }
            }
            if (null != this.currentCondition) {
                if (name.equals("KeyPrefixEquals")) {
                    this.currentCondition.setKeyPrefixEquals(content);
                } else if (name.equals("HttpErrorCodeReturnedEquals")) {
                    this.currentCondition.setHttpErrorCodeReturnedEquals(content);
                }
            }
            if (name.equals("Protocol")) {
                if (this.currentRedirectAllRule != null) {
                    this.currentRedirectAllRule.setRedirectProtocol(ProtocolEnum.getValueFromCode(content));
                } else if (this.currentRedirectRule != null) {
                    this.currentRedirectRule.setRedirectProtocol(ProtocolEnum.getValueFromCode(content));
                }
            } else if (name.equals("HostName")) {
                if (this.currentRedirectAllRule != null) {
                    this.currentRedirectAllRule.setHostName(content);
                } else if (this.currentRedirectRule != null) {
                    this.currentRedirectRule.setHostName(content);
                }
            }
            if (null != this.currentRedirectRule) {
                switch (name) {
                    case "ReplaceKeyPrefixWith": {
                        this.currentRedirectRule.setReplaceKeyPrefixWith(content);
                        break;
                    }
                    case "ReplaceKeyWith": {
                        this.currentRedirectRule.setReplaceKeyWith(content);
                        break;
                    }
                    case "HttpRedirectCode": {
                        this.currentRedirectRule.setHttpRedirectCode(content);
                        break;
                    }
                }
            }
        }
    }

    public static class CompleteMultipartUploadHandler
    extends SimpleHandler {
        private String location;
        private String bucketName;
        private String objectKey;
        private String etag;
        private String encodingType;
        private boolean needDecode;

        public CompleteMultipartUploadHandler(XMLReader xr) {
            super(xr);
        }

        public void endLocation(String content) {
            this.location = content;
        }

        public void endBucket(String content) {
            this.bucketName = content;
        }

        public void endKey(String content) {
            this.objectKey = content;
        }

        public void endETag(String content) {
            this.etag = content;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public String getObjectKey() {
            return XmlResponsesSaxParser.getDecodedString(this.objectKey, this.needDecode);
        }

        public String getEtag() {
            return this.etag;
        }

        public void endEncodingType(String content) {
            this.encodingType = content;
            if (this.encodingType.equals("url")) {
                this.needDecode = true;
            }
        }

        public String getEncodingType() {
            return this.encodingType;
        }
    }

    public static class ListPartsHandler
    extends SimpleHandler {
        private final List<Multipart> parts = new ArrayList<Multipart>();
        private String bucketName;
        private String objectKey;
        private String uploadId;
        private Owner initiator;
        private Owner owner;
        private String storageClass;
        private String partNumberMarker;
        private String nextPartNumberMarker;
        private String encodingType;
        private boolean needDecode;
        private int maxParts;
        private boolean isTruncated = false;
        private boolean isInInitiator = false;

        public ListPartsHandler(XMLReader xr) {
            super(xr);
        }

        public List<Multipart> getMultiPartList() {
            return this.parts;
        }

        public boolean isTruncated() {
            return this.isTruncated;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public String getObjectKey() {
            return XmlResponsesSaxParser.getDecodedString(this.objectKey, this.needDecode);
        }

        public String getUploadId() {
            return this.uploadId;
        }

        public Owner getInitiator() {
            return this.initiator;
        }

        public Owner getOwner() {
            return this.owner;
        }

        public String getStorageClass() {
            return this.storageClass;
        }

        public String getPartNumberMarker() {
            return this.partNumberMarker;
        }

        public String getNextPartNumberMarker() {
            return this.nextPartNumberMarker;
        }

        public String getEncodingType() {
            return this.encodingType;
        }

        public int getMaxParts() {
            return this.maxParts;
        }

        public void startPart() {
            this.transferControl(new PartResultHandler(this.xr));
        }

        @Override
        public void controlReturned(SimpleHandler childHandler) {
            if (childHandler instanceof PartResultHandler) {
                this.parts.add(((PartResultHandler)childHandler).getMultipartPart());
            } else if (childHandler instanceof OwnerHandler) {
                if (this.isInInitiator) {
                    this.initiator = ((OwnerHandler)childHandler).getOwner();
                } else {
                    this.owner = ((OwnerHandler)childHandler).getOwner();
                }
            }
        }

        public void startInitiator() {
            this.isInInitiator = true;
            this.transferControl(new OwnerHandler(this.xr));
        }

        public void startOwner() {
            this.isInInitiator = false;
            this.transferControl(new OwnerHandler(this.xr));
        }

        public void endBucket(String content) {
            this.bucketName = content;
        }

        public void endKey(String content) {
            this.objectKey = content;
        }

        public void endStorageClass(String content) {
            this.storageClass = content;
        }

        public void endUploadId(String content) {
            this.uploadId = content;
        }

        public void endPartNumberMarker(String content) {
            this.partNumberMarker = content;
        }

        public void endNextPartNumberMarker(String content) {
            this.nextPartNumberMarker = content;
        }

        public void endMaxParts(String content) {
            this.maxParts = Integer.parseInt(content);
        }

        public void endIsTruncated(String content) {
            this.isTruncated = Boolean.parseBoolean(content);
        }

        public void endEncodingType(String content) {
            this.encodingType = content;
            if (this.encodingType.equals("url")) {
                this.needDecode = true;
            }
        }
    }

    public static class PartResultHandler
    extends SimpleHandler {
        private int partNumber;
        private Date lastModified;
        private String etag;
        private long size;

        public PartResultHandler(XMLReader xr) {
            super(xr);
        }

        public Multipart getMultipartPart() {
            return new Multipart(this.partNumber, this.lastModified, this.etag, this.size);
        }

        public void endPartNumber(String content) {
            this.partNumber = Integer.parseInt(content);
        }

        public void endLastModified(String content) {
            try {
                this.lastModified = ServiceUtils.parseIso8601Date(content);
            }
            catch (ParseException e) {
                log.warn("date parse failed.", e);
            }
        }

        public void endETag(String content) {
            this.etag = content;
        }

        public void endSize(String content) {
            this.size = Long.parseLong(content);
        }

        public void endPart(String content) {
            this.returnControlToParentHandler();
        }
    }

    public static class CopyPartResultHandler
    extends SimpleHandler {
        private Date lastModified;
        private String etag;

        public CopyPartResultHandler(XMLReader xr) {
            super(xr);
        }

        public CopyPartResult getCopyPartResult(int partNumber) {
            CopyPartResult result = new CopyPartResult(partNumber, this.etag, this.lastModified);
            return result;
        }

        public void endLastModified(String content) {
            try {
                this.lastModified = ServiceUtils.parseIso8601Date(content);
            }
            catch (ParseException e) {
                log.warn("date parse failed.", e);
            }
        }

        public void endETag(String content) {
            this.etag = content;
        }
    }

    public static class ListMultipartUploadsHandler
    extends SimpleHandler {
        private final List<MultipartUpload> uploads = new ArrayList<MultipartUpload>();
        private final List<String> commonPrefixes = new ArrayList<String>();
        private final List<String> finalCommonPrefixes = new ArrayList<String>();
        private boolean insideCommonPrefixes;
        private String bucketName;
        private String keyMarker;
        private String uploadIdMarker;
        private String nextKeyMarker;
        private String nextUploadIdMarker;
        private String delimiter;
        private int maxUploads;
        private String prefix;
        private boolean isTruncated = false;
        private String encodingType;
        private boolean needDecode;

        public ListMultipartUploadsHandler(XMLReader xr) {
            super(xr);
        }

        public List<MultipartUpload> getMultipartUploadList() {
            for (MultipartUpload upload : this.uploads) {
                upload.setBucketName(this.bucketName);
                upload.setObjectKey(XmlResponsesSaxParser.getDecodedString(upload.getObjectKey(), this.needDecode));
            }
            return this.uploads;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public boolean isTruncated() {
            return this.isTruncated;
        }

        public String getKeyMarker() {
            return XmlResponsesSaxParser.getDecodedString(this.keyMarker, this.needDecode);
        }

        public String getUploadIdMarker() {
            return this.uploadIdMarker;
        }

        public String getNextKeyMarker() {
            return XmlResponsesSaxParser.getDecodedString(this.nextKeyMarker, this.needDecode);
        }

        public String getNextUploadIdMarker() {
            return this.nextUploadIdMarker;
        }

        public int getMaxUploads() {
            return this.maxUploads;
        }

        public List<String> getCommonPrefixes() {
            for (String commonPrefix : this.commonPrefixes) {
                this.finalCommonPrefixes.add(XmlResponsesSaxParser.getDecodedString(commonPrefix, this.needDecode));
            }
            return this.finalCommonPrefixes;
        }

        public String getDelimiter() {
            return XmlResponsesSaxParser.getDecodedString(this.delimiter, this.needDecode);
        }

        public String getPrefix() {
            return XmlResponsesSaxParser.getDecodedString(this.prefix, this.needDecode);
        }

        public String getEncodingType() {
            return this.encodingType;
        }

        public void startUpload() {
            this.transferControl(new MultipartUploadHandler(this.xr));
        }

        public void startCommonPrefixes() {
            this.insideCommonPrefixes = true;
        }

        @Override
        public void controlReturned(SimpleHandler childHandler) {
            if (childHandler instanceof MultipartUploadHandler) {
                this.uploads.add(((MultipartUploadHandler)childHandler).getMultipartUpload());
            }
        }

        public void endDelimiter(String content) {
            this.delimiter = content;
        }

        public void endBucket(String content) {
            this.bucketName = content;
        }

        public void endKeyMarker(String content) {
            this.keyMarker = content;
        }

        public void endUploadIdMarker(String content) {
            this.uploadIdMarker = content;
        }

        public void endNextKeyMarker(String content) {
            this.nextKeyMarker = content;
        }

        public void endNextUploadIdMarker(String content) {
            this.nextUploadIdMarker = content;
        }

        public void endMaxUploads(String content) {
            block2: {
                try {
                    this.maxUploads = Integer.parseInt(content);
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block2;
                    log.error("Response xml is not well-format", e);
                }
            }
        }

        public void endIsTruncated(String content) {
            this.isTruncated = Boolean.parseBoolean(content);
        }

        public void endPrefix(String content) {
            if (this.insideCommonPrefixes) {
                this.commonPrefixes.add(content);
            } else {
                this.prefix = content;
            }
        }

        public void endCommonPrefixes() {
            this.insideCommonPrefixes = false;
        }

        public void endEncodingType(String content) {
            this.encodingType = content;
            if (this.encodingType.equals("url")) {
                this.needDecode = true;
            }
        }
    }

    public static class MultipartUploadHandler
    extends SimpleHandler {
        private String uploadId;
        private String objectKey;
        private String storageClass;
        private Owner owner;
        private Owner initiator;
        private Date initiatedDate;
        private boolean isInInitiator = false;

        public MultipartUploadHandler(XMLReader xr) {
            super(xr);
        }

        public MultipartUpload getMultipartUpload() {
            return new MultipartUpload(this.uploadId, this.objectKey, this.initiatedDate, StorageClassEnum.getValueFromCode(this.storageClass), this.owner, this.initiator);
        }

        public void endUploadId(String content) {
            this.uploadId = content;
        }

        public void endKey(String content) {
            this.objectKey = content;
        }

        public void endStorageClass(String content) {
            this.storageClass = content;
        }

        public void endInitiated(String content) {
            try {
                this.initiatedDate = ServiceUtils.parseIso8601Date(content);
            }
            catch (ParseException e) {
                log.warn("date parse failed.", e);
            }
        }

        public void startOwner() {
            this.isInInitiator = false;
            this.transferControl(new OwnerHandler(this.xr));
        }

        public void startInitiator() {
            this.isInInitiator = true;
            this.transferControl(new OwnerHandler(this.xr));
        }

        @Override
        public void controlReturned(SimpleHandler childHandler) {
            if (childHandler instanceof OwnerHandler) {
                if (this.isInInitiator) {
                    this.initiator = ((OwnerHandler)childHandler).getOwner();
                } else {
                    this.owner = ((OwnerHandler)childHandler).getOwner();
                }
            }
        }

        public void endUpload(String content) {
            this.returnControlToParentHandler();
        }
    }

    public static class InitiateMultipartUploadHandler
    extends SimpleHandler {
        private String uploadId;
        private String bucketName;
        private String objectKey;
        private String encodingType;
        private boolean needDecode;

        public InitiateMultipartUploadHandler(XMLReader xr) {
            super(xr);
        }

        public InitiateMultipartUploadResult getInitiateMultipartUploadResult() {
            this.objectKey = XmlResponsesSaxParser.getDecodedString(this.objectKey, this.needDecode);
            return new InitiateMultipartUploadResult(this.bucketName, this.objectKey, this.uploadId);
        }

        public void endUploadId(String content) {
            this.uploadId = content;
        }

        public void endBucket(String content) {
            this.bucketName = content;
        }

        public void endKey(String content) {
            this.objectKey = content;
        }

        public void endEncodingType(String content) {
            this.encodingType = content;
            if (this.encodingType.equals("url")) {
                this.needDecode = true;
            }
        }

        public String getEncodingType() {
            return this.encodingType;
        }
    }

    public static class OwnerHandler
    extends SimpleHandler {
        private String id;
        private String displayName;

        public OwnerHandler(XMLReader xr) {
            super(xr);
        }

        public Owner getOwner() {
            Owner owner = new Owner();
            owner.setId(this.id);
            owner.setDisplayName(this.displayName);
            return owner;
        }

        public void endID(String content) {
            this.id = content;
        }

        public void endDisplayName(String content) {
            this.displayName = content;
        }

        public void endOwner(String content) {
            this.returnControlToParentHandler();
        }

        public void endInitiator(String content) {
            this.returnControlToParentHandler();
        }
    }

    public static class ListVersionsHandler
    extends DefaultXmlHandler {
        private final List<VersionOrDeleteMarker> items = new ArrayList<VersionOrDeleteMarker>();
        private final List<String> commonPrefixes = new ArrayList<String>();
        private final List<String> finalCommonPrefixes = new ArrayList<String>();
        private String key;
        private String versionId;
        private boolean isLatest = false;
        private Date lastModified;
        private Owner owner;
        private String etag;
        private long size = 0L;
        private String storageClass;
        private boolean isAppendable;
        private boolean insideCommonPrefixes = false;
        private String bucketName;
        private String requestPrefix;
        private String keyMarker;
        private String versionIdMarker;
        private long requestMaxKeys = 0L;
        private boolean listingTruncated = false;
        private String nextMarker;
        private String nextVersionIdMarker;
        private String delimiter;
        private String encodingType;
        private boolean needDecode;

        public String getDelimiter() {
            return XmlResponsesSaxParser.getDecodedString(this.delimiter, this.needDecode);
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public boolean isListingTruncated() {
            return this.listingTruncated;
        }

        public List<VersionOrDeleteMarker> getItems() {
            for (VersionOrDeleteMarker marker : this.items) {
                marker.setKey(XmlResponsesSaxParser.getDecodedString(marker.getKey(), this.needDecode));
            }
            return this.items;
        }

        public List<String> getCommonPrefixes() {
            for (String commonPrefix : this.commonPrefixes) {
                this.finalCommonPrefixes.add(XmlResponsesSaxParser.getDecodedString(commonPrefix, this.needDecode));
            }
            return this.finalCommonPrefixes;
        }

        public String getRequestPrefix() {
            return XmlResponsesSaxParser.getDecodedString(this.requestPrefix, this.needDecode);
        }

        public String getKeyMarker() {
            return XmlResponsesSaxParser.getDecodedString(this.keyMarker, this.needDecode);
        }

        public String getVersionIdMarker() {
            return this.versionIdMarker;
        }

        public String getNextKeyMarker() {
            return XmlResponsesSaxParser.getDecodedString(this.nextMarker, this.needDecode);
        }

        public String getNextVersionIdMarker() {
            return this.nextVersionIdMarker;
        }

        public String getEncodingType() {
            return this.encodingType;
        }

        public long getRequestMaxKeys() {
            return this.requestMaxKeys;
        }

        private void reset() {
            this.key = null;
            this.versionId = null;
            this.isLatest = false;
            this.lastModified = null;
            this.etag = null;
            this.isAppendable = false;
            this.size = 0L;
            this.storageClass = null;
            this.owner = null;
        }

        @Override
        public void startElement(String name) {
            if (name.equals("Owner")) {
                this.owner = new Owner();
            } else if (name.equals("CommonPrefixes")) {
                this.insideCommonPrefixes = true;
            }
        }

        @Override
        public void endElement(String name, String content) {
            this.setBaseInfo(name, content);
            if (name.equals("Key")) {
                this.key = content;
            } else if (name.equals("VersionId")) {
                this.versionId = content;
            } else if (name.equals("IsLatest")) {
                this.isLatest = Boolean.parseBoolean(content);
            } else if (name.equals("LastModified")) {
                try {
                    this.lastModified = ServiceUtils.parseIso8601Date(content);
                }
                catch (ParseException e) {
                    if (log.isWarnEnabled()) {
                        log.warn("Non-ISO8601 date for LastModified in bucket's versions listing output: " + content, e);
                    }
                }
            } else if (name.equals("ETag")) {
                this.etag = content;
            } else if (name.equals("Size")) {
                this.size = Long.parseLong(content);
            } else if (name.equals("StorageClass")) {
                this.storageClass = content;
            } else if (name.equals("Type")) {
                this.isAppendable = "Appendable".equals(content);
            } else if (name.equals("ID")) {
                if (this.owner == null) {
                    this.owner = new Owner();
                }
                this.owner.setId(content);
            } else if (name.equals("DisplayName")) {
                if (this.owner != null) {
                    this.owner.setDisplayName(content);
                }
            } else if (this.insideCommonPrefixes && name.equals("Prefix")) {
                this.commonPrefixes.add(content);
            } else if (name.equals("CommonPrefixes")) {
                this.insideCommonPrefixes = false;
            } else if (name.equals("EncodingType")) {
                this.encodingType = content;
                if (this.encodingType.equals("url")) {
                    this.needDecode = true;
                }
            }
            this.addVersionOrDeleteMarker(name);
        }

        private void setBaseInfo(String name, String content) {
            if (name.equals("Name")) {
                this.bucketName = content;
            } else if (!this.insideCommonPrefixes && name.equals("Prefix")) {
                this.requestPrefix = content;
            } else if (name.equals("KeyMarker")) {
                this.keyMarker = content;
            } else if (name.equals("NextKeyMarker")) {
                this.nextMarker = content;
            } else if (name.equals("VersionIdMarker")) {
                this.versionIdMarker = content;
            } else if (name.equals("NextVersionIdMarker")) {
                this.nextVersionIdMarker = content;
            } else if (name.equals("MaxKeys")) {
                this.requestMaxKeys = Long.parseLong(content);
            } else if (name.equals("IsTruncated")) {
                this.listingTruncated = Boolean.parseBoolean(content);
            } else if (name.equals("Delimiter")) {
                this.delimiter = content;
            }
        }

        private void addVersionOrDeleteMarker(String name) {
            VersionOrDeleteMarker.Builder builder = new VersionOrDeleteMarker.Builder().bucketName(this.bucketName).key(this.key).versionId(this.versionId).isLatest(this.isLatest).lastModified(this.lastModified).owner(this.owner);
            if (name.equals("Version")) {
                VersionOrDeleteMarker item = builder.etag(this.etag).size(this.size).storageClass(StorageClassEnum.getValueFromCode(this.storageClass)).isDeleteMarker(false).appendable(this.isAppendable).builder();
                this.items.add(item);
                this.reset();
            } else if (name.equals("DeleteMarker")) {
                VersionOrDeleteMarker item = builder.etag(null).size(0L).storageClass(null).isDeleteMarker(true).appendable(false).builder();
                this.items.add(item);
                this.reset();
            }
        }
    }

    public static class RequestPaymentHandler
    extends DefaultXmlHandler {
        private RequestPaymentConfiguration requestPaymentConfiguration;
        private String payer;

        public RequestPaymentConfiguration getRequestPaymentConfiguration() {
            return this.requestPaymentConfiguration;
        }

        @Override
        public void endElement(String name, String elementText) {
            if (name.equals("Payer")) {
                this.payer = elementText;
            } else if (name.equals("RequestPaymentConfiguration")) {
                this.requestPaymentConfiguration = new RequestPaymentConfiguration(RequestPaymentEnum.getValueFromCode(this.payer));
            }
        }
    }

    public static class BucketCustomDomainHandler
    extends DefaultXmlHandler {
        private BucketCustomDomainInfo bucketCustomDomainInfo = new BucketCustomDomainInfo();
        private String domainName;
        private Date createTime;

        public BucketCustomDomainInfo getBucketTagInfo() {
            return this.bucketCustomDomainInfo;
        }

        @Override
        public void endElement(String name, String content) {
            if ("DomainName".equals(name)) {
                this.domainName = content;
            } else if ("CreateTime".equals(name)) {
                try {
                    this.createTime = ServiceUtils.parseIso8601Date(content);
                }
                catch (ParseException e) {
                    if (log.isErrorEnabled()) {
                        log.error("Non-ISO8601 date for CreateTime in domain listing output: " + content, e);
                    }
                }
            } else if ("Domains".equals(name)) {
                this.bucketCustomDomainInfo.addDomain(this.domainName, this.createTime);
            }
        }
    }

    public static class BucketVersioningHandler
    extends DefaultXmlHandler {
        private BucketVersioningConfiguration versioningStatus;
        private String status;

        public BucketVersioningConfiguration getVersioningStatus() {
            return this.versioningStatus;
        }

        @Override
        public void endElement(String name, String elementText) {
            if (name.equals("Status")) {
                this.status = elementText;
            } else if (name.equals("VersioningConfiguration")) {
                this.versioningStatus = new BucketVersioningConfiguration(VersioningStatusEnum.getValueFromCode(this.status));
            }
        }
    }

    public static class RequestPaymentConfigurationHandler
    extends DefaultXmlHandler {
        private String payer = null;

        public boolean isRequesterPays() {
            return "Requester".equals(this.payer);
        }

        @Override
        public void endElement(String name, String elementText) {
            if (name.equals("Payer")) {
                this.payer = elementText;
            }
        }
    }

    public static class CopyObjectResultHandler
    extends DefaultXmlHandler {
        private String etag;
        private Date lastModified;

        public Date getLastModified() {
            return ServiceUtils.cloneDateIgnoreNull(this.lastModified);
        }

        public String getETag() {
            return this.etag;
        }

        @Override
        public void endElement(String name, String elementText) {
            if (name.equals("LastModified")) {
                try {
                    this.lastModified = ServiceUtils.parseIso8601Date(elementText);
                }
                catch (ParseException e) {
                    if (log.isErrorEnabled()) {
                        log.error("Non-ISO8601 date for LastModified in copy object output: " + elementText, e);
                    }
                }
            } else if (name.equals("ETag")) {
                this.etag = elementText;
            }
        }
    }

    public static class BucketCorsHandler
    extends DefaultXmlHandler {
        private final BucketCors configuration = new BucketCors();
        private BucketCorsRule currentRule;
        private List<String> allowedMethods = null;
        private List<String> allowedOrigins = null;
        private List<String> exposedHeaders = null;
        private List<String> allowedHeaders = null;

        public BucketCors getConfiguration() {
            return this.configuration;
        }

        @Override
        public void startElement(String name) {
            if ("CORSRule".equals(name)) {
                this.currentRule = new BucketCorsRule();
            }
            if ("AllowedOrigin".equals(name)) {
                if (this.allowedOrigins == null) {
                    this.allowedOrigins = new ArrayList<String>();
                }
            } else if ("AllowedMethod".equals(name)) {
                if (this.allowedMethods == null) {
                    this.allowedMethods = new ArrayList<String>();
                }
            } else if ("ExposeHeader".equals(name)) {
                if (this.exposedHeaders == null) {
                    this.exposedHeaders = new ArrayList<String>();
                }
            } else if ("AllowedHeader".equals(name) && this.allowedHeaders == null) {
                this.allowedHeaders = new LinkedList<String>();
            }
        }

        @Override
        public void endElement(String name, String elementText) {
            if (name.equals("CORSRule")) {
                this.currentRule.setAllowedHeader(this.allowedHeaders);
                this.currentRule.setAllowedMethod(this.allowedMethods);
                this.currentRule.setAllowedOrigin(this.allowedOrigins);
                this.currentRule.setExposeHeader(this.exposedHeaders);
                this.configuration.getRules().add(this.currentRule);
                this.allowedHeaders = null;
                this.allowedMethods = null;
                this.allowedOrigins = null;
                this.exposedHeaders = null;
                this.currentRule = null;
            }
            if (name.equals("ID") && null != this.currentRule) {
                this.currentRule.setId(elementText);
            } else if (name.equals("AllowedOrigin") && null != this.allowedOrigins) {
                this.allowedOrigins.add(elementText);
            } else if (name.equals("AllowedMethod") && null != this.allowedMethods) {
                this.allowedMethods.add(elementText);
            } else if (name.equals("MaxAgeSeconds") && null != this.currentRule) {
                this.currentRule.setMaxAgeSecond(Integer.parseInt(elementText));
            } else if (name.equals("ExposeHeader") && null != this.exposedHeaders) {
                this.exposedHeaders.add(elementText);
            } else if (name.equals("AllowedHeader") && null != this.allowedHeaders) {
                this.allowedHeaders.add(elementText);
            }
        }
    }

    public static class BucketLocationHandler
    extends DefaultXmlHandler {
        private String location;

        public String getLocation() {
            return this.location;
        }

        @Override
        public void endElement(String name, String elementText) {
            if (name.equals("LocationConstraint") || name.equals("Location")) {
                this.location = elementText;
            }
        }
    }

    public static class BucketLoggingHandler
    extends DefaultXmlHandler {
        private BucketLoggingConfiguration bucketLoggingStatus = new BucketLoggingConfiguration();
        private String targetBucket;
        private String targetPrefix;
        private GranteeInterface currentGrantee;
        private Permission currentPermission;
        private boolean currentDelivered;

        public BucketLoggingConfiguration getBucketLoggingStatus() {
            return this.bucketLoggingStatus;
        }

        @Override
        public void endElement(String name, String elementText) {
            switch (name) {
                case "TargetBucket": {
                    this.targetBucket = elementText;
                    break;
                }
                case "TargetPrefix": {
                    this.targetPrefix = elementText;
                    break;
                }
                case "LoggingEnabled": {
                    this.bucketLoggingStatus.setTargetBucketName(this.targetBucket);
                    this.bucketLoggingStatus.setLogfilePrefix(this.targetPrefix);
                    break;
                }
                case "Agency": {
                    this.bucketLoggingStatus.setAgency(elementText);
                    break;
                }
                case "ID": {
                    this.currentGrantee = new CanonicalGrantee();
                    this.currentGrantee.setIdentifier(elementText);
                    break;
                }
                case "URI": 
                case "Canned": {
                    this.currentGrantee = new GroupGrantee();
                    this.currentGrantee.setIdentifier(elementText);
                    break;
                }
                case "DisplayName": {
                    if (!(this.currentGrantee instanceof CanonicalGrantee)) break;
                    ((CanonicalGrantee)this.currentGrantee).setDisplayName(elementText);
                    break;
                }
                case "Delivered": {
                    this.currentDelivered = Boolean.parseBoolean(elementText);
                    break;
                }
                case "Permission": {
                    this.currentPermission = Permission.parsePermission(elementText);
                    break;
                }
                case "Grant": {
                    GrantAndPermission gap = new GrantAndPermission(this.currentGrantee, this.currentPermission);
                    gap.setDelivered(this.currentDelivered);
                    this.bucketLoggingStatus.addTargetGrant(gap);
                    break;
                }
            }
        }
    }

    public static class ListBucketsHandler
    extends DefaultXmlHandler {
        private Owner bucketsOwner;
        private ObsBucket currentBucket;
        private final List<ObsBucket> buckets = new ArrayList<ObsBucket>();

        public List<ObsBucket> getBuckets() {
            return this.buckets;
        }

        public Owner getOwner() {
            return this.bucketsOwner;
        }

        @Override
        public void startElement(String name) {
            if (name.equals("Bucket")) {
                this.currentBucket = new ObsBucket();
            } else if (name.equals("Owner")) {
                this.bucketsOwner = new Owner();
            }
        }

        @Override
        public void endElement(String name, String elementText) {
            if (null != this.bucketsOwner) {
                if (name.equals("ID")) {
                    this.bucketsOwner.setId(elementText);
                } else if (name.equals("DisplayName")) {
                    this.bucketsOwner.setDisplayName(elementText);
                }
            }
            if (null != this.currentBucket) {
                switch (name) {
                    case "Bucket": {
                        this.currentBucket.setOwner(this.bucketsOwner);
                        this.buckets.add(this.currentBucket);
                        break;
                    }
                    case "Name": {
                        this.currentBucket.setBucketName(elementText);
                        break;
                    }
                    case "Location": {
                        this.currentBucket.setLocation(elementText);
                        break;
                    }
                    case "CreationDate": {
                        elementText = elementText + ".000Z";
                        try {
                            this.currentBucket.setCreationDate(ServiceUtils.parseIso8601Date(elementText));
                        }
                        catch (ParseException e) {
                            if (!log.isWarnEnabled()) break;
                            log.warn("Non-ISO8601 date for CreationDate in list buckets output: " + elementText, e);
                        }
                        break;
                    }
                    case "BucketType": {
                        if ("POSIX".equals(elementText)) {
                            this.currentBucket.setBucketType(BucketTypeEnum.PFS);
                            break;
                        }
                        this.currentBucket.setBucketType(BucketTypeEnum.OBJECT);
                        break;
                    }
                }
            }
        }
    }

    public static class ListBucketAliasHandler
    extends DefaultXmlHandler {
        private Owner bucketAliasOwner;
        private ListBucketAliasResult.BucketAlias bucketAlias;
        private List<String> bucketList;
        private final List<ListBucketAliasResult.BucketAlias> listBucketAlias = new ArrayList<ListBucketAliasResult.BucketAlias>();

        public Owner getBucketAliasOwner() {
            return this.bucketAliasOwner;
        }

        public List<ListBucketAliasResult.BucketAlias> getListBucketAlias() {
            return this.listBucketAlias;
        }

        @Override
        public void startElement(String name) {
            if (name.equals("Owner")) {
                this.bucketAliasOwner = new Owner();
            } else if (name.equals("BucketAlias")) {
                this.bucketAlias = new ListBucketAliasResult.BucketAlias();
            } else if (name.equals("BucketList")) {
                this.bucketList = new ArrayList<String>();
            }
        }

        @Override
        public void endElement(String name, String elementText) {
            switch (name) {
                case "ID": {
                    this.bucketAliasOwner.setId(elementText);
                    break;
                }
                case "Alias": {
                    this.bucketAlias.setAlias(elementText);
                    break;
                }
                case "BucketList": {
                    this.bucketAlias.setBucketList(this.bucketList);
                    break;
                }
                case "Bucket": {
                    this.bucketList.add(elementText);
                    break;
                }
                case "BucketAlias": {
                    this.listBucketAlias.add(this.bucketAlias);
                    break;
                }
            }
        }
    }

    public static class ContentSummaryFsHandler
    extends DefaultXmlHandler {
        private String bucketName;
        private DirSummary contentSummary;

        public String getBucketName() {
            return this.bucketName;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public DirSummary getContentSummary() {
            return this.contentSummary;
        }

        public void setContentSummary(DirSummary contentSummary) {
            this.contentSummary = contentSummary;
        }

        @Override
        public void startElement(String name) {
            if (name.equals("GetContentSummaryResult")) {
                this.contentSummary = new DirSummary();
            }
        }

        @Override
        public void endElement(String name, String elementText) {
            if (name.equals("BucketName")) {
                this.bucketName = elementText;
            } else if (name.equals("Name")) {
                this.contentSummary.setName(elementText);
            } else if (name.equals("DirCount")) {
                this.contentSummary.setDirCount(Long.parseLong(elementText));
            } else if (name.equals("FileCount")) {
                this.contentSummary.setFileCount(Long.parseLong(elementText));
            } else if (name.equals("FileSize")) {
                this.contentSummary.setFileSize(Long.parseLong(elementText));
            } else if (name.equals("Inode")) {
                this.contentSummary.setInode(Long.parseLong(elementText));
            }
        }
    }

    public static class ListContentSummaryFsHandler
    extends DefaultXmlHandler {
        private String bucketName;
        private DirSummary dirSummary;
        private DirContentSummary dirContentSummary;
        private ListContentSummaryFsResult.ErrorResult errorResult;
        private List<DirContentSummary> dirContentSummaries = new ArrayList<DirContentSummary>();
        private List<ListContentSummaryFsResult.ErrorResult> errorResults = new ArrayList<ListContentSummaryFsResult.ErrorResult>();
        private List<DirSummary> subDirs;

        public DirContentSummary getDirContentSummary() {
            return this.dirContentSummary;
        }

        public void setDirContentSummary(DirContentSummary dirContentSummary) {
            this.dirContentSummary = dirContentSummary;
        }

        public ListContentSummaryFsResult.ErrorResult getErrorResult() {
            return this.errorResult;
        }

        public void setErrorResult(ListContentSummaryFsResult.ErrorResult errorResult) {
            this.errorResult = errorResult;
        }

        public List<DirContentSummary> getDirContentSummaries() {
            return this.dirContentSummaries;
        }

        public void setDirContentSummaries(List<DirContentSummary> dirContentSummaries) {
            this.dirContentSummaries = dirContentSummaries;
        }

        public List<ListContentSummaryFsResult.ErrorResult> getErrorResults() {
            return this.errorResults;
        }

        public void setErrorResults(List<ListContentSummaryFsResult.ErrorResult> errorResults) {
            this.errorResults = errorResults;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public void startElement(String name) {
            if (name.equals("Contents")) {
                this.dirContentSummary = new DirContentSummary();
                this.subDirs = new ArrayList<DirSummary>();
                this.errorResult = null;
            } else if (name.equals("ErrContents")) {
                this.errorResult = new ListContentSummaryFsResult.ErrorResult();
                this.dirContentSummary = null;
            } else if (name.equals("SubDir")) {
                this.dirSummary = new DirSummary();
            }
        }

        @Override
        public void endElement(String name, String elementText) {
            if (name.equals("BucketName")) {
                this.bucketName = elementText;
            } else if (name.equals("Key")) {
                this.fnSetKey(elementText);
            } else if (name.equals("Inode")) {
                this.fnSetInode(elementText);
            } else if (name.equals("IsTruncated")) {
                this.dirContentSummary.setTruncated(Boolean.parseBoolean(elementText));
            } else if (name.equals("NextMarker")) {
                this.dirContentSummary.setNextMarker(elementText);
            } else if (name.equals("SubDir")) {
                this.subDirs.add(this.dirSummary);
                this.dirSummary = null;
            } else if (name.equals("Name")) {
                this.dirSummary.setName(elementText);
            } else if (name.equals("DirCount")) {
                this.dirSummary.setDirCount(Long.parseLong(elementText));
            } else if (name.equals("FileCount")) {
                this.dirSummary.setFileCount(Long.parseLong(elementText));
            } else if (name.equals("FileSize")) {
                this.dirSummary.setFileSize(Long.parseLong(elementText));
            } else if (name.equals("ErrContents")) {
                this.errorResults.add(this.errorResult);
            } else if (name.equals("ErrorCode")) {
                this.errorResult.setErrorCode(elementText);
            } else if (name.equals("Message")) {
                this.errorResult.setMessage(elementText);
            } else if (name.equals("StatusCode")) {
                this.errorResult.setStatusCode(elementText);
            } else if (name.equals("Contents")) {
                this.dirContentSummary.setSubDir(this.subDirs);
                this.dirContentSummaries.add(this.dirContentSummary);
            }
        }

        private void fnSetInode(String elementText) {
            if (this.dirSummary != null) {
                this.dirSummary.setInode(Long.parseLong(elementText));
            } else if (this.errorResult != null) {
                this.errorResult.setInode(Long.parseLong(elementText));
            } else if (this.dirContentSummary != null) {
                this.dirContentSummary.setInode(Long.parseLong(elementText));
            }
        }

        private void fnSetKey(String elementText) {
            if (this.dirContentSummary != null) {
                this.dirContentSummary.setKey(elementText);
            } else {
                this.errorResult.setKey(elementText);
            }
        }
    }

    public static class ListContentSummaryHandler
    extends DefaultXmlHandler {
        private FolderContentSummary currentFolderContentSummary;
        private FolderContentSummary.LayerSummary currentLayerSummary;
        private final List<FolderContentSummary> folderContentSummaries = new ArrayList<FolderContentSummary>();
        private String bucketName;
        private String requestPrefix;
        private String requestMarker;
        private String requestDelimiter;
        private int requestMaxKeys = 0;
        private boolean listingTruncated = false;
        private String nextMarker;
        private String lastFolder;

        public String getBucketName() {
            return this.bucketName;
        }

        public boolean isListingTruncated() {
            return this.listingTruncated;
        }

        public List<FolderContentSummary> getFolderContentSummaries() {
            return this.folderContentSummaries;
        }

        public String getRequestPrefix() {
            return this.requestPrefix;
        }

        public String getRequestMarker() {
            return this.requestMarker;
        }

        public String getNextMarker() {
            return this.nextMarker;
        }

        public int getRequestMaxKeys() {
            return this.requestMaxKeys;
        }

        public String getRequestDelimiter() {
            return this.requestDelimiter;
        }

        public String getMarkerForNextListing() {
            return this.listingTruncated ? (this.nextMarker == null ? this.lastFolder : this.nextMarker) : null;
        }

        @Override
        public void startElement(String name) {
            if (name.equals("Contents")) {
                this.currentFolderContentSummary = new FolderContentSummary();
            } else if (name.equals("LayerSummary")) {
                this.currentLayerSummary = new FolderContentSummary.LayerSummary();
            }
        }

        @Override
        public void endElement(String name, String elementText) {
            if (name.equals("BucketName")) {
                this.bucketName = elementText;
            } else if (name.equals("Prefix")) {
                this.requestPrefix = elementText;
            } else if (name.equals("Marker")) {
                this.requestMarker = elementText;
            } else if (name.equals("NextMarker")) {
                this.nextMarker = elementText;
            } else if (name.equals("MaxKeys")) {
                this.requestMaxKeys = Integer.parseInt(elementText);
            } else if (name.equals("Delimiter")) {
                this.requestDelimiter = elementText;
            } else if (name.equals("IsTruncated")) {
                this.listingTruncated = Boolean.parseBoolean(elementText);
            } else if (name.equals("Directory")) {
                this.currentFolderContentSummary.setDir(elementText);
                this.lastFolder = elementText;
            } else if (name.equals("DirHeight")) {
                this.currentFolderContentSummary.setDirHeight(Long.parseLong(elementText));
            } else if (name.equals("SummaryHeight")) {
                this.currentLayerSummary.setSummaryHeight(Long.parseLong(elementText));
            } else if (name.equals("DirCount")) {
                this.currentLayerSummary.setDirCount(Long.parseLong(elementText));
            } else if (name.equals("FileCount")) {
                this.currentLayerSummary.setFileCount(Long.parseLong(elementText));
            } else if (name.equals("FileSize")) {
                this.currentLayerSummary.setFileSize(Long.parseLong(elementText));
            } else if (name.equals("LayerSummary")) {
                this.currentFolderContentSummary.getLayerSummaries().add(this.currentLayerSummary);
            } else if (name.equals("Contents")) {
                this.folderContentSummaries.add(this.currentFolderContentSummary);
            }
        }
    }

    public static class ListObjectsHandler
    extends DefaultXmlHandler {
        private ObsObject currentObject;
        private Owner currentOwner;
        private boolean insideCommonPrefixes = false;
        private final List<ObsObject> objects = new ArrayList<ObsObject>();
        private final List<String> commonPrefixes = new ArrayList<String>();
        private final List<String> finalCommonPrefixes = new ArrayList<String>();
        private ObsObject currentExtendCommonPrefix;
        private final List<ObsObject> extendCommonPrefixes = new ArrayList<ObsObject>();
        private String bucketName;
        private String requestPrefix;
        private String requestMarker;
        private String requestDelimiter;
        private int requestMaxKeys = 0;
        private boolean listingTruncated = false;
        private String lastKey;
        private String nextMarker;
        private String encodingType;
        private boolean needDecode;

        public String getMarkerForNextListing() {
            return XmlResponsesSaxParser.getDecodedString(this.listingTruncated ? (this.nextMarker == null ? this.lastKey : this.nextMarker) : null, this.needDecode);
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public boolean isListingTruncated() {
            return this.listingTruncated;
        }

        public List<ObsObject> getObjects() {
            for (ObsObject object : this.objects) {
                object.setObjectKey(XmlResponsesSaxParser.getDecodedString(object.getObjectKey(), this.needDecode));
            }
            return this.objects;
        }

        public List<String> getCommonPrefixes() {
            for (String commonPrefix : this.commonPrefixes) {
                this.finalCommonPrefixes.add(XmlResponsesSaxParser.getDecodedString(commonPrefix, this.needDecode));
            }
            return this.finalCommonPrefixes;
        }

        @Deprecated
        public List<ObsObject> getExtenedCommonPrefixes() {
            return this.getExtendCommonPrefixes();
        }

        public List<ObsObject> getExtendCommonPrefixes() {
            for (ObsObject object : this.extendCommonPrefixes) {
                object.setObjectKey(XmlResponsesSaxParser.getDecodedString(object.getObjectKey(), this.needDecode));
            }
            return this.extendCommonPrefixes;
        }

        public String getRequestPrefix() {
            return XmlResponsesSaxParser.getDecodedString(this.requestPrefix, this.needDecode);
        }

        public String getRequestMarker() {
            return XmlResponsesSaxParser.getDecodedString(this.requestMarker, this.needDecode);
        }

        public String getNextMarker() {
            return XmlResponsesSaxParser.getDecodedString(this.nextMarker, this.needDecode);
        }

        public int getRequestMaxKeys() {
            return this.requestMaxKeys;
        }

        public String getRequestDelimiter() {
            return XmlResponsesSaxParser.getDecodedString(this.requestDelimiter, this.needDecode);
        }

        public String getEncodingType() {
            return this.encodingType;
        }

        @Override
        public void startElement(String name) {
            switch (name) {
                case "Contents": {
                    this.currentObject = new ObsObject();
                    this.currentObject.setBucketName(this.bucketName);
                    break;
                }
                case "Owner": {
                    this.currentOwner = new Owner();
                    break;
                }
                case "CommonPrefixes": {
                    this.insideCommonPrefixes = true;
                    this.currentExtendCommonPrefix = new ObsObject();
                    break;
                }
            }
        }

        @Override
        public void endElement(String name, String elementText) {
            if (name.equals("Name")) {
                this.bucketName = elementText;
            } else if (!this.insideCommonPrefixes && name.equals("Prefix")) {
                this.requestPrefix = elementText;
            } else if (name.equals("Marker")) {
                this.requestMarker = elementText;
            } else if (name.equals("NextMarker")) {
                this.nextMarker = elementText;
            } else if (name.equals("MaxKeys")) {
                this.requestMaxKeys = Integer.parseInt(elementText);
            } else if (name.equals("Delimiter")) {
                this.requestDelimiter = elementText;
            } else if (name.equals("IsTruncated")) {
                this.listingTruncated = Boolean.parseBoolean(elementText);
            } else if (name.equals("Contents")) {
                this.objects.add(this.currentObject);
            } else if (name.equals("DisplayName")) {
                if (this.currentOwner != null) {
                    this.currentOwner.setDisplayName(elementText);
                }
            } else if (name.equals("EncodingType")) {
                this.encodingType = elementText;
                if (this.encodingType.equals("url")) {
                    this.needDecode = true;
                }
            }
            this.setCurrentObjectProperties(name, elementText);
            if (null != this.currentExtendCommonPrefix) {
                if (this.insideCommonPrefixes && name.equals("Prefix")) {
                    this.commonPrefixes.add(elementText);
                    this.currentExtendCommonPrefix.setObjectKey(elementText);
                } else if (this.insideCommonPrefixes && name.equals("MTime")) {
                    this.currentExtendCommonPrefix.getMetadata().setLastModified(new Date(Long.parseLong(elementText) * 1000L));
                }
            }
            if (name.equals("CommonPrefixes")) {
                this.extendCommonPrefixes.add(this.currentExtendCommonPrefix);
                this.insideCommonPrefixes = false;
            }
        }

        private void setCurrentObjectProperties(String name, String elementText) {
            if (name.equals("Key")) {
                this.currentObject.setObjectKey(elementText);
                this.lastKey = elementText;
            } else if (name.equals("LastModified")) {
                if (!this.insideCommonPrefixes) {
                    try {
                        this.currentObject.getMetadata().setLastModified(ServiceUtils.parseIso8601Date(elementText));
                    }
                    catch (ParseException e) {
                        if (log.isErrorEnabled()) {
                            log.error("Non-ISO8601 date for LastModified in bucket's object listing output: " + elementText, e);
                        }
                    }
                }
            } else if (name.equals("ETag")) {
                this.currentObject.getMetadata().setEtag(elementText);
            } else if (name.equals("Size")) {
                this.currentObject.getMetadata().setContentLength(Long.parseLong(elementText));
            } else if (name.equals("StorageClass")) {
                this.currentObject.getMetadata().setObjectStorageClass(StorageClassEnum.getValueFromCode(elementText));
            } else if (name.equals("ID")) {
                if (this.currentOwner == null) {
                    this.currentOwner = new Owner();
                }
                this.currentObject.setOwner(this.currentOwner);
                this.currentOwner.setId(elementText);
            } else if (name.equals("Type")) {
                this.currentObject.getMetadata().setAppendable("Appendable".equals(elementText));
            }
        }
    }
}

