/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sqlparser.JSQLParserException;
import com.sqlparser.parser.CCJSqlParserUtil;
import com.sqlparser.statement.Statement;
import com.sqlparser.statement.UnsupportedStatement;
import com.sqlparser.statement.alter.Alter;
import com.sqlparser.statement.create.index.CreateIndex;
import com.sqlparser.statement.create.table.CreateTable;
import com.sqlparser.statement.create.view.CreateView;
import com.sqlparser.statement.drop.Drop;

public class SqlParser {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static String createTable(String sql) throws JSQLParserException, JsonProcessingException {
        CreateTable createTable = (CreateTable)SqlParser.parse(sql);
        return objectMapper.writeValueAsString((Object)createTable);
    }

    public static String createIndex(String sql) throws JSQLParserException, JsonProcessingException {
        CreateIndex createIndex = (CreateIndex)SqlParser.parse(sql);
        return objectMapper.writeValueAsString((Object)createIndex);
    }

    public static String createView(String sql) throws JSQLParserException, JsonProcessingException {
        CreateView createView = (CreateView)SqlParser.parse(sql);
        return objectMapper.writeValueAsString((Object)createView);
    }

    public static String createTrigger(String sql) throws JSQLParserException, JsonProcessingException {
        UnsupportedStatement unsupportedStatement = (UnsupportedStatement)SqlParser.parse(sql);
        return objectMapper.writeValueAsString((Object)unsupportedStatement);
    }

    public static String drop(String sql) throws JSQLParserException, JsonProcessingException {
        Drop drop = (Drop)SqlParser.parse(sql);
        return objectMapper.writeValueAsString((Object)drop);
    }

    public static String alter(String sql) throws JSQLParserException, JsonProcessingException {
        Alter alter = (Alter)SqlParser.parse(sql);
        return objectMapper.writeValueAsString((Object)alter);
    }

    public static Statement serializer(String sql) throws JSQLParserException {
        return CCJSqlParserUtil.parse(sql);
    }

    public static <T> T deserializer(String s, Class<?> t) throws JsonProcessingException {
        return (T)objectMapper.readValue(s, t);
    }

    private static <T extends Statement> T parse(String sql) throws JSQLParserException {
        return (T)CCJSqlParserUtil.parse(sql);
    }
}

