/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.expression;

import com.sqlparser.expression.Expression;
import com.sqlparser.expression.ExpressionVisitor;
import com.sqlparser.expression.FilterOverImpl;
import com.sqlparser.expression.JsonAggregateOnNullType;
import com.sqlparser.expression.JsonAggregateUniqueKeysType;
import com.sqlparser.expression.JsonFunctionType;
import com.sqlparser.expression.OrderByClause;
import com.sqlparser.statement.select.OrderByElement;
import java.util.List;
import java.util.Objects;

public class JsonAggregateFunction
extends FilterOverImpl
implements Expression {
    private JsonFunctionType functionType;
    private Expression expression = null;
    private final OrderByClause expressionOrderBy = new OrderByClause();
    private boolean usingKeyKeyword = false;
    private String key;
    private boolean usingValueKeyword = false;
    private Object value;
    private boolean usingFormatJson = false;
    private JsonAggregateOnNullType onNullType;
    private JsonAggregateUniqueKeysType uniqueKeysType;

    public JsonAggregateOnNullType getOnNullType() {
        return this.onNullType;
    }

    public void setOnNullType(JsonAggregateOnNullType onNullType) {
        this.onNullType = onNullType;
    }

    public JsonAggregateFunction withOnNullType(JsonAggregateOnNullType onNullType) {
        this.setOnNullType(onNullType);
        return this;
    }

    public JsonAggregateUniqueKeysType getUniqueKeysType() {
        return this.uniqueKeysType;
    }

    public void setUniqueKeysType(JsonAggregateUniqueKeysType uniqueKeysType) {
        this.uniqueKeysType = uniqueKeysType;
    }

    public JsonAggregateFunction withUniqueKeysType(JsonAggregateUniqueKeysType uniqueKeysType) {
        this.setUniqueKeysType(uniqueKeysType);
        return this;
    }

    public JsonFunctionType getType() {
        return this.functionType;
    }

    public void setType(JsonFunctionType type) {
        this.functionType = Objects.requireNonNull(type, "The Type of the JSON Aggregate Function must not be null");
    }

    public JsonAggregateFunction withType(JsonFunctionType type) {
        this.setType(type);
        return this;
    }

    public void setType(String typeName) {
        this.functionType = JsonFunctionType.valueOf(Objects.requireNonNull(typeName, "The Type of the JSON Aggregate Function must not be null").toUpperCase());
    }

    public JsonAggregateFunction withType(String typeName) {
        this.setType(typeName);
        return this;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public JsonAggregateFunction withExpression(Expression expression) {
        this.setExpression(expression);
        return this;
    }

    public boolean isUsingKeyKeyword() {
        return this.usingKeyKeyword;
    }

    public void setUsingKeyKeyword(boolean usingKeyKeyword) {
        this.usingKeyKeyword = usingKeyKeyword;
    }

    public JsonAggregateFunction withUsingKeyKeyword(boolean usingKeyKeyword) {
        this.setUsingKeyKeyword(usingKeyKeyword);
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public JsonAggregateFunction withKey(String key) {
        this.setKey(key);
        return this;
    }

    public boolean isUsingValueKeyword() {
        return this.usingValueKeyword;
    }

    public void setUsingValueKeyword(boolean usingValueKeyword) {
        this.usingValueKeyword = usingValueKeyword;
    }

    public JsonAggregateFunction withUsingValueKeyword(boolean usingValueKeyword) {
        this.setUsingValueKeyword(usingValueKeyword);
        return this;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public JsonAggregateFunction withValue(Object value) {
        this.setValue(value);
        return this;
    }

    public boolean isUsingFormatJson() {
        return this.usingFormatJson;
    }

    public void setUsingFormatJson(boolean usingFormatJson) {
        this.usingFormatJson = usingFormatJson;
    }

    public JsonAggregateFunction withUsingFormatJson(boolean usingFormatJson) {
        this.setUsingFormatJson(usingFormatJson);
        return this;
    }

    public List<OrderByElement> getExpressionOrderByElements() {
        return this.expressionOrderBy.getOrderByElements();
    }

    public void setExpressionOrderByElements(List<OrderByElement> orderByElements) {
        this.expressionOrderBy.setOrderByElements(orderByElements);
    }

    public JsonAggregateFunction withExpressionOrderByElements(List<OrderByElement> orderByElements) {
        this.setExpressionOrderByElements(orderByElements);
        return this;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    @Override
    public StringBuilder append(StringBuilder builder) {
        switch (this.functionType) {
            case OBJECT: {
                this.appendObject(builder);
                break;
            }
            case ARRAY: {
                this.appendArray(builder);
                break;
            }
            default: {
                throw new UnsupportedOperationException("JSON Aggregate Function of the type " + this.functionType.name() + " has not been implemented yet.");
            }
        }
        return builder;
    }

    public StringBuilder appendObject(StringBuilder builder) {
        builder.append("JSON_OBJECTAGG( ");
        if (this.usingValueKeyword) {
            if (this.usingKeyKeyword) {
                builder.append("KEY ");
            }
            builder.append(this.key).append(" VALUE ").append(this.value);
        } else {
            builder.append(this.key).append(":").append(this.value);
        }
        if (this.usingFormatJson) {
            builder.append(" FORMAT JSON");
        }
        if (this.onNullType != null) {
            switch (this.onNullType) {
                case NULL: {
                    builder.append(" NULL ON NULL");
                    break;
                }
                case ABSENT: {
                    builder.append(" ABSENT On NULL");
                    break;
                }
            }
        }
        if (this.uniqueKeysType != null) {
            switch (this.uniqueKeysType) {
                case WITH: {
                    builder.append(" WITH UNIQUE KEYS");
                    break;
                }
                case WITHOUT: {
                    builder.append(" WITHOUT UNIQUE KEYS");
                    break;
                }
            }
        }
        builder.append(" ) ");
        super.append(builder);
        return builder;
    }

    public StringBuilder appendArray(StringBuilder builder) {
        builder.append("JSON_ARRAYAGG( ");
        builder.append(this.expression).append(" ");
        if (this.usingFormatJson) {
            builder.append("FORMAT JSON ");
        }
        this.expressionOrderBy.toStringOrderByElements(builder);
        if (this.onNullType != null) {
            switch (this.onNullType) {
                case NULL: {
                    builder.append(" NULL ON NULL ");
                    break;
                }
                case ABSENT: {
                    builder.append(" ABSENT On NULL ");
                    break;
                }
            }
        }
        builder.append(") ");
        super.append(builder);
        return builder;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        return this.append(builder).toString();
    }
}

