/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.expression;

import com.sqlparser.expression.Expression;
import com.sqlparser.expression.ExpressionVisitor;
import com.sqlparser.parser.ASTNodeAccessImpl;
import java.util.List;
import java.util.regex.Pattern;

public class NextValExpression
extends ASTNodeAccessImpl
implements Expression {
    public static final Pattern NEXT_VALUE_PATTERN = Pattern.compile("NEXT\\s+VALUE\\s+FOR", 2);
    private final List<String> nameList;
    private boolean usingNextValueFor = false;

    public NextValExpression(List<String> nameList, String image) {
        this.nameList = nameList;
        if (NEXT_VALUE_PATTERN.matcher(image).matches()) {
            this.usingNextValueFor = true;
        }
    }

    public boolean isUsingNextValueFor() {
        return this.usingNextValueFor;
    }

    public void setUsingNextValueFor(boolean usingNextValueFor) {
        this.usingNextValueFor = usingNextValueFor;
    }

    public NextValExpression withNextValueFor(boolean usingNextValueFor) {
        this.setUsingNextValueFor(usingNextValueFor);
        return this;
    }

    public List<String> getNameList() {
        return this.nameList;
    }

    public String getName() {
        StringBuilder b = new StringBuilder();
        for (String name : this.nameList) {
            if (b.length() > 0) {
                b.append(".");
            }
            b.append(name);
        }
        return b.toString();
    }

    public String toString() {
        return (this.usingNextValueFor ? "NEXT VALUE FOR " : "NEXTVAL FOR ") + this.getName();
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }
}

