/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.expression;

import com.sqlparser.expression.Expression;
import com.sqlparser.expression.ExpressionVisitor;
import com.sqlparser.parser.ASTNodeAccessImpl;
import com.sqlparser.statement.select.ParenthesedSelect;
import com.sqlparser.statement.select.PlainSelect;
import com.sqlparser.statement.select.Select;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OracleHint
extends ASTNodeAccessImpl
implements Expression {
    private static final Pattern SINGLE_LINE = Pattern.compile("--\\+ *([^ ].*[^ ])");
    private static final Pattern MULTI_LINE = Pattern.compile("\\/\\*\\+ *([^ ].*[^ ]) *\\*+\\/", 40);
    private String value;
    private boolean singleLine = false;

    public static boolean isHintMatch(String comment) {
        return SINGLE_LINE.matcher(comment).find() || MULTI_LINE.matcher(comment).find();
    }

    public final void setComment(String comment) {
        Matcher m = SINGLE_LINE.matcher(comment);
        if (m.find()) {
            this.value = m.group(1);
            this.singleLine = true;
            return;
        }
        m = MULTI_LINE.matcher(comment);
        if (m.find()) {
            this.value = m.group(1);
            this.singleLine = false;
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isSingleLine() {
        return this.singleLine;
    }

    public void setSingleLine(boolean singleLine) {
        this.singleLine = singleLine;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        if (this.singleLine) {
            return "--+ " + this.value + "\n";
        }
        return "/*+ " + this.value + " */";
    }

    public OracleHint withValue(String value) {
        this.setValue(value);
        return this;
    }

    public OracleHint withSingleLine(boolean singleLine) {
        this.setSingleLine(singleLine);
        return this;
    }

    public static OracleHint getHintFromSelectBody(Select selectBody) {
        if (selectBody instanceof PlainSelect) {
            return ((PlainSelect)selectBody).getOracleHint();
        }
        if (selectBody instanceof ParenthesedSelect) {
            return OracleHint.getHintFromSelectBody(((ParenthesedSelect)selectBody).getSelect());
        }
        return null;
    }
}

