/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.expression;

import com.sqlparser.ClassName;
import com.sqlparser.expression.Expression;
import java.io.Serializable;

public class WindowOffset
implements Serializable,
ClassName {
    private Expression expression;
    private Type type;

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.expression != null) {
            buffer.append(' ').append(this.expression);
            if (this.type != null) {
                buffer.append(' ');
                buffer.append(this.type);
            }
        } else if (this.type != null) {
            switch (this.type) {
                case PRECEDING: {
                    buffer.append(" UNBOUNDED PRECEDING");
                    break;
                }
                case FOLLOWING: {
                    buffer.append(" UNBOUNDED FOLLOWING");
                    break;
                }
                case CURRENT: {
                    buffer.append(" CURRENT ROW");
                    break;
                }
            }
        }
        return buffer.toString();
    }

    public WindowOffset withExpression(Expression expression) {
        this.setExpression(expression);
        return this;
    }

    public WindowOffset withType(Type type) {
        this.setType(type);
        return this;
    }

    public <E extends Expression> E getExpression(Class<E> type) {
        return (E)((Expression)type.cast(this.getExpression()));
    }

    public static enum Type implements ClassName
    {
        PRECEDING,
        FOLLOWING,
        CURRENT,
        EXPR;


        public static Type from(String type) {
            return Enum.valueOf(Type.class, type.toUpperCase());
        }
    }
}

