/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.expression.operators.relational;

import com.sqlparser.expression.Expression;
import com.sqlparser.expression.ExpressionVisitor;
import com.sqlparser.expression.JdbcNamedParameter;
import com.sqlparser.expression.JdbcParameter;
import com.sqlparser.expression.StringValue;
import com.sqlparser.expression.operators.relational.ExpressionList;
import com.sqlparser.parser.ASTNodeAccessImpl;
import com.sqlparser.schema.Column;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;

public class FullTextSearch
extends ASTNodeAccessImpl
implements Expression {
    private ExpressionList<Column> _matchColumns;
    private Expression _againstValue;
    private String _searchModifier;

    public void setMatchColumns(ExpressionList<Column> columns) {
        this._matchColumns = columns;
    }

    public ExpressionList<Column> getMatchColumns() {
        return this._matchColumns;
    }

    public void setAgainstValue(StringValue val) {
        this._againstValue = val;
    }

    public void setAgainstValue(JdbcNamedParameter val) {
        this._againstValue = val;
    }

    public void setAgainstValue(JdbcParameter val) {
        this._againstValue = val;
    }

    public Expression getAgainstValue() {
        return this._againstValue;
    }

    public void setSearchModifier(String val) {
        this._searchModifier = val;
    }

    public String getSearchModifier() {
        return this._searchModifier;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        String columnsListCommaSeperated = "";
        Iterator iterator = this._matchColumns.iterator();
        while (iterator.hasNext()) {
            Column col = (Column)iterator.next();
            columnsListCommaSeperated = columnsListCommaSeperated + col.getFullyQualifiedName();
            if (!iterator.hasNext()) continue;
            columnsListCommaSeperated = columnsListCommaSeperated + ",";
        }
        return "MATCH (" + columnsListCommaSeperated + ") AGAINST (" + this._againstValue + (this._searchModifier != null ? " " + this._searchModifier : "") + ")";
    }

    public FullTextSearch withMatchColumns(ExpressionList<Column> matchColumns) {
        this.setMatchColumns(matchColumns);
        return this;
    }

    public FullTextSearch withAgainstValue(StringValue againstValue) {
        this.setAgainstValue(againstValue);
        return this;
    }

    public FullTextSearch withSearchModifier(String searchModifier) {
        this.setSearchModifier(searchModifier);
        return this;
    }

    public FullTextSearch addMatchColumns(Column ... matchColumns) {
        return this.addMatchColumns(Arrays.asList(matchColumns));
    }

    public FullTextSearch addMatchColumns(Collection<? extends Column> matchColumns) {
        ExpressionList collection = Optional.ofNullable(this.getMatchColumns()).orElseGet(ExpressionList::new);
        collection.addAll(matchColumns);
        return this.withMatchColumns(collection);
    }
}

