/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.expression.operators.relational;

import com.sqlparser.expression.BinaryExpression;
import com.sqlparser.expression.Expression;
import com.sqlparser.expression.ExpressionVisitor;
import com.sqlparser.expression.operators.relational.RegExpMatchOperatorType;
import java.util.Objects;

public class RegExpMatchOperator
extends BinaryExpression {
    private RegExpMatchOperatorType operatorType;

    public RegExpMatchOperator(RegExpMatchOperatorType operatorType) {
        this.operatorType = Objects.requireNonNull(operatorType, "The provided RegExpMatchOperatorType must not be NULL.");
    }

    public RegExpMatchOperatorType getOperatorType() {
        return this.operatorType;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    @Override
    public String getStringExpression() {
        switch (this.operatorType) {
            case MATCH_CASESENSITIVE: {
                return "~";
            }
            case MATCH_CASEINSENSITIVE: {
                return "~*";
            }
            case NOT_MATCH_CASESENSITIVE: {
                return "!~";
            }
            case NOT_MATCH_CASEINSENSITIVE: {
                return "!~*";
            }
        }
        return null;
    }

    @Override
    public RegExpMatchOperator withLeftExpression(Expression arg0) {
        return (RegExpMatchOperator)super.withLeftExpression(arg0);
    }

    @Override
    public RegExpMatchOperator withRightExpression(Expression arg0) {
        return (RegExpMatchOperator)super.withRightExpression(arg0);
    }
}

