/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.parser;

import com.sqlparser.parser.ParseException;
import com.sqlparser.parser.feature.Feature;
import com.sqlparser.parser.feature.FeatureConfiguration;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractJSqlParser<P> {
    protected int jdbcParameterIndex = 0;
    protected boolean errorRecovery = false;
    protected List<ParseException> parseErrors = new ArrayList<ParseException>();

    public P withSquareBracketQuotation(boolean allowSquareBracketQuotation) {
        return this.withFeature(Feature.allowSquareBracketQuotation, allowSquareBracketQuotation);
    }

    public P withAllowComplexParsing(boolean allowComplexParsing) {
        return this.withFeature(Feature.allowComplexParsing, allowComplexParsing);
    }

    public P withUnsupportedStatements(boolean allowUnsupportedStatements) {
        return this.withFeature(Feature.allowUnsupportedStatements, allowUnsupportedStatements);
    }

    public P withTimeOut(long timeOutMillSeconds) {
        return this.withFeature(Feature.timeOut, timeOutMillSeconds);
    }

    public P withBackslashEscapeCharacter(boolean allowBackslashEscapeCharacter) {
        return this.withFeature(Feature.allowBackslashEscapeCharacter, allowBackslashEscapeCharacter);
    }

    public P withFeature(Feature f, boolean enabled) {
        this.getConfiguration().setValue(f, enabled);
        return this.me();
    }

    public P withFeature(Feature f, long value) {
        this.getConfiguration().setValue(f, value);
        return this.me();
    }

    public abstract FeatureConfiguration getConfiguration();

    public abstract P me();

    public boolean getAsBoolean(Feature f) {
        return this.getConfiguration().getAsBoolean(f);
    }

    public Long getAsLong(Feature f) {
        return this.getConfiguration().getAsLong(f);
    }

    public void setErrorRecovery(boolean errorRecovery) {
        this.errorRecovery = errorRecovery;
    }

    public List<ParseException> getParseErrors() {
        return this.parseErrors;
    }
}

