/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.schema;

import com.sqlparser.parser.ASTNodeAccessImpl;
import com.sqlparser.schema.Database;
import com.sqlparser.schema.MultiPartName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Synonym
extends ASTNodeAccessImpl
implements MultiPartName {
    private static final int NAME_IDX = 0;
    private static final int SCHEMA_IDX = 1;
    private static final int DATABASE_IDX = 2;
    private static final int SERVER_IDX = 3;
    private List<String> partItems = new ArrayList<String>();

    public Synonym() {
    }

    public Synonym(List<String> partItems) {
        this.partItems = new ArrayList<String>(partItems);
        Collections.reverse(this.partItems);
    }

    public Database getDatabase() {
        return new Database(this.getIndex(2));
    }

    public void setDatabase(Database database) {
        this.setIndex(2, database.getDatabaseName());
        if (database.getServer() != null) {
            this.setIndex(3, database.getServer().getFullyQualifiedName());
        }
    }

    public Synonym withDatabase(Database database) {
        this.setDatabase(database);
        return this;
    }

    public String getSchemaName() {
        return this.getIndex(1);
    }

    public void setSchemaName(String string) {
        this.setIndex(1, string);
    }

    public Synonym withSchemaName(String string) {
        this.setSchemaName(string);
        return this;
    }

    public String getName() {
        return this.getIndex(0);
    }

    public void setName(String string) {
        this.setIndex(0, string);
    }

    public Synonym withName(String string) {
        this.setName(string);
        return this;
    }

    private void setIndex(int idx, String value) {
        int size = this.partItems.size();
        for (int i = 0; i < idx - size + 1; ++i) {
            this.partItems.add(null);
        }
        this.partItems.set(idx, value);
    }

    private String getIndex(int idx) {
        if (idx < this.partItems.size()) {
            return this.partItems.get(idx);
        }
        return null;
    }

    @Override
    public String getFullyQualifiedName() {
        StringBuilder fqn = new StringBuilder();
        for (int i = this.partItems.size() - 1; i >= 0; --i) {
            String part = this.partItems.get(i);
            if (part == null) {
                part = "";
            }
            fqn.append(part);
            if (i == 0) continue;
            fqn.append(".");
        }
        return fqn.toString();
    }

    public String toString() {
        StringBuilder sql = new StringBuilder(this.getFullyQualifiedName());
        return sql.toString();
    }
}

