/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.statement;

import com.sqlparser.expression.Expression;
import com.sqlparser.expression.operators.relational.ExpressionList;
import com.sqlparser.statement.Statement;
import com.sqlparser.statement.StatementVisitor;
import com.sqlparser.statement.select.PlainSelect;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class SetStatement
implements Statement {
    private String effectParameter;
    private final List<NameExpr> values = new ArrayList<NameExpr>();

    public SetStatement() {
    }

    public SetStatement(Object name, ExpressionList<?> value) {
        this.add(name, value, true);
    }

    public void add(Object name, ExpressionList<?> value, boolean useEqual) {
        this.values.add(new NameExpr(name, value, useEqual));
    }

    public void remove(int idx) {
        this.values.remove(idx);
    }

    public int getCount() {
        return this.values.size();
    }

    public boolean isUseEqual(int idx) {
        return this.values.get((int)idx).useEqual;
    }

    public boolean isUseEqual() {
        return this.isUseEqual(0);
    }

    public SetStatement withUseEqual(int idx, boolean useEqual) {
        this.setUseEqual(idx, useEqual);
        return this;
    }

    public SetStatement setUseEqual(int idx, boolean useEqual) {
        this.values.get((int)idx).useEqual = useEqual;
        return this;
    }

    public SetStatement withUseEqual(boolean useEqual) {
        this.setUseEqual(useEqual);
        return this;
    }

    public SetStatement setUseEqual(boolean useEqual) {
        return this.setUseEqual(0, useEqual);
    }

    public Object getName() {
        return this.getName(0);
    }

    public Object getName(int idx) {
        return this.values.get((int)idx).name;
    }

    public void setName(String name) {
        this.setName(0, name);
    }

    public void setName(int idx, String name) {
        this.values.get((int)idx).name = name;
    }

    public List<Expression> getExpressions(int idx) {
        return this.values.get((int)idx).expressions;
    }

    public List<Expression> getExpressions() {
        return this.getExpressions(0);
    }

    public void setExpressions(int idx, ExpressionList<?> expressions) {
        this.values.get((int)idx).expressions = expressions;
    }

    public void setExpressions(ExpressionList<?> expressions) {
        this.setExpressions(0, expressions);
    }

    private String toString(NameExpr ne) {
        return ne.name + (ne.useEqual ? " = " : " ") + PlainSelect.getStringList(ne.expressions, true, false);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("SET ");
        if (this.effectParameter != null) {
            b.append(this.effectParameter).append(" ");
        }
        boolean addComma = false;
        for (NameExpr ne : this.values) {
            if (addComma) {
                b.append(", ");
            } else {
                addComma = true;
            }
            b.append(this.toString(ne));
        }
        return b.toString();
    }

    public List<NameExpr> getKeyValuePairs() {
        return this.values;
    }

    public void addKeyValuePairs(Collection<NameExpr> keyValuePairs) {
        this.values.addAll(keyValuePairs);
    }

    public void addKeyValuePairs(NameExpr ... keyValuePairs) {
        this.addKeyValuePairs(Arrays.asList(keyValuePairs));
    }

    public void clear() {
        this.values.clear();
        this.effectParameter = null;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public String getEffectParameter() {
        return this.effectParameter;
    }

    public void setEffectParameter(String effectParameter) {
        this.effectParameter = effectParameter;
    }

    public SetStatement withEffectParameter(String effectParameter) {
        this.effectParameter = effectParameter;
        return this;
    }

    static class NameExpr
    implements Serializable {
        Object name;
        ExpressionList expressions;
        boolean useEqual;

        public Object getName() {
            return this.name;
        }

        public void setName(Object name) {
            this.name = name;
        }

        public ExpressionList<?> getExpressions() {
            return this.expressions;
        }

        public void setExpressions(ExpressionList<?> expressions) {
            this.expressions = expressions;
        }

        public boolean isUseEqual() {
            return this.useEqual;
        }

        public void setUseEqual(boolean useEqual) {
            this.useEqual = useEqual;
        }

        public NameExpr(Object name, ExpressionList<?> expressions, boolean useEqual) {
            this.name = name;
            this.expressions = expressions;
            this.useEqual = useEqual;
        }
    }
}

