/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.statement;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sqlparser.deserializer.UnsupportedStatementDeserializer;
import com.sqlparser.statement.Statement;
import com.sqlparser.statement.StatementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(using=UnsupportedStatementDeserializer.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class UnsupportedStatement
implements Statement {
    private List<String> declarations;

    public UnsupportedStatement(List<String> declarations) {
        this.declarations = Objects.requireNonNull(declarations, "The List of Tokens must not be null.");
    }

    public UnsupportedStatement(String upfront, List<String> declarations) {
        this.declarations = new ArrayList<String>();
        this.declarations.add(upfront);
        this.declarations.addAll((Collection<String>)Objects.requireNonNull(declarations, "The List of Tokens must not be null."));
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int i = 0;
        for (String s : this.declarations) {
            if (i > 0) {
                builder.append(" ");
            }
            builder.append(s);
            ++i;
        }
        return builder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public boolean isEmpty() {
        return this.declarations.isEmpty();
    }

    public List<String> getDeclarations() {
        return this.declarations;
    }

    public void setDeclarations(List<String> declarations) {
        this.declarations = declarations;
    }
}

