/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.statement.alter;

import com.sqlparser.statement.Statement;
import com.sqlparser.statement.StatementVisitor;
import com.sqlparser.statement.alter.AlterSystemOperation;
import java.util.List;
import java.util.Objects;

public class AlterSystemStatement
implements Statement {
    private final AlterSystemOperation operation;
    private final List<String> parameters;

    public AlterSystemStatement(AlterSystemOperation operation, List<String> parameters) {
        this.operation = Objects.requireNonNull(operation, "The ALTER SYSTEM Operation must not be Null");
        this.parameters = Objects.requireNonNull(parameters, "The PARAMETERS List must not be null although it can be empty.");
    }

    public AlterSystemOperation getOperation() {
        return this.operation;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    private static void appendParameters(StringBuilder builder, List<String> parameters) {
        for (String s : parameters) {
            builder.append(" ").append(s);
        }
    }

    public StringBuilder appendTo(StringBuilder builder) {
        builder.append("ALTER SYSTEM ").append((Object)this.operation);
        AlterSystemStatement.appendParameters(builder, this.parameters);
        return builder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }
}

