/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.statement.create.table;

import com.sqlparser.ClassName;
import com.sqlparser.statement.create.table.ColDataType;
import com.sqlparser.statement.select.PlainSelect;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class ColumnDefinition
implements Serializable,
ClassName {
    private String columnName;
    private ColDataType colDataType;
    private List<String> columnSpecs;

    public ColumnDefinition() {
    }

    public ColumnDefinition(String columnName, ColDataType colDataType) {
        this.columnName = columnName;
        this.colDataType = colDataType;
    }

    public ColumnDefinition(String columnName, ColDataType colDataType, List<String> columnSpecs) {
        this(columnName, colDataType);
        this.columnSpecs = columnSpecs;
    }

    public List<String> getColumnSpecs() {
        return this.columnSpecs;
    }

    public void setColumnSpecs(List<String> list) {
        this.columnSpecs = list;
    }

    public ColDataType getColDataType() {
        return this.colDataType;
    }

    public void setColDataType(ColDataType type) {
        this.colDataType = type;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public String toString() {
        return this.columnName + " " + this.toStringDataTypeAndSpec();
    }

    public String toStringDataTypeAndSpec() {
        return this.colDataType + (this.columnSpecs != null && !this.columnSpecs.isEmpty() ? " " + PlainSelect.getStringList(this.columnSpecs, false, false) : "");
    }

    public ColumnDefinition withColumnName(String columnName) {
        this.setColumnName(columnName);
        return this;
    }

    public ColumnDefinition withColDataType(ColDataType colDataType) {
        this.setColDataType(colDataType);
        return this;
    }

    public ColumnDefinition withColumnSpecs(List<String> columnSpecs) {
        this.setColumnSpecs(columnSpecs);
        return this;
    }

    public ColumnDefinition addColumnSpecs(String ... columnSpecs) {
        List collection = Optional.ofNullable(this.getColumnSpecs()).orElseGet(ArrayList::new);
        Collections.addAll(collection, columnSpecs);
        return this.withColumnSpecs(collection);
    }

    public ColumnDefinition addColumnSpecs(Collection<String> columnSpecs) {
        List collection = Optional.ofNullable(this.getColumnSpecs()).orElseGet(ArrayList::new);
        collection.addAll(columnSpecs);
        return this.withColumnSpecs(collection);
    }
}

