/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.statement.create.table;

import com.sqlparser.schema.Table;
import com.sqlparser.statement.ReferentialAction;
import com.sqlparser.statement.create.table.Index;
import com.sqlparser.statement.create.table.NamedConstraint;
import com.sqlparser.statement.select.PlainSelect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class ForeignKeyIndex
extends NamedConstraint {
    private Table table;
    private List<String> referencedColumnNames;
    private Set<ReferentialAction> referentialActions = new LinkedHashSet<ReferentialAction>(2);

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public List<String> getReferencedColumnNames() {
        return this.referencedColumnNames;
    }

    public void setReferencedColumnNames(List<String> referencedColumnNames) {
        this.referencedColumnNames = referencedColumnNames;
    }

    public void setReferentialAction(ReferentialAction.Type type, ReferentialAction.Action action) {
        this.setReferentialAction(type, action, true);
    }

    public ForeignKeyIndex withReferentialAction(ReferentialAction.Type type, ReferentialAction.Action action) {
        this.setReferentialAction(type, action);
        return this;
    }

    public void removeReferentialAction(ReferentialAction.Type type) {
        this.setReferentialAction(type, null, false);
    }

    public ReferentialAction getReferentialAction(ReferentialAction.Type type) {
        return this.referentialActions.stream().filter(ra -> type.equals((Object)ra.getType())).findFirst().orElse(null);
    }

    private void setReferentialAction(ReferentialAction.Type type, ReferentialAction.Action action, boolean set) {
        ReferentialAction found = this.getReferentialAction(type);
        if (set) {
            if (found == null) {
                this.referentialActions.add(new ReferentialAction(type, action));
            } else {
                found.setAction(action);
            }
        } else if (found != null) {
            this.referentialActions.remove(found);
        }
    }

    @Deprecated
    public String getOnDeleteReferenceOption() {
        ReferentialAction a = this.getReferentialAction(ReferentialAction.Type.DELETE);
        return a == null ? null : a.getAction().getAction();
    }

    @Deprecated
    public void setOnDeleteReferenceOption(String onDeleteReferenceOption) {
        if (onDeleteReferenceOption == null) {
            this.removeReferentialAction(ReferentialAction.Type.DELETE);
        } else {
            this.setReferentialAction(ReferentialAction.Type.DELETE, ReferentialAction.Action.from(onDeleteReferenceOption));
        }
    }

    @Deprecated
    public String getOnUpdateReferenceOption() {
        ReferentialAction a = this.getReferentialAction(ReferentialAction.Type.UPDATE);
        return a == null ? null : a.getAction().getAction();
    }

    @Deprecated
    public void setOnUpdateReferenceOption(String onUpdateReferenceOption) {
        if (onUpdateReferenceOption == null) {
            this.removeReferentialAction(ReferentialAction.Type.UPDATE);
        } else {
            this.setReferentialAction(ReferentialAction.Type.UPDATE, ReferentialAction.Action.from(onUpdateReferenceOption));
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder(super.toString()).append(" REFERENCES ").append(this.table).append(PlainSelect.getStringList(this.getReferencedColumnNames(), true, true));
        this.referentialActions.forEach(b::append);
        return b.toString();
    }

    public ForeignKeyIndex withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public ForeignKeyIndex withReferencedColumnNames(List<String> referencedColumnNames) {
        this.setReferencedColumnNames(referencedColumnNames);
        return this;
    }

    public ForeignKeyIndex withOnDeleteReferenceOption(String onDeleteReferenceOption) {
        this.setOnDeleteReferenceOption(onDeleteReferenceOption);
        return this;
    }

    public ForeignKeyIndex withOnUpdateReferenceOption(String onUpdateReferenceOption) {
        this.setOnUpdateReferenceOption(onUpdateReferenceOption);
        return this;
    }

    public ForeignKeyIndex addReferencedColumnNames(String ... referencedColumnNames) {
        List collection = Optional.ofNullable(this.getReferencedColumnNames()).orElseGet(ArrayList::new);
        Collections.addAll(collection, referencedColumnNames);
        return this.withReferencedColumnNames(collection);
    }

    public ForeignKeyIndex addReferencedColumnNames(Collection<String> referencedColumnNames) {
        List collection = Optional.ofNullable(this.getReferencedColumnNames()).orElseGet(ArrayList::new);
        collection.addAll(referencedColumnNames);
        return this.withReferencedColumnNames(collection);
    }

    @Override
    public ForeignKeyIndex withType(String type) {
        return (ForeignKeyIndex)super.withType(type);
    }

    @Override
    public ForeignKeyIndex withUsing(String using) {
        return (ForeignKeyIndex)super.withUsing(using);
    }

    @Override
    public ForeignKeyIndex withName(List<String> name) {
        return (ForeignKeyIndex)super.withName((List)name);
    }

    @Override
    public ForeignKeyIndex withName(String name) {
        return (ForeignKeyIndex)super.withName(name);
    }

    @Override
    public ForeignKeyIndex withColumnsNames(List<String> list) {
        return (ForeignKeyIndex)super.withColumnsNames((List)list);
    }

    @Override
    public ForeignKeyIndex withColumns(List<Index.ColumnParams> columns) {
        return (ForeignKeyIndex)super.withColumns((List)columns);
    }

    @Override
    public ForeignKeyIndex addColumns(Index.ColumnParams ... functionDeclarationParts) {
        return (ForeignKeyIndex)super.addColumns(functionDeclarationParts);
    }

    @Override
    public ForeignKeyIndex addColumns(Collection<? extends Index.ColumnParams> functionDeclarationParts) {
        return (ForeignKeyIndex)super.addColumns((Collection)functionDeclarationParts);
    }

    @Override
    public ForeignKeyIndex withIndexSpec(List<String> idxSpec) {
        return (ForeignKeyIndex)super.withIndexSpec((List)idxSpec);
    }
}

