/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.statement.drop;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sqlparser.deserializer.DropDeserializer;
import com.sqlparser.schema.Table;
import com.sqlparser.statement.Statement;
import com.sqlparser.statement.StatementVisitor;
import com.sqlparser.statement.select.PlainSelect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(using=DropDeserializer.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Drop
implements Statement {
    private String type;
    private Table name;
    private List<String> parameters;
    private Map<String, List<String>> typeToParameters = new HashMap<String, List<String>>();
    private boolean ifExists = false;
    private boolean materialized = false;
    private boolean isUsingTemporary;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getName() {
        return this.name;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public String getType() {
        return this.type;
    }

    public void setName(Table string) {
        this.name = string;
    }

    public void setParameters(List<String> list) {
        this.parameters = list;
    }

    public void setType(String string) {
        this.type = string;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    public boolean isUsingTemporary() {
        return this.isUsingTemporary;
    }

    public void setUsingTemporary(boolean useTemporary) {
        this.isUsingTemporary = useTemporary;
    }

    public void setIsUsingTemporary(boolean useTemporary) {
        this.isUsingTemporary = useTemporary;
    }

    public Drop withUsingTemporary(boolean useTemporary) {
        this.setUsingTemporary(useTemporary);
        return this;
    }

    public boolean isMaterialized() {
        return this.materialized;
    }

    public void setMaterialized(boolean materialized) {
        this.materialized = materialized;
    }

    public Map<String, List<String>> getTypeToParameters() {
        return this.typeToParameters;
    }

    public void setTypeToParameters(Map<String, List<String>> typeToParameters) {
        this.typeToParameters = typeToParameters;
    }

    public String toString() {
        String sql = "DROP " + (this.isUsingTemporary ? "TEMPORARY " : "") + (this.materialized ? "MATERIALIZED " : "") + this.type + " " + (this.ifExists ? "IF EXISTS " : "") + this.name.toString();
        if (this.type.equals("FUNCTION")) {
            sql = sql + Drop.formatFuncParams(this.getParamsByType("FUNCTION"));
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            sql = sql + " " + PlainSelect.getStringList(this.parameters, false, false);
        }
        return sql;
    }

    public static String formatFuncParams(List<String> params) {
        if (params == null) {
            return "";
        }
        return params.isEmpty() ? "()" : PlainSelect.getStringList(params, true, true);
    }

    public List<String> getParamsByType(String type) {
        return this.typeToParameters.get(type);
    }

    public Drop withIfExists(boolean ifExists) {
        this.setIfExists(ifExists);
        return this;
    }

    public Drop withMaterialized(boolean materialized) {
        this.setMaterialized(materialized);
        return this;
    }

    public Drop withType(String type) {
        this.setType(type);
        return this;
    }

    public Drop withName(Table name) {
        this.setName(name);
        return this;
    }

    public Drop withParameters(List<String> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public Drop addParameters(String ... parameters) {
        List collection = Optional.ofNullable(this.getParameters()).orElseGet(ArrayList::new);
        Collections.addAll(collection, parameters);
        return this.withParameters(collection);
    }

    public Drop addParameters(Collection<String> parameters) {
        List collection = Optional.ofNullable(this.getParameters()).orElseGet(ArrayList::new);
        collection.addAll(parameters);
        return this.withParameters(collection);
    }
}

